# Awesome Laravel [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Build Status](https://img.shields.io/travis/chiraggude/awesome-laravel/master.svg?style=flat)](https://travis-ci.org/chiraggude/awesome-laravel)

> A curated list of awesome bookmarks, packages, tutorials, videos and other cool resources from the Laravel ecosystem.

Inspired by <b><code>&nbsp;31109⭐</code></b> <b><code>&nbsp;&nbsp;5080🍴</code></b> [ziadoz/awesome-php](https://github.com/ziadoz/awesome-php))

## Table of Contents

- [Essentials](#essentials)
- [Packages](#packages)
- [Popular Packages](#popular-packages)
- [Development Setup](#development-setup)
- [Application Hosting](#application-hosting)
- [Application Deployment](#application-deployment)
- [Code Snippets](#code-snippets)
- [Tutorials & Blogs](#tutorials--blogs)
- [Videos](#videos)
- [Conferences](#conferences)
- [Books](#books)
- [Starter Projects](#starter-projects)
- [Codebases for Reference](#codebases-for-reference)
- [Content Management Systems](#content-management-systems)
- [Podcasts](#podcasts)
- [Community](#community)
- [Jobs](#jobs)
- [Hosted Development Tools](#hosted-development-tools)
- [Miscellaneous](#miscellaneous)

## Essentials

* 🌎 [Laravel](laravel.com)  🌎 [Documentation](laravel.com/docs))
* 🌎 [Laravel API Reference](laravel.com/api/master/)
* 🌎 [Lumen](lumen.laravel.com)  🌎 [Documentation](lumen.laravel.com/docs))
* 🌎 [Laracasts](laracasts.com)
* 🌎 [Laravel News](laravel-news.com)  🌎 [Archive](laravel-news.com/archive/))

## Packages

* 🌎 [Packagist](packagist.org/)
* 🌎 [Laravel Collective](laravelcollective.com/)
* [Packalyst](http://packalyst.com/)
* 🌎 [Spatie](spatie.be/en/opensource/laravel)

## Popular Packages

> This is a list of well-documented, tested packages that are frequently used in Laravel projects. If you're looking for an exhaustive list of PHP packages, then check out the Package Repositories mentioned above.

##### Developer Tools

* <b><code>&nbsp;&nbsp;&nbsp;915⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;136🍴</code></b> [Scaffold Interface](https://github.com/amranidev/scaffold-interface)) - A Smart CRUD Generator For Laravel
* <b><code>&nbsp;14302⭐</code></b> <b><code>&nbsp;&nbsp;1173🍴</code></b> [IDE Helper](https://github.com/barryvdh/laravel-ide-helper)) - Generates a helper file for IDE auto-completion
* <b><code>&nbsp;&nbsp;2448⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;347🍴</code></b> [Laravel 5 Extended Generators](https://github.com/laracasts/Laravel-5-Generators-Extended)) - Extends built-in file generators
* <b><code>&nbsp;&nbsp;3803⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;816🍴</code></b> [Laravel API/Scaffold/CRUD Generator](https://github.com/InfyOmLabs/laravel-generator)) - Generator for APIs, CRUD scaffolds etc.
* <b><code>&nbsp;&nbsp;&nbsp;449⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [Laravel Tinx](https://github.com/furey/tinx)) - Reload your Laravel Tinker session from inside Tinker
* <b><code>&nbsp;&nbsp;3446⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;612🍴</code></b> [Laravel API Documentation Generator](https://github.com/mpociot/laravel-apidoc-generator)) - Automatically generate your API documentation
* <b><code>&nbsp;&nbsp;1358⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;189🍴</code></b> [Laravel Packager](https://github.com/Jeroen-G/Laravel-Packager)) - A CLI tool for creating Laravel packages
* <b><code>&nbsp;&nbsp;&nbsp;899⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;236🍴</code></b> [Workbench Export to Migrations](https://github.com/beckenrode/mysql-workbench-export-laravel-5-migrations)) - Workbench plugin for exporting Models to Laravel migrations
* <b><code>&nbsp;&nbsp;&nbsp;523⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42🍴</code></b> [Laravel Decomposer](https://github.com/lubusIN/laravel-decomposer)) - List all installed packages, their dependencies, app & server details
* <b><code>&nbsp;&nbsp;2422⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;264🍴</code></b> [LaRecipe](https://github.com/saleem-hadad/larecipe)) - Write gorgeous documentations for your products using Markdown inside your Laravel app.
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Prequel](https://github.com/Protoqol/Prequel/)) - A clear and concise database management GUI tweaked for Laravel.

##### Testing & Debugging

* 🌎 [Laravel TestTools](chrome.google.com/webstore/detail/laravel-testtools/ddieaepnbjhgcbddafciempnibnfnakl) - Chrome extension to generate Laravel integration tests while using your app
* <b><code>&nbsp;&nbsp;&nbsp;935⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;87🍴</code></b> [Laravel Test Factory Generator](https://github.com/mpociot/laravel-test-factory-helper)) - Generate Laravel test factories from your existing models
* <b><code>&nbsp;&nbsp;5735⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;322🍴</code></b> [Clockwork](https://github.com/itsgoingd/clockwork)) - Integrates Clockwork Chrome extension for debugging and profiling apps
* <b><code>&nbsp;17617⭐</code></b> <b><code>&nbsp;&nbsp;1567🍴</code></b> [Debug Bar](https://github.com/barryvdh/laravel-debugbar)) - Integrates PHP Debug Bar with Laravel
* <b><code>&nbsp;&nbsp;2085⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;184🍴</code></b> [Ignition](https://github.com/facade/ignition)) - A beautiful error page for Laravel apps
* <b><code>&nbsp;&nbsp;3148⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;375🍴</code></b> [Laravel 5 Log Viewer](https://github.com/rap2hpoutre/laravel-log-viewer)) - Log viewer
* <b><code>&nbsp;&nbsp;2374⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;333🍴</code></b> [LogViewer](https://github.com/ARCANEDEV/LogViewer)) - Provides a log viewer
* <b><code>&nbsp;&nbsp;&nbsp;440⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [LERN](https://github.com/tylercd100/lern#lern-laravel-exception-recorder-and-notifier)) - Record exceptions into a database and will send you a notification
* <b><code>&nbsp;&nbsp;1194⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82🍴</code></b> [Mail Preview](https://github.com/themsaid/laravel-mail-preview)) - Preview sent mail in a web browser or mail client
* <b><code>&nbsp;&nbsp;&nbsp;385⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;43🍴</code></b> [Laravel Tracy](https://github.com/recca0120/laravel-tracy)) - A Laravel Package to integrate Nette Tracy Debugger
* <b><code>&nbsp;&nbsp;&nbsp;860⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;58🍴</code></b> [Laravel Terminal](https://github.com/recca0120/laravel-terminal)) - run artisan in a web browser
* <b><code>&nbsp;&nbsp;&nbsp;357⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;52🍴</code></b> [Laravel API Tester](https://github.com/asvae/laravel-api-tester)) - Postman-like tool with Laravel routes
* <b><code>&nbsp;&nbsp;&nbsp;738⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [Laravel Tail](https://github.com/spatie/laravel-tail)) - The missing tail command
* <b><code>&nbsp;&nbsp;4916⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;589🍴</code></b> [Laravel Telescope](https://github.com/laravel/telescope)) - Laravel Telescope is an elegant debug assistant for the Laravel framework

##### Authentication & Authorization

* <b><code>&nbsp;&nbsp;3464⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;336🍴</code></b> [Bouncer](https://github.com/JosephSilber/bouncer)) - Roles & Permissions
* <b><code>&nbsp;&nbsp;2208⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;378🍴</code></b> [Laratrust](https://github.com/santigarcor/laratrust)) - Roles, Permissions and teams
* <b><code>&nbsp;&nbsp;6047⭐</code></b> <b><code>&nbsp;&nbsp;1285🍴</code></b> [Entrust](https://github.com/Zizaco/entrust)) - Role-based Permissions
* <b><code>&nbsp;11341⭐</code></b> <b><code>&nbsp;&nbsp;1544🍴</code></b> [JWT Auth](https://github.com/tymondesigns/jwt-auth)) - JSON Web Token authentication for APIs
* <b><code>&nbsp;12246⭐</code></b> <b><code>&nbsp;&nbsp;1787🍴</code></b> [Laravel Permission](https://github.com/spatie/laravel-permission)) - Associate users with roles and permissions
* <b><code>&nbsp;&nbsp;&nbsp;441⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;96🍴</code></b> [Defender](https://github.com/artesaos/defender)) - Roles & Permissions
* <b><code>&nbsp;&nbsp;2364⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;532🍴</code></b> [OAuth2 Server Laravel](https://github.com/lucadegasperi/oauth2-server-laravel)) - OAuth 2.0 authorization server and resource server
* <b><code>&nbsp;&nbsp;5594⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;938🍴</code></b> [Socialite](https://github.com/laravel/socialite)) - OAuth authentication with Facebook, Google, Twitter etc.
* [Socialite Providers 2.0](http://socialiteproviders.github.io/) - 100+ social authentication providers for Socialite with Lumen support
* <b><code>&nbsp;&nbsp;1870⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;200🍴</code></b> [Google2FA](https://github.com/antonioribeiro/google2fa)) - Google Two-Factor Authentication Module
* <b><code>&nbsp;&nbsp;&nbsp;855⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;118🍴</code></b> [Laravel User Verification](https://github.com/jrean/laravel-user-verification)) - Handle the user verification flow and validate email
* <b><code>&nbsp;&nbsp;&nbsp;911⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;185🍴</code></b> [Adldap2 Laravel](https://github.com/Adldap2/Adldap2-Laravel)) - LDAP authentication and Active Directory management
* <b><code>&nbsp;&nbsp;1030⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [Doorman](https://github.com/clarkeash/doorman)) - Limit access to your Laravel applications by using invite codes
* <b><code>&nbsp;&nbsp;&nbsp;919⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [Laravel Heyman](https://github.com/imanghafoori1/laravel-heyman)) - Heyman continues where the above role-permission packages left off

##### Utilities

* <b><code>&nbsp;&nbsp;&nbsp;851⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;96🍴</code></b> [Awes.io](https://github.com/awes-io/awes-io)) - boilerplate for CRM, SaaS, ERP based on Vue (Nuxt.js), TailwindCSS plus Laravel as a backend.
* <b><code>&nbsp;&nbsp;&nbsp;870⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;118🍴</code></b> [Artisan View](https://github.com/svenluijten/artisan-view)) - Manage the views in Laravel projects via artisan
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Bootstrapper](https://github.com/patricktalmadge/bootstrapper/)) - Set of classes to create Bootstrap 3 markup
* <b><code>&nbsp;&nbsp;2478⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;454🍴</code></b> [Captcha](https://github.com/mewebstudio/captcha)) - An anti-bot image captcha system
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;77⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35🍴</code></b> [Charts](https://github.com/ConsoleTVs/Charts)) - Multi-library chart package to create interactive charts
* <b><code>&nbsp;&nbsp;&nbsp;621⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;142🍴</code></b> [Lavacharts](https://github.com/kevinkhill/lavacharts)) - Charts and Graphs for PHP Powered by the Google Chart API
* <b><code>&nbsp;&nbsp;1736⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;121🍴</code></b> [Eloquent Filter](https://github.com/Tucker-Eric/EloquentFilter)) - Filter models and their Relationships
* <b><code>&nbsp;&nbsp;3917⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;461🍴</code></b> [Eloquent Sluggable](https://github.com/cviebrock/eloquent-sluggable)) - Create slugs for Eloquent models
* <b><code>&nbsp;&nbsp;1416⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;139🍴</code></b> [Eloquent Sortable](https://github.com/spatie/eloquent-sortable)) - Sortable behaviour for Eloquent models
* <b><code>&nbsp;&nbsp;4003⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;827🍴</code></b> [HTML](https://github.com/LaravelCollective/html)) - HTML and Form Builders for Laravel
* <b><code>&nbsp;&nbsp;2563⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;395🍴</code></b> [Multi-tenant](https://github.com/hyn/multi-tenant)) - Flexible multi tenancy with secure separation of routes, assets and databases
* <b><code>&nbsp;&nbsp;1706⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;296🍴</code></b> [Laravel Form Builder](https://github.com/kristijanhusak/laravel-form-builder)) - Form builder inspired by Symfony's form builder
* <b><code>&nbsp;&nbsp;5400⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;717🍴</code></b> [Laravel Activitylog](https://github.com/spatie/laravel-activitylog)) - Log activity inside your Laravel app
* <b><code>&nbsp;&nbsp;3083⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;389🍴</code></b> [Laravel Auditing](https://github.com/owen-it/laravel-auditing)) - Audit for Eloquent models
* <b><code>&nbsp;&nbsp;2335⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;415🍴</code></b> [Laravel Breadcrumbs](https://github.com/davejamesmiller/laravel-breadcrumbs)) - Create and manage breadcrumbs
* <b><code>&nbsp;&nbsp;1765⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;142🍴</code></b> [Laravel Collection Macros](https://github.com/spatie/laravel-collection-macros)) - A set of handy collection macros
* <b><code>&nbsp;&nbsp;1409⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;142🍴</code></b> [Laravel Cookie Consent](https://github.com/spatie/laravel-cookie-consent)) - Make your Laravel app comply with the crazy EU cookie law
* <b><code>&nbsp;&nbsp;4776⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;858🍴</code></b> [Laravel Datatables](https://github.com/yajra/laravel-datatables)) - jQuery DataTables API
* <b><code>&nbsp;&nbsp;2127⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;373🍴</code></b> [Laravel GeoIP](https://github.com/Torann/laravel-geoip)) - Determine the location of website visitors based on their IP addresses
* <b><code>&nbsp;&nbsp;1994⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;173🍴</code></b> [Laravel Hashids](https://github.com/vinkla/laravel-hashids)) - Generate unique, non-sequential ids using [Hashids](http://hashids.org/php/)
* <b><code>&nbsp;&nbsp;2044⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;213🍴</code></b> [Laravel Impersonate](https://github.com/404labfr/laravel-impersonate)) - A package to authenticate as one of your users
* <b><code>&nbsp;&nbsp;1048⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;127🍴</code></b> [Laravel Mailbox](https://github.com/beyondcode/laravel-mailbox)) - A package to handle incoming emails
* <b><code>&nbsp;&nbsp;1320⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;141🍴</code></b> [Laravel Markdown](https://github.com/GrahamCampbell/Laravel-Markdown)) - CommonMark markdown parser
* <b><code>&nbsp;&nbsp;&nbsp;930⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82🍴</code></b> [Laravel Menu](https://github.com/spatie/laravel-menu)) - Html menu generator for Laravel
* <b><code>&nbsp;&nbsp;1610⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;326🍴</code></b> [Laravel Talk](https://github.com/nahid/talk)) - Realtime User messaging system
* <b><code>&nbsp;&nbsp;2476⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;518🍴</code></b> [Laravel Messenger](https://github.com/cmgmyr/laravel-messenger)) - User messaging system
* <b><code>&nbsp;&nbsp;&nbsp;527⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;67🍴</code></b> [Laravel Moderation](https://github.com/hootlex/laravel-moderation)) - Approve or reject resources like posts, comments, users, etc.
* <b><code>&nbsp;&nbsp;1642⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;283🍴</code></b> [Laravel Tags](https://github.com/spatie/laravel-tags)) - Add tags and taggable behaviour
* <b><code>&nbsp;&nbsp;2903⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;597🍴</code></b> [Laravel Stats Tracker](https://github.com/antonioribeiro/tracker)) - Gather information from requests to identify and store
* <b><code>&nbsp;&nbsp;&nbsp;134⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;17🍴</code></b> [Listify](https://github.com/lookitsatravis/listify)) - Add sorting/ordering capabilities to any Eloquent model
* <b><code>&nbsp;&nbsp;&nbsp;360⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;56🍴</code></b> [noCAPTCHA](https://github.com/ARCANEDEV/noCAPTCHA)) - Helper for Google's new noCAPTCHA (reCAPTCHA)
* <b><code>&nbsp;&nbsp;1891⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;230🍴</code></b> [Purifier](https://github.com/mewebstudio/purifier)) - HTML filter
* <b><code>&nbsp;&nbsp;2562⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;349🍴</code></b> [Revisionable](https://github.com/VentureCraft/revisionable)) - Create a revision history for Eloquent models
* <b><code>&nbsp;&nbsp;3136⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;504🍴</code></b> [SEOTools](https://github.com/artesaos/seotools)) - Helpers for some common SEO techniques
* <b><code>&nbsp;&nbsp;1217⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;118🍴</code></b> [Page Cache](https://github.com/JosephSilber/page-cache)) - Caches responses as static files on disk for lightning fast page loads
* <b><code>&nbsp;&nbsp;&nbsp;941⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;113🍴</code></b> [Laravel Setting](https://github.com/anlutro/laravel-settings)) - Persistent configuration settings that are stored in JSON files
* <b><code>&nbsp;&nbsp;&nbsp;704⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;151🍴</code></b> [Friendship](https://github.com/hootlex/laravel-friendships)) - Friendship management system
* <b><code>&nbsp;&nbsp;1084⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;171🍴</code></b> [Teamwork](https://github.com/mpociot/teamwork)) - User to team associations with an invite system
* <b><code>&nbsp;&nbsp;&nbsp;972⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;76🍴</code></b> [Validating](https://github.com/dwightwatson/validating)) - Trait for validating Eloquent models
* <b><code>&nbsp;&nbsp;1203⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;91🍴</code></b> [VAT Calculator](https://github.com/mpociot/vat-calculator)) - Handle all the hard stuff related to EU MOSS vat regulations
* <b><code>&nbsp;&nbsp;1806⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;151🍴</code></b> [Laravel UUID](https://github.com/webpatser/laravel-uuid)) - Generate a UUID according to the RFC 4122 standard
* <b><code>&nbsp;&nbsp;1941⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;475🍴</code></b> [Laravel Installer](https://github.com/RachidLaasri/LaravelInstaller)) - Allow users to install your application just by following the setup wizard, like WordPress
* <b><code>&nbsp;&nbsp;5595⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;968🍴</code></b> [Laravel Modules](https://github.com/nWidart/laravel-modules)) - Easy module management
* <b><code>&nbsp;&nbsp;2785⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;219🍴</code></b> [Laravel Phone](https://github.com/Propaganistas/Laravel-Phone)) - Phone number validator and formatter
* <b><code>&nbsp;&nbsp;1078⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;64🍴</code></b> [Laravel Ban](https://github.com/cybercog/laravel-ban)) - Simplify blocking and banning Eloquent models
* <b><code>&nbsp;&nbsp;7361⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;125🍴</code></b> [Laravel Proxy](https://github.com/fideloper/TrustedProxy)) - Handling sessions when behind load balancers or other intermediaries.
* <b><code>&nbsp;&nbsp;&nbsp;808⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;230🍴</code></b> [Laravel Video Chat](https://github.com/PHPJunior/laravel-video-chat)) - Video Chat using Socket.IO and WebRTC
* <b><code>&nbsp;&nbsp;1122⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;113🍴</code></b> [Widgets for Laravel](https://github.com/arrilot/laravel-widgets)) - A powerful alternative to view composers.
* <b><code>&nbsp;&nbsp;&nbsp;509⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [Secure Headers](https://github.com/BePsvPT/secure-headers)) - Add security related headers to HTTP response
* 🌎 [Laravel Nova](nova.laravel.com/) - Nova is a beautifully designed administration panel for Laravel
* <b><code>&nbsp;&nbsp;1173⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;71🍴</code></b> [Laravel Love](https://github.com/cybercog/laravel-love)) - It lets people express how they feel about the content. React on Eloquent models with Likes or Dislikes.
* <b><code>&nbsp;&nbsp;3706⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;436🍴</code></b> [stancl/tenancy](https://github.com/stancl/tenancy)) - Automatic tenancy for your Laravel app. No code changes needed.

##### Media & Document Management

* <b><code>&nbsp;13995⭐</code></b> <b><code>&nbsp;&nbsp;1495🍴</code></b> [Intervention Image](https://github.com/Intervention/image)) - Image handling library for creating, editing and composing images
* <b><code>&nbsp;&nbsp;&nbsp;764⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [Laravel ImageUp](https://github.com/qcod/laravel-imageup)) - Yet another image manipulation package, adds tons of extra functionality
* <b><code>&nbsp;&nbsp;&nbsp;428⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;51🍴</code></b> [Laravel Glide](https://github.com/spatie/laravel-glide)) - Easily convert images with Glide
* <b><code>&nbsp;&nbsp;5819⭐</code></b> <b><code>&nbsp;&nbsp;1079🍴</code></b> [Laravel MediaLibrary](https://github.com/spatie/laravel-medialibrary)) - Associate files with Eloquent models
* <b><code>&nbsp;&nbsp;2653⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;292🍴</code></b> [Laravel Snappy](https://github.com/barryvdh/laravel-snappy)) - HTML to PDF generator using wkhtmltopdf
* <b><code>&nbsp;&nbsp;6815⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;980🍴</code></b> [Laravel DOMPDF](https://github.com/barryvdh/laravel-dompdf)) - HTML to PDF generator using <b><code>&nbsp;10618⭐</code></b> <b><code>&nbsp;&nbsp;1800🍴</code></b> [dompdf](https://github.com/dompdf/dompdf))
* <b><code>&nbsp;&nbsp;&nbsp;555⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;109🍴</code></b> [Laravel Stapler](https://github.com/CodeSleeve/laravel-stapler)) - ORM-based file upload manager
* <b><code>&nbsp;12362⭐</code></b> <b><code>&nbsp;&nbsp;1930🍴</code></b> [Laravel Excel](https://github.com/Maatwebsite/Laravel-Excel)) - Import and export Excel and CSV files
* <b><code>&nbsp;&nbsp;2132⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;250🍴</code></b> [Fast Excel](https://github.com/rap2hpoutre/fast-excel)) - Fast XLSX, CSV and ODT import and export for Laravel
* <b><code>&nbsp;&nbsp;1917⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;174🍴</code></b> [Laravolt Avatar](https://github.com/laravolt/avatar)) - Plug n play avatar, turn name, email, and any other string into beautiful avatar (or gravatar), effortless.
* <b><code>&nbsp;&nbsp;1667⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;194🍴</code></b> [Laravel FFmpeg](https://github.com/pascalbaljetmedia/laravel-ffmpeg)) - This package provides an integration with FFmpeg for Laravel 5.8.

##### Integration with Javascript

* <b><code>&nbsp;&nbsp;&nbsp;797⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;140🍴</code></b> [Laroute](https://github.com/aaronlord/laroute)) - Generate Laravel route URLs from JavaScript
* <b><code>&nbsp;&nbsp;2212⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;219🍴</code></b> [PHP Vars to JavaScript Transformer](https://github.com/laracasts/PHP-Vars-To-Js-Transformer)) - Pass server-side string/array/collection/whatever to JavaScript
* <b><code>&nbsp;&nbsp;1135⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;175🍴</code></b> [Javascript Validation](https://github.com/proengsoft/laravel-jsvalidation)) - Use validation rules, messages, FormRequest and validators to validate forms in client-side
* <b><code>&nbsp;&nbsp;&nbsp;510⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;50🍴</code></b> [Laravel Pjax](https://github.com/spatie/laravel-pjax)) - A Pjax middleware
* <b><code>&nbsp;&nbsp;&nbsp;619⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;41🍴</code></b> [Laravel Blade Javascript](https://github.com/spatie/laravel-blade-javascript)) - A Blade directive to export variables to JavaScript
* <b><code>&nbsp;&nbsp;3975⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;253🍴</code></b> [Ziggy](https://github.com/tightenco/ziggy)) - Use your Laravel named routes in JavaScript
* <b><code>&nbsp;22529⭐</code></b> <b><code>&nbsp;&nbsp;1581🍴</code></b> [LiveWire](https://github.com/livewire/livewire)) - A magical front-end framework for Laravel

##### Databases, ORMs, Migrations & Seeding

* <b><code>&nbsp;&nbsp;&nbsp;655⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;148🍴</code></b> [Backup Manager](https://github.com/backup-manager/laravel)) - Backup and restore databases from S3, Dropbox, SFTP etc.
* <b><code>&nbsp;&nbsp;3673⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;471🍴</code></b> [Laravel Nestedset](https://github.com/lazychaser/laravel-nestedset)) - Nested Sets pattern implementation
* <b><code>&nbsp;&nbsp;&nbsp;457⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;104🍴</code></b> [ClosureTable](https://github.com/franzose/ClosureTable)) - Closure table pattern implementation
* <b><code>&nbsp;&nbsp;&nbsp;554⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;58🍴</code></b> [Eloquence](https://github.com/kirkbushell/eloquence)) - Extra features for Eloquent models
* <b><code>&nbsp;&nbsp;2789⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;385🍴</code></b> [iSeed](https://github.com/orangehill/iseed)) - Generate a new seed file from an existing database table
* <b><code>&nbsp;&nbsp;&nbsp;839⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;239🍴</code></b> [Laravel OCI8](https://github.com/yajra/laravel-oci8)) - Oracle DB driver via OCI8
* <b><code>&nbsp;&nbsp;5688⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;762🍴</code></b> [Laravel Backup](https://github.com/spatie/laravel-backup)) - Backup your app
* <b><code>&nbsp;&nbsp;&nbsp;829⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;178🍴</code></b> [Laravel Doctrine](https://github.com/laravel-doctrine/orm)) - Doctrine 2 ORM implementation
* <b><code>&nbsp;&nbsp;7028⭐</code></b> <b><code>&nbsp;&nbsp;1428🍴</code></b> [Laravel MongoDB](https://github.com/jenssegers/laravel-mongodb)) - Eloquent model and query builder with support for MongoDB
* <b><code>&nbsp;&nbsp;3335⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;584🍴</code></b> [Migrations Generator](https://github.com/Xethron/migrations-generator)) - Generate migrations from an existing database
* <b><code>&nbsp;&nbsp;1087⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;142🍴</code></b> [Sofa/Eloquence](https://github.com/jarektkaczyk/eloquence)) - Extensions for the Eloquent ORM
* <b><code>&nbsp;&nbsp;&nbsp;588⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;53🍴</code></b> [Tenanti](https://github.com/orchestral/tenanti)) - Multi-tenant database schema manager
* <b><code>&nbsp;&nbsp;4197⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;878🍴</code></b> [Laravel Repository](https://github.com/andersao/l5-repository)) - Repositories to abstract the database layer
* <b><code>&nbsp;&nbsp;&nbsp;538⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;68🍴</code></b> [Lada Cache](https://github.com/spiritix/lada-cache)) - A Redis based, fully automated and scalable database cache layer
* <b><code>&nbsp;&nbsp;&nbsp;798⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;316🍴</code></b> [Laravel MySQL Spatial extension](https://github.com/grimzy/laravel-mysql-spatial)) - easily work with MySQL Spatial Data Types and MySQL Spatial Functions

##### Search

* <b><code>&nbsp;&nbsp;&nbsp;238⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;52🍴</code></b> [Algolia Search](https://github.com/algolia/algoliasearch-laravel)) - Integrates the Algolia Search API to the Laravel Eloquent ORM
* <b><code>&nbsp;&nbsp;1356⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;400🍴</code></b> [Elasticquent](https://github.com/elasticquent/Elasticquent)) - Elasticsearch for Eloquent models
* <b><code>&nbsp;&nbsp;&nbsp;509⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;109🍴</code></b> [Plastic](https://github.com/sleimanx2/plastic)) - Fluently mapping and searching Elasticsearch
* <b><code>&nbsp;&nbsp;&nbsp;352⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;59🍴</code></b> [Laravel Search](https://github.com/mmanos/laravel-search)) - Unified API for Elasticsearch, Algolia, and ZendSearch
* <b><code>&nbsp;&nbsp;&nbsp;442⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;48🍴</code></b> [SearchIndex](https://github.com/spatie/searchindex)) - Store and retrieve objects from Algolia or Elasticsearch
* <b><code>&nbsp;&nbsp;2010⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;291🍴</code></b> [Searchable](https://github.com/nicolaslopezj/searchable)) - Trait that adds a simple search function to Eloquent models
* <b><code>&nbsp;&nbsp;3102⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;292🍴</code></b> [TNTSearch](https://github.com/teamtnt/tntsearch)) - A fully featured full text search engine written in PHP
* <b><code>&nbsp;&nbsp;1104⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;142🍴</code></b> [TNTSearch driver](https://github.com/teamtnt/laravel-scout-tntsearch-driver)) - Driver for <b><code>&nbsp;&nbsp;1578⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;340🍴</code></b> [Laravel Scout](https://github.com/laravel/scout)) search package based on TNTSearch
* <b><code>&nbsp;&nbsp;&nbsp;535⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;109🍴</code></b> [Laravel-Searchy](https://github.com/TomLingham/Laravel-Searchy)) - Fuzzy search, basic string matching, Levenshtein Distance

##### APIs

* <b><code>&nbsp;&nbsp;&nbsp;691⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;144🍴</code></b> [ApiGuard](https://github.com/chrisbjr/api-guard)) - Allow API authentication with API keys
* <b><code>&nbsp;&nbsp;9328⭐</code></b> <b><code>&nbsp;&nbsp;1257🍴</code></b> [Dingo API](https://github.com/dingo/api)) - Multi-purpose toolkit for developing RESTful APIs
* <b><code>&nbsp;&nbsp;6275⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;613🍴</code></b> [Laravel CORS](https://github.com/barryvdh/laravel-cors)) - Add CORS (Cross-Origin Resource Sharing) headers support
* <b><code>&nbsp;&nbsp;1899⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;190🍴</code></b> [Laravel Fractal](https://github.com/spatie/laravel-fractal)) - Output complex, flexible, AJAX/RESTful data structures with Fractal
* <b><code>&nbsp;&nbsp;2140⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;264🍴</code></b> [Laravel GraphQL](https://github.com/rebing/graphql-laravel)) - Supports Relay, eloquent models, validation and GraphiQL
* <b><code>&nbsp;&nbsp;3382⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;438🍴</code></b> [Lighthouse](https://github.com/nuwave/lighthouse)) - An up and coming GraphQL library for Laravel
* <b><code>&nbsp;&nbsp;&nbsp;868⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;86🍴</code></b> [Laravel Responder](https://github.com/flugger/laravel-responder)) - Build custom API responses with Fractal

##### Tasks, Commands and Scheduling

* <b><code>&nbsp;&nbsp;1060⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;70🍴</code></b> [Dispatcher](https://github.com/indatus/dispatcher)) - Scheduler for Artisan commands
* <b><code>&nbsp;&nbsp;1075⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;250🍴</code></b> [Elixir](https://github.com/laravel/elixir)) - Node (NPM) package to run Gulp tasks
* <b><code>&nbsp;&nbsp;5274⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;811🍴</code></b> [Mix](https://github.com/JeffreyWay/laravel-mix)) - Fluent API for defining basic webpack build steps
* <b><code>&nbsp;&nbsp;1581⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;178🍴</code></b> [Envoy](https://github.com/laravel/envoy)) - SSH Task Runner

##### Payments

* <b><code>&nbsp;&nbsp;2397⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;681🍴</code></b> [Cashier](https://github.com/laravel/cashier)) - Subscription billing with Stripe
* <b><code>&nbsp;&nbsp;&nbsp;511⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;100🍴</code></b> [Omnipay for Laravel](https://github.com/ignited/laravel-omnipay)) - Integrate the <b><code>&nbsp;&nbsp;5962⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;929🍴</code></b> [Omnipay](https://github.com/thephpleague/omnipay)) PHP library

##### Optimization

* <b><code>&nbsp;&nbsp;&nbsp;636⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;120🍴</code></b> [Intervention Image Cache](https://github.com/Intervention/imagecache)) - Caching extension for the Intervention Image Class
* <b><code>&nbsp;&nbsp;1022⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;117🍴</code></b> [Laravel HTMLMin](https://github.com/GrahamCampbell/Laravel-HTMLMin)) - Blade/HTML/CSS/javascript minifier
* <b><code>&nbsp;&nbsp;1121⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;95🍴</code></b> [Rememberable](https://github.com/dwightwatson/rememberable)) - Query caching for Eloquent
* <b><code>&nbsp;&nbsp;&nbsp;903⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;73🍴</code></b> [Widgetize](https://github.com/imanghafoori1/laravel-widgetize)) - Page Partial caching
* <b><code>&nbsp;&nbsp;2511⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;228🍴</code></b> [Laravel Responsecache](https://github.com/spatie/laravel-responsecache)) - Speed up app by caching the entire response

##### Monitoring

* <b><code>&nbsp;&nbsp;3892⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;660🍴</code></b> [Horizon](https://github.com/laravel/horizon)) - Monitor and configure queues with a simple web UI
* <b><code>&nbsp;&nbsp;&nbsp;915⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;53🍴</code></b> [Laravel Failed Job Monitor](https://github.com/spatie/laravel-failed-job-monitor)) - Get notified when a queued job fails
* <b><code>&nbsp;&nbsp;1028⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;174🍴</code></b> [Laravel Uptime Monitor](https://github.com/spatie/laravel-uptime-monitor)) - A powerful and easy to configure uptime and ssl monitor
* <b><code>&nbsp;&nbsp;&nbsp;628⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;54🍴</code></b> [Larametrics](https://github.com/aschmelyun/larametrics)) - A self-hosted metrics and notifications platform for Laravel apps

##### Localization

* <b><code>&nbsp;&nbsp;7519⭐</code></b> <b><code>&nbsp;&nbsp;3041🍴</code></b> [Language Files](https://github.com/caouecs/Laravel-lang)) - Validation, Pagination and Reminders language lines in 37 languages
* <b><code>&nbsp;&nbsp;3389⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;513🍴</code></b> [Laravel Localization](https://github.com/mcamara/laravel-localization)) - Add i18n support via routes
* <b><code>&nbsp;&nbsp;2269⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;283🍴</code></b> [Laravel Translatable](https://github.com/spatie/laravel-translatable)) - Making Eloquent models translatable by storing translations as JSON
* <b><code>&nbsp;&nbsp;1948⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;320🍴</code></b> [Laravel Translatable](https://github.com/dimsav/laravel-translatable)) - Retrieve and store translatable Eloquent model instances
* <b><code>&nbsp;&nbsp;&nbsp;274⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28🍴</code></b> [Laravel Translator](https://github.com/vinkla/laravel-translator)) - Translate Eloquent models into multiple languages
* <b><code>&nbsp;&nbsp;1815⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;245🍴</code></b> [Laravel Date](https://github.com/jenssegers/date)) - A library to help you work with dates in multiple languages, based on Carbon
* <b><code>&nbsp;&nbsp;&nbsp;876⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;167🍴</code></b> [Laravel Langman](https://github.com/themsaid/laravel-langman)) - Manage language files from Artisan Console
* <b><code>&nbsp;&nbsp;&nbsp;359⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;170🍴</code></b> [Laravel Translation](https://github.com/waavi/translation)) - Translation and localization management
* <b><code>&nbsp;&nbsp;&nbsp;190⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15🍴</code></b> [Linguist](https://github.com/keevitaja/linguist)) - i18n localization support for Laravel

##### Third-party Service Integration

* <b><code>&nbsp;&nbsp;3114⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;468🍴</code></b> [Laravel Analytics](https://github.com/spatie/laravel-analytics)) - Retrieve pageviews and other data from Google Analytics
* <b><code>&nbsp;&nbsp;&nbsp;465⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;71🍴</code></b> [Laravel DigitalOcean](https://github.com/GrahamCampbell/Laravel-DigitalOcean)) - DigitalOceanV2 bridge
* <b><code>&nbsp;&nbsp;&nbsp;625⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;121🍴</code></b> [Laravel GitHub](https://github.com/GrahamCampbell/Laravel-GitHub)) - PHP GitHub API bridge
* <b><code>&nbsp;&nbsp;&nbsp;491⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;98🍴</code></b> [Laravel Instagram](https://github.com/vinkla/laravel-instagram)) - Instagram API bridge
* <b><code>&nbsp;&nbsp;1613⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;235🍴</code></b> [Laravel Newsletter](https://github.com/spatie/laravel-newsletter)) - Send newsletters with Mailchimp
* <b><code>&nbsp;&nbsp;&nbsp;402⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [Laravel Pusher](https://github.com/vinkla/laravel-pusher)) - Pusher API bridge

## Development Setup

* 🌎 [Homestead](laravel.com/docs/master/homestead) - Official Vagrant box for Laravel
* 🌎 [Valet](laravel.com/docs/master/valet) - Development environment for Mac users
* <b><code>&nbsp;&nbsp;1357⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;156🍴</code></b> [Valet Linux](https://github.com/cpriego/valet-linux)) - Development environment for Linux users
* <b><code>&nbsp;12462⭐</code></b> <b><code>&nbsp;&nbsp;4448🍴</code></b> [LaraDock](https://github.com/LaraDock/laradock)) - Run Laravel on Docker (Like Homestead but for Docker instead of Vagrant)
* <b><code>&nbsp;&nbsp;&nbsp;450⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;78🍴</code></b> [LaraEdit Docker](https://github.com/laraedit/laraedit-docker)) - Homestead environment in a single Docker container
* 🌎 [Laragon](laragon.org/) -  Isolated development environment on Windows
* <b><code>&nbsp;&nbsp;&nbsp;364⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;23🍴</code></b> [Stacker](https://github.com/Maxlab/stacker)) - The environment for local web development on Docker
* <b><code>&nbsp;&nbsp;4409⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;656🍴</code></b> [Devilbox](https://github.com/cytopia/devilbox)) - A dockerized and general-purpose LAMP/MEAN stack for every PHP version
* 🌎 [Vessel](vessel.shippingdocker.com) - Simple Docker development environments for Laravel
* 🌎 [Lando](docs.lando.dev/config/laravel.html) - A local development environment tool built on Docker

## Application Hosting

* 🌎 [Vapor](vapor.laravel.com)
* 🌎 [Forge](forge.laravel.com/)  🌎 [ForgeRecipes](forgerecipes.com/))
* 🌎 [FortRabbit](www.fortrabbit.com/laravel-hosting)
* 🌎 [Heroku](www.heroku.com/)  🌎 [Documentation](devcenter.heroku.com/articles/getting-started-with-laravel))
* 🌎 [AWS Elastic Beanstalk](aws.amazon.com/elasticbeanstalk/) ([Tutorial](http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/php-laravel-tutorial.html))
* 🌎 [Cloudways](www.cloudways.com/en/laravel-hosting.php)
* 🌎 [Ploi](ploi.io/)
* 🌎 [CodePier](codepier.io?ref=awesome-laravel)
* 🌎 [RunCloud](runcloud.io/)

## Application Deployment

* 🌎 [Deployer](deployer.org/) - A deployment tool with support for Laravel out of the box
* 🌎 [Envoyer](envoyer.io/) - Zero down-time Deployer for PHP & Laravel projects
* <b><code>&nbsp;&nbsp;2661⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;217🍴</code></b> [Rocketeer](https://github.com/rocketeers/rocketeer)) - Task runner and deployment package

## Code Snippets

* 🌎 [Laravel LTS Cheat Sheet ](summerblue.github.io/laravel5-cheatsheet/)  🌎 [Chinese version](cs.phphub.org/))
* [Laravel Tricks](http://laravel-tricks.com/)

## Tutorials & Blogs

* [Taylor Otwell](http://taylorotwell.com/)
* 🌎 [Tuts+](code.tutsplus.com/categories/laravel)
* 🌎 [Medium](medium.com/tag/laravel/latest)
* 🌎 [Laravel Daily](laraveldaily.com/)
* 🌎 [Scotch](scotch.io/tag/laravel)
* 🌎 [Digital Ocean](www.digitalocean.com/community/search?q=laravel&primary_filter=newest&type=tutorials)
* 🌎 [Matt Stauffer](mattstauffer.co/blog)
* 🌎 [Vegi Bit](vegibit.com/tag/laravel/)
* 🌎 [Neon Tsunami](www.neontsunami.com/tags/laravel)
* 🌎 [Dor.ky](dor.ky/tag/laravel/)
* 🌎 [Stillat](stillat.com/explore/categories/laravel-5)
* [Easy Laravel Book Blog](http://www.easylaravelbook.com/blog/)
* [Laraveles](http://laraveles.com/blog/) (ES)
* 🌎 [Styde](styde.net/category/laravel-5/) (ES)
* [Cloudways Laravel Blog](http://cloudways.com/blog/laravel)
* <b><code>&nbsp;11500⭐</code></b> <b><code>&nbsp;&nbsp;2397🍴</code></b> [Laravel Best Practices](https://github.com/alexeymezenin/laravel-best-practices))
* 🌎 [Pusher Laravel Tutorials](pusher.com/tutorials?tag=Laravel)
* 🌎 [LaraShout](larashout.com/)

## Videos

* 🌎 [Laracasts](laracasts.com/)
* 🌎 [Codecourse](www.codecourse.com/)  🌎 [YouTube](www.youtube.com/user/phpacademy/playlists))
* [Tuts+](http://code.tutsplus.com/categories/laravel/courses)
* 🌎 [Servers for Hackers](serversforhackers.com/laravel-perf)
* 🌎 [Test-Driven Laravel](course.testdrivenlaravel.com/)
* 🌎 [Duilio Palacios](www.youtube.com/user/silencedsg/videos) (ES)
* 🌎 [CodigoFacilito](codigofacilito.com/courses/laravel) (ES)
* 🌎 [DevDojo](devdojo.com/search?value=laravel)
* 🌎 [Amitav Roy](www.youtube.com/channel/UC4gijXR8cM4gmEt9Olse-TQ/videos)
* 🌎 [Laracademy](laracademy.co/)
* 🌎 [Dev Marketer](www.youtube.com/channel/UC6kwT7-jjZHHF1s7vCfg2CA/playlists)
* 🌎 [Udemy](www.udemy.com/courses/search/?q=laravel)
* 🌎 [Lynda](www.lynda.com/search?q=laravel)
* 🌎 [Pluralsight](www.pluralsight.com/search?q=laravel&categories=course)
* 🌎 [Bitfumes](www.youtube.com/bitfumes)
* 🌎 [ConfidentLaravel](confidentlaravel.com/)

## Conferences

* [Laracon US](http://laracon.us/)
* [Laracon EU](http://laracon.eu/)
* 🌎 [Laracon Online](laracon.net/)
* [Laraconf Brasil](http://laraconfbrasil.com.br/)
* 🌎 [Laracon Australia](laracon.com.au/)
* 🌎 [Laravel Live UK](laravellive.uk/)
* 🌎 [Laravel Live India](laravellive.in/)
* 🌎 [Laravel Nigeria](laravelnigeria.com)

##### Videos

* 🌎 [Laracon EU 2018](www.youtube.com/playlist?list=PLMdXHJK-lGoC64wnqvm6v1R5dsuAV-MpS)
* 🌎 [Laracon US 2018](www.youtube.com/playlist?list=PL-yJve--iT5oM2LgF37VXsBb8Os4ZulIc)
* 🌎 [Laracon EU 2017](www.youtube.com/playlist?list=PLMdXHJK-lGoBFZgG2juDXF6LiikpQeLx2)
* 🌎 [Laracon US 2017](www.youtube.com/playlist?list=PL-yJve--iT5oaLQA6OI8TWLVSOBP1qhs3)
* 🌎 [Laracon EU 2016](www.youtube.com/playlist?list=PLMdXHJK-lGoCMkOxqe82hOC8tgthqhHCN)
* 🌎 [Laracon US 2016](www.youtube.com/playlist?list=PL-yJve--iT5o9fH_cRY0u6P751pcF59GK)
* 🌎 [Laracon EU 2015](www.youtube.com/playlist?list=PLMdXHJK-lGoA9SIsuFy0UWL8PZD1G3YFZ)
* Laracon US 2015
* 🌎 [Laracon EU 2014](www.youtube.com/playlist?list=PLMdXHJK-lGoCYhxlU3OJ5bOGhcKtDMkcN)
* 🌎 [Laracon US 2014](www.youtube.com/channel/UCRawXmZv30Vf_MivyPYb_GQ/videos)
* 🌎 [Laracon EU 2013](www.youtube.com/playlist?list=PLMdXHJK-lGoB-CIVsiQt0WU8WcYrb5eoe)
* 🌎 [Laracon US 2013](www.youtube.com/playlist?list=PLkwAlZpjHQbLcox_S_AgGU24QUfKgXayN)

## Books

* 🌎 [Laravel Starter](www.amazon.com/Laravel-Starter-Shawn-McCool-ebook/dp/B00ABFQ0AS) by Shawn McCool
* 🌎 [Laravel: Code Happy](leanpub.com/codehappy) by Dayle Rees
* 🌎 [Laravel: Code Bright](leanpub.com/codebright) by Dayle Rees
* 🌎 [Laravel: Code Smart](leanpub.com/codesmart) by Dayle Rees
* 🌎 [Laravel: From Apprentice To Artisan](leanpub.com/laravel) by Taylor Otwell
* 🌎 [Laravel 4 Cookbook](leanpub.com/laravel4cookbook) by Christopher Pitt and Taylor Otwell
* 🌎 [Laravel Testing Decoded](leanpub.com/laravel-testing-decoded) by Jeffrey Way
* 🌎 [Refactoring to Collections](adamwathan.me/refactoring-to-collections/) by Adam Wathan
* 🌎 [Implementing Laravel](leanpub.com/implementinglaravel) by Chris Fidao
* 🌎 [Getting Stuff Done with Laravel 4](leanpub.com/gettingstuffdonelaravel) by Chuck Heintzelman
* 🌎 [Laravel Application Development Blueprints](www.packtpub.com/web-development/laravel-application-development-blueprints) by Arda Kılıçdağı and Halil İbrahim Yılmaz
* 🌎 [Build APIs You Won't Hate](leanpub.com/build-apis-you-wont-hate) by Phil Sturgeon
* 🌎 [Integrating Front end Components with Web Applications](leanpub.com/frontend) by Maksim Surguy
* 🌎 [Laravel Design Patterns and Best Practices](www.packtpub.com/web-development/laravel-design-patterns-and-best-practices) by Arda Kılıçdağı and Halil İbrahim Yılmaz
* 🌎 [Learning Laravel 4 Application Development](www.packtpub.com/web-development/learning-laravel-4-application-development) by Hardik Dangar
* 🌎 [Getting Started with Laravel 4](www.packtpub.com/web-development/getting-started-laravel-4) by Raphaël Saunier
* 🌎 [Laravel Application Development Cookbook](www.packtpub.com/web-development/laravel-application-development-cookbook) by Terry Matula
* 🌎 [Building Web Applications Using Parse REST API](leanpub.com/building-web-applications-using-parse-rest-api) by Mhd Zaher Ghaibeh
* 🌎 [Laravel - My First Framework](leanpub.com/laravel-first-framework) by Maksim Surguy
* 🌎 [Easy Laravel 5](leanpub.com/easylaravel/) by W. Jason Gilmore
* 🌎 [Laravel 5 Essentials](www.packtpub.com/web-development/laravel-5-essentials) by Martin Bean
* 🌎 [Easy E-Commerce Using Laravel and Stripe](leanpub.com/easyecommerce) by W. Jason Gilmore and Eric L. Barnes
* 🌎 [Laravel 5.1 Beauty](leanpub.com/l5-beauty) by Chuck Heintzelman
* 🌎 [Design Patterns with PHP and Laravel](leanpub.com/larasign) by Kelt Dockins
* 🌎 [Mastering Laravel](www.packtpub.com/web-development/mastering-laravel) by Christopher John Pecoraro
* [How to Build Real-Time Laravel Apps with Pusher](http://pusher-community.github.io/real-time-laravel/) by Pusher
* 🌎 [Learning Laravel's Eloquent](www.amazon.com/Learning-Laravels-Eloquent-Francesco-Malatesta-ebook/dp/B00YSILQ6C) by Francesco Malatesta
* 🌎 [Laravel 5 Learn Easy](leanpub.com/laravel5learneasy) by Sanjib Sinha
* 🌎 [Laravel and AngularJS](leanpub.com/laravel-and-angularjs) by Daniel Schmitz and Daniel Pedrinha Georgii
* 🌎 [Laravel Collections Unraveled](leanpub.com/laravelcollectionsunraveled) by Jeff Madsen
* 🌎 [Writing APIs With Lumen](leanpub.com/lumen-apis) by Paul Redmond
* 🌎 [The Laravel Survival Guide](leanpub.com/laravelsurvivalguide) by Tony Lea
* 🌎 [Laraboot: Laravel 5 For Beginners](leanpub.com/laravel-5-for-beginners-laraboot) by Bill Keck
* 🌎 [Laravel 5.4 For Beginners](leanpub.com/laravel-5-4-for-beginners) by Bill Keck
* 🌎 [Laravel Up & Running](www.amazon.com/gp/product/1491936088) by Matt Stauffer
* 🌎 [Laravel Companion](leanpub.com/laravelcompanion-secondedition) by Johnathon Koster
* 🌎 [Deploy Laravel on AWS with CloudFormation](leanpub.com/laravel-aws) by Lionel Martin
* 🌎 [React Native and Laravel for Future Mobile Development](leanpub.com/rn_laravel) by Ega Radiegtya
* 🌎 [Servers for Hackers](book.serversforhackers.com) by Chris Fidao
* 🌎 [Full-Stack Vue.js 2 and Laravel 5](www.amazon.com/Full-Stack-Vue-js-Laravel-frontend-together/dp/1788299582) by Anthony Gore
* 🌎 [Build an API with Laravel](buildanapi.com) by Wacky Studio

## Starter Projects

* 🌎 [Spark](spark.laravel.com/)
* <b><code>&nbsp;&nbsp;1576⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;537🍴</code></b> [LaraAdmin](https://github.com/dwijitsolutions/laraadmin))
* <b><code>&nbsp;&nbsp;&nbsp;990⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;110🍴</code></b> [Grafite Builder](https://github.com/GrafiteInc/Builder))
* <b><code>&nbsp;&nbsp;5603⭐</code></b> <b><code>&nbsp;&nbsp;1576🍴</code></b> [Laravel Boilerplate](https://github.com/rappasoft/laravel-5-boilerplate))
* <b><code>&nbsp;&nbsp;1661⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;400🍴</code></b> [Laravel Angular Material Starter](https://github.com/jadjoubran/laravel5-angular-material-starter))
* <b><code>&nbsp;&nbsp;1813⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;510🍴</code></b> [AdminLTE Laravel](https://github.com/acacha/adminlte-laravel))
* <b><code>&nbsp;&nbsp;1639⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;296🍴</code></b> [Laravel Hackathon Starter](https://github.com/unicodeveloper/laravel-hackathon-starter))
* <b><code>&nbsp;&nbsp;&nbsp;425⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;117🍴</code></b> [Laravel API Starter Kit](https://github.com/joselfonseca/laravel-api))
* <b><code>&nbsp;&nbsp;&nbsp;925⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;267🍴</code></b> [Backpack for Laravel](https://github.com/Laravel-Backpack/Base))
* <b><code>&nbsp;&nbsp;&nbsp;839⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;169🍴</code></b> [SomelineStarter](https://github.com/someline/someline-starter))
* <b><code>&nbsp;11159⭐</code></b> <b><code>&nbsp;&nbsp;2829🍴</code></b> [Laravel Admin](https://github.com/z-song/laravel-admin))
* <b><code>&nbsp;11816⭐</code></b> <b><code>&nbsp;&nbsp;2676🍴</code></b> [Voyager](https://github.com/the-control-group/voyager))
* <b><code>&nbsp;&nbsp;4482⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;657🍴</code></b> [Orchid](https://github.com/TheOrchid/Platform))
* <b><code>&nbsp;&nbsp;1174⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;285🍴</code></b> [Laravel REST API Boilerplate](https://github.com/francescomalatesta/laravel-api-boilerplate-jwt))
* <b><code>&nbsp;&nbsp;3030⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;486🍴</code></b> [Hello API](https://github.com/Porto-SAP/Hello-API))
* <b><code>&nbsp;&nbsp;&nbsp;487⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;143🍴</code></b> [REST API With Lumen](https://github.com/hasib32/rest-api-with-lumen))
* <b><code>&nbsp;&nbsp;3725⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;202🍴</code></b> [Laravel Zero - Console application](https://github.com/laravel-zero/laravel-zero))
* <b><code>&nbsp;&nbsp;3030⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;486🍴</code></b> [Apiato](https://github.com/apiato/apiato))
* <b><code>&nbsp;&nbsp;&nbsp;972⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;460🍴</code></b> [Laravel Adminpanel](https://github.com/viralsolani/laravel-adminpanel))
* <b><code>&nbsp;&nbsp;&nbsp;542⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;145🍴</code></b> [Laravel Vue Boilerplate](https://github.com/alefesouza/laravel-vue-boilerplate))
* <b><code>&nbsp;&nbsp;1086⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;279🍴</code></b> [Laravel Enso](https://github.com/laravel-enso/enso))
* <b><code>&nbsp;&nbsp;&nbsp;963⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;268🍴</code></b> [Laravel Template with Vue](https://github.com/wmhello/laravel_template_with_vue))

## Codebases for Reference

* <b><code>&nbsp;14154⭐</code></b> <b><code>&nbsp;&nbsp;1565🍴</code></b> [Cachet](https://github.com/cachethq/Cachet)) - Status page system for websites and APIs
* <b><code>&nbsp;&nbsp;&nbsp;915⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;185🍴</code></b> [Deployer](https://github.com/REBELinBLUE/deployer)) - Application deployment system
* <b><code>&nbsp;&nbsp;2895⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;728🍴</code></b> [GitScrum](https://github.com/renatomarinho/laravel-gitscrum)) - Task management with Git and Scrum
* <b><code>&nbsp;&nbsp;8408⭐</code></b> <b><code>&nbsp;&nbsp;2290🍴</code></b> [Invoice Ninja](https://github.com/invoiceninja/invoiceninja)) - Invoicing, expenses, & time-tracking application
* <b><code>&nbsp;16130⭐</code></b> <b><code>&nbsp;&nbsp;1982🍴</code></b> [Koel](https://github.com/phanan/koel)) - Personal music streaming server
* <b><code>&nbsp;&nbsp;2455⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;654🍴</code></b> [Laravel.io](https://github.com/laravelio/portal)) - Source for the Laravel.io Community Portal
* <b><code>&nbsp;&nbsp;4043⭐</code></b> <b><code>&nbsp;&nbsp;1192🍴</code></b> [Attendize](https://github.com/Attendize/Attendize)) - Ticket selling and event management platform
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Antvel](https://github.com/ant-vel/App)) - Ecommerce platform
* <b><code>&nbsp;&nbsp;2149⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;182🍴</code></b> [Jigsaw](https://github.com/tightenco/jigsaw)) - Static site generator
* <b><code>&nbsp;&nbsp;3270⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;519🍴</code></b> [Canvas](https://github.com/cnvs/canvas)) - A Laravel Publishing Platform
* <b><code>&nbsp;&nbsp;2287⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;542🍴</code></b> [Vuedo](https://github.com/Vuedo/vuedo)) - Vuedo is blog platform, built with Laravel and Vue.js
* <b><code>&nbsp;&nbsp;&nbsp;509⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;101🍴</code></b> [Screeenly](https://github.com/stefanzweifel/screeenly)) - Create website screenshots through an API
* <b><code>&nbsp;&nbsp;1261⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;230🍴</code></b> [Voten](https://github.com/voten-co/voten)) - A real-time social bookmarking for the 21st century
* <b><code>&nbsp;21921⭐</code></b> <b><code>&nbsp;&nbsp;2195🍴</code></b> [Monica](https://github.com/monicahq/monica)) - Personal relationship management system
* <b><code>&nbsp;11358⭐</code></b> <b><code>&nbsp;&nbsp;3227🍴</code></b> [Snipe-IT](https://github.com/snipe/snipe-it)) - IT asset/license management system
* <b><code>&nbsp;&nbsp;8211⭐</code></b> <b><code>&nbsp;&nbsp;2485🍴</code></b> [Akaunting](https://github.com/akaunting/akaunting)) - Accounting software for small businesses and freelancers
* <b><code>&nbsp;&nbsp;1855⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;211🍴</code></b> [Torch](https://github.com/mattstauffer/Torch)) - Examples of using each Illuminate component in non-Laravel applications
* <b><code>&nbsp;&nbsp;5710⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;685🍴</code></b> [Pixelfed](https://github.com/pixelfed/pixelfed)) - A free and ethical photo sharing platform, powered by ActivityPub federation


## Content Management Systems

* <b><code>&nbsp;11057⭐</code></b> <b><code>&nbsp;&nbsp;2208🍴</code></b> [OctoberCMS](https://github.com/octobercms/october))
* <b><code>&nbsp;&nbsp;&nbsp;808⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;217🍴</code></b> [SleepingOwlAdmin](https://github.com/LaravelRUS/SleepingOwlAdmin))
* <b><code>&nbsp;&nbsp;3181⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;933🍴</code></b> [PyroCMS](https://github.com/pyrocms/pyrocms))
* <b><code>&nbsp;&nbsp;2859⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;970🍴</code></b> [Lavalite](https://github.com/LavaLite/cms))
* <b><code>&nbsp;&nbsp;1407⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;405🍴</code></b> [TypiCMS](https://github.com/typicms/base))
* <b><code>&nbsp;&nbsp;&nbsp;783⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;241🍴</code></b> [Asgard CMS](https://github.com/AsgardCms/Platform))
* <b><code>&nbsp;&nbsp;3160⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;886🍴</code></b> [Microweber](https://github.com/microweber/microweber))
* <b><code>&nbsp;&nbsp;&nbsp;392⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;107🍴</code></b> [Coaster CMS](https://github.com/web-feet/coastercms))
* 🌎 [Statamic](statamic.com/)
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Borgert CMS](https://github.com/odirleiborgert/borgert-cms/))
* <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [PJ Blog](https://github.com/jcc/blog/))
* <b><code>&nbsp;&nbsp;&nbsp;299⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;44🍴</code></b> [Laralum](https://github.com/Laralum/Laralum))
* <b><code>&nbsp;&nbsp;3811⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;577🍴</code></b> [Twill](https://github.com/area17/twill))

## Podcasts

* [The Laravel Podcast](http://www.laravelpodcast.com/)
* 🌎 [The Laravel News Podcast](laravel-news.com/podcast/ )
* 🌎 [The Laracasts Snippet](laracasts.simplecast.fm/)
* [Hecho en Laravel (Spanish)](http://hechoenlaravel.com)

## Community

* 🌎 [Laracasts Forum](laracasts.com/discuss)
* [Laravel.io Forum](http://laravel.io/forum)
* 🌎 [Larachat Slack](larachat.slack.com/)  🌎 [Signup](larachat.co/register))
* 🌎 [Gitter](gitter.im/laravel/laravel)
* [IRC Channel](http://laravel.io/chat)
* [StackOverflow](http://stackoverflow.com/questions/tagged/laravel)
* 🌎 [Twitter](twitter.com/laravelphp)
* 🌎 [Google+](plus.google.com/communities/106838454910116161868)
* 🌎 [Reddit](www.reddit.com/r/laravel)
* 🌎 [Quora](www.quora.com/topic/Laravel)
* 🌎 [Facebook](www.facebook.com/LaravelCommunity)
* 🌎 [LinkedIn](www.linkedin.com/groups/4419933/profile)

##### Local User Groups

* 🌎 [Laravel Global Community](www.facebook.com/groups/group.laravel/)
* 🌎 [LaravelES Slack](laraveles.slack.com) ([Signup](http://laraveles.com/blog/wp-login.php?action=slack-invitation))
* 🌎 [Laravel India](laravellive.in/), 🌎 [Slack Signup](laravelliveindia.slack.com/join/shared_invite/enQtNjQyMDE4NDA3MDQzLWMyZmIxNGZkNGVkNGFmMzE1MTgyOGNiZGY1ZmU1ZDQ3Mzk2ODBlZGJlODk3ZmI0OWNlZmI5MzQyZDJhYzg1NjE), 🌎 [Twitter](twitter.com/LaravelLiveIN), 🌎 [Facebook](www.facebook.com/laravellive/), 🌎 [Youtube](www.youtube.com/channel/UC6TxYSHI7g9FMJ7VlHk72Yg)
* 🌎 [Laravel UK](laravelphp.uk/), 🌎 [Slack Signup](laravelphp.uk/login/slack)
* 🌎 [Laravel Russia](laravel.ru/) ([VK group](http://m.vk.com/laravel_rus))
* 🌎 [Laravel France](laravel.fr/)
* 🌎 [Laravel Bangladesh](www.facebook.com/groups/LaravelBanglaDesh/)
* [Laravel Indonesia](http://id-laravel.com/)  🌎 [Facebook](www.facebook.com/groups/laravel/), 🌎 [Telegram](t.me/laravelindonesia))
* [Laravel Brasil](http://www.laravel.com.br/)  🌎 [Facebook](www.facebook.com/groups/laravelbrasil/), [Slack](http://slack.laravel.com.br), 🌎 [Telegram](telegram.me/laravelbr), [GitHub](https://github.com/laravelbrasil), 🌎 [Discord](discord.gg/9dpuWeZ))
* [Laravel Turkey](http://www.laravel.gen.tr/)  🌎 [Facebook](www.facebook.com/groups/laravelturkiye/))
* [Laravel Nigeria](http://www.laravelnigeria.com/)  🌎 [Facebook](www.facebook.com/groups/laravelnigeria/))
* 🌎 [Laravel China](phphub.org/)
* 🌎 [Laravel Taiwan](laravel.tw/)  🌎 [Facebook](www.facebook.com/groups/laravel.tw/))
* [Laravel Spanish](http://laraveles.com/foro/)
* 🌎 [Laravel Korea](www.laravel.co.kr/)  🌎 [Facebook](www.facebook.com/groups/laravelkorea/))
* [Laravel Japan](http://laravel.jp/)  🌎 [Facebook](www.facebook.com/groups/laravel.jp/))
* 🌎 [Laravel Malaysia](www.facebook.com/groups/laravel.my/)
* 🌎 [Laravel Algeria](www.facebook.com/groups/LaravelAlgeria/)
* [Laravel Greece](http://www.laravel.gr)  🌎 [Facebook](www.facebook.com/laravelgr))
* [Laravel Middle East](http://laravelme.com/)  🌎 [Facebook](www.facebook.com/laravelme))
* 🌎 [Laravel Georgia](www.facebook.com/groups/laravel.georgia/)
* [Laravel Italy](http://laravel-italia.it)
* 🌎 [Laravel Vietnam](www.facebook.com/groups/vietnam.laravel/)
* 🌎 [Laravel Slovenia](www.facebook.com/groups/laravelslovenija/)
* 🌎 [Laravel Hungary](laravel.hu)
* 🌎 [Laravel Cameroon](laravelcm.com/)  🌎 [Slack](laravelcm.slack.com), [GitHub](https://github.com/laravelcm), 🌎 [Facebook](www.facebook.com/laravelcm), 🌎 [Twitter](twitter.com/laravelcm))
* 🌎 [Laravel Philippines](www.facebook.com/groups/laravelph)

##### Meetups

* [All Meetups](http://www.meetup.com/topics/laravel/)
* 🌎 [London Meetup](www.meetup.com/London-Laravel/)
* 🌎 [Buenos Aires Meetup](www.meetup.com/Laravel-Buenos-Aires/)
* 🌎 [Athens-Greece Meetup](www.meetup.com/athens-laravel-meetup/)
* 🌎 [Copenhagen Meetup](www.meetup.com/Copenhagen-Laravel-Meetup/)
* 🌎 [Detroit Meetup](www.meetup.com/Laravel-Detroit/)
* 🌎 [Paris Meetup](www.meetup.com/fr-FR/Paris-Laravel-Meetup/)
* 🌎 [Melbourne Meetup](www.meetup.com/Melbourne-laravel-Meetup/)
* 🌎 [Budapest Meetup](www.meetup.com/Laravel-Hungary-Meetup/)

## Jobs

* 🌎 [LaraJobs](larajobs.com/)
* 🌎 [Laravel Gurus](laravelgurus.com/)

## Hosted Development Tools

* 🌎 [Laravel Shift](laravelshift.com/) - Automated upgrade tool for Laravel projects
* [Laravel Schema Designer](http://laravelsd.com/) - Create, export and share database schemas
* 🌎 [StyleCI](styleci.io) - PHP Coding Style Service

## Miscellaneous

* 🌎 [CodeCanyon](codecanyon.net/tags/laravel?term=laravel) - Paid scripts and plugins
* 🌎 [Laravel Collections](laravelcollections.com) - Every Laravel Developers Goto Resource Site
* 🌎 [LaravelLinks](telegram.me/laravellinks) - A Telegram Channel dedicated to sharing great Laravel Resources

## Contributing

Found an awesome package, blog, course or video? Send me a pull request!

#### Guidelines

* Please make an individual pull request for each suggestion
* Make sure the Travis tests pass on your pull request
* Use the following format for links: \[Resource\]\(URL\)
* Want to suggest a package? Read the [Contribution Guide](https://github.com/correia-jpv/fucking-awesome-laravel/blob/master/CONTRIBUTING.md)
* New categories or improvements to the existing categorization are welcome

## License

[![CC BY 4.0](https://licensebuttons.net/l/by/4.0/88x31.png)](https://creativecommons.org/licenses/by/4.0/)

Awesome Laravel is licensed under a  🌎 [Creative Commons Attribution 4.0 International License](creativecommons.org/licenses/by/4.0/).

## Source
<b><code>&nbsp;12587⭐</code></b> <b><code>&nbsp;&nbsp;2360🍴</code></b> [chiraggude/awesome-laravel](https://github.com/chiraggude/awesome-laravel))