# CONTRIBUTING

Contributions are welcome, and are accepted via pull requests. Please review these guidelines before submitting any pull requests.

## Must haves for Packages, Starter Projects, Codebases etc.

- 500+ stars on GitHub.
- Support Laravel 6 LTS or higher.
- Use [PSR-4](http://www.php-fig.org/psr/psr-4/) autoloader.
- Packages must be listed on [Packagist](https://packagist.org/).
- Packages must have also had 10,000 downloads.
- Utilize [Travis-CI](https://travis-ci.org/) or similar CI tools to automatically check coding standards and run tests.

## Adding to the list of Popular Packages

Please ensure your pull request adheres to the following guidelines:

- Make an individual pull request for each suggestion.
- Search previous suggestions before making a new one, as yours may be a duplicate.
- Use the following format for links: \[Package\]\(URL\) - Short description
- The pull request and commit should have a useful title.

## Best practices for all repos

- Keep a [Changelog](http://keepachangelog.com/)
- Adhere to [PSR-2](http://www.php-fig.org/psr/psr-2/) as the coding style guide.
- [DocBlock](http://www.phpdoc.org/docs/latest/references/phpdoc/index.html) all the things.
- Use [Semantic Versioning](http://semver.org/).
- Maintain an extensive [README](https://github.com/thephpleague/skeleton/blob/master/README.md).
- [Excludes non-essential files in .gitattributes](https://www.reddit.com/r/PHP/comments/2jzp6k/i_dont_need_your_tests_in_my_production).
