[<img src="https://user-images.githubusercontent.com/1295961/45949308-cbb2f680-bffb-11e8-8054-28c35ed6d132.png" align="center" width="850">](https://flutter.dev/)


<p align="center">
<a href="https://github.com/sindresorhus/awesome">
<img alt="Awesome" src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" />
</a>
<a href="https://twitter.com/blueaquilae">
<img alt="Awesome" src="https://img.shields.io/twitter/url/https/twitter.com/blueaquilae.svg?style=social&label=Follow%20%40blueaquilae" />
</a>
</p>


<a href="https://flutter.dev/">🌎 Flutter</a> is Google’s UI toolkit for building beautiful, natively compiled applications for mobile, web, and desktop from a single codebase.
If you appreciate the content 📖, support projects visibility, give 👍| ⭐| 👏

<a href="https://getstream.io/chat/sdk/flutter/?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&utm_campaign=Github_Mar2022_FlutterChatSDK&utm_term=Awesome">
<img src="https://user-images.githubusercontent.com/1295961/160238710-1b5a987a-478e-41b4-b11c-37be8670a8c9.png"/>
</a>


#### Demonstrations
<div style="text-align: center"><table><tr>
<td style="text-align: center, width: 180">

 🌎 [Instant Chat Integration](getstream.io/chat/sdk/flutter/?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&utm_campaign=Github_Mar2022_FlutterChatSDK&utm_term=Awesome)

<a href="https://getstream.io/chat/sdk/flutter/?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&utm_campaign=Github_Mar2022_FlutterChatSDK&utm_term=Awesome">
<img alt="Stream" src="./.github/stream-animation.gif" />
</a>
 🌎 [with Stream!](getstream.io/chat/sdk/flutter/?utm_source=Github&utm_medium=Github_Repo_Content_Ad&utm_content=Developer&utm_campaign=Github_Mar2022_FlutterChatSDK&utm_term=Awesome)


</td>
<td style="text-align: center">
<img width="180" alt="BMW" src="https://user-images.githubusercontent.com/1295961/160239273-ce881c0c-c3de-4953-9448-dfd12d7ffe30.png">

BMW
Connect

</td>
<td style="text-align: center">
<img width="180" alt="BlueAquilae Twitter Meteo" src="https://user-images.githubusercontent.com/1295961/160238906-540a4a0d-b721-4c73-8b58-58b96b5e6414.png">


Calendar
Meteo

</td>


</tr></table></div>


## Contents

- [Articles](#articles)
- [Videos](#videos)
- [Components](#components)
- [Navigation](#navigation)
- [Template](#templates)
- [Plugins](#plugins)
- [Frameworks](#frameworks)
- [Experimental](#experimental)
- [Open Source Apps](#open-source-apps)
- [Web](#web)
- [Utilities](#utilities)
- [Bonus](#bonus)
- [Community](#community)

## Articles

### Introduction

- 🌎 [Google IO 2018](medium.com/flutter-io/building-beautiful-flexible-user-interfaces-with-flutter-material-theming-and-official-material-13ae9279ef19)  - Building beautiful, flexible user interfaces
- 🌎 [Presentation](speakerdeck.com/hjjunior/why-i-chose-flutter) - by [Helio S. Junior](https://github.com/hjJunior)
- 🌎 [Flutter Web](medium.com/flutter-community/ins-and-outs-of-flutter-web-7a82721dc19a)  - Ins and Outs of Flutter Web by [Nash](https://github.com/nash0x7e2)

### Websites / Blogs

- 🌎 [Welcome to Flutter](didierboelens.com) - English and French blog dedicated to providing practical solutions to most asked questions about Flutter by Didier Boelens
- 🌎 [SZAŁKO-BLOG](marcinszalek.pl/) - Step by step advanced design by 🌎 [Marcin Szalek](marcinszalek.pl).
- 🌎 [Flutter by Example](flutterbyexample.com/) - Tutorials based on Redux, Firebase, Custom Animations, and UI
- 🌎 [Flutter Institute](flutter.institute/) - Very original content and tutorials by 🌎 [Brian Armstrong](twitter.com/flutterinst)
- 🌎 [Norbert](medium.com/@norbertkozsir) - In depth articles, features and app creation by [Norbert515](https://github.com/Norbert515)
- 🌎 [Flutter Tips](medium.com/@diegoveloper) - Articles, tips & tricks in the development by 🌎 [Diego Velásquez](twitter.com/diegoveloper)
- 🌎 [FilledStacks](www.filledstacks.com/) - Tutorials and guides on development by 🌎 [Dane Mackier](www.instagram.com/filledstacks/)
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Awesome Flutter tips](https://github.com/erluxman/awesomefluttertips/)) - Tips to help developers increase productivity by 🌎 [erluxman](twitter.com/erluxman/).
- [Flutter4Fun](http://flutter4fun.com) - UI Challenge implementation blog by [Iman Khoshabi](https://github.com/imaNNeoFighT).
- 🌎 [Flutter Stack Weekly](blog.canopas.com/tagged/canopas-flutter-weekly) - Weekly newsletter on new development and updates curated by 🌎 [Jimmy Sanghani](twitter.com/jimmys0251)


### Tutorial

- 🌎 [Animated Chat](codelabs.developers.google.com/codelabs/flutter/#0) - Building beautiful UIs by Google Code Labs
- 🌎 [Firebase Chat](codelabs.developers.google.com/codelabs/flutter-firebase/#0) - Firebase integration by Google Code Labs
- 🌎 [Flutter and Dart development](suragch.medium.com/flutter-and-dart-development-articles-981be9ef7b23) - Articles and tutorials by 🌎 [Suragch](twitter.com/Suragch1)

### Beginner

- <b><code>&nbsp;&nbsp;5559⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;777🍴</code></b> [Roadmap to Flutter Development](https://github.com/olexale/flutter_roadmap)) [5433⭐] - Visual roadmap with principles, patterns, and frameworks for Flutter newbies by [Olexandr Leuschenko](https://github.com/olexale).
- 🌎 [Layout Cheat Sheet](medium.com/flutter-community/flutter-layout-cheat-sheet-5363348d037e) - Extensive examples of layout widgets by [Tomek Polański](https://github.com/tomaszpolanski)
- 🌎 [Getting Started with Flutter](www.raywenderlich.com/24499516-getting-started-with-flutter) - by 🌎 [raywenderlich.com](www.raywenderlich.com)
- <b><code>&nbsp;&nbsp;&nbsp;390⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [Beginner's Guide](https://github.com/antz22/ultimate-guide-to-flutter)) [377⭐] - Comprehensive guide to the basics of Flutter and Firebase by [Anthony](https://github.com/antz22)

### Intermediate

- 🌎 [Flutter state management for minimalists](suragch.medium.com/flutter-state-management-for-minimalists-4c71a2f2f0c1?sk=6f9cedfb550ca9cc7f88317e2e7055a0) - Understanding app architecture without relying on third-party frameworks by 🌎 [Suragch](twitter.com/Suragch1). See also [State Management](#state-management)

### Advanced

- 🌎 [Rendering Pipeline](www.youtube.com/watch?v=UUfXWzp0-DU) [1140👍] and 🌎 [Let's build a render tree](www.youtube.com/watch?v=VsYbFnucHsU) - Engine architecture by Adam Barth
- 🌎 [Render Objects](medium.com/flutter-community/flutter-what-are-widgets-renderobjects-and-elements-630a57d05208)  - What are Widgets, RenderObjects and Elements? by [Norbert515](https://github.com/Norbert515)
- 🌎 [Streams and RxDart](skillsmatter.com/skillscasts/12254-flutter-with-streams-and-rxdart) - Skillmatters presentation by [Brian Egan](https://github.com/brianegan)
- 🌎 [Gesture System](medium.com/flutter-community/flutter-deep-dive-gestures-c16203b3434f)  - Flutter Deep Dive: Gestures by [Nash](https://github.com/nash0x7e2)
- 🌎 [Schemas](www.didierboelens.com/2018/06/widget---state---context---inheritedwidget/) - Widget, State, Context and InheritedWidget explanations by 🌎 [Didier Boelens](didierboelens.com)
- 🌎 [Rendering Engine Tutorial](medium.com/saugo360/flutters-rendering-engine-a-tutorial-part-1-e9eff68b825d)  - Flutter's Rendering Engine: A Tutorial by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [AbdulRahman AlHamali](https://github.com/AbdulRahmanAlHamali/))
- 🌎 [Inherited Widget](medium.com/@chemamolins/is-flutters-inheritedwidget-a-good-fit-to-hold-app-state-2ec5b33d023e) - Flutter’s InheritedWidget to hold app state by [Chema Molins](https://github.com/jmolins)
- 🌎 [From Mobile to Desktop](medium.com/flutter-community/flutter-from-mobile-to-desktop-93635e8de64e) - Building applications for smartphones and desktops by 🌎 [Marcelo Henrique Neppel](neppel.com.br)
- 🌎 [Accessibility widgets](medium.com/flutter-community/a-deep-dive-into-flutters-accessibility-widgets-eb0ef9455bc)  - Deep dive information about all aspects of accessibility by 🌎 [Muhammed Salih Güler](twitter.com/salihgueler)
- 🌎 [Profiling w/ Timeline](medium.com/flutter-io/profiling-flutter-applications-using-the-timeline-a1a434964af3)  - Using the Timeline allows you to find and address specific performance issues in your application by 🌎 [Chinmay Garde](medium.com/@chinmaygarde)

## Advanced graphics rendering

- 🌎 [Shaders](wolfenrain.medium.com/flutter-shaders-an-initial-look-d9eb98d3fd7a) - Fragment shaders, set it up, how it works and making it work by 🌎 [Jochum van der Ploeg](twitter.com/wolfenrain)

### Howtos

- 🌎 [Parallax Effect](marcinszalek.pl/flutter/tickets-challenge-parallax) - Parallax & non linear animation by 🌎 [Marcin Szalek](marcinszalek.pl).
- 🌎 [Build Flavor](medium.com/@salvatoregiordanoo/flavoring-flutter-392aaa875f36)  - Define build configurations and switch them by 🌎 [Salvatore Giordano](medium.com/@salvatoregiordanoo)
- 🌎 [Build Flavor](medium.com/@angeloavv/easily-build-flavors-in-flutter-android-and-ios-with-flutter-flavorizr-d48cbf956e4) - Easily build flavors in Flutter (Android and iOS) with flutter_flavorizr by 🌎 [Angelo Cassano](medium.com/@angeloavv)

## Videos

- 🌎 [Boring Show](www.youtube.com/watch?v=CPmN4-i9zC8&list=PLOU2XLYxmsIK0r_D-zWcmJ1plIcDNnRkK) - Exploration with the Flutter Team.
- 🌎 [Tensor Programming](www.youtube.com/watch?v=WwhyaqNtNQY&list=PLJbE2Yu2zumDqr_-hqpAN0nIr6m14TAsd)  - Very rich content by [Tensor Programming](http://tensor-programming.com/)
- 🌎 [Mtechviral](www.youtube.com/watch?v=qWL1lGchpRA&list=PLR2qQy0Zxs_UdqAcaipPR3CG1Ly57UlhV)  - [Hindi/English] Mtechviral Series By [Pawan Kumar](https://github.com/iampawan)
- 🌎 [Flutter in Practice](www.youtube.com/playlist?list=PLhXZp00uXBk5TSY6YOdmpzp1yG3QbFvrN) - Free video courssd for beginners & non-programmers by 🌎 [Zaiste](zaiste.net/)
- 🌎 [Whatsupcoders](www.youtube.com/c/whatsupcoders)  - Free video series on Flutter Widgets by [Kamal](https://github.com/whatsupcoders)
- 🌎 [Reso Coder](www.youtube.com/channel/UCSIvrn68cUk8CS8MbtBmBkA) - Intermediate and advanced videos by [Matej Rešetár](https://github.com/ResoCoder)

## Components

### Demonstrations

- <b><code>&nbsp;&nbsp;6437⭐</code></b> <b><code>&nbsp;&nbsp;1549🍴</code></b> [Official Gallery](https://github.com/flutter/gallery)) - Demo for the material design widgets provided by Flutter Team
- <b><code>&nbsp;&nbsp;7002⭐</code></b> <b><code>&nbsp;&nbsp;1672🍴</code></b> [Flutter Examples](https://github.com/nisrulz/flutter-examples)) [6923⭐] - Simple basic isolated apps for devs by [Nishant Srivastava](https://github.com/nisrulz)
- <b><code>&nbsp;&nbsp;2211⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;557🍴</code></b> [Flutter Catalog](https://github.com/X-Wei/flutter_catalog)) [2167⭐] - showcasing Flutter components, with side-by-side source code view, by [X-Wei](https://github.com/X-Wei)


### UI

- <b><code>&nbsp;&nbsp;&nbsp;438⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;66🍴</code></b> [Facebook Reactions](https://github.com/duytq94/facebook-reaction-animation)) [425⭐] - Facebook reactions widget by [Duy Tran](https://github.com/duytq94)
- <b><code>&nbsp;&nbsp;1012⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;173🍴</code></b> [Flushbar](https://github.com/AndreHaueisen/flushbar)) [1004⭐] - Highly configurable Snackbar by [Andre Haueisen](https://github.com/AndreHaueisen)
- <b><code>&nbsp;&nbsp;&nbsp;324⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28🍴</code></b> [Stepper Touch](https://github.com/Rahiche/stepper_touch)) [303⭐] - Lateral value stepper nicely animated by [Raouf Rahiche](https://github.com/Rahiche).
- <b><code>&nbsp;&nbsp;1263⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;92🍴</code></b> [Liquid Pull To Refresh](https://github.com/aagarwal1012/Liquid-Pull-To-Refresh)) [1249⭐] - A beautiful and custom refresh indicator by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Ayush Agarwal](https://github.com/aagarwal1012/)).
- <b><code>&nbsp;&nbsp;&nbsp;787⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;63🍴</code></b> [Direct Select](https://github.com/LanarsInc/direct-select-flutter)) [774⭐] - Selection widget with an ethereal, full-screen modal popup by [Ivan Yatsouba](https://github.com/iyatsouba).
- <b><code>&nbsp;&nbsp;&nbsp;943⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;109🍴</code></b> [Before After](https://github.com/xsahil03x/before_after)) [913⭐] - Beautiful slider which makes it easier to display the difference between two images, by [Sahil Kumar](https://github.com/xsahil03x).
- <b><code>&nbsp;&nbsp;&nbsp;596⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;67🍴</code></b> [Scratcher](https://github.com/vintage/scratcher)) [573⭐] - Scratch card widget which temporarily hides content from user, by [Kamil Rykowski](https://github.com/vintage).
- <b><code>&nbsp;&nbsp;&nbsp;687⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;91🍴</code></b> [Beautiful_Popup](https://github.com/jaweii/Flutter_beautiful_popup)) [677⭐] - Beautify your app popup by [jaweii](https://github.com/jaweii).
- <b><code>&nbsp;&nbsp;&nbsp;372⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [Animated Selection Slide](https://github.com/sbilketay/animated_selection_slide)) An animated selection widget by swiping by [Sezgin Bilgetay](https://github.com/sbilketay).
- <b><code>&nbsp;&nbsp;2060⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;382🍴</code></b> [Flutter Neumorphic](https://github.com/Idean/Flutter-Neumorphic)) [2007⭐] - Ready to use Neumorphic kit for Flutter with 🕶️ dark mode.
- <b><code>&nbsp;&nbsp;&nbsp;717⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;29🍴</code></b> [Dough](https://github.com/HatFeather/flutter_dough)) [704⭐] - Widgets for a squishy user interface by [Josiah Saunders](https://github.com/HatFeather).
- <b><code>&nbsp;&nbsp;&nbsp;556⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;105🍴</code></b> [Card Settings](https://github.com/codegrue/card_settings)) [545⭐] - package for building settings forms by [codegrue](https://github.com/codegrue).
- <b><code>&nbsp;&nbsp;&nbsp;728⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;170🍴</code></b> [Timelines](https://github.com/chulwoo-park/timelines)) [712⭐] - Powerful & Easy to use timeline package by [Chulwoo Park](https://github.com/chulwoo-park).
- <b><code>&nbsp;&nbsp;&nbsp;764⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;148🍴</code></b> [Timeline Tile](https://github.com/JHBitencourt/timeline_tile)) [735⭐] - Tile to help build beautiful and customisable timelines by [Julio Bitencourt](https://github.com/JHBitencourt).
- <b><code>&nbsp;&nbsp;&nbsp;348⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;88🍴</code></b> [Rounded Loading Button](https://github.com/chrisedg87/flutter_rounded_loading_button)) [325⭐] - Button with a loading indicator, complete with success and error animations by 🌎 [Chris Edgington](twitter.com/ChrisTheEdg)
- <b><code>&nbsp;&nbsp;1683⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;729🍴</code></b> [Flyer Chat](https://github.com/flyerhq/flutter_chat_ui)) [1594⭐] - Community-driven chat UI implementation by the [Flyer Chat team](https://github.com/flyerhq)
- <b><code>&nbsp;&nbsp;1273⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;150🍴</code></b> [Smooth Page Indicator](https://github.com/Milad-Akarie/smooth_page_indicator)) [1199⭐] - Customizable animated page indicator with a set of built-in effects. [Milad Akarie](https://github.com/Milad-Akarie)

#### Libraries

- <b><code>&nbsp;&nbsp;&nbsp;633⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [Forui](https://github.com/forus-labs/forui)) [359⭐] - Minimalistic UI library heavily inspired by shadcn/ui by [Forus Labs](https://github.com/forus-labs).
- <b><code>&nbsp;&nbsp;1297⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;74🍴</code></b> [Shadcn](https://github.com/nank1ro/flutter-shadcn-ui)) [894⭐] - Shadcn-ui port. Fully customizable UI components.

#### List

- <b><code>&nbsp;&nbsp;&nbsp;309⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;19🍴</code></b> [Super List](https://github.com/superlistapp/super_sliver_list)) [283⭐] - Drop-in replacement for SliverList and ListView that can handle large amount of items with variable extents by [Matej Knopp](https://github.com/knopp)
- <b><code>&nbsp;&nbsp;&nbsp;742⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;170🍴</code></b> [Reorderables](https://github.com/hanshengchiu/reorderables)) [726⭐] - Drag&Drop Table, Row, Column, Wrap(Grid) and SliverList elements by [Hansheng Chiu](https://github.com/hanshengchiu).
- <b><code>&nbsp;&nbsp;1263⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;92🍴</code></b> [Liquid Pull To Refresh](https://github.com/aagarwal1012/Liquid-Pull-To-Refresh)) [1249⭐] - A beautiful and custom refresh indicator by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Ayush Agarwal](https://github.com/aagarwal1012/)).
- <b><code>&nbsp;&nbsp;&nbsp;678⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;329🍴</code></b> [PlutoGrid](https://github.com/bosskmk/pluto_grid)) [661⭐] - Web and desktop datagrid that can be controlled by the keyboard by [bosskmk](https://github.com/bosskmk).
- <b><code>&nbsp;&nbsp;&nbsp;837⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;351🍴</code></b> [Typeahead](https://github.com/AbdulRahmanAlHamali/flutter_typeahead)) [817⭐] - Display overlay suggestions to users as they type by [Abdul Rahman Al Hamali](https://github.com/AbdulRahmanAlHamali)
- <b><code>&nbsp;&nbsp;3164⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;511🍴</code></b> [StaggeredGridView](https://github.com/letsar/flutter_staggered_grid_view)) [3122⭐] - GridView with tiles of variable sizes by [Romain Rastel](https://github.com/letsar)
- <b><code>&nbsp;&nbsp;1110⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;130🍴</code></b> [Sticky Headers](https://github.com/slightfoot/flutter_sticky_headers)) [1080⭐] - Configurable sticky headers by [Simon Lightfoot](http://www.devangels.london/)

#### Drawers

- <b><code>&nbsp;&nbsp;&nbsp;353⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;55🍴</code></b> [Hidden Drawer Menu](https://github.com/RafaelBarbosatec/hidden_drawer_menu)) [351⭐] - Beautiful drawer mode menu feature with perspective animations by [Rafael Almeida Barbosa](https://github.com/RafaelBarbosatec).
- <b><code>&nbsp;&nbsp;&nbsp;516⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;129🍴</code></b> [Flutter Inner Drawer](https://github.com/Dn-a/flutter_inner_drawer)) [513⭐] - Easy way to create an internal drawer (left / right) where you can enter a list-menu or other by [Di Natale Antonino](https://github.com/Dn-a).

#### Bottom bars

- <b><code>&nbsp;&nbsp;&nbsp;775⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;186🍴</code></b> [Fancy Bottom Navigation](https://github.com/tunitowen/fancy_bottom_navigation)) [758⭐] - Animated bottom navigation by [Tony Owen](https://github.com/tunitowen).
- <b><code>&nbsp;&nbsp;&nbsp;663⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;97🍴</code></b> [Circular Bottom Navigation](https://github.com/imaNNeoFighT/circular_bottom_navigation)) [653⭐] - Beautiful animated bottom navigation bar by [Iman Khoshabi](https://github.com/imaNNeoFighT).
- <b><code>&nbsp;&nbsp;1050⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;218🍴</code></b> [Bottom Navy Bar](https://github.com/pedromassango/bottom_navy_bar)) [1022⭐] - Beautiful and colorful animated bottom navigation bar by [Pedro Massango](https://github.com/pedromassango).
- <b><code>&nbsp;&nbsp;&nbsp;755⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;114🍴</code></b> [Google Nav Bar](https://github.com/sooxt98/google_nav_bar)) [737⭐] - A modern google style nav bar for flutter by [Sooxt98](http://github.com/sooxt98)

#### Bottom Sheets
- <b><code>&nbsp;&nbsp;&nbsp;561⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;89🍴</code></b> [Rubber Bottom Sheet](https://github.com/mcrovero/rubber)) [562⭐] - Elastic material bottom sheet by [Mattia Crovero](https://github.com/mcrovero).
- <b><code>&nbsp;&nbsp;1909⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;485🍴</code></b> [Modal Bottom Sheet](https://github.com/jamesblasco/modal_bottom_sheet)) [1860⭐] - Modal bottom sheet with Material, Cupertino iOS13 or custom appareance by [Jaime Blasco](https://github.com/jamesblasco).

#### Sliders

- <b><code>&nbsp;&nbsp;&nbsp;374⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;67🍴</code></b> [RangeSlider](https://github.com/boeledi/RangeSlider)) [374⭐] - 2-thumb configurable RangeSlider by 🌎 [Didier Boelens](www.didierboelens.com)
- <b><code>&nbsp;&nbsp;&nbsp;520⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;184🍴</code></b> [Flutter Xlider](https://github.com/Ali-Azmoud/flutter_xlider)) [518⭐] - A material design slider and range slider, horizontal and vertical, with RTL support by [Ali-Azmoud](https://github.com/Ali-Azmoud)

#### UI Helpers

- <b><code>&nbsp;&nbsp;1108⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;119🍴</code></b> [Offline](https://github.com/jogboms/flutter_offline)) [1054⭐] - Tidy utility to handle offline/online connectivity by 🌎 [Jeremiah Ogbomo](twitter.com/jogboms).
- <b><code>&nbsp;&nbsp;1591⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;457🍴</code></b> [ShowCaseView](https://github.com/simformsolutions/flutter_showcaseview)) [1488⭐] - Way to showcase your app features on iOS and Android by [Simform](https://github.com/simformsolutions)
- <b><code>&nbsp;&nbsp;&nbsp;622⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;38🍴</code></b> [Mix](https://github.com/leoafarias/mix)) [561⭐] - An expressive way to effortlessly build design systems by [Leo Farias](https://github.com/leoafarias).
- <b><code>&nbsp;&nbsp;&nbsp;533⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;66🍴</code></b> [Blurhash](https://github.com/fluttercommunity/flutter_blurhash)) [520⭐] - Compact representation of a placeholder for an image. Encode a blurry image under 30 caracters by 🌎 [Robert Felker](www.linkedin.com/in/robert-felker/)


#### Material Design

- <b><code>&nbsp;&nbsp;2742⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;612🍴</code></b> [Slidable](https://github.com/letsar/flutter_slidable)) [2690⭐] - Slidable list item with left and right slide actions by [Romain Rastel](https://github.com/letsar)
- <b><code>&nbsp;&nbsp;&nbsp;339⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;36🍴</code></b> [Backdrop](https://github.com/fluttercommunity/backdrop)) [331⭐] - 🌎 [Backdrop](material.io/design/components/backdrop.html) implementation for flutter.

#### Effect

- [Frosted Glass](http://stackoverflow.com/questions/43550853/how-do-i-do-the-frosted-glass-effect-in-flutter) - Render effect by [Collin Jackson](http://www.collinjackson.com)
- <b><code>&nbsp;&nbsp;1807⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;206🍴</code></b> [Shimmer](https://github.com/hnvn/flutter_shimmer)) [1784⭐] - Shimmer effect while content is loading by [HungHD](https://github.com/hnvn)
- <b><code>&nbsp;&nbsp;1114⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;96🍴</code></b> [Wave](https://github.com/i-protoss/wave)) [1106⭐] - Displaying some waves with custom color, duration, floating and blur effects by [RockerFlower](https://github.com/RockerFlower)
- <b><code>&nbsp;&nbsp;1233⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;158🍴</code></b> [Liquid Swipe](https://github.com/iamSahdeep/liquid_swipe_flutter)) - Liquid swipe to your stacked containers by [Sahdeep Singh](https://github.com/iamSahdeep)
- <b><code>&nbsp;&nbsp;&nbsp;405⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;136🍴</code></b> [PhotoFilters](https://github.com/skkallayath/photofilters)) [403⭐] - Apply filters to an image by [Sharafudheen KK](https://github.com/skkallayath).
- <b><code>&nbsp;&nbsp;&nbsp;148⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13🍴</code></b> [Shine](https://github.com/JonathanMonga/flutter_shine.dart)) [146⭐]  - Pretty shadows with dynamic light positions by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Jonathan Monga](https://github.com/JonathanMonga/)).
- <b><code>&nbsp;&nbsp;&nbsp;444⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;34🍴</code></b> [Clay Containers](https://github.com/mcaubrey/clay_containers)) [437⭐] - Neumorphic widget primitives to serve as the foundation of your own designs by [Michael Charles](https://github.com/mcaubrey).

#### Calendar

- <b><code>&nbsp;&nbsp;&nbsp;841⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;309🍴</code></b> [Calendar Carousel Widget](https://github.com/dooboolab/flutter_calendar_carousel)) <!-- stargazers:dooboolab/flutter_calendar_carousel--> - Calendar carousel by <b><code>&nbsp;&nbsp;&nbsp;841⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;309🍴</code></b> [dooboolab](https://github.com/dooboolab/flutter_calendar_carousel))
- <b><code>&nbsp;&nbsp;1859⭐</code></b> <b><code>&nbsp;&nbsp;1016🍴</code></b> [Table Calendar](https://github.com/aleksanderwozniak/table_calendar)) [1813⭐] - Calendar organized neatly into a Table, with vertical autosizing by [Aleksander Woźniak](https://github.com/aleksanderwozniak)
- <b><code>&nbsp;&nbsp;&nbsp;225⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [Time Planner](https://github.com/Jamalianpour/time_planner)) [223⭐] - A beautiful, easy to use and customizable time planner for flutter mobile, desktop and web by [Mohammad Jamalianpour](https://github.com/Jamalianpour)

#### Backend-Driven

- <b><code>&nbsp;&nbsp;1576⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;312🍴</code></b> [Dynamic Widget](https://github.com/dengyin2000/dynamic_widget)) [1554⭐] - Build your dynamic UI with json, and the json format is very similar with flutter widget code by [Denny Deng](https://github.com/dengyin2000).

### Image

- <b><code>&nbsp;&nbsp;1610⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;589🍴</code></b> [Carousel Slider](https://github.com/serenader2014/flutter_carousel_slider)) [1591⭐] - Carousel slider widget, support infinite scroll and custom child widget by [serenader](https://github.com/serenader2014)
- <b><code>&nbsp;&nbsp;1926⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;548🍴</code></b> [Photo View](https://github.com/renancaraujo/photo_view)) [1901⭐] - Scalable image view with loading placeholder by [Renan C. Araújo](https://github.com/renancaraujo)
- <b><code>&nbsp;&nbsp;1679⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;459🍴</code></b> [SVG](https://github.com/dnfield/flutter_svg)) [1661⭐] - SVG parsing, rendering, and widget library by [Dan Field](https://github.com/dnfield)
- <b><code>&nbsp;&nbsp;1005⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;395🍴</code></b> [Image Cropper](https://github.com/hnvn/flutter_image_cropper)) [993⭐] - Crop your images support ratio, rotation, zoom by [HungHD](https://github.com/hnvn)
- <b><code>&nbsp;&nbsp;2467⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;664🍴</code></b> [Cached Network Image](https://github.com/renefloor/flutter_cached_network_image)) [2431⭐] - Show images from the internet and keep them in the cache directory by
- <b><code>&nbsp;&nbsp;1195⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;203🍴</code></b> [Lottie](https://github.com/xvrh/lottie-flutter)) [1157⭐] - Use airbnb's popular 🌎 [After Effects Animation library](airbnb.design/lottie/) by <b><code>&nbsp;&nbsp;1195⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;203🍴</code></b> [xvrh](https://github.com/xvrh/lottie-flutter))
- <b><code>&nbsp;&nbsp;&nbsp;175⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;34🍴</code></b> [Bitmap](https://github.com/renancaraujo/bitmap)) [175⭐] - Perform Bitmap manipulations (such as contrast and exposure) with a help from the Dart FFI by [Renan C. Araújo](https://github.com/renancaraujo)
- <b><code>&nbsp;&nbsp;&nbsp;257⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;87🍴</code></b> [Crop](https://github.com/xclud/flutter_crop)) [258⭐] - Crop any widget/image in Android, iOS, Web and Desktop by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Mahdi K. Fard](https://github.com/xclud/))

#### Image Picker

- <b><code>&nbsp;&nbsp;4497⭐</code></b> <b><code>&nbsp;&nbsp;2982🍴</code></b> [Image Picker](https://github.com/flutter/packages/tree/main/packages/image_picker)) - Images Selection by [Collin Jackson](http://www.collinjackson.com)
- <b><code>&nbsp;&nbsp;1543⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;460🍴</code></b> [WeChat Assets Picker](https://github.com/fluttercandies/flutter_wechat_assets_picker)) [1496⭐] - Assets picker in WeChat style, support multi assets by [Alex Li](https://github.com/AlexV525).
- 🌎 [Advance Image Picker](pub.dev/packages/advance_image_picker) - Select and edit images from Android/iOS library and capture camera shots from within the same view by [WetaVN](https://github.com/weta-vn)

### Map

- <b><code>&nbsp;&nbsp;&nbsp;186⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;178🍴</code></b> [GeoCoder](https://github.com/aloisdeniel/flutter_geocoder)) [185⭐] - Forward and reverse geocoding by 🌎 [Aloïs Deniel](aloisdeniel.github.com)
- <b><code>&nbsp;&nbsp;&nbsp;541⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;163🍴</code></b> [AMap](https://github.com/fluttify-project/amap_map_fluttify)) [538⭐] - Access to AMap services(高德地图) by [fluttify-project](https://github.com/fluttify-project)
- <b><code>&nbsp;&nbsp;&nbsp;133⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28🍴</code></b> [Map](https://github.com/xclud/flutter_map)) [129⭐] - Fully-fledged interactive Map widget for flutter written in pure Dart. Supports all platforms. by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Mahdi K. Fard](https://github.com/xclud/))

### Charts

- <b><code>&nbsp;&nbsp;&nbsp;403⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;142🍴</code></b> [Circular Chart](https://github.com/xqwzts/flutter_circular_chart)) [398⭐] - Animated radial and pie charts by [Victor Choueiri](https://github.com/xqwzts)
- <b><code>&nbsp;&nbsp;6934⭐</code></b> <b><code>&nbsp;&nbsp;1791🍴</code></b> [FL Chart](https://github.com/imaNNeoFighT/fl_chart)) [6741⭐] - Draw fantastic charts in Flutter by [Iman Khoshabi](http://www.ikhoshabi.com)
- <b><code>&nbsp;&nbsp;&nbsp;449⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;131🍴</code></b> [Bezier Chart](https://github.com/aeyrium/bezier-chart)) [446⭐] - Beautiful bezier line chart widget for flutter that is highly interactive and configurable by 🌎 [Diego Velasquez](twitter.com/diegoveloper)
- <b><code>&nbsp;&nbsp;&nbsp;745⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;169🍴</code></b> [Echarts](https://github.com/entronad/flutter_echarts)) [739⭐] - Large collection of advanced reactives charts by [LIN Chen](https://github.com/entronad)
- <b><code>&nbsp;&nbsp;1636⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;176🍴</code></b> [Graphic](https://github.com/entronad/graphic)) [1587⭐] - Data visualization library based on the Grammar of Graphics by [LIN Chen](https://github.com/entronad)

### Navigation

- <b><code>&nbsp;&nbsp;3691⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;416🍴</code></b> [Fluro](https://github.com/goposse/fluro)) [3672⭐] - The brightest, hippest, coolest router for Flutter with Navigation, wildcard, query, transitions by [Posse](http://goposse.com)
- <b><code>&nbsp;10522⭐</code></b> <b><code>&nbsp;&nbsp;1641🍴</code></b> [Get](https://github.com/jonataslaw/get)) [10245⭐] - Navigate between screens & display snackbars/dialogs/bottomSheets without context by [Jonny Borges](https://github.com/jonataslaw)
- <b><code>&nbsp;&nbsp;&nbsp;592⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;129🍴</code></b> [Beamer](https://github.com/slovnicki/beamer)) [588⭐] - Route through guarded page stacks and URLs using the Navigator 2.0 API effortlessly by [Sandro Lovnički](https://github.com/slovnicki)
- <b><code>&nbsp;&nbsp;1613⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;410🍴</code></b> [auto_route](https://github.com/Milad-Akarie/auto_route_library)) [1570⭐] - AutoRoute is a declarative routing solution, where everything needed for navigation is automatically generated for you. [Milad_Akarie](https://github.com/Milad-Akarie).

### Auth

- <b><code>&nbsp;&nbsp;4497⭐</code></b> <b><code>&nbsp;&nbsp;2982🍴</code></b> [Local Auth](https://github.com/flutter/packages/tree/main/packages/local_auth)) - Touch ID, lock code, fingerprint auth on iOS and Android
- <b><code>&nbsp;&nbsp;4497⭐</code></b> <b><code>&nbsp;&nbsp;2982🍴</code></b> [Google Sign-In](https://github.com/flutter/packages/tree/main/packages/google_sign_in)) - Google OAuth
- <b><code>&nbsp;&nbsp;8778⭐</code></b> <b><code>&nbsp;&nbsp;3989🍴</code></b> [Firebase Auth](https://github.com/FirebaseExtended/flutterfire/tree/master/packages/firebase_auth)) - Firebase OAuth
- 🌎 [Firebase Phone Auth](medium.com/@gildaswise/flutter-adding-sign-in-with-google-and-phone-authentication-to-your-app-69f681518f9b)  - Phone number auth via SMS by [Gildásio Filho](https://github.com/gildaswise)
- <b><code>&nbsp;&nbsp;&nbsp;353⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;108🍴</code></b> [SimpleAuth](https://github.com/Clancey/simple_auth)) [352⭐] - Azure Active Directory, Amazon, Dropbox, Facebook, Github, Google, Instagram, Linked In, Microsoft Live Connect, Github, OAuth, Basic Auth by [James Clancey](https://github.com/Clancey)
- <b><code>&nbsp;&nbsp;&nbsp;279⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;248🍴</code></b> [Flutter AppAuth](https://github.com/MaikuB/flutter_appauth)) [271⭐] - Plugin that provides a wrapper around the AppAuth iOS and Android SDKs by [Michael Bui](https://github.com/MaikuB)

### Text & Rich Content

- <b><code>&nbsp;&nbsp;&nbsp;275⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;124🍴</code></b> [Masked Text](https://github.com/benhurott/flutter-masked-text)) [276⭐] - Masked text with custom and monetary formatting by [Ben-hur Santos Ott](https://github.com/benhurott)
- <b><code>&nbsp;&nbsp;&nbsp;210⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39🍴</code></b> [Fleather](https://github.com/fleather-editor/fleather)) <!--stargazersfleather-editor/fleather--> - Soft & gentle rich text editor
- <b><code>&nbsp;&nbsp;2068⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;241🍴</code></b> [AutoSizeText](https://github.com/leisim/auto_size_text)) [2025⭐] - Automatically resizes text to fit perfectly within its bounds by [Simon Leier](https://github.com/leisim).
- <b><code>&nbsp;&nbsp;&nbsp;219⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;69🍴</code></b> [Parsed Text](https://github.com/fayeed/flutter_parsed_text)) [219⭐] - Interactive text based on content recognition, also supports Regex by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Fayeed Pawaskar](https://github.com/fayeed/))
- <b><code>&nbsp;&nbsp;&nbsp;283⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;137🍴</code></b> [TeX](https://github.com/shah-xad/flutter_tex)) [276⭐] - Render Mathematics Equations with full HTML and JavaScript support by [Shahzad Akram](https://github.com/shah-xad)
- <b><code>&nbsp;&nbsp;&nbsp;236⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [Code Field](https://github.com/BertrandBev/code_field)) - Customizable code field widget supporting syntax highlighting by [Bertrand Bevillard](https://github.com/BertrandBev)

### Forms
- <b><code>&nbsp;&nbsp;1510⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;540🍴</code></b> [Form Builder](https://github.com/danvick/flutter_form_builder)) [1480⭐] - Framework that simplifies building forms, validating fields, reacting to changes, and collecting the final user input by [Danvick Miller](https://github.com/danvick)
- <b><code>&nbsp;&nbsp;&nbsp;475⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;94🍴</code></b> [Reactive Forms](https://github.com/joanpablo/reactive_forms)) [467⭐] - Model-driven approach to handling Forms inputs and validations, heavily inspired in Angular's Reactive Forms.

### Analytics

- <b><code>&nbsp;&nbsp;&nbsp;146⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;42🍴</code></b> [Usage](https://github.com/dart-lang/usage)) [146⭐] - Google Analytics wrapper for command-line, web, and Flutter apps
- <b><code>&nbsp;&nbsp;8778⭐</code></b> <b><code>&nbsp;&nbsp;3989🍴</code></b> [Firebase Analytics](https://github.com/FirebaseExtended/flutterfire/tree/master/packages/firebase_analytics)) - Connect to Firebase Analytics API

### Internationalization

- <b><code>&nbsp;&nbsp;&nbsp;100⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;23🍴</code></b> [GenLang](https://github.com/KingWu/gen_lang)) [100⭐] - Code generator for Internationalization by [King Wu](https://github.com/KingWu)
- <b><code>&nbsp;&nbsp;&nbsp;408⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;119🍴</code></b> [Flutter Translate](https://github.com/bratan/flutter_translate)) [401⭐] - Internationalization (i18n) library by [Florin Bratan](http://bratan.me)
- <b><code>&nbsp;&nbsp;&nbsp;339⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;27🍴</code></b> [attranslate](https://github.com/fkirc/attranslate)) - Semi-automated translation of ARB or JSON files by [fkirc](https://github.com/fkirc)


### Styling


### Media

- <b><code>&nbsp;&nbsp;&nbsp;708⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;322🍴</code></b> [photo_manager](https://github.com/fluttercandies/flutter_photo_manager)) [671⭐] - Provides assets (image/video/audio) abstraction management APIs that can be easily integrated with custom UI widgets by [CaiJingLong](https://github.com/CaiJingLong) and [Alex Li](https://github.com/AlexV525).

#### Audio

- <b><code>&nbsp;&nbsp;2034⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;853🍴</code></b> [Audio Players Plugin](https://github.com/luanpotter/audioplayers)) [1976⭐] - Play multiple audio files simultaneously (Android/iOS) by [Luan Nico](https://github.com/luanpotter).
- <b><code>&nbsp;&nbsp;&nbsp;121⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;150🍴</code></b> [Flutter Audio Recorder](https://github.com/shadow-app/flutter_audio_recorder)) - Provides full controls and access to recording details such as level metering by [Wenyan Li](https://github.com/nikli2009).
- <b><code>&nbsp;&nbsp;&nbsp;885⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;584🍴</code></b> [Flutter Sound](https://github.com/dooboolab/flutter_sound)) [868⭐] - Flutter audio recorder and player at one hand by [dooboolab](https://github.com/dooboolab)
- <b><code>&nbsp;&nbsp;&nbsp;761⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;381🍴</code></b> [AssetsAudioPlayer](https://github.com/florent37/Flutter-AssetsAudioPlayer)) [752⭐]  Simultaneous playback of audio from assets/network/file and displaying notifications [android / ios / web / macos]
- 🌎 [Audio Service](pub.dev/packages/audio_service) - System background audio support by [Ryan Heise](https://github.com/ryanheise). 🌎 [Tutorial](suragch.medium.com/background-audio-in-flutter-with-audio-service-and-just-audio-3cce17b4a7d?sk=0837a1b1773e27a4f879ff3072e90305) by 🌎 [Suragch](twitter.com/Suragch1).

#### Video

- <b><code>&nbsp;&nbsp;4185⭐</code></b> <b><code>&nbsp;&nbsp;1137🍴</code></b> [WebRTC](https://github.com/cloudwebrtc/flutter-webrtc)) [4086⭐] - WebRTC plugin for iOS/Android by [CloudWebRtc](https://github.com/cloudwebrtc)
- <b><code>&nbsp;&nbsp;1955⭐</code></b> <b><code>&nbsp;&nbsp;1022🍴</code></b> [Chewie](https://github.com/brianegan/chewie)) [1926⭐] - Provides low-level access to video playback by [Brian Egan](https://github.com/brianegan)
- <b><code>&nbsp;&nbsp;&nbsp;446⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;281🍴</code></b> [Video Trimmer](https://github.com/sbis04/video_trimmer)) [432⭐] - Visualise and trim videos by [Souvik Biswas](https://github.com/sbis04)
- <b><code>&nbsp;&nbsp;&nbsp;996⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;268🍴</code></b> [CamerAwesome](https://github.com/Apparence-io/camera_awesome)) [952⭐] - Community camera plugin rework by 🌎 [Apparence.io studio](apparence.io)
- <b><code>&nbsp;&nbsp;&nbsp;421⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;252🍴</code></b> [Video Editor](https://github.com/LeGoffMael/video_editor)) [386⭐] - Edit (crop, trim, rotate) a video and a its cover by [Maël Le Goff](https://github.com/LeGoffMael)

#### Voice

- <b><code>&nbsp;&nbsp;&nbsp;336⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;197🍴</code></b> [Speech Recognition](https://github.com/rxlabz/speech_recognition)) [337⭐] - Speech to text by 🌎 [Erick Ghaumez](twitter.com/rxlabz)
- 🌎 [OK Google](marcinszalek.pl/flutter/ok-google-flutter/) - Integrate google assistant by 🌎 [Marcin Szalek](marcinszalek.pl/)

### Storage

- <b><code>&nbsp;&nbsp;8778⭐</code></b> <b><code>&nbsp;&nbsp;3989🍴</code></b> [Firebase Storage](https://github.com/FirebaseExtended/flutterfire/tree/master/packages/firebase_storage)) - Firebase as data storage
- <b><code>&nbsp;&nbsp;1145⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;401🍴</code></b> [Secure Storage](https://github.com/mogol/flutter_secure_storage)) [1118⭐] - Keychain and Keystore storage by [German Saprykin](https://github.com/mogol)

#### Preferences


### Monetization

- 🌎 [Admob](pub.dev/packages/admob) - GoogleAdmob supports interstitial ads in both iOS and Android by Brett Nesbitt
- <b><code>&nbsp;&nbsp;8778⭐</code></b> <b><code>&nbsp;&nbsp;3989🍴</code></b> [Firebase AdMob](https://github.com/FirebaseExtended/flutterfire/tree/master/packages/firebase_admob)) - Ad integration using Firebase
- <b><code>&nbsp;&nbsp;&nbsp;557⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;234🍴</code></b> [Inapp Purchase](https://github.com/dooboolab/flutter_inapp_purchase)) [550⭐] - Features set of 'in app purchase' derived from <b><code>&nbsp;&nbsp;2893⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;655🍴</code></b> [react-native-iap](https://github.com/dooboolab/react-native-iap)) by [dooboolab](https://github.com/dooboolab)
- <b><code>&nbsp;&nbsp;&nbsp;435⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;153🍴</code></b> [Admob Flutter](https://github.com/kmcgill88/admob_flutter)) - Admob plugin that shows banner ads using native platform views by [Youssef Kababe](https://github.com/YoussefKababe) & [Kevin McGill](https://github.com/kmcgill88).
- <b><code>&nbsp;&nbsp;&nbsp;158⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;90🍴</code></b> [Facebook Audience Network](https://github.com/dreamsoftin/facebook_audience_network)) - Facebook Audience Network Ad plugin that shows banner, interstitial, in-stream video, rewarded video & natvie ads by [Dreamsoft Innovations](https://github.com/dreamsoftin).
- <b><code>&nbsp;&nbsp;&nbsp;341⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;127🍴</code></b> [Square In-App Payments SDK](https://github.com/square/in-app-payments-flutter-plugin)) [339⭐] - Take payments by embedding a card entry form in your app that produces nonces from customer-provided card information or digital wallets by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Square](https://github.com/orgs/square))

## Templates

- <b><code>&nbsp;&nbsp;&nbsp;593⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;153🍴</code></b> [Mates](https://github.com/CodemateLtd/FlutterMates)) [592⭐] - How to load profiles from the randomuser.me API and a nice profile details page by [Iiro Krankka](https://github.com/roughike)
- <b><code>&nbsp;&nbsp;1751⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;505🍴</code></b> [The Gorgeous Login](https://github.com/huextrat/TheGorgeousLogin)) [1736⭐] - Design and smooth login template by [Hugo Extrat](https://github.com/huextrat)
- <b><code>&nbsp;&nbsp;&nbsp;309⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;112🍴</code></b> [Liquid Pay Payment App](https://github.com/longhoang2984/flutter_payment_app_ui)) [304⭐] - Liquid Pay App Concept by [Long Hoang](https://github.com/longhoang2984)
- <b><code>&nbsp;&nbsp;1631⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;476🍴</code></b> [FlutterFoodybite](https://github.com/JideGuru/FlutterFoodybite)) [1567⭐] - Beautiful food app UI template by [JideGuru](https://github.com/JideGuru)
- <b><code>&nbsp;&nbsp;3114⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;745🍴</code></b> [Flutter Samples](https://github.com/diegoveloper/flutter-samples)) [3083⭐] - Collection of nice flutter samples by [Diego Velásquez](https://github.com/diegoveloper).
- <b><code>&nbsp;&nbsp;&nbsp;496⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;87🍴</code></b> [ActingWeb First_App](https://github.com/gregertw/actingweb_firstapp)) [476⭐] - Starter app with basic elements for a team-developed production-quality app by [Greger Wedel](https://github.com/gregertw)
- <b><code>&nbsp;&nbsp;&nbsp;883⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;125🍴</code></b> [Smart Washing Machine](https://github.com/pawlik92/flutter_whirlpool)) [880⭐] - Smart washing machine UI challenge app with Box2D physic engine by [Tomasz Pawlikowski](https://github.com/pawlik92)

### Clone

- <b><code>&nbsp;&nbsp;1587⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;137🍴</code></b> [GitTouch](https://github.com/pd4d10/git-touch)) [1565⭐] - Open source mobile client for GitHub, GitLab, Bitbucket and Gitea by [Rongjian Zhang](https://github.com/pd4d10)
- <b><code>&nbsp;78738⭐</code></b> <b><code>&nbsp;10995🍴</code></b> [RustDesk](https://github.com/rustdesk/rustdesk)) [72980⭐] - Open source virtual / remote desktop. TeamViewer alternative.  Built with Rust by 🌎 [RustDesk team](www.rustdesk.com/)

### Machine Learning

- <b><code>&nbsp;&nbsp;2834⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;240🍴</code></b> [m2cgen](https://github.com/BayesWitnesses/m2cgen)) [2792⭐] - CLI tool to convert ML models into native Dart code by [BayesWitnesses](https://github.com/BayesWitnesses)

### Vision


#### Augmented Reality

- <b><code>&nbsp;&nbsp;&nbsp;807⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;228🍴</code></b> [ARKit Plugin](https://github.com/olexale/arkit_flutter_plugin)) [798⭐] - Wrapper for ARKit - Apple's augmented reality platform for iOS by [Olexandr Leuschenko](https://github.com/olexale).
- <b><code>&nbsp;&nbsp;&nbsp;436⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;281🍴</code></b> [ARCore Plugin](https://github.com/giandifra/arcore_flutter_plugin)) [433⭐] - Augmented reality with ARCore platform by [Gian Marco Di Francesco](https://github.com/giandifra).

## Plugins

- 🌎 [Pub packages](pub.dev/flutter/packages) - Packages filter in Dart Pub Repository.
- <b><code>&nbsp;&nbsp;4497⭐</code></b> <b><code>&nbsp;&nbsp;2982🍴</code></b> [Plugins](https://github.com/flutter/packages/tree/main/packages)) - Official Flutter Team Plugins

### Device

- <b><code>&nbsp;&nbsp;1482⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;936🍴</code></b> [WebView](https://github.com/dart-flitter/flutter_webview_plugin)) [1479⭐] - Render web content by 🌎 [Hadrien Lejard](twitter.com/HadrienLejard)
- <b><code>&nbsp;&nbsp;1122⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;829🍴</code></b> [Location](https://github.com/Lyokone/flutterlocation)) [1104⭐] - Handle location, handling callbacks to get continuous location by [Lyokone](https://github.com/Lyokone)
- 🌎 [Proximity Sensor Plugin](pub.dev/packages/proximity_plugin) - A plugin to access the proximity sensor of your device by [Manoj NB](https://github.com/Samaritan1011001)
- <b><code>&nbsp;&nbsp;2487⭐</code></b> <b><code>&nbsp;&nbsp;1416🍴</code></b> [Local Notifications](https://github.com/MaikuB/flutter_local_notifications)) [2441⭐] - Plugin for displaying local notifications by [Michael Bui](https://github.com/MaikuB)
- <b><code>&nbsp;&nbsp;&nbsp;270⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;275🍴</code></b> [Device Calendar](https://github.com/builttoroam/device_calendar)) - Plugin for modifying calendars on the user's device by [Built to Roam](http://builttoroam.com)
- <b><code>&nbsp;&nbsp;&nbsp;307⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;179🍴</code></b> [Badger](https://github.com/g123k/flutter_app_badger)) [308⭐] - Update app badge on the launcher by 🌎 [Edouard Marquez](twitter.com/g123k)
- <b><code>&nbsp;&nbsp;&nbsp;252⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;56🍴</code></b> [UDID](https://github.com/GigaDroid/flutter_udid)) [245⭐] - Persistent UDID across app reinstalls by 🌎 [Leon Kukuk](kukuk.me)
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [Downloader](https://github.com/hnvn/flutter_downloader)) [906⭐] - Create and manage download tasks by [HungHD](https://github.com/hnvn)
- <b><code>&nbsp;&nbsp;3353⭐</code></b> <b><code>&nbsp;&nbsp;1666🍴</code></b> [InAppWebView](https://github.com/pichillilorenzo/flutter_inappwebview)) [3178⭐] - Add inline WebView widgets or open an in-app browser window by [Lorenzo Pichilli](https://github.com/pichillilorenzo)
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;92⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;90🍴</code></b> [AppAvailability](https://github.com/pichillilorenzo/flutter_appavailability)) [92⭐] - List, launch and check installed apps by [Lorenzo Pichilli](https://github.com/pichillilorenzo)
- <b><code>&nbsp;&nbsp;1373⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;694🍴</code></b> [File Picker](https://github.com/miguelpruivo/plugins_flutter_file_picker)) [1320⭐] - Native file explorer to load absolute file path by [Miguel Ruivo](https://github.com/miguelpruivo)
- <b><code>&nbsp;&nbsp;&nbsp;362⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;131🍴</code></b> [VPN](https://github.com/X-dea/Flutter_VPN)) [350⭐] - Access VPN services by [Jason C.H](https://github.com/ctrysbita)
- <b><code>&nbsp;&nbsp;1256⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;660🍴</code></b> [Geolocator](https://github.com/baseflow/flutter-geolocator)) [1240⭐] - A Flutter geolocation plugin which provides easy access to the platform specific location services by 🌎 [Baseflow](baseflow.com)
- <b><code>&nbsp;&nbsp;2070⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;869🍴</code></b> [Permission Handler](https://github.com/baseflow/flutter-permission-handler)) [2023⭐] - A Flutter permission plugin which provides a cross-platform (iOS, Android) API to request and check permissions by 🌎 [Baseflow](baseflow.com)
- <b><code>&nbsp;&nbsp;&nbsp;191⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;56🍴</code></b> [Live Activities](https://github.com/istornz/live_activities)) [164⭐] - A plugin to use iOS live activities & Dynamic Island features by [Dimitri Dessus](https://github.com/istornz)

#### Scanner


#### Bluetooth / NFC / Beacon

- <b><code>&nbsp;&nbsp;2401⭐</code></b> <b><code>&nbsp;&nbsp;1240🍴</code></b> [Blue](https://github.com/pauldemarco/flutter_blue)) [2378⭐] - Bluetooth by [Paul DeMarco](https://github.com/pauldemarco)
- <b><code>&nbsp;&nbsp;&nbsp;407⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;198🍴</code></b> [NFC Reader](https://github.com/matteocrippa/flutter-nfc-reader)) [394⭐] - NFC reader plugin for iOS and Android by [Matteo Crippa](https://github.com/matteocrippa)
- <b><code>&nbsp;&nbsp;&nbsp;672⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;339🍴</code></b> [Reactive Ble](https://github.com/PhilipsHue/flutter_reactive_ble)) [664⭐] - Handles BLE operations for multiple devices by [Philips Hue](https://github.com/PhilipsHue)
- <b><code>&nbsp;&nbsp;&nbsp;213⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;139🍴</code></b> [NFC Manager](https://github.com/okadan/flutter-nfc-manager)) [200⭐] - Generic NFC plugin for iOS and Android by [Naoki Okada](https://github.com/okadan)

### Storage

- <b><code>&nbsp;&nbsp;2898⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;527🍴</code></b> [Sqflite](https://github.com/tekartik/sqflite)) [2856⭐] - SQLite flutter plugin by 🌎 [Alexandre Roux](www.linkedin.com/in/alextekartik/)
- <b><code>&nbsp;&nbsp;2726⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;378🍴</code></b> [Drift](https://github.com/simolus3/drift)) - Drift is an easy to use, reactive, typesafe persistence library for Dart & Flutter by [
Simon Binder](https://github.com/simolus3)
- <b><code>&nbsp;&nbsp;1068⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;125🍴</code></b> [ObjectBox](https://github.com/objectbox/objectbox-dart)) - On-device database for fast cross-platform Dart object persistence by [ObjectBox](https://github.com/objectbox)

### Services

- <b><code>&nbsp;&nbsp;&nbsp;634⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;217🍴</code></b> [OneSignal](https://github.com/OneSignal/OneSignal-Flutter-SDK)) [615⭐] - Push notification service by [OneSignal](https://github.com/OneSignal)
- <b><code>&nbsp;&nbsp;&nbsp;334⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82🍴</code></b> [In App Review](https://github.com/britannio/in_app_review)) [311⭐] - Requesting and Writing Reviews for Android, iOS and MacOS by [Britannio Jarrett](https://github.com/britannio)


## Frameworks

### State management

#### Standard

- <b><code>&nbsp;11921⭐</code></b> <b><code>&nbsp;&nbsp;3398🍴</code></b> [Bloc](https://github.com/felangel/bloc)) [11726⭐] - Collection of packages that help implement the BLoC design pattern by [Felix Angelov](https://github.com/felangel)
- <b><code>&nbsp;&nbsp;5133⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;515🍴</code></b> [Provider](https://github.com/rrousselGit/provider)) [5101⭐] - State-management library for Flutter by [Remi Rousselet](https://github.com/rrousselGit)
- <b><code>&nbsp;&nbsp;6383⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;967🍴</code></b> [RiverPod](https://github.com/rrousselGit/river_pod)) [6172⭐] - Provider, but different by [Remi Rousselet](https://github.com/rrousselGit)
- <b><code>&nbsp;&nbsp;1367⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;148🍴</code></b> [Get It](https://github.com/fluttercommunity/get_it)) [1323⭐] - Simple direct Service Locator that allows to decouple the interface from a concrete implementation by 🌎 [Thomas Burkhartb](twitter.com/Thomasburkhartb)
- <b><code>&nbsp;10522⭐</code></b> <b><code>&nbsp;&nbsp;1641🍴</code></b> [GetX](https://github.com/jonataslaw/getx)) [10245⭐] - Contextless, State-management & navigation by [Jonny Borges](https://github.com/jonataslaw)
- <b><code>&nbsp;&nbsp;2417⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;310🍴</code></b> [MobX](https://github.com/mobxjs/mobx.dart)) [2390⭐] - Supercharge the state-management in your apps with Transparent Functional Reactive Programming (TFRP). Port of MobX from the Js/React land.
- <b><code>&nbsp;&nbsp;&nbsp;507⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;55🍴</code></b> [Signals](https://github.com/rodydavis/signals.dart)) [433⭐] - Reactive programming made simple. Port of Signals pattern by [Rody Davis](https://github.com/rodydavis)


#### Redux / ELM / Dependency Injection

- <b><code>&nbsp;&nbsp;&nbsp;519⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;59🍴</code></b> [Redux.dart](https://github.com/johnpryan/redux.dart)) [516⭐] - Port of Redux to Dart with an ecosystem of middleware, Flutter integrations, and time traveling dev tools by [John Ryan](https://github.com/johnpryan) and 🌎 [Brian Egan](gitlab.com/users/brianegan/projects)
- <b><code>&nbsp;&nbsp;1654⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;217🍴</code></b> [Redux](https://github.com/brianegan/flutter_redux)) [1653⭐] - Built to work with <b><code>&nbsp;&nbsp;&nbsp;519⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;59🍴</code></b> [redux.dart](https://github.com/johnpryan/redux.dart)), utilities that allow you to easily consume a Redux Store to build Widgets
- 🌎 [Async Redux](pub.dev/packages/async_redux) [229⭐] - Redux without boilerplate. Allows for both sync and async reducers by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Marcelo Glasberg](https://github.com/marcglasberg/))

### Widgets

- <b><code>&nbsp;&nbsp;3166⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;180🍴</code></b> [Hooks](https://github.com/rrousselGit/flutter_hooks)) [3119⭐] - Advanced code sharing between widgets by [Remi Rousselet](https://github.com/rrousselGit)
- <b><code>&nbsp;&nbsp;&nbsp;602⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;46🍴</code></b> [Functional widget](https://github.com/rrousselGit/functional_widget)) [595⭐] - Code generator writing widgets as functions with annotations by [Remi Rousselet](https://github.com/rrousselGit)

### Data

- <b><code>&nbsp;&nbsp;3258⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;628🍴</code></b> [Graphql](https://github.com/zino-app/graphql-flutter)) [3243⭐] - Implementation of the GraphQL spec by [Zino App B.V.](https://github.com/zino-app)
- <b><code>&nbsp;&nbsp;&nbsp;305⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;261🍴</code></b> [GeoFlutterFire](https://github.com/DarshanGowda0/GeoFlutterFire)) [305⭐] - Implementation of GeoFirestore for flutter by 🌎 [Darshan Gowda](darshann.me/)
- <b><code>&nbsp;&nbsp;&nbsp;610⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;121🍴</code></b> [Ferry](https://github.com/gql-dart/ferry)) [600⭐] - Powerful & Extensible GraphQL Client by [Sat Mandir Khalsa](https://github.com/smkhalsa)


### Backend

- <b><code>&nbsp;&nbsp;1576⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;312🍴</code></b> [Dynamic Widget](https://github.com/dengyin2000/dynamic_widget)) [1554⭐] - Build your dynamic UI with json, and the json format is very similar with flutter widget code by [Denny Deng](https://github.com/dengyin2000).
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;78⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12🍴</code></b> [NETCoreSync](https://github.com/aldycool/NETCoreSync)) - Centralized database synchronization framework for multiple clients, built on top of <b><code>&nbsp;&nbsp;2726⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;378🍴</code></b> [Moor](https://github.com/simolus3/moor)) library by [Aldy J](https://github.com/aldycool)
- <b><code>&nbsp;&nbsp;&nbsp;578⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;198🍴</code></b> [Parse for Flutter](https://github.com/parse-community/Parse-SDK-Flutter/tree/master/packages/flutter)) [575⭐] Open source backend framework by 🌎 [ParsePlatform](parseplatform.org/).
- <b><code>&nbsp;&nbsp;2608⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;245🍴</code></b> [Serverpod](https://github.com/serverpod/serverpod)) - Write your server-side code and API in Dart.

### Animation

- <b><code>&nbsp;&nbsp;3042⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;311🍴</code></b> [SpinKit](https://github.com/jogboms/flutter_spinkit)) [2990⭐] - Animated loading indicators by 🌎 [Jeremiah Ogbomo](twitter.com/jogboms)
- <b><code>&nbsp;&nbsp;1678⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;310🍴</code></b> [AnimatedTextKit](https://github.com/aagarwal1012/Animated-Text-Kit)) [1652⭐] - A collection of cool text animations by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Ayush Agarwal](https://github.com/aagarwal1012/))
- <b><code>&nbsp;&nbsp;&nbsp;491⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;124🍴</code></b> [Drawing Animation](https://github.com/biocarl/drawing_animation)) [484⭐] - Create drawing line animations based on SVG path data by 🌎 [Carl Hauck](twitter.com/cahaucks)
- <b><code>&nbsp;&nbsp;1042⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;107🍴</code></b> [Simple Animations](https://github.com/felixblaschke/simple_animations)) - Create awesome custom animations easily by [Felix Blaschke](https://github.com/felixblaschke)
- <b><code>&nbsp;&nbsp;1595⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;133🍴</code></b> [Staggered Animations](https://github.com/mobiten/flutter_staggered_animations)) [1566⭐] - Easily add staggered animations to your ListView, GridView, Column and Row by 🌎 [mobiten](mobiten.com/)
- 🌎 [Animate Do](pub.dev/packages/animate_do) - Animation package inspired in Animate.css by 🌎 [Fernando Herrera](twitter.com/Fernando_Her85).
- <b><code>&nbsp;&nbsp;&nbsp;529⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;38🍴</code></b> [Funvas](https://github.com/creativecreatorormaybenot/funvas)) [524⭐] - Create fun *time based canvas animations* by 🌎 [creativecreatorormaybenot](twitter.com/creativemaybeno).
- 🌎 [Flutter Animate](pub.dev/packages/flutter_animate) [915⭐] - A performant library that makes it simple to add almost any kind of animated effect by 🌎 [gskinner](gskinner.com/)


### Testing

- <b><code>&nbsp;&nbsp;&nbsp;499⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [flutter_convenient_test](https://github.com/fzyzcjy/flutter_convenient_test)) [479⭐] - Tests with action history, time travelling, screenshots, rapid re-execution, video recordings, interactive mode by [fzyzcjy](https://github.com/fzyzcjy)
- <b><code>&nbsp;&nbsp;&nbsp;960⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;148🍴</code></b> [Patrol](https://github.com/leancodepl/patrol)) [860⭐] - Easy-to-learn, powerful UI testing framework eliminating limitations of `flutter_test`, `integration_test`, and `flutter_driver` by 🌎 [LeanCode](leancode.co)

### Web

- <b><code>&nbsp;&nbsp;1295⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;152🍴</code></b> [Responsive Framework](https://github.com/Codelessly/ResponsiveFramework)) [1262⭐] - Automatically adapt UI to different screen sizes. Responsiveness made simple by 🌎 [Codelessly](codelessly.com)

## Experimental

This section contains libraries that take an experimental or unorthodox approach.

- <b><code>&nbsp;&nbsp;1281⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;103🍴</code></b> [styled_widget](https://github.com/ReinBentdal/styled_widget)) [1260⭐] - Simplifying your widget tree structure by defining widgets using methods by [Rein Gundersen Bentdal](https://github.com/ReinBentdal).

## Engines

### Rendering

- <b><code>&nbsp;&nbsp;&nbsp;500⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;49🍴</code></b> [Graphx](https://github.com/roipeker/graphx)) [491⭐] - Making drawings and animations extremely simple, inspired by Flash, by [Roi Peker](https://github.com/roipeker).

### Game

- <b><code>&nbsp;&nbsp;9587⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;931🍴</code></b> [Flame](https://github.com/flame-engine/flame)) [9154⭐] - Minimalist game engine by [Luan Nico](https://github.com/luanpotter)
- <b><code>&nbsp;&nbsp;1301⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;190🍴</code></b> [Bonfire](https://github.com/RafaelBarbosatec/bonfire)) [1217⭐] - Flame engine based game engine for 2D RPG games
- <b><code>&nbsp;&nbsp;&nbsp;688⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;62🍴</code></b> [Zerker](https://github.com/flutterkit/zerker)) [681⭐] - Lightweight and powerful graphic animation library by [drawcall](https://github.com/drawcall).

#### Open source games

- <b><code>&nbsp;&nbsp;&nbsp;263⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;62🍴</code></b> [Flip](https://github.com/RedBrogdon/flutterflip)) [265⭐] - Reversi game by [Andrew Brogdon](https://github.com/RedBrogdon)
- <b><code>&nbsp;&nbsp;&nbsp;586⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;231🍴</code></b> [Crush](https://github.com/boeledi/flutter_crush)) [575⭐] - How to build a Math-3 game, like Candy Crush, Bejeweled by 🌎 [Didier Boelens](didierboelens.com)
- <b><code>&nbsp;&nbsp;1620⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;340🍴</code></b> [Tetris](https://github.com/boyan01/flutter-tetris)) [1601⭐] - Tetris game by [YangBin](https://github.com/boyan01)

#### Game Engine resources

- <b><code>&nbsp;&nbsp;1112⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;97🍴</code></b> [Awesome Flame](https://github.com/flame-engine/awesome-flame)) [1047⭐] - Curated list of the best Flame games, projects, libraries, tools, tutorials, articles and more by [Flame Engine](https://github.com/flame-engine)


## Open Source Apps

### Premium

- <b><code>&nbsp;59158⭐</code></b> <b><code>&nbsp;&nbsp;3928🍴</code></b> [AppFlowy](https://github.com/AppFlowy-IO/appflowy)) [55783⭐] - Open Source Notion Alternative. You are in charge of your data and customizations. Built with Flutter and Rust by 🌎 [AppFlowy team](www.appflowy.io/)
- <b><code>&nbsp;78738⭐</code></b> <b><code>&nbsp;10995🍴</code></b> [RustDesk](https://github.com/rustdesk/rustdesk)) [72980⭐] - Open source virtual/remote desktop and TeamViewer alternative. Built with Flutter and Rust by 🌎 [RustDesk team](www.rustdesk.com/).
- <b><code>&nbsp;33393⭐</code></b> <b><code>&nbsp;&nbsp;1397🍴</code></b> [Spotube](https://github.com/KRTirtho/spotube)) - Open source Spotify client for desktop and mobile by [Kingkor Roy Tirtho](https://github.com/KRTirtho)

### Top

- <b><code>&nbsp;17567⭐</code></b> <b><code>&nbsp;&nbsp;7601🍴</code></b> [Flutter Team Samples](https://github.com/flutter/samples)) [17079⭐] - Collection of examples (including maps, json, Material and Cupertino) by the <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;?🍴</code></b> [Flutter team](https://github.com/orgs/flutter/people))
- <b><code>&nbsp;23665⭐</code></b> <b><code>&nbsp;&nbsp;3804🍴</code></b> [Flutter Common Widgets](https://github.com/alibaba/flutter-common-widgets-app)) [23626⭐] - Collection of official widgets demos & docs in chinese to help developers learn quickly by [Alibaba Auction Frontend Team](https://github.com/alibaba-paimai-frontend)
- <b><code>&nbsp;&nbsp;1727⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;553🍴</code></b> [Music Player](https://github.com/iampawan/Flutter-Music-Player)) [1708⭐] - Full featured music player by 🌎 [Pawan Kumar](about.me/imthepk)
- <b><code>&nbsp;&nbsp;1200⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;276🍴</code></b> [WhatTodo](https://github.com/burhanrashid52/WhatTodo)) [1175⭐] - Todoist like UI by 🌎 [Burhanuddin Rashid](about.me/burhanrashid52)
- <b><code>&nbsp;&nbsp;2336⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;622🍴</code></b> [FlutterGram](https://github.com/mdanics/fluttergram)) [2314⭐] - Complete Instagram based on Firestore & Google Functions by [MDanics](https://github.com/mdanics)
- <b><code>&nbsp;&nbsp;1120⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;339🍴</code></b> [Trace](https://github.com/trentpiercy/trace)) [1108⭐] - Modern and powerful crypto portfolio & market explorer by [Trent Piercy](https://github.com/trentpiercy)
- <b><code>&nbsp;&nbsp;1019⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;279🍴</code></b> [Taskist](https://github.com/huextrat/Taskist)) [998⭐] - Taskist is a ToDo List app for Task Management by [Hugo EXTRAT](https://github.com/huextrat)
- <b><code>&nbsp;&nbsp;1139⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82🍴</code></b> [Linwood Butterfly](https://github.com/LinwoodCloud/Butterfly)) [972⭐] - Powerful note taking app and an alternative to OneNote by [CodeDoctorDE](https://github.com/CodeDoctorDE)
- <b><code>&nbsp;&nbsp;&nbsp;617⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;226🍴</code></b> [Trinity Orientation @ Univ Toronto](https://github.com/matthewtory/trinity-orientation-2018)) [617⭐] - Orientation week at Trinity College, U of T by [Matthew Tory](https://github.com/matthewtory)
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;26⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [Transform Widget](https://github.com/DrPaulT/flutter-engine-test)) - Image widgets as 3D game engine sprites by [Paul Thomas](https://github.com/DrPaulT)
- <b><code>&nbsp;&nbsp;&nbsp;327⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;115🍴</code></b> [TailorMade](https://github.com/jogboms/tailor_made)) [327⭐] - Managing a Fashion designer's daily routine using a mixture of ReBLoC w/ Firebase Cloud Store & Functions by 🌎 [Jeremiah Ogbomo](twitter.com/jogboms)
- <b><code>&nbsp;&nbsp;&nbsp;882⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;253🍴</code></b> [Spacex-Go](https://github.com/jesusrp98/spacex-go)) [869⭐] - Simple yet powerful, open-source SpaceX launch tracker. 🌎 [jesusrp98](twitter.com/jesusrp98).
- <b><code>&nbsp;&nbsp;&nbsp;400⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;120🍴</code></b> [Enigma](https://github.com/AmitJoki/Enigma)) - Privacy chat with end-to-end encryption by [AmitJoki](https://github.com/AmitJoki)
- <b><code>&nbsp;&nbsp;&nbsp;748⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;197🍴</code></b> [Chillify](https://github.com/KarimElghamry/chillify)) - Fancy music app made with Provider and Bloc pattern by [Karim Elghamry](https://github.com/KarimElghamry)
- <b><code>&nbsp;&nbsp;2400⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;570🍴</code></b> [Pokedex](https://github.com/scitbiz/flutter_pokedex)) - Pokedex app with beautiful UI and smooth animation by [Hung Pham](https://github.com/scitbiz)
- <b><code>&nbsp;&nbsp;2092⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;463🍴</code></b> [Timy Messenger](https://github.com/janoodleFTW/timy-messenger)) [2081⭐] - Group messaging app with a focus on organizing events by [Miguel Beltran](https://github.com/miquelbeltran) and [Franz Heinfling](https://github.com/fheinfling)
- <b><code>&nbsp;&nbsp;3545⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;245🍴</code></b> [GitJournal](https://github.com/GitJournal/GitJournal)) [3454⭐] - Journaling your data in a Git Repo by [Vishesh Handa](https://github.com/vHanda)
- <b><code>&nbsp;&nbsp;2335⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;258🍴</code></b> [AuthPass](https://github.com/authpass/authpass)) [2251⭐] - Keepass compatible password manager for mobile and desktop by [hpoul](https://github.com/hpoul)
- <b><code>&nbsp;&nbsp;3970⭐</code></b> <b><code>&nbsp;&nbsp;1110🍴</code></b> [Fwitter](https://github.com/TheAlphamerc/flutter_twitter_clone)) [3858⭐] - Full Twitter clone using Firebase solution by [Sonu Sharma](https://github.com/TheAlphamerc)
- <b><code>&nbsp;&nbsp;2075⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;200🍴</code></b> [Harpy](https://github.com/robertodoering/harpy)) [2064⭐] - Feature rich Twitter client by [Roberto Doering](https://github.com/robertodoering)
- <b><code>&nbsp;&nbsp;&nbsp;209⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [Mooltik](https://github.com/ruskakimov/mooltik)) [203⭐] - Animation app for making cartoons by [Rustem Kakimov](https://github.com/ruskakimov)
- <b><code>&nbsp;33393⭐</code></b> <b><code>&nbsp;&nbsp;1397🍴</code></b> [Spotube](https://github.com/KRTirtho/spotube)) [28916⭐] - A lightweight free Spotify crossplatform-client with no Spotify premium account requirement by [KRTirtho](https://github.com/KRTirtho)
- <b><code>&nbsp;&nbsp;&nbsp;299⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;87🍴</code></b> [Let's Draw](https://github.com/JideGuru/flutter_drawing_board)) [278⭐] - A simple drawing app made by [JideGuru](https://github.com/JideGuru)
- <b><code>&nbsp;&nbsp;&nbsp;992⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;60🍴</code></b> [Openreads](https://github.com/mateusz-bak/openreads-android)) [872⭐] - A simple privacy oriented mobile books tracker using Open Library API by [mateusz-bak](https://github.com/mateusz-bak)

## Utilities

- <b><code>&nbsp;&nbsp;2034⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;405🍴</code></b> [Launcher Icons](https://github.com/franzsilva/flutter_launcher_icons)) - Generate your launcher icons easily by [Mark O'Sullivan](https://github.com/MarkOSullivan94) and [Franz Silva](https://github.com/franzsilva)
- [FlutterIcon](http://fluttericon.com/) [420⭐] - Icon set generator by [Mike Hoolehan](https://github.com/ilikerobots)
- <b><code>&nbsp;&nbsp;4790⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;240🍴</code></b> [FVM](https://github.com/leoafarias/fvm)) [4565⭐] - Flutter Version Management: A simple cli to manage Flutter SDK versions.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;92⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [Environment Configuration](https://github.com/TatsuUkraine/dart_environment_config)) [92⭐] - CLI tool to generate `.env` configurations for application environments by [TatsuUkraine](https://github.com/TatsuUkraine)
- <b><code>&nbsp;&nbsp;&nbsp;473⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;89🍴</code></b> [Flutter Flavorizr](https://github.com/AngeloAvv/flutter_flavorizr)) [453⭐] - CLI utility to easily generate flavors for Android and iOS in less than 3 minutes by [Angelo Cassano](https://github.com/AngeloAvv)
- <b><code>&nbsp;&nbsp;&nbsp;105⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15🍴</code></b> [Fontify](https://github.com/westracer/fontify)) [103⭐] - CLI tool to convert SVG icons to OTF font and generate Flutter-compatible class by [Igor Kharakhordin](https://github.com/westracer)
- <b><code>&nbsp;&nbsp;1501⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;151🍴</code></b> [FlutterGen](https://github.com/FlutterGen/flutter_gen)) [1460⭐] - Assets code generator for your images, fonts, colors, etc — Get rid of String-based APIs.
- <b><code>&nbsp;&nbsp;2206⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;197🍴</code></b> [Very Good Cli](https://github.com/VeryGoodOpenSource/very_good_cli)) [2150⭐] - Very Good Command Line Interface for Dart created by  [Very Good Ventures](https://github.com/VeryGoodOpenSource)
- <b><code>&nbsp;&nbsp;1583⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;102🍴</code></b> [Flutter Sidekick](https://github.com/leoafarias/sidekick))  [1529⭐] - Simple app to make Flutter development more delightful by [Leo Farias](https://github.com/leoafarias)
- <b><code>&nbsp;&nbsp;&nbsp;863⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;266🍴</code></b> [Dart Code Metrics](https://github.com/dart-code-checker/dart-code-metrics)) [859⭐] - Additional linter which reports code metrics, checks for anti-patterns and provides additional rules for the Dart analyzer by [Dart Code Checker team](https://github.com/dart-code-checker).
- <b><code>&nbsp;&nbsp;1213⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;212🍴</code></b> [Melos](https://github.com/invertase/melos)) [1116⭐] - Manage projects with multiple packages, automated versioning, changelogs & publishing via Conventional Commits by [Invertase](https://github.com/invertase)

### VSCode

- 🌎 [Awesome Snippets](marketplace.visualstudio.com/items?itemName=Nash.awesome-flutter-snippets) - Collection of commonly used classes and methods by 🌎 [Nash](twitter.com/Nash0x7E2)
- 🌎 [Flutter Files](marketplace.visualstudio.com/items?itemName=gornivv.vscode-flutter-files) - Quick generation for BLoC templates files by context menu by [Gorniv](https://github.com/gorniv).
- 🌎 [Flutter Intl](marketplace.visualstudio.com/items?itemName=localizely.flutter-intl) - i18n binding from arb files by 🌎 [Localizely](twitter.com/localizely)


### IntelliJ / Android Studio

- <b><code>&nbsp;&nbsp;&nbsp;287⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;30🍴</code></b> [Enhancement_Suite](https://github.com/marius-h/flutter_enhancement_suite)) [286⭐] - Search for pub.dev libraries, update version, Bloc, Snippet, etc you're covered by [Marius Höfler](https://github.com/marius-h)
- 🌎 [Flutter Intl](plugins.jetbrains.com/plugin/13666-flutter-intl) - 18n binding from arb files by 🌎 [Localizely](twitter.com/localizely)

### Desktop

- <b><code>&nbsp;&nbsp;7107⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;608🍴</code></b> [Desktop Embedding](https://github.com/google/flutter-desktop-embedding)) [7102⭐] - Desktop implementations of the Flutter embedding API by Google
- <b><code>&nbsp;&nbsp;5882⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;282🍴</code></b> [Golang Desktop Embedder](https://github.com/go-flutter-desktop/go-flutter)) [5856⭐] - Golang embedder for desktop by [Pierre Champion](https://github.com/pchampio)
- <b><code>&nbsp;&nbsp;&nbsp;638⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [Native Shell](https://github.com/nativeshell/nativeshell)) [628⭐] - Experimental embedder for Flutter by 🌎 [Matej Knopp](twitter.com/matejknopp)
- <b><code>&nbsp;&nbsp;2105⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;77🍴</code></b> [Rust Desktop Embedder](https://github.com/gliheng/flutter-rs)) [2101⭐] - Rust embedder for desktop by [juju](https://github.com/gliheng).
- <b><code>&nbsp;&nbsp;&nbsp;817⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;231🍴</code></b> [bitsdojo_window](https://github.com/bitsdojo/bitsdojo_window)) <!--bitsdojo/bitsdojo_window--> - Customize windows owner-drawn chrome by [BitsDojo](https://github.com/bitsdojo)
- <b><code>&nbsp;&nbsp;1666⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;163🍴</code></b> [Raspberry Pi Embedder](https://github.com/ardera/flutter-pi)) [1587⭐] - Light-weight Embedder for Raspberry Pi by [Hannes Winkler](https://github.com/ardera)
- <b><code>&nbsp;&nbsp;3036⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;468🍴</code></b> [Fluent UI](https://github.com/bdlukaa/fluent_ui)) [2890⭐] - Microsoft's Fluent Design System in Flutter by 🌎 [Bruno D'Luka](twitter.com/bdlukaadev)
- <b><code>&nbsp;&nbsp;1912⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;188🍴</code></b> [MacOS UI](https://github.com/GroovinChip/macos_ui)) [1820⭐] - Widgets and themes implementing the current macOS design language by 🌎 [Groovin Chip](twitter.com/GroovinChip)
- <b><code>&nbsp;&nbsp;&nbsp;256⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;39🍴</code></b> [Ubuntu Yaru](https://github.com/ubuntu/yaru.dart)) [195⭐] - Distinct look and feel of the Ubuntu Desktop by [Ubuntu](https://github.com/ubuntu)
- <b><code>&nbsp;&nbsp;1581⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;112🍴</code></b> [Awesome Flutter Desktop](https://github.com/leanflutter/awesome-flutter-desktop)) [1537⭐] - A curated list of awesome things related to Flutter desktop by [LeanFlutter](https://github.com/leanflutter)

## Podcasts

### English

- 🌎 [It's all widgets! Flutter podcast](open.spotify.com/show/2qJVeu47e2eAum4j7lxXXv?si=d26QVJQsSRyRHeybfL_01Q) - by 🌎 [Hillel Coren](twitter.com/hillelcoren).

### Portuguese

- 🌎 [Universo Flutter](open.spotify.com/show/4AlxqGkkrqe0mfIx3Mi7Xt?si=1eC0a22MR1OkEAT7HErT-A) - by [Matias de Andrea](http://deandreamatias.com/).

### Spanish

- 🌎 [Código Flutter](open.spotify.com/show/3QUTYR6jspNxHK8akJFxYf?si=MZtgjIMyTi6-WgN9Go6vZQ) - by 🌎 [Guillermo García](guillermogarcia.es/).

### Russian

- 🌎 [Flutter Dev Podcast](open.spotify.com/show/5qc1VFD4pkJlUYZBVTOFCI?si=OWn7VCELRO2QV03Gi2u8nA&nd=1) - by 🌎 [Eugene Saturov](twitter.com/saturovv).

## Bonus

- 🌎 [It's All Widgets!](itsallwidgets.com) - Open list of published apps by 🌎 [Hillel Coren](twitter.com/hillelcoren), 🌎 [Thomas Burkhart](twitter.com/ThomasBurkhartB), 🌎 [Simon Lightfoot](twitter.com/devangelslondon) and 🌎 [Scott Stoll](twitter.com/scottstoll2017)
- <b><code>&nbsp;&nbsp;&nbsp;186⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12🍴</code></b> [Awesome Flutter Linux](https://github.com/jpnurmi/awesome-flutter-linux)) - A curated list of awesome Linux-specific Flutter packages and projects by 🌎 [J-P Nurmi](twitter.com/jpnurmi)

### Fun

- 🌎 [The One](www.youtube.com/watch?v=sIIgtClYq0s) [459👍]

### Hardware

- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2🍴</code></b> [Matrix2](https://github.com/bus710/matrix2)) - Sense Hat's LED matrix control game by [bus710](https://github.com/bus710)

### Guide & Interviews

- <b><code>&nbsp;&nbsp;&nbsp;356⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;90🍴</code></b> [Interview Questions](https://github.com/whatsupcoders/Flutter-Interview-Questions)) - List of helpful questions you can use to interview potential candidates by <b><code>&nbsp;&nbsp;&nbsp;&nbsp;41⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [Whatsupcoders](https://github.com/whatsupcoders/Whatsupcoders-flutter))
- 🌎 [The International Flutter Starter Kit](medium.com/flutter-community/intl-flutter-starter-kit-18415e739fb6) - Guide by the experts by 🌎 [Beyza Sunay Guler](twitter.com/BeyzaSunayGler1) & 🌎 [Nawal Alhamwi](twitter.com/__nawalhmw)
- 🌎 [Roadmap.sh/flutter](roadmap.sh/flutter) - A community curated flutter developer learning roadmap from the 6th most starred GitHub project.


## Community

### Presentation material

- 🌎 [Logo](drive.google.com/drive/folders/1GDGdQ0ghrxTNTx6aZLT41eV5sPZvV7bU) - Logo for stickers impressions

### Communication

- 🌎 [Gitter](gitter.im/flutter/flutter) - Exchange channel
- 🌎 [r/FlutterDev](www.reddit.com/r/FlutterDev/) - Reddit community by 🌎 [u/JaapVermeulen](www.reddit.com/user/JaapVermeulen)
- 🌎 [Discord](discord.gg/N7Yshp4) - Discord server to discuss and get help by 🌎 [Pritykin](twitter.com/AndrewPritykin)
- [Flutter Community](https://github.com/fluttercommunity) - Central place for community made packages
- [OpenFlutter](https://github.com/OpenFlutter) - Make it easier 让 Flutter 更简单
- 🌎 [Hashnode](hashnode.com/n/flutter) - Read and write posts, participate in discussions or ask questions.

#### Misc

- 🌎 [Flutter Events](flutterevents.com) - An open list of Flutter events by 🌎 [@hillelcoren](twitter.com/hillelcoren)
- 🌎 [FlutterX](flutterx.com) - Searchable list of resources by 🌎 [Hillel Coren](twitter.com/hillelcoren)

### 🇦🇴 Angola
- Facebook 🌎 [Group](facebook.com/groups/556888664681938)
- Facebook 🌎 [Page](facebook.com/Flutter-Angola-2076395262380886/)
- Twitter 🌎 [Page](twitter.com/AngolaFlutter)

### 🇦🇺 Australia
- Slack 🌎 [GDG Sydney](gdg-sydney.slack.com)
- Meetup 🌎 [GDG Sydney](www.meetup.com/gdgsydney)
- Twitter 🌎 [Flutter Sydney](twitter.com/FlutterSydney)

### Bangladesh
- 🌎 [Facebook Group](www.facebook.com/groups/flutter.bangladesh/)

### 🇧🇷 Brazil
- Slack 🌎 [Flutter Brasil](flutterbr.slack.com)
- Medium 🌎 [Flutter Comunidade BR](medium.com/flutter-comunidade-br)
- Twitter 🌎 [Flutter Comunidade BR](twitter.com/br_flutter)
- Meetup 🌎 [São Paulo](www.meetup.com/flutter-sp)
- 🌎 [Flutter para iniciantes](www.flutterparainiciantes.com.br)

### cm Cameroon

- Twitter 🌎 [Flutter Cameroon](twitter.com/fluttercm)
- Telegram 🌎 [Flutter & Dart Community CM](t.me/fluttercameroon)

### 🇨🇦 Canada

- Meetup 🌎 [Toronto](www.meetup.com/FlutterToronto)
- Meetup 🌎 [Montreal](www.meetup.com/FlutterMontreal)
- Meetup 🌎 [Calgary](www.meetup.com/FlutterCalgary)

### 🇨🇮 Côte d'Ivoire (Ivory Coast)

- Facebook 🌎 [Page](web.facebook.com/flutterci/)
- Facebook 🌎 [Group](web.facebook.com/groups/1725273507587759/)

### 🇩🇰 Denmark

- Meetup 🌎 [Denmark](www.meetup.com/Flutter-Developers-Denmark/)

### 🇪🇹 Ethiopia

- 🌎 [Telegram](t.me/flutter_forum/)

### 🇫🇷 France

- Meetup 🌎 [Bordeaux](www.meetup.com/fr-FR/Flutter-Bordeaux) - 🌎 [Lille](www.meetup.com/fr-FR/Flutter-Lille) - 🌎 [Paris](www.meetup.com/fr-FR/Flutter-Paris) - 🌎 [Rennes](www.meetup.com/fr-FR/Flutter-Rennes) - 🌎 [Nantes](www.meetup.com/fr-FR/flutter-nantes/)
- 🌎 [Twitter](twitter.com/FlutterFrance)
- 🌎 [Slack](linktr.ee/flutter_france)
- 🌎 [Newsletter Flutter Digest](www.flutter-digest.com/)

### 🇩🇪 Germany

- Meetup 🌎 [Berlin](www.meetup.com/flutter-berlin/) - 🌎 [Düsseldorf](www.meetup.com/flutter-school/) - 🌎 [Karlsruhe](www.meetup.com/Karlsruhe-Flutter-Meetup/) - 🌎 [Hamburg](www.meetup.com/Flutter-Hamburg/) - 🌎 [Stuttgart](www.meetup.com/Flutter-Stuttgart/) - 🌎 [Munich](www.meetup.com/Flutter-Munich)
- Twitter 🌎 [Flutter Berlin](twitter.com/flutterBerlin) - 🌎 [Düsseldorf](twitter.com/flutter_school) - 🌎 [Munich](twitter.com/FlutterMunich)
- Slack 🌎 [Flutter Berlin](flutterberlin.slack.com/join/shared_invite/enQtMzQ1NDI0NjU4Mjc5LWVjOTg0NmUxZmU4YzZjZjFkMWNjYWYyYTI5NjMyZWE5MDZjNDM0YzgyNWQyM2EzM2E0NDE4ZmQyMzQyMzRlNjI)
- LinkedIn 🌎 [Munich](www.linkedin.com/company/Flutter-Munich)

### 🇬🇷 Greece

- Meetup 🌎 [Athens](www.meetup.com/Athens-Flutter-Group/)
- Slack 🌎 [Flutter GR](join.slack.com/t/fluttergr/shared_invite/enQtNzQwODM2NzIxOTg0LWFjNWYxYzkyMTdmYWQ4ZWYyMWI2YjcyOTI4YzAzYjY2Nzk3OWNkMTkwZGRjNjRiMGFlNzgyOGRhMmEyZTQ3MmM)

### 🇮🇹 Italy
- Telegram 🌎 [Flutter Italia Developers](t.me/flutteritdevs)
- Website 🌎 [flutteritalia.dev](flutteritalia.dev)

### 🇮🇳 India
- Telegram 🌎 [Flutter India 🇮🇳](t.me/flutterindia)

### 🇮🇱 Israel
- Facebook 🌎 [Flutter Israel Developers](www.facebook.com/groups/2779846762051712)

### 🇮🇩 Indonesia
- Telegram 🌎 [Flutter Indonesia](t.me/flutter_id)

### 🇮🇷 Iran
- Telegram 🌎 [Persian Flutter](t.me/persian_flutter)

### 🇯🇵 Japan

- Meetup 🌎 [Tokyo Flutter Developers](www.meetup.com/Tokyo-Flutter/)

### 🇰🇪 Kenya
- Meetup 🌎 [Flutter Developers Kenya](www.meetup.com/KenyaFlutterDev/)
- Twitter 🌎 [Flutter Developers Kenya](twitter.com/KenyaFlutterDev/)

### 🇰🇷 Korea

- Meetup 🌎 [Flutter Korea](www.meetup.com/ko-KR/Flutter-Korea/)
- Facebook 🌎 [Flutter Korea User Group](www.facebook.com/groups/flutterkorea/)
- Slack [GDG Korea #flutter channel](http://slack.gdg.kr/)

### 🇲🇾 Malaysia

- Telegram 🌎 [Flutter/Dart Dev Malaysia](t.me/flutterdevmalaysia)

### 🇳🇬 Nigeria

- Slack 🌎 [DevCenter Square](devcenter-square-slack.herokuapp.com)
- Telegram 🌎 [FlutterLagos](t.me/joinchat/PAH0fVA0l7F_zMM537lo9w)
- Twitter 🌎 [FlutterLagos](twitter.com/FlutterLagos)

### 🇵🇰 Pakistan

- 🌎 [Facebook Group](www.facebook.com/groups/FlutterPK/)

### 🇵🇭 Philippines
- 🌎 [Website](flutter.ph/)
- 🌎 [Meetup](www.meetup.com/flutterph/)
- 🌎 [Twitter](twitter.com/flutter_ph)
- 🌎 [Facebook Page](web.facebook.com/flutterphilippines/)
- 🌎 [Facebook Group](web.facebook.com/groups/flutterphilippines/)
- [Github](https://github.com/flutterph)

### 🇵🇱 Poland
- 🌎 [Flutter Developers Poland Facebook Group](www.facebook.com/groups/2228619364094561/about/)
- [Flutter Poland Slack workspace](http://bit.ly/flutter-pl-slack)
- 🌎 [Flutter Warsaw Meetup](www.meetup.com/Flutter-Warsaw/)
- 🌎 [Flutter Warsaw Twitter](twitter.com/flutterwarsaw)
- 🌎 [Flutter Warsaw YouTube Channel](www.youtube.com/channel/UCO7yMprO8cFwV4QnuhTMVlQ)
- 🌎 [Poznan Flutter Developer Group](www.meetup.com/poznan-flutter-developers/)
- 🌎 [Flutter Wrocław Meetup](www.meetup.com/Flutter-Wroc%C5%82aw/)
- Meetup 🌎 [Tricity](www.meetup.com/pl-PL/Flutter-Tricity/)
- Twitter 🌎 [Tricity](twitter.com/FlutterTricity/)

### 🇵🇹 Portugal
- 🌎 [Meetup](www.meetup.com/flutterportugal)

### 🇵🇪 Peru

- Facebook 🌎 [Flutter Peru Group](www.facebook.com/groups/flutterperu/)
- Meetup 🌎 [Flutter Peru](meetup.com/Flutter-Peru/)
- Twitter 🌎 [Flutter Peru](twitter.com/FlutterPeru)

### 🇷🇺 Russia

- 🌎 [Telegram](t.me/rudart)
- 🌎 [Telegram - Oh, my Flutter](t.me/ohmyflutter)
- Meetup 🌎 [Flutter Voronezh](www.meetup.com/flutter-voronezh/)

### 🇪🇸 Spain

- 🌎 [Madrid Community](flutter.madrid)
- 🌎 [Madrid Meetup](www.meetup.com/es-ES/Flutter-Madrid)
- 🌎 [Madrid Twitter](twitter.com/FlutterMadrid)


### 🇱🇰 Sri Lanka

- 🌎 [Gitter](gitter.im/Colombo-Flutter-Community)
- 🌎 [Slack](fluttercmb.slack.com/)
- [Community GitHub Page](https://github.com/Colombo-Flutter-Meetup)
- 🌎 [Facebook Page](www.facebook.com/flutterCMB/)

### 🇹🇷 Turkey

- 🌎 [Twitter](twitter.com/flutter_turkiye)
- 🌎 [Medium](medium.com/flutter-türkiye/)
- 🌎 [Telegram Channel](t.me/FlutterTurk)
- 🌎 [Telegram Group](t.me/FlutterTR)
- 🌎 [Slack](bit.ly/flutterTR)
- [Github](https://github.com/flutterturkey)

### 🇺🇦 Ukraine
- 🌎 [Telegram](t.me/artflutter)
- 🌎 [Twitter](twitter.com/ArtFlutter)

### 🇬🇧 United Kingdom

- 🌎 [Flutter London](flutterldn.dev/)
- Meetup 🌎 [London](www.meetup.com/FlutterLDN/)
- 🌎 [Twitter](twitter.com/FlutterLDN)
- 🌎 [YouTube](www.youtube.com/channel/UC_a-vGdkAIRMKT1zzZ4I2ag)

### 🇺🇸 United States

- Meetup 🌎 [Chicago](www.meetup.com/Flutter-Chicago/)
- Meetup [Washington DC] (https://www.meetup.com/DCFlutter/)
- Meetup 🌎 [NYC](www.meetup.com/flutter-nyc/)

### 🏴 Kurdistan

- Meetup 🌎 [Kurdistan](www.meetup.com/Flutter-Kurdistan/)

### 🇳🇴 Norway
- 🌎 [Meetup Oslo](www.meetup.com/Oslo-Flutter-Dart-Meetup/)
- 🌎 [Meetup Stavanger](www.meetup.com/Flutter-Stavanger/)
- 🌎 [Twitter](twitter.com/flutterNorway)

### 🇺🇿 Uzbekistan
- 🌎 [Telegram](t.me/dartdevuz)

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, 🌎 [Robert Felker](www.linkedin.com/in/robert-felker/) has waived all copyright and related or neighboring rights to this work.

## Source
<b><code>&nbsp;54261⭐</code></b> <b><code>&nbsp;&nbsp;6687🍴</code></b> [Solido/awesome-flutter](https://github.com/Solido/awesome-flutter))