# Contributing Guide

Please read the contributing guide thoroughly before you start contributing to the project to avoid any inconvenience.

Also, check out the ![README.md](https://github.com/YurisCodingClub/dev-cv/blob/main/README.md)
file and the ![the project's wiki](https://github.com/YurisCodingClub/dev-cv/wiki).

## Issues & Pull Requests

### Creating an Issue

During Hacktoberfest, Issues are only created by me. When the project is in a more advanced process, community members can create Issues as well.

### Working on an Issue (get it assigned to you)

Before working on an existing Issue please follow these steps:

1. only ask to be assigned 1 issue at a time
1. look out for the Issue label `status: ready for dev` (if it does not have this label, your work might not be accepted)
1. comment asking for the issue to be assigned to you
1. after the Issue is assigned to you, you can start working on it
1. **only** start working on this Issue (and open a Pull Request) when it has been assigned to you - this will prevent confusion, multiple people working on the same issue and work not being used
1. do **not** enable GitHub Actions on your fork
1. reference the Issue in your Pull Request (for example `closes #123`)

> Notes:
>
> - it is not sustainable for maintainers to review historical comments asking for assignments before the Issue label `status: ready for dev` was added; only requests for assignment of an Issue after this label has been added will be considered
> - check the `Assignees` box at the top of the page to see if the issue has been assigned to someone else before requesting this be assigned to you
> - if an Issue is unclear, ask questions to get more clarity before asking to have the Issue assigned to you
> - only request to be assigned an Issue if you know how to work on it
> - an Issue can be assigned to multiple people, if you all agree to collaborate on the issue (the Pull Request can contain commits from different collaborators)
> - any Issues that have no activity after 2 weeks will be unassigned and re-assigned to someone else

## Reviewing Pull Requests

During Hacktoberfest I will review Pull Requests latest on Saturday evening. Please be patient. Numerous messages and tags will not speed up the process.

### DOs

- use inline comments to communicate your thoughts on the PR if I leave a suggestion

### DON'Ts

- do not be rude, disrespectful or aggressive
- do not repeat comments/messages, this creates more noise than value (check the existing conversation), use GitHub reactions if you agree/disagree with a comment

---

> Note: Persistent non-compliance with this Contributing Guide can lead to a warning and/or ban under the [Code of Conduct](https://github.com/YurisCodingClub/accessibility-mentor/blob/main/CODE_OF_CONDUCT.md)
