import { Math } from '@vicons/tabler';
import { defineTool } from '../tool';
import { translate } from '@/plugins/i18n.plugin';

export const tool = defineTool({
  name: translate('tools.math-evaluator.title'),
  path: '/math-evaluator',
  description: translate('tools.math-evaluator.description'),
  keywords: [
    'math',
    'evaluator',
    'calculator',
    'expression',
    'abs',
    'acos',
    'acosh',
    'acot',
    'acoth',
    'acsc',
    'acsch',
    'asec',
    'asech',
    'asin',
    'asinh',
    'atan',
    'atan2',
    'atanh',
    'cos',
    'cosh',
    'cot',
    'coth',
    'csc',
    'csch',
    'sec',
    'sech',
    'sin',
    'sinh',
    'sqrt',
    'tan',
    'tanh',
  ],
  component: () => import('./math-evaluator.vue'),
  icon: Math,
});
