# Summary

- [Introduction](index.md)
  - [Acknowledgments](acknowledments.md)

# WezTerm

- [Installation](wezterm/installation.md)

- [Configuration](wezterm/configuration.md)

  - [Window](wezterm/window.md)
  - [Shell Prompt](wezterm/shell.md)
  - [Font](wezterm/font.md)
  - [Window Frame](wezterm/frame.md)
  - [Key Binding](wezterm/keybind.md)
  - [Leader Key](wezterm/leader.md)

- [Format](wezterm/format.md)

  - [Window Title](wezterm/window-title.md)
  - [Tab](wezterm/tab.md)

- [Status Bar](wezterm/status.md)

  - [Left Status](wezterm/left-status.md)
  - [Right Status](wezterm/right-status.md)

- [Custom Event](wezterm/custom.md)
  - [Toggle Font](wezterm/toggle-font.md)
  - [DPI Detection](wezterm/dpi-detection.md)
  - [Window Decorations](wezterm/window-decorations.md)

# Neovim

- [Installation](neovim/installation.md)

- [User Config](neovim/user-config.md)
- [Lua Module](neovim/lua-module.md)
- [Options](neovim/options/options.md)

  - [nvim_set_option](neovim/options/nvim_set_option.md)

    - [termguicolors](neovim/options/termguicolors.md)
    - [scrolloff](neovim/options/scrolloff.md)
    - [ignorecase / smartcase](neovim/options/ignorecase-smartcase.md)
    - [inccommand](neovim/options/inccommand.md)
    - [clipboard](neovim/options/clipboard.md)

  - [nvim_win_set_option](neovim/options/nvim_win_set_option.md)

    - [number](neovim/options/number.md)
    - [cusrorline](neovim/options/cursorline.md)
    - [signcolumn](neovim/options/signcolumn.md)
    - [wrap / colorcolumn](neovim/options/wrap-colorcolumn.md)

  - [nvim_buf_set_option](neovim/options/nvim_buf_set_option.md)
    - [tabstop / shiftwidth / expandtab](neovim/options/tab.md)

- [Automatic Command](neovim/au/automatic-commands.md)

  - [nvim_create_autocmd](neovim/au/nvim_create_autocmd.md)
  - [nvim_create_augroup](neovim/au/nvim_create_augroup.md)

- [Key Binding](neovim/keybind.md)
- [Leader Key](neovim/leader.md)

- [Function](neovim/function/function.md)

  - [Warming Up](neovim/function/warming-up.md)
  - [Parameters / Return Values](neovim/function/param-return.md)
  - [vim.cmd](neovim/function/vim-cmd.md)
  - [Call The Plugin](neovim/function/call-plugin.md)

- [Plugin](neovim/plugin/plugin.md)
  - [packer.nvim](neovim/plugin/packer.md)
  - [nvim-treesitter](neovim/plugin/nvim-treesitter.md)
  - [onenord.nvim](neovim/plugin/onenord.md)
  - [lualine.nvim](neovim/plugin/lualine.md)
  - [nvim-hlslens](neovim/plugin/nvim-hlslens.md)
  - [gitsigns](neovim/plugin/gitsigns.md)
  - [nvim-scrollbar](neovim/plugin/nvim-scrollbar.md)
  - [lualine.nvim Part Ⅱ](neovim/plugin/lualine-part2.md)
  - [lualine.nvim Part Ⅲ](neovim/plugin/lualine-part3.md)
  - [telescope.nvim](neovim/plugin/telescope.md)
    - [Config](neovim/plugin/telescope-config.md)
    - [telescope-all-recent](neovim/plugin/telescope-all-recent.md)
  - [nvim-tree.lua](neovim/plugin/nvim-tree.md)
    - [Actions](neovim/plugin/nvim-tree-actions.md)
      - [(Extra) for Nvim 0.10](neovim/plugin/nvim-tree-actions-tip.md)

- [Language Server Protocol](neovim/lsp/language-server-protocol.md)
  - [nvim-lspconfig](neovim/lsp/nvim-lspconfig.md)
  - [mason.nvim](neovim/lsp/mason.md)
  - [mason-lspconfig.nvim](neovim/lsp/mason-lspconfig.md)
  - [nvim-navic](neovim/lsp/nvim-navic.md)
  - [nvim-navbuddy](neovim/lsp/nvim-navbuddy.md)
  - [nvim-cmp](neovim/lsp/nvim-cmp.md)
    - [cmp-nvim-lsp](neovim/lsp/cmp-nvim-lsp.md)
  - [LuaSnip](neovim/lsp/luasnip.md)
    - [cmp_luasnip](neovim/lsp/cmp_luasnip.md)
    - [Friendly Snippets](neovim/lsp/friendly_snippets.md)
  - [copilot.lua](neovim/lsp/copilot.md)
    - [(Extra) GitHub Copilot](neovim/lsp/github-copilot.md)
    - [copilot-cmp](neovim/lsp/copilot-cmp.md)
  - [nvim-cmp-source(s)](neovim/lsp/nvim-cmp-sources.md)
  - [fidget.nvim](neovim/lsp/fidget.md)
  - [Trouble](neovim/lsp/trouble.md)

# ... To Be Continued.

- [Outroduction](outro/outroduction.md)
  - [lazy.nvim](outro/lazy.md)
    - [Migration Guide](outro/lazy-migration-guide.md)
  - [nvim-notify](outro/nvim-notify.md)
  - [nvim_set_option_value](outro/nvim_set_option_value.md)
  - [none-ls.nvim](outro/none-ls.md)
  - [mason-null-ls.nvim](outro/mason-null-ls.md)
    - [(Extra) Year 2024](outro/year2024.md)
    - [Linter](outro/linter.md)
  - [LSP (Meet Me)](outro/lsp-meet-me.md)
  - [nvim_get_option_value](outro/nvim_get_option_value.md)
  - [nvim_set_var](outro/nvim_set_var.md)
  - [WezTerm (Meet Me)](outro/wezterm-meet-me.md)
- [fin](fin.md)
