---
sidebar_position: 5
keywords: [html, html headings, six headings of html, headings in html, heading syntax]
---

# HTML Headings

HTML headings are titles or subtitles that you may want in your web page. There are altogether 6 headings in HTML from `h1` to `h6`. You can use headings as shown below.

```html title="headings.html"
<h1>Heading 1</h1>
<h2>Heading 2</h2>
<h3>Heading 3</h3>
<h4>Heading 4</h4>
<h5>Heading 5</h5>
<h6>Heading 6</h6>
```

The `<h1>` defines the most important heading whereas the `<h6>` defines the least important heading.

## Considerations

Headings are the most important blocks in HTML. Before using them, you need to know the following things.

- There are only 6 headings `h1` to `h6`.
- You can have multiple headings in a same webpage. For example you may have a main headings defined by `h1` and multiple headings defined by `h2`.
- Browsers by default can add some spacing around headings.
- Browsers by default have the heading text bold.
- Headings are important as they show the page structure.
- Headings should be used in proper order.
- Don't use headings to make text **bold** or **big**.

:::danger important
Although you can add multiple heading of same type don't use more than one `h1`. You can use other headings as many times as you want.
:::
