---
sidebar_position: 3
keywords: [html, sample html, basic html]
---

# A Sample HTML Document

Before starting out have a look at the sample HTML document.

```html title=sample-example.html
<!DOCTYPE html>
<html>
  <head>
    <title>My First HTML Document</title>
  </head>
  <body>
    <h1>This is my first HTML Page.</h1>
    <p>I am learning HTML with ComputeNepal.</p>
  </body>
</html>
```

## Explanation

The code shown above is a simple HTML document that displays a heading ans a paragraph.

- `<!DOCTYPE html>` is the declaration that the document is an HTML5 document.
- `<html>` is the root element of the HTML page.
- `<head>` is the element that contains the metadata for the website like favicon information, seo title, seo description, tags, etc.
- `<title>` is the element that gives the title to the HTML page which is shown in the browser's tab or title bar.
- `<body>` is the element that cntains all the content of the HTML page.
- `<h1>` is the element that defines a large heading.
- `<p>` is the element that defines a paragraph in HTML.

### File Extension

You may have noticed, at title of the code-block. The name of the file is **_sample-example.html_**. The file type (extension) for HTML is <code>.html</code> or <code>.htm</code>.

### What is HTML Element/ Tag?

HTML element are the blocks that you see in your web page like headings, images, texts, etc. It is defined by a HTML tag. A HTML tag contains a start tag and end tag, content enclosed in between.

```html
<tagname>Content here...</tagname>
```

:::tip Note
Some tags like `<br>` don't have a closing tag and content in between. These tags are called **_singular tags_**.
:::
