class Emoticon {
  const Emoticon({
    required this.symbol,
    required this.name,
  });

  final String symbol;
  final String name;
}

class Emoticons {
  static List<Emoticon> all() => List.unmodifiable(_emoticons);

  static Emoticon? byChar(String char) {
    return _emoticons
        .firstWhere((Emoticon emoticon) => emoticon.symbol == char);
  }

  static const Iterable<Emoticon> _emoticons = [
    Emoticon(symbol: ':)', name: 'Smiling Face'),
    Emoticon(symbol: ':(', name: 'Sad Face'),
    Emoticon(symbol: ':D', name: 'Grinning Face'),
    Emoticon(symbol: ':P', name: 'Face with Tongue'),
    Emoticon(symbol: ':|', name: 'Neutral Face'),
    Emoticon(symbol: ';)', name: 'Winking Face'),
    Emoticon(symbol: ':S', name: 'Confused Face'),
    Emoticon(symbol: ':/', name: 'Skeptical:Face'),
    Emoticon(symbol: ':*', name: 'Kissing:Face'),
    Emoticon(symbol: 'XD', name: 'Laughing Face'),
    Emoticon(symbol: ':\\', name: 'Unsure:Face'),
    Emoticon(symbol: ':]', name: 'Smirking:Face'),
    Emoticon(symbol: ':[', name: 'Disappointed:Face'),
    Emoticon(symbol: ':3', name: 'Cute Face'),
    Emoticon(symbol: ':L', name: 'Bored Face'),
    Emoticon(symbol: ':C', name: 'Very Sad Face'),
    Emoticon(symbol: '=)', name: 'Happy:Face'),
    Emoticon(symbol: '=(', name: 'Unhappy:Face'),
    Emoticon(symbol: '=D', name: 'Very Happy Face'),
    Emoticon(symbol: '=P', name: 'Playful Face'),
    Emoticon(symbol: '=O', name: 'Shocked Face'),
    Emoticon(symbol: '=|', name: 'Stoic:Face'),
    Emoticon(symbol: '=3', name: 'Excited Face'),
    Emoticon(symbol: '=S', name: 'Perplexed Face'),
    Emoticon(symbol: '=X', name: 'Muted Face'),
    Emoticon(symbol: 'B)', name: 'Cool Face'),
    Emoticon(symbol: 'B(', name: 'Upset Cool Face'),
    Emoticon(symbol: 'BD', name: 'Cool Grinning Face'),
    Emoticon(symbol: '8)', name: 'Wide-Eyed Face'),
    Emoticon(symbol: '8(', name: 'Wide-Eyed Sad Face'),
    Emoticon(symbol: '8D', name: 'Wide-Eyed Happy Face'),
    Emoticon(symbol: '8O', name: 'Wide-Eyed Shock'),
    Emoticon(symbol: '8P', name: 'Wide-Eyed Playful'),
    Emoticon(symbol: '8|', name: 'Wide-Eyed Neutral'),
    Emoticon(symbol: '8/', name: 'Wide-Eyed Confused'),
    Emoticon(symbol: 'xD', name: 'Laughing with Closed Eyes'),
    Emoticon(symbol: 'xP', name: 'Tongue Out, Eyes Closed'),
    Emoticon(symbol: 'x(', name: 'Frustrated Face'),
    Emoticon(symbol: 'x)', name: 'Squinting Happy Face'),
    Emoticon(symbol: 'X(', name: 'Angry Frustrated Face'),
    Emoticon(symbol: 'X)', name: 'Tight-Eyed Laugh'),
    Emoticon(symbol: 'XP', name: 'Disgusted Face'),
    Emoticon(symbol: 'XO', name: 'Shocked Angry Face'),
    Emoticon(symbol: 'X|', name: 'Tired Face'),
    Emoticon(symbol: 'X/', name: 'Annoyed Face'),
    Emoticon(symbol: ':Y', name: 'Thumbs Up'),
    Emoticon(symbol: ':N', name: 'Thumbs Down'),
    Emoticon(symbol: ':I', name: 'Indifferent Face'),
    Emoticon(symbol: ':E', name: 'Disappointed Face'),
    Emoticon(symbol: ':F', name: 'Flower'),
    Emoticon(symbol: ':G', name: 'Grinning with Teeth'),
    Emoticon(symbol: ':H', name: 'Hot Face'),
    Emoticon(symbol: ':J', name: 'Tongue-in-Cheek'),
    Emoticon(symbol: ':K', name: 'Blowing a Kiss'),
    Emoticon(symbol: ':M', name: 'Thinking Face'),
    Emoticon(symbol: ':Q', name: 'Smoking Face'),
    Emoticon(symbol: ':R', name: 'Embarrassed Face'),
    Emoticon(symbol: ':T', name: 'Serious Face'),
    Emoticon(symbol: ':U', name: 'Unamused Face'),
    Emoticon(symbol: ':V', name: 'Shouting Face'),
    Emoticon(symbol: ':W', name: 'Wobbly Mouth'),
    Emoticon(symbol: ':Z', name: 'Sleeping Face'),
    Emoticon(symbol: ':^)', name: 'Pointed Nose Smile'),
    Emoticon(symbol: ':^(', name: 'Pointed Nose Frown'),
    Emoticon(symbol: ':^D', name: 'Pointed Nose Grin'),
    Emoticon(symbol: ':^P', name: 'Pointed Nose Tongue'),
    Emoticon(symbol: ':^O', name: 'Pointed Nose Surprise'),
    Emoticon(symbol: ':^|', name: 'Pointed Nose Neutral'),
    Emoticon(symbol: ':^/', name: 'Pointed Nose Skeptical'),
    Emoticon(symbol: ':^S', name: 'Pointed Nose Confused'),
    Emoticon(symbol: '(y)', name: 'Thumbs Up'),
    Emoticon(symbol: '(n)', name: 'Thumbs Down'),
    Emoticon(symbol: '(h)', name: 'Heart'),
    Emoticon(symbol: '(m)', name: 'Mail'),
    Emoticon(symbol: '(c)', name: 'Call'),
    Emoticon(symbol: '(i)', name: 'Information'),
    Emoticon(symbol: '(s)', name: 'Moon'),
    Emoticon(symbol: '(r)', name: 'Rainbow'),
    Emoticon(symbol: '(f)', name: 'Flower'),
    Emoticon(symbol: '(u)', name: 'Broken Heart'),
    Emoticon(symbol: '(~)', name: 'Film'),
    Emoticon(symbol: '(8)', name: 'Music Note'),
    Emoticon(symbol: '(p)', name: 'Camera'),
    Emoticon(symbol: '(d)', name: 'Drink'),
    Emoticon(symbol: '(w)', name: 'Wilted Flower'),
    Emoticon(symbol: '(l)', name: 'Light Bulb'),
    Emoticon(symbol: '(k)', name: 'Clock'),
    Emoticon(symbol: '(@)', name: 'Cat'),
    Emoticon(symbol: '(&)', name: 'Dog'),
    Emoticon(symbol: '(*)', name: 'Star'),
    Emoticon(symbol: '^_^', name: 'Happy Eyes'),
    Emoticon(symbol: 'T_T', name: 'Crying Face'),
    Emoticon(symbol: 'O.O', name: 'Wide Eyes'),
    Emoticon(symbol: '-_-', name: 'Expressionless'),
    Emoticon(symbol: '~_~', name: 'Unamused'),
    Emoticon(symbol: 'o_O', name: 'Confused Look'),
    Emoticon(symbol: 'O_o', name: 'Perplexed'),
    Emoticon(symbol: '._.', name: 'Blank Stare'),
    Emoticon(symbol: '*-*', name: 'Starry Eyed'),
    Emoticon(symbol: 'u_u', name: 'Disappointed'),
    Emoticon(symbol: 'n_n', name: 'Very Happy'),
    Emoticon(symbol: 'v.v', name: 'Dejected'),
    Emoticon(symbol: 'U_U', name: 'Sleeping'),
    Emoticon(symbol: 'x_x', name: 'Dead'),
    Emoticon(symbol: '@_@', name: 'Dizzy'),
    Emoticon(symbol: '\$_\$', name: 'Money Eyes'),
    Emoticon(symbol: '*.*', name: 'Starstruck'),
    Emoticon(symbol: '?.?', name: 'Puzzled'),
    Emoticon(symbol: '!.!', name: 'Surprised'),
    Emoticon(symbol: '~.~', name: 'Relieved'),
    Emoticon(symbol: ';)', name: 'Winking Face'),
    Emoticon(symbol: ':/', name: 'Skeptical Face'),
    Emoticon(symbol: ':]', name: 'Smirking Face'),
    Emoticon(symbol: ':[', name: 'Frowning Face'),
    Emoticon(symbol: '=)', name: 'Happy Face'),
    Emoticon(symbol: '=(', name: 'Unhappy Face'),
    Emoticon(symbol: '=|', name: 'Stoic Face'),
    Emoticon(symbol: 'BD', name: 'Cool Grinning'),
    Emoticon(symbol: '8(', name: 'Wide-Eyed Sad'),
    Emoticon(symbol: '8D', name: 'Wide Happy Face'),
    Emoticon(symbol: 'xD', name: 'Laughing'),
    Emoticon(symbol: 'xP', name: 'Tongue Out'),
    Emoticon(symbol: 'x)', name: 'Squinting Happy'),
    Emoticon(symbol: 'X(', name: 'Angry Frustrated'),
    Emoticon(symbol: 'XO', name: 'Shocked Angry'),
    Emoticon(symbol: ':E', name: 'Disappointed'),
    Emoticon(symbol: ':G', name: 'Grinning Teeth'),
    Emoticon(symbol: ':R', name: 'Embarrassed'),
    Emoticon(symbol: ':#', name: 'Zipped Mouth'),
    Emoticon(symbol: ':\$', name: 'Blushing Face'),
    Emoticon(symbol: ':!', name: 'Foot in Mouth'),
    Emoticon(symbol: ':%', name: 'Confused'),
    Emoticon(symbol: ':^)', name: 'Pointed Nose'),
    Emoticon(symbol: ':b', name: 'Sticking Tongue'),
    Emoticon(symbol: ':j', name: 'Determined'),
    Emoticon(symbol: ':[)', name: 'Vampire'),
    Emoticon(symbol: '*o*', name: 'Amazed'),
    Emoticon(symbol: '+_+', name: 'Dizzy'),
    Emoticon(symbol: '%_%', name: 'Confused'),
    Emoticon(symbol: '#_#', name: 'Censored Eyes'),
    Emoticon(symbol: '~_+', name: 'Winking Dizzy'),
    Emoticon(symbol: '&_&', name: 'Glasses'),
    Emoticon(symbol: '?_?', name: 'Very Confused'),
    Emoticon(symbol: '!_!', name: 'Alarmed'),
    Emoticon(symbol: '._,', name: 'Sweating'),
    Emoticon(symbol: '=-:', name: 'Unimpressed'),
    Emoticon(symbol: ':-/', name: 'Skeptical'),
    Emoticon(symbol: ':-o', name: 'Gasping'),
    Emoticon(symbol: ':-0', name: 'Shocked'),
    Emoticon(symbol: ':-}', name: 'Devilish Grin'),
    Emoticon(symbol: ':{', name: 'Mustache'),
    Emoticon(symbol: ':}', name: 'Cheesy Grin'),
    Emoticon(symbol: ':B', name: 'Buck Teeth'),
    Emoticon(symbol: ':b', name: 'Tongue Out'),
    Emoticon(symbol: ':e', name: 'Disappointed'),
    Emoticon(symbol: ':t', name: 'Pouting'),
    Emoticon(symbol: ':u', name: 'Horseshoe'),
    Emoticon(symbol: ':x', name: 'Sealed Lips'),
    Emoticon(symbol: ':z', name: 'Bored'),
    Emoticon(symbol: ':~)', name: 'Runny Nose'),
    Emoticon(symbol: ':|)', name: 'Straight Nose'),
    Emoticon(symbol: ':~P', name: 'Drooling'),
    Emoticon(symbol: ':~D', name: 'Laughing Hard'),
    Emoticon(symbol: ':~O', name: 'Yawning'),
    Emoticon(symbol: ':~/', name: 'Perplexed'),
    Emoticon(symbol: ':~|', name: 'Unamused'),
    Emoticon(symbol: ':~\\', name: 'Skeptical'),
    Emoticon(symbol: ':-}', name: 'Smug'),
    Emoticon(symbol: ':-{', name: 'Mustache'),
    Emoticon(symbol: ':-B', name: 'Nerd'),
    Emoticon(symbol: ':-b', name: 'Tongue Out'),
    Emoticon(symbol: ':-c', name: 'Frown'),
    Emoticon(symbol: ':-e', name: 'Disappointed'),
    Emoticon(symbol: ':-t', name: 'Pouting'),
    Emoticon(symbol: ':-u', name: 'Horseshoe'),
    Emoticon(symbol: ':-x', name: 'Sealed Lips'),
    Emoticon(symbol: ':-z', name: 'Bored'),
    Emoticon(symbol: ';~)', name: 'Winking Nose'),
    Emoticon(symbol: ';|)', name: 'Winking Nose'),
    Emoticon(symbol: ';~(', name: 'Winking Cry'),
    Emoticon(symbol: ';~P', name: 'Winking Drool'),
    Emoticon(symbol: ';~D', name: 'Winking Laugh'),
    Emoticon(symbol: ';~O', name: 'Winking Yawn'),
    Emoticon(symbol: ';~/', name: 'Winking Perplexed'),
    Emoticon(symbol: ';~|', name: 'Winking Unamused'),
    Emoticon(symbol: ';~\\', name: 'Winking Skeptical'),
    Emoticon(symbol: '=~)', name: 'Equal Nose'),
    Emoticon(symbol: '=|)', name: 'Equal Nose'),
    Emoticon(symbol: '=~(', name: 'Equal Cry'),
    Emoticon(symbol: '=~P', name: 'Equal Drool'),
    Emoticon(symbol: '=~D', name: 'Equal Laugh'),
    Emoticon(symbol: '=~O', name: 'Equal Yawn'),
    Emoticon(symbol: '=~/', name: 'Equal Perplexed'),
    Emoticon(symbol: '=~|', name: 'Equal Unamused'),
    Emoticon(symbol: '=~\\', name: 'Equal Skeptical'),
    Emoticon(symbol: 'B~)', name: 'Cool Nose'),
    Emoticon(symbol: 'B|)', name: 'Cool Nose'),
    Emoticon(symbol: 'B~(', name: 'Cool Cry'),
    Emoticon(symbol: 'B~P', name: 'Cool Drool'),
    Emoticon(symbol: 'B~D', name: 'Cool Laugh'),
    Emoticon(symbol: 'B~O', name: 'Cool Yawn'),
    Emoticon(symbol: 'B~/', name: 'Cool Perplexed'),
    Emoticon(symbol: 'B~|', name: 'Cool Unamused'),
    Emoticon(symbol: 'B~\\', name: 'Cool Skeptical'),
    Emoticon(symbol: '8~)', name: 'Wide Nose'),
    Emoticon(symbol: '8|)', name: 'Wide Nose'),
    Emoticon(symbol: '8~(', name: 'Wide Cry'),
    Emoticon(symbol: '8~P', name: 'Wide Drool'),
    Emoticon(symbol: '8~D', name: 'Wide Laugh'),
    Emoticon(symbol: '8~O', name: 'Wide Yawn'),
    Emoticon(symbol: '8~/', name: 'Wide Perplexed'),
    Emoticon(symbol: '8~|', name: 'Wide Unamused'),
    Emoticon(symbol: '8~\\', name: 'Wide Skeptical'),
    Emoticon(symbol: ':-J', name: 'Tongue in Cheek'),
    Emoticon(symbol: ':-K', name: 'Kiss'),
    Emoticon(symbol: ':-L', name: 'Licking Lips'),
    Emoticon(symbol: ':-M', name: 'Sealed Lips'),
    Emoticon(symbol: ':-N', name: 'No'),
    Emoticon(symbol: ':-T', name: 'Sad But Relieved'),
    Emoticon(symbol: ':-U', name: 'Unimpressed Face'),
    Emoticon(symbol: ':-V', name: 'Skeptical Face'),
    Emoticon(symbol: ':-W', name: 'Wonky Face'),
    Emoticon(symbol: ':-X', name: 'Closed Eyes'),
    Emoticon(symbol: ':-Y', name: 'Yes'),
    Emoticon(symbol: ':-Z', name: 'Sleeping'),
    Emoticon(symbol: ':-[', name: 'Shy'),
    Emoticon(symbol: ':-]', name: 'Nervous Smile'),
    Emoticon(symbol: ':-^', name: 'Raised Eyebrow'),
    Emoticon(symbol: ':-*', name: 'Kiss with Heart'),
    Emoticon(symbol: ':-~', name: 'Sneezing'),
    Emoticon(symbol: ':-8', name: 'Glasses'),
    Emoticon(symbol: ':-9', name: 'Hungry'),
    Emoticon(symbol: ':-10', name: 'Excited'),
    Emoticon(symbol: ':-11', name: 'Surprised'),
    Emoticon(symbol: ':-12', name: 'Awkward'),
    Emoticon(symbol: ':-13', name: 'Curious'),
    Emoticon(symbol: ':-14', name: 'Concerned'),
    Emoticon(symbol: ':-15', name: 'Pensive'),
    Emoticon(symbol: ':-16', name: 'Annoyed'),
    Emoticon(symbol: ':-17', name: 'Puzzled'),
    Emoticon(symbol: ':-18', name: 'Confounded'),
    Emoticon(symbol: ':-19', name: 'Cautious'),
    Emoticon(symbol: ':-20', name: 'Eager'),
    Emoticon(symbol: ':-21', name: 'Horrified'),
    Emoticon(symbol: ':-22', name: 'Agitated'),
    Emoticon(symbol: ':-23', name: 'Charmed'),
    Emoticon(symbol: ':-24', name: 'Bored'),
    Emoticon(symbol: ':-25', name: 'Disgusted'),
    Emoticon(symbol: ':-26', name: 'Elated'),
    Emoticon(symbol: ':-27', name: 'Frustrated'),
    Emoticon(symbol: ':-28', name: 'Gleeful'),
    Emoticon(symbol: ':-29', name: 'Hesitant'),
    Emoticon(symbol: ':-30', name: 'Indifferent'),
    Emoticon(symbol: ':-31', name: 'Joyful'),
    Emoticon(symbol: ':-32', name: 'Keen'),
    Emoticon(symbol: ':-33', name: 'Lamenting'),
    Emoticon(symbol: ':-34', name: 'Musing'),
    Emoticon(symbol: ':-35', name: 'Nostalgic'),
    Emoticon(symbol: ':-36', name: 'Optimistic'),
    Emoticon(symbol: ':-37', name: 'Perplexed'),
    Emoticon(symbol: ':-38', name: 'Quizzical'),
    Emoticon(symbol: ':-39', name: 'Reflective'),
    Emoticon(symbol: ':-40', name: 'Suspicious'),
    Emoticon(symbol: ':-41', name: 'Thoughtful'),
    Emoticon(symbol: ':-42', name: 'Uncertain'),
    Emoticon(symbol: ':-43', name: 'Vexed'),
    Emoticon(symbol: ':-44', name: 'Worried'),
    Emoticon(symbol: ':-45', name: 'Yearning'),
    Emoticon(symbol: ':-46', name: 'Zealous'),
    Emoticon(symbol: ':*D', name: 'Excited Grin'),
    Emoticon(symbol: ':*P', name: 'Silly Face'),
    Emoticon(symbol: ':*O', name: 'Astonished'),
    Emoticon(symbol: ':*|', name: 'Worried Face'),
    Emoticon(symbol: ':*L', name: 'Loudly Crying'),
    Emoticon(symbol: ':*G', name: 'Goofy Smile'),
    Emoticon(symbol: ':*H', name: 'Hushed Face'),
    Emoticon(symbol: ':*S', name: 'Smiling Eyes'),
    Emoticon(symbol: ':*T', name: 'Tear of Joy'),
    Emoticon(symbol: ':*M', name: 'Mouth Open'),
    Emoticon(symbol: ':*B', name: 'Blushing Grin'),
    Emoticon(symbol: ':*K', name: 'Kissing Face'),
    Emoticon(symbol: ':*X', name: 'Cross-eyed'),
    Emoticon(symbol: ':*Y', name: 'Yelling'),
    Emoticon(symbol: ':*J', name: 'Jubilant'),
    Emoticon(symbol: ':*F', name: 'Frustrated Smile'),
    Emoticon(symbol: ':*R', name: 'Rolling Eyes'),
    Emoticon(symbol: ':*N', name: 'Nodding Face'),
    Emoticon(symbol: ':*W', name: 'Winking Grin'),
    Emoticon(symbol: ':*Q', name: 'Questioning Look'),
    Emoticon(symbol: ':*Z', name: 'Zipping Lips'),
    Emoticon(symbol: ':*C', name: 'Cool Face'),
    Emoticon(symbol: ':*V', name: 'Victorious'),
    Emoticon(symbol: ':*A', name: 'Angelic Smile'),
    Emoticon(symbol: ':*E', name: 'Eager Face'),
    Emoticon(symbol: ':*I', name: 'Inspired'),
    Emoticon(symbol: ':*U', name: 'Unhappy Smile'),
    Emoticon(symbol: ':*0', name: 'Surprised Grin'),
    Emoticon(symbol: ':*1', name: 'Excited Wink'),
    Emoticon(symbol: ':*2', name: 'Confused Grin'),
    Emoticon(symbol: ':*3', name: 'Shocked Face'),
    Emoticon(symbol: ':*4', name: 'Crying Laugh'),
    Emoticon(symbol: ':*5', name: 'Nervous Grin'),
    Emoticon(symbol: ':*6', name: 'Hysterical Laugh'),
    Emoticon(symbol: ':*7', name: 'Sly Smile'),
    Emoticon(symbol: ':*8', name: 'Wide Grin'),
    Emoticon(symbol: ':*9', name: 'Sheepish Smile'),
    Emoticon(symbol: ':*@', name: 'Crazy Face'),
    Emoticon(symbol: ':*\$', name: 'Money Face'),
    Emoticon(symbol: ':*#', name: 'Pound Face'),
    Emoticon(symbol: ':*%', name: 'Percent Face'),
    Emoticon(symbol: ':*&', name: 'Ampersand Face'),
    Emoticon(symbol: ':*(', name: 'Sad Grin'),
    Emoticon(symbol: ':*)', name: 'Happy Tears'),
    Emoticon(symbol: ':*-', name: 'Relieved Grin'),
    Emoticon(symbol: ':*+', name: 'Plus Face'),
    Emoticon(symbol: ':*~', name: 'Dreamy Smile'),
    Emoticon(symbol: ':*`', name: 'Wry Smile'),
    Emoticon(symbol: ':*^', name: 'Surprised Wink'),
    Emoticon(symbol: ':*_', name: 'Serious Grin'),
    Emoticon(symbol: ':*:', name: 'Mouth Open Smile'),
    Emoticon(symbol: ':*;', name: 'Winking Laugh'),
    Emoticon(symbol: ':*?', name: 'Questioning Grin'),
    Emoticon(symbol: ':*!', name: 'Exclamation Face'),
    Emoticon(symbol: ':*.', name: 'Period Face'),
    Emoticon(symbol: ':*/', name: 'Unsure Grin'),
    Emoticon(symbol: ':*\\', name: 'Skeptical Grin'),
    Emoticon(symbol: ':*|', name: 'Unimpressed Grin'),
    Emoticon(symbol: ':*((', name: 'Very Sad Grin'),
    Emoticon(symbol: ':*}}', name: 'Wide Mouth Grin'),
    Emoticon(symbol: ':*--', name: 'Deadpan Grin'),
    Emoticon(symbol: ':*==', name: 'Robot Face'),
    Emoticon(symbol: ':*[]', name: 'Hug Face'),
    Emoticon(symbol: ':*{}', name: 'Handshake Face'),
    Emoticon(symbol: ':*^^', name: 'Double Wink'),
    Emoticon(symbol: ':*~~', name: 'Sarcastic Smile'),
    Emoticon(symbol: ':)', name: 'Smile'),
    Emoticon(symbol: 'XD', name: 'Laughing'),
    Emoticon(symbol: ':-P', name: 'Cheeky'),
    Emoticon(symbol: ':S', name: 'Confused'),
    Emoticon(symbol: ':-D', name: 'Grin'),
    Emoticon(symbol: ':@', name: 'Angry'),
    Emoticon(symbol: '8)', name: 'Cool'),
    Emoticon(symbol: ':L', name: 'Skeptical'),
    Emoticon(symbol: '>:)', name: 'Evil Smile'),
    Emoticon(symbol: ':/', name: 'Disappointed'),
    Emoticon(symbol: ':-|', name: 'Indifferent'),
    Emoticon(symbol: ':-O', name: 'Astonished'),
    Emoticon(symbol: '8-)', name: 'Nerdy Glasses'),
    Emoticon(symbol: 'B-)', name: 'Cool Shades'),
    Emoticon(symbol: 'D:', name: 'Horrified'),
    Emoticon(symbol: ':-X', name: 'Secretive'),
    Emoticon(symbol: ':-&', name: 'Tongue-Tied'),
    Emoticon(symbol: ':-S', name: 'Frustrated'),
    Emoticon(symbol: ':\')]', name: 'Smile with Nose'),
    Emoticon(symbol: ':(', name: 'Frown with Nose'),
    Emoticon(symbol: ':->', name: 'Sarcastic'),
    Emoticon(symbol: '>:D', name: 'Evil Grin'),
    Emoticon(symbol: ':-D', name: 'Happy Grin'),
    Emoticon(symbol: ':->', name: 'Sneaky Smile'),
    Emoticon(symbol: '(:', name: 'Reverse Smile'),
    Emoticon(symbol: '):', name: 'Reverse Frown'),
    Emoticon(symbol: 'O:)', name: 'Innocent'),
    Emoticon(symbol: 'O:-)', name: 'Angel'),
    Emoticon(symbol: ':#', name: 'Mouth Shut'),
    Emoticon(symbol: ':-]', name: 'Smug Smile'),
    Emoticon(symbol: ':-}', name: 'Smiling Face'),
    Emoticon(symbol: '{:-)', name: 'Moustache Smile'),
    Emoticon(symbol: '}:)', name: 'Devilish Smile'),
    Emoticon(symbol: ':)', name: 'Smiling'),
    Emoticon(symbol: ':-)', name: 'Smiling Face'),
    Emoticon(symbol: '(-:', name: 'Left Handed Smile'),
    Emoticon(symbol: '(-:', name: 'Happy Left'),
    Emoticon(symbol: ':\\', name: 'Uncertain'),
    Emoticon(symbol: '=)', name: 'Equal Smile'),
    Emoticon(symbol: ':-\\', name: 'Unsure'),
    Emoticon(symbol: ':,)', name: 'Tearful Smile'),
    Emoticon(symbol: ':-\'(', name: 'Crying Face'),
    Emoticon(symbol: ':-D', name: 'Very Happy'),
    Emoticon(symbol: ':-)', name: 'Regular Smile'),
    Emoticon(symbol: ';-)', name: 'Winking Smile'),
    Emoticon(symbol: 'O:-)', name: 'Saint'),
    Emoticon(symbol: '(:', name: 'Upside Down Smile'),
    Emoticon(symbol: ':=', name: 'Pursed Lips'),
    Emoticon(symbol: ':-)', name: 'Standard Smile'),
    Emoticon(symbol: ':*', name: 'Blowing a Kiss'),
    Emoticon(symbol: ':))', name: 'Big Grin'),
    Emoticon(symbol: ':o)', name: 'Monkey Face'),
    Emoticon(symbol: ':@', name: 'Angry Face'),
    Emoticon(symbol: ':-@', name: 'Screaming'),
    Emoticon(symbol: ':-)', name: 'Cheerful'),
    Emoticon(symbol: ':&', name: 'Tongue-Tied'),
    Emoticon(symbol: ':^*', name: 'Kiss'),
    Emoticon(symbol: '<3', name: 'Heart'),
    Emoticon(symbol: '3:)', name: 'Devil Horns'),
    Emoticon(symbol: ':-<', name: 'Disappointed Face'),
    Emoticon(symbol: ':-)', name: 'Simple Smile'),
    Emoticon(symbol: ':*', name: 'Mwah'),
    Emoticon(symbol: ':o(', name: 'Surprised Sad Face'),
    Emoticon(symbol: ':-o', name: 'Open Mouth'),
    Emoticon(symbol: ':-)', name: 'Classic Smile'),
    Emoticon(symbol: '8-)', name: 'Cool Glasses'),
    Emoticon(symbol: ':^) ', name: 'Upward Smile'),
    Emoticon(symbol: ':-(', name: 'Displeased'),
    Emoticon(symbol: ':)', name: 'Simple Smile'),
    Emoticon(symbol: ':-)', name: 'Standard Happy'),
    Emoticon(symbol: ':=)', name: 'Wide Smile'),
    Emoticon(symbol: ':c)', name: 'Happy Side Smile'),
    Emoticon(symbol: ':o)', name: 'Curious Smile'),
    Emoticon(symbol: ':}', name: 'Beaming Smile'),
    Emoticon(symbol: 'c:', name: 'Happy Face Left'),
    Emoticon(symbol: '(:', name: 'Happy Face Left'),
    Emoticon(symbol: ':\\', name: 'Worried Smile'),
    Emoticon(symbol: ':1', name: 'Goofy Smile'),
    Emoticon(symbol: ':x', name: 'Shy Smile'),
    Emoticon(symbol: ';)', name: 'Wink'),
    Emoticon(symbol: ';D', name: 'Cheerful Wink'),
    Emoticon(symbol: ':/', name: 'Skeptical Smile'),
    Emoticon(symbol: ':o', name: 'Wow Face'),
    Emoticon(symbol: ':@', name: 'Annoyed Face'),
    Emoticon(symbol: '>:)', name: 'Devious Smile'),
    Emoticon(symbol: ';-)', name: 'Flirty Wink'),
    Emoticon(symbol: ':]', name: 'Joyful'),
    Emoticon(symbol: ':-)', name: 'Glad Smile'),
    Emoticon(symbol: ':]', name: 'Happy Expression'),
    Emoticon(symbol: ';P', name: 'Winking Tongue Out'),
    Emoticon(symbol: ':s', name: 'Uneasy Smile'),
    Emoticon(symbol: '=D', name: 'Excited Smile'),
    Emoticon(symbol: '8D', name: 'Big Eyed Smile'),
    Emoticon(symbol: ':c', name: 'Concerned Face'),
    Emoticon(symbol: ':P', name: 'Cheeky Face'),
    Emoticon(symbol: ':(', name: 'Unhappy Face'),
    Emoticon(symbol: ':|', name: 'Ambivalent'),
    Emoticon(symbol: ':]', name: 'Joy'),
    Emoticon(symbol: ':\\', name: 'Unsure'),
    Emoticon(symbol: ':-|', name: 'Indifferent Face'),
    Emoticon(symbol: ':O', name: 'Surprised Face'),
    Emoticon(symbol: ':-O', name: 'Astonished Face'),
    Emoticon(symbol: ':)', name: 'Pleased Smile'),
    Emoticon(symbol: ':-)', name: 'Sincere Smile'),
    Emoticon(symbol: ':D', name: 'Delighted Smile'),
    Emoticon(symbol: ':-(', name: 'Distressed Face'),
    Emoticon(symbol: ':\$', name: 'Embarrassed Smile'),
    Emoticon(symbol: ':-)', name: 'Typical Smile'),
    Emoticon(symbol: 'D:', name: 'Shocked Face'),
    Emoticon(symbol: ':)', name: 'Friendly Smile'),
    Emoticon(symbol: '>:(', name: 'Angry Frown'),
    Emoticon(symbol: ':-)', name: 'Satisfied Smile'),
    Emoticon(symbol: ';-)', name: 'Sneaky Wink'),
    Emoticon(symbol: ':\\', name: 'Uncertain Smile'),
    Emoticon(symbol: ':c)', name: 'Sly Smile'),
    Emoticon(symbol: ':(', name: 'Downcast Smile'),
    Emoticon(symbol: ':D', name: 'Happy Grin'),
    Emoticon(symbol: ':-D', name: 'Broad Smile'),
    Emoticon(symbol: ':-O', name: 'Shocked Face'),
    Emoticon(symbol: ':O', name: 'Amazed Face'),
    Emoticon(symbol: ':]', name: 'Warm Smile'),
    Emoticon(symbol: ':<', name: 'Pouting Face'),
    Emoticon(symbol: ':o', name: 'Surprised Expression'),
    Emoticon(symbol: ':}', name: 'Delighted'),
    Emoticon(symbol: ':)', name: 'Optimistic'),
    Emoticon(symbol: ':|', name: 'Neutral Face'),
    Emoticon(symbol: ':)', name: 'Sunshine'),
    Emoticon(symbol: ':-[', name: 'Blushing'),
    Emoticon(symbol: ':)', name: 'Beaming Smile'),
    Emoticon(symbol: ':-D', name: 'Cheshire Smile'),
    Emoticon(symbol: ':-]', name: 'Slight Smile'),
    Emoticon(symbol: ':)', name: 'Smiley Face'),
    Emoticon(symbol: ':D', name: 'Smiling'),
    Emoticon(symbol: ':)', name: 'Grin'),
    Emoticon(symbol: ':]', name: 'Satisfied Smile'),
    Emoticon(symbol: ':-)', name: 'Positive Smile'),
    Emoticon(symbol: ':-]', name: 'Slightly Happy'),
    Emoticon(symbol: ':-<', name: 'Unhappy'),
    Emoticon(symbol: ':-]', name: 'Friendly Smile'),
    Emoticon(symbol: ':^)', name: 'Raised Eyebrow'),
    Emoticon(symbol: ':v)', name: 'Smiling Face with Glasses'),
    Emoticon(symbol: '>:o', name: 'Angry Face'),
    Emoticon(symbol: ':-?', name: 'Skeptical Face'),
    Emoticon(symbol: ':-c', name: 'Unhappy Face'),
    Emoticon(symbol: ':=D', name: 'Equal Grin'),
    Emoticon(symbol: ':-b', name: 'Playful Tongue'),
    Emoticon(symbol: 'B-)', name: 'Cool Face'),
    Emoticon(symbol: 'B-(', name: 'Upset Cool Face'),
    Emoticon(symbol: ':->', name: 'Sly Smile'),
    Emoticon(symbol: ':*)', name: 'Drunk Face'),
    Emoticon(symbol: '=^_^=', name: 'Cat Smile'),
    Emoticon(symbol: ':-T', name: 'Pouting'),
    Emoticon(symbol: ':-~', name: 'Drooling Face'),
    Emoticon(symbol: ':--)', name: 'Crooked Smile'),
    Emoticon(symbol: ':?-(', name: 'Confused Frown'),
    Emoticon(symbol: ':-&', name: 'Tongue Tied'),
    Emoticon(symbol: ':(', name: 'Sad with Nose'),
    Emoticon(symbol: ':-}', name: 'Cheshire Cat'),
    Emoticon(symbol: ':-]', name: 'Grinning Face with Eyes'),
    Emoticon(symbol: ':-o', name: 'Surprised with Nose'),
    Emoticon(symbol: ':-<', name: 'Pouting Smile'),
    Emoticon(symbol: ':~)', name: 'Cry Smile'),
    Emoticon(symbol: ':v', name: 'Pac-Man'),
    Emoticon(symbol: '=]', name: 'Happy Face'),
    Emoticon(symbol: '=D', name: 'Big Grin'),
    Emoticon(symbol: ':B', name: 'Toothy Grin'),
    Emoticon(symbol: ':-<', name: 'Frown Face'),
    Emoticon(symbol: '=]', name: 'Cheerful'),
    Emoticon(symbol: ':-k', name: 'Tongue Out'),
    Emoticon(symbol: ':oD', name: 'Excited Grin'),
    Emoticon(symbol: ':-}', name: 'Satisfied Smile'),
    Emoticon(symbol: ':->', name: 'Sarcastic Grin'),
    Emoticon(symbol: ':p', name: 'Playful Tongue Out'),
    Emoticon(symbol: ':-c', name: 'Sad with Tongue'),
    Emoticon(symbol: ':)', name: 'Happy Face with Nose'),
    Emoticon(symbol: ':}', name: 'Content Face'),
    Emoticon(symbol: ':-q', name: 'Quirky Smile'),
    Emoticon(symbol: ':--)', name: 'Wry Smile'),
    Emoticon(symbol: ':D', name: 'Excited Face'),
    Emoticon(symbol: ':}', name: 'Satisfied Smile'),
    Emoticon(symbol: ':B', name: 'Goofy Smile'),
    Emoticon(symbol: ':>', name: 'Mischievous Grin'),
    Emoticon(symbol: ':E', name: 'Vampire Teeth'),
    Emoticon(symbol: ':^D', name: 'Laughing Hard'),
    Emoticon(symbol: ':*)', name: 'Kiss'),
    Emoticon(symbol: ':3', name: 'Cat Smile'),
    Emoticon(symbol: ':-3', name: 'Cute Smile'),
    Emoticon(symbol: '=}', name: 'Content Smile'),
    Emoticon(symbol: ':c]', name: 'Cheeky Smile'),
    Emoticon(symbol: ':-p', name: 'Playful'),
    Emoticon(symbol: ':^) ', name: 'Snarky Smile'),
    Emoticon(symbol: ':o)', name: 'Cheerful'),
    Emoticon(symbol: ':V', name: 'Big Smile'),
    Emoticon(symbol: ':D', name: 'Wide Grin'),
    Emoticon(symbol: ':*', name: 'Kissing Face'),
    Emoticon(symbol: ':]', name: 'Grinning'),
    Emoticon(symbol: ':^)', name: 'Sly Smile'),
    Emoticon(symbol: ':-}', name: 'Content Face'),
    Emoticon(symbol: ':-] ', name: 'Happy Grin'),
    Emoticon(symbol: ':7', name: 'Joking Face'),
    Emoticon(symbol: ':1', name: 'Happy'),
    Emoticon(symbol: ':=', name: 'Cute'),
    Emoticon(symbol: ':9', name: 'Smiling Face'),
    Emoticon(symbol: ':-c', name: 'Pouting Face'),
    Emoticon(symbol: ':p', name: 'Silly Tongue'),
    Emoticon(symbol: ':8)', name: 'Big Eyes'),
    Emoticon(symbol: ':-X', name: 'Sealed Lips'),
    Emoticon(symbol: ':-/', name: 'Unsure'),
    Emoticon(symbol: ':O', name: 'Surprised'),
    Emoticon(symbol: ':]', name: 'Glad'),
    Emoticon(symbol: ':]', name: 'Content Smile'),
    Emoticon(symbol: ':-}', name: 'Wry Smile'),
    Emoticon(symbol: ':}', name: 'Beaming Face'),
    Emoticon(symbol: ':-)', name: 'Friendly Smile'),
    Emoticon(symbol: ':-B', name: 'Nerdy Smile'),
    Emoticon(symbol: ':^D', name: 'Big Laugh'),
    Emoticon(symbol: ':-)', name: 'Warm Smile'),
    Emoticon(symbol: ':3', name: 'Cute Cat Smile'),
    Emoticon(symbol: ':-X', name: 'Kiss Face'),
    Emoticon(symbol: ':-/', name: 'Worried Smile'),
    Emoticon(symbol: ':(', name: 'Sad Smile'),
    Emoticon(symbol: ':-]', name: 'Happy Face'),
    Emoticon(symbol: ':*)', name: 'Silly Face'),
    Emoticon(symbol: ':-E', name: 'Vampire Smile'),
    Emoticon(symbol: ':]', name: 'Glad Face'),
    Emoticon(symbol: ':^)', name: 'Snarky Smile'),
    Emoticon(symbol: ':1', name: 'Confused Smile'),
    Emoticon(symbol: ':-@', name: 'Yelling Face'),
    Emoticon(symbol: ':-#', name: 'Sealed Lips'),
    Emoticon(symbol: ':?', name: 'Curious Smile'),
    Emoticon(symbol: ':v)', name: 'Grinning Face'),
    Emoticon(symbol: ':^]', name: 'Happy Smile'),
    Emoticon(symbol: ':-}', name: 'Content Smile'),
    Emoticon(symbol: ':]', name: 'Content'),
    Emoticon(symbol: ':7', name: 'Awkward Smile'),
    Emoticon(symbol: ':|', name: 'Indifferent Face'),
    Emoticon(symbol: ':-)', name: 'Happy Camper'),
    Emoticon(symbol: ':8)', name: 'Happy Wide-Eyed'),
    Emoticon(symbol: ':-V', name: 'Screaming'),
    Emoticon(symbol: ':-B', name: 'Cheeky Smile'),
    Emoticon(symbol: ':E', name: 'Big Grin'),
    Emoticon(symbol: ':c', name: 'Worried Smile'),
    Emoticon(symbol: ':-c', name: 'Frown Face'),
    Emoticon(symbol: ':-p', name: 'Playful Tongue'),
    Emoticon(symbol: ':*', name: 'Kiss'),
    Emoticon(symbol: ':>D', name: 'Laughing'),
    Emoticon(symbol: ':>', name: 'Big Smile'),
    Emoticon(symbol: ':-Q', name: 'Smoking'),
    Emoticon(symbol: ':c)', name: 'Side Smile'),
    Emoticon(symbol: ':-]', name: 'Grin'),
    Emoticon(symbol: ':^)', name: 'Raised Eyebrow Smile'),
    Emoticon(symbol: ':)', name: 'Happy'),
    Emoticon(symbol: ':o', name: 'Surprised Face'),
    Emoticon(symbol: ':)', name: 'Classic Smile'),
    Emoticon(symbol: ':|', name: 'Neutral Smile'),
    Emoticon(symbol: ':-)', name: 'Content Face'),
    Emoticon(symbol: ':-?', name: 'Skeptical Smile'),
    Emoticon(symbol: ':X', name: 'Sealed Lips'),
    Emoticon(symbol: ':-<', name: 'Sad Face'),
    Emoticon(symbol: ':8)', name: 'Wide-Eyed Smile'),
    Emoticon(symbol: ':-/', name: 'Confused Smile'),
    Emoticon(symbol: ':-)', name: 'Happy'),
    Emoticon(symbol: ':-D', name: 'Big Grin'),
    Emoticon(symbol: ':=)', name: 'Wide Grin'),
    Emoticon(symbol: ':D', name: 'Joyful Smile'),
    Emoticon(symbol: ':-]', name: 'Smiling Face'),
    Emoticon(symbol: ':v)', name: 'Smiling Face'),
    Emoticon(symbol: ':-]', name: 'Grinning Face'),
    Emoticon(symbol: ':~(', name: 'Sad Face'),
    Emoticon(symbol: ':]', name: 'Cheerful Face'),
    Emoticon(symbol: ':-*', name: 'Kiss Face'),
    Emoticon(symbol: ':-<', name: 'Disappointed'),
    Emoticon(symbol: ':o)', name: 'Excited Face'),
    Emoticon(symbol: ':-)', name: 'Joyful'),
    Emoticon(symbol: ':^)', name: 'Cute Smile'),
    Emoticon(symbol: ':-)', name: 'Happy Face'),
    Emoticon(symbol: ':~(', name: 'Crying Face'),
    Emoticon(symbol: ':-*', name: 'Kiss'),
    Emoticon(symbol: ':^)', name: 'Cheeky Grin'),
    Emoticon(symbol: ':~D', name: 'Big Laugh'),
    Emoticon(symbol: ':C', name: 'Sad'),
    Emoticon(symbol: ':-I', name: 'Indifferent'),
    Emoticon(symbol: ':~]', name: 'Happy Face'),
    Emoticon(symbol: ':T', name: 'Tearful'),
    Emoticon(symbol: ':-E', name: 'Vampire Grin'),
    Emoticon(symbol: ':]', name: 'Grinning Face'),
    Emoticon(symbol: ':-[', name: 'Embarrassed Smile'),
    Emoticon(symbol: ':}}', name: 'Very Happy'),
    Emoticon(symbol: ':-/', name: 'Confused'),
    Emoticon(symbol: ':]', name: 'Happy Face'),
    Emoticon(symbol: ':)', name: 'Pleased'),
    Emoticon(symbol: ':^D', name: 'Wide Smile'),
    Emoticon(symbol: ':)', name: 'Content'),
    Emoticon(symbol: ':P', name: 'Tongue Out'),
    Emoticon(symbol: ':O', name: 'Shocked'),
    Emoticon(symbol: ':-}', name: 'Happy Grin'),
    Emoticon(symbol: ':}}', name: 'Beaming Smile'),
    Emoticon(symbol: ':-|', name: 'Straight Face'),
    Emoticon(symbol: ':->', name: 'Sarcastic Smile'),
    Emoticon(symbol: ':#', name: 'Mouth Sealed'),
    Emoticon(symbol: ':-9', name: 'Licking Lips'),
    Emoticon(symbol: ':3', name: 'Cute'),
    Emoticon(symbol: ':-]', name: 'Happy Grin'),
    Emoticon(symbol: ':c)', name: 'Smiling Face'),
    Emoticon(symbol: ':D', name: 'Joyful'),
    Emoticon(symbol: ':o)', name: 'Surprised Smile'),
    Emoticon(symbol: ':v', name: 'Pacman'),
    Emoticon(symbol: ':}', name: 'Satisfied'),
    Emoticon(symbol: ':-]', name: 'Smiling'),
    Emoticon(symbol: ':~)', name: 'Tearful Joy'),
    Emoticon(symbol: ':*)', name: 'Happy'),
    Emoticon(symbol: ':<', name: 'Sad'),
    Emoticon(symbol: ':|', name: 'Blank'),
    Emoticon(symbol: ':c', name: 'Frown'),
    Emoticon(symbol: ':-*', name: 'Blowing Kiss'),
    Emoticon(symbol: ':>', name: 'Happy Grin'),
    Emoticon(symbol: ':-{', name: 'Moustache Smile'),
    Emoticon(symbol: ':)', name: 'Cheerful'),
    Emoticon(symbol: ':-@', name: 'Angry'),
    Emoticon(symbol: ':}', name: 'Content'),
    Emoticon(symbol: ':v', name: 'Pacman Face'),
    Emoticon(symbol: ':p', name: 'Playful'),
    Emoticon(symbol: ':~(', name: 'Crying'),
    Emoticon(symbol: ':^)', name: 'Cheerful Smile'),
    Emoticon(symbol: ':-[', name: 'Embarrassed'),
    Emoticon(symbol: ':)', name: 'Happy Face'),
    Emoticon(symbol: ':-/', name: 'Worried'),
    Emoticon(symbol: ':D', name: 'Big Smile'),
    Emoticon(symbol: ':~)', name: 'Tearful Smile'),
    Emoticon(symbol: ':]', name: 'Smiling'),
    Emoticon(symbol: ':c', name: 'Concerned'),
    Emoticon(symbol: ':o)', name: 'Excited'),
    Emoticon(symbol: ':)', name: 'Joyful'),
    Emoticon(symbol: ':<', name: 'Disappointed'),
    Emoticon(symbol: ':\$', name: 'Embarrassed'),
    Emoticon(symbol: ':-)', name: 'Standard'),
    Emoticon(symbol: ':-D', name: 'Big Smile'),
    Emoticon(symbol: ':v', name: 'Grin'),
    Emoticon(symbol: ':-o', name: 'Surprised'),
    Emoticon(symbol: ':9', name: 'Licking Lips'),
    Emoticon(symbol: ':3', name: 'Cute Smile'),
    Emoticon(symbol: ':D', name: 'Excited'),
    Emoticon(symbol: ':]', name: 'Content Face'),
    Emoticon(symbol: ':<', name: 'Sad Face'),
    Emoticon(symbol: ':|', name: 'Straight'),
    Emoticon(symbol: ':~)', name: 'Happy'),
    Emoticon(symbol: ':-P', name: 'Playful'),
    Emoticon(symbol: ':o', name: 'Surprised'),
    Emoticon(symbol: ':-(', name: 'Sad'),
    Emoticon(symbol: ':~]', name: 'Smiling'),
    Emoticon(symbol: ':>', name: 'Joyful'),
    Emoticon(symbol: ':D', name: 'Happy'),
    Emoticon(symbol: ':c)', name: 'Smiling'),
    Emoticon(symbol: ':-}', name: 'Satisfied'),
    Emoticon(symbol: ':~)', name: 'Cheerful'),
    Emoticon(symbol: ':(', name: 'Frown'),
    Emoticon(symbol: ':P', name: 'Playful'),
    Emoticon(symbol: ':|', name: 'Straight Face'),
    Emoticon(symbol: ':}', name: 'Happy Face'),
    Emoticon(symbol: ':-D', name: 'Excited'),
    Emoticon(symbol: ':oD', name: 'Surprised Laugh'),
    Emoticon(symbol: ':~D', name: 'Joyful'),
    Emoticon(symbol: ':]', name: 'Cheerful'),
    Emoticon(symbol: ':|', name: 'Neutral'),
    Emoticon(symbol: ':-c', name: 'Concerned'),
    Emoticon(symbol: ':^)', name: 'Happy'),
    Emoticon(symbol: ':o)', name: 'Surprised'),
    Emoticon(symbol: ':-]', name: 'Joyful'),
    Emoticon(symbol: ':D', name: 'Big Grin'),
    Emoticon(symbol: ':~(', name: 'Sad'),
    Emoticon(symbol: ':c)', name: 'Happy Face'),
    Emoticon(symbol: '(;-;)', name: 'Tearful'),
    Emoticon(symbol: '(T_T)', name: 'Sad Tears'),
    Emoticon(symbol: '(ToT)', name: 'Bawling'),
    Emoticon(symbol: '(;_;)', name: 'Crying'),
    Emoticon(symbol: '(^_~)', name: 'Wink'),
    Emoticon(symbol: '(^_^;)', name: 'Nervous'),
    Emoticon(symbol: '(^_^)/', name: 'Waving'),
    Emoticon(symbol: '(=_=)', name: 'Tired'),
    Emoticon(symbol: '(^-^*)', name: 'Blushing'),
    Emoticon(symbol: '(^.^)', name: 'Joyful'),
    Emoticon(symbol: '(*^-^*)', name: 'Shy'),
    Emoticon(symbol: '(•ω•)', name: 'Curious'),
    Emoticon(symbol: '(¬_¬")', name: 'Skeptical'),
    Emoticon(symbol: '(^○^)', name: 'Excited'),
    Emoticon(symbol: '(-.-)', name: 'Unimpressed'),
    Emoticon(symbol: '(~_^)', name: 'Wink'),
    Emoticon(symbol: '(˘︹˘)', name: 'Upset'),
    Emoticon(symbol: '(-_-;)', name: 'Worried'),
    Emoticon(symbol: '(^▽^)', name: 'Very Happy'),
    Emoticon(symbol: '(º_º)', name: 'Confused'),
    Emoticon(symbol: '(^ム^)', name: 'Grinning'),
    Emoticon(symbol: '(¯﹃¯)', name: 'Drooling'),
    Emoticon(symbol: '(^ｰ^)', name: 'Pleased'),
  ];
}
