<h1 align="center">Forkify App</h1>
<p align="center">
    <img src="./src/img/favicon.png" alt="Logo" width="15%" height="auto">
 </p>

<p align="center">
  <img src="https://img.shields.io/badge/version-2.0.0-blue.svg?cacheSeconds=2592000" />
  <a href="https://forkify-alamin.netlify.app/" target="_blank">
    <img alt="Demo" src="https://img.shields.io/badge/demo-online-green.svg" />
  </a>
  <a href="https://github.com/CodeWithAlamin/Forkify-Recipe-App#readme" target="_blank">
    <img alt="Documentation" src="https://img.shields.io/badge/documentation-yes-brightgreen.svg" />
  </a>
  <a href="https://github.com/CodeWithAlamin/Forkify-Recipe-App/graphs/commit-activity" target="_blank">
    <img alt="Maintenance" src="https://img.shields.io/badge/maintained-yes-green.svg" />
  </a>
  <a href="https://github.com/CodeWithAlamin/Forkify-Recipe-App/blob/master/LICENSE" target="_blank">
    <img alt="License: MIT" src="https://img.shields.io/badge/License-MIT-yellow.svg" />
  </a>
  <a href="https://twitter.com/CodeWithAlamin" target="_blank">
    <img alt="Twitter: CodeWithAlamin" src="https://img.shields.io/twitter/follow/CodeWithAlamin.svg?style=social" />
  </a>
</p>

<h2 align="center">
Check out the <a href="https://forkify-alamin.netlify.app/" target="_blank">live Forkify App here</a>.
</h2>
<p align="left">
Forkify is a recipe search and saving app, built with HTML5, CSS3, and JavaScript. It features an intuitive user interface and dynamic serving size adjustment. The app uses advanced JavaScript concepts like asynchronous programming, ES6 modules, and object-oriented programming. Forkify was created by Jonas Smechmann in his Udemy course and this app was built as part of a personal project to learn JavaScript.
</p>

## Features

- Search for recipes: Find recipes using keywords or ingredients.
- View recipe details: See ingredients, cooking instructions, and serving size.
- Bookmark recipes: Save your favorite recipes for later.
- Add recipes: Create and share your own recipes.
- Pagination: Easily navigate search results.
- Responsive Design

## Built with

- JavaScript
- CSS3
- HTML5
- Parcel
- NPM

<p align="center">
  <img alt="Forkify App" src="./src/img/forkify-alamin-screenshot.png" width="100%" />
</p>

## Flowchart

<p align="center">
  <img alt="Flowchart" src="./forkify-flowchart-part-3.png" width="100%" />
</p>

## Recipe Loading Architecture

<p align="center">
  <img alt="Recipe Loading Architecture" src="./forkify-architecture-recipe-loading.png" width="100%" />
</p>

## Installation

- Clone this repo:

```sh
git clone https://github.com/CodeWithAlamin/Forkify-Recipe-App.git
```

- Install dependencies:

```sh
npm install
```

- Run the app:

```sh
npm start
```

## Author

<b>👤 Alamin</b>

- LinkedIn - [@CodeWithAlamin](https://www.linkedin.com/in/CodeWithAlamin)
- Twitter - [@CodeWithAlamin](https://www.twitter.com/CodeWithAlamin)
- Frontend Mentor - [@CodeWithAlamin](https://www.frontendmentor.io/profile/CodeWithAlamin)
- Github: [@CodeWithAlamin](https://github.com/CodeWithAlamin)

Feel free to contact me with any questions or feedback!

## Credits

This app was created as part of [Jonas Smechmann](https://twitter.com/jonasschmedtman)'s Udemy course [The Complete JavaScript Course 2023: From Zero to Expert!](https://www.udemy.com/course/the-complete-javascript-course/).

Special thanks to Jonas for his excellent teaching and guidance throughout the course.

## Show your support

Give a ⭐️ if you liked this project!

## License

This project is [MIT](https://github.com/CodeWithAlamin/Forkify-Recipe-App/blob/master/LICENSE) licensed.
