# Contribution Guidelines

Ensure your pull request adheres to the following guidelines:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- If you just created something, wait at least a couple of weeks before submitting.
- Submitted icon fonts should be tested.
- Make an individual pull request for each suggestion.
- Use the following format: `[package](link) - Description.`
- Add (if possible) the suitable legend icon and link them correctly.
- Additions should be added to the bottom of the relevant section.
- New categories, or improvements to the existing categorization are welcome.
- Keep descriptions short and simple, but descriptive.
- Start the description with a capital and end with a full stop/period.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- The pull request should have a useful title and include a link to the icon font and why it should be included.

Thank you for your suggestion!

### Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult.
If the maintainers notice anything that we'd like changed, we'll ask you to edit your PR before we merge it. If you're not sure how to do that, [here is a guide](https://github.com/RichardLitt/docs/blob/master/amending-a-commit-guide.md) on the different ways you can update your PR so that we can merge it.
