# Aprenda Swift

[![Validação de Links](https://github.com/CodandoApple/aprenda-swift/actions/workflows/validation.yml/badge.svg)](https://github.com/CodandoApple/aprenda-swift/actions/workflows/validation.yml)

Esta lista contém diversos links com conteúdos para aprender a desenvolver usando a linguagem Swift. Pela escassez de conteúdo em Português, incluímos conteúdos em inglês na lista. Os conteúdos totalmente em PT-BR estão destacados com a uma tag `[🇧🇷]`.

Caso você tenha interesse em contribuir, fique à vontade para fazer um fork e submeter um PR. Quanto mais conteúdo, melhor 🙂.

## Como contribuir?

Quer saber como contribuir para este projeto? Verifique nosso arquivo [CONTRIBUTING.md](https://github.com/CodandoApple/aprenda-swift/blob/main/CONTRIBUTING.md)

# Sumário

- [Aprenda Swift](#aprenda-swift)
  - [Como contribuir?](#como-contribuir)
- [Sumário](#sumário)
  - [Conteúdos](#conteúdos)
    - [Tutoriais](#tutoriais)
    - [Linguagem](#linguagem)
    - [Arquiteturas](#arquiteturas)
    - [Padrões de Projeto](#padrões-de-projeto)
    - [Interface](#interface)
      - [Geral](#geral)
      - [SwiftUI](#swiftui)
      - [Storyboard](#storyboard)
      - [ViewCode](#viewcode)
      - [UIKit](#uikit)
      - [Animações](#animações)
    - [Networking](#networking)
    - [Gerenciamento de Dependências](#gerenciamento-de-dependências)
    - [Persistência](#persistência)
    - [Reatividade](#reatividade)
    - [Segurança](#segurança)
    - [Acessibilidade](#acessibilidade)
    - [Testes](#testes)
    - [Backend](#backend)
  - [Ferramentas e Recursos](#ferramentas-e-recursos)
    - [Utilidades](#utilidades)
    - [Deploy e CI/CD](#deploy-e-cicd)
  - [Blogs e Plataformas](#blogs-e-plataformas)
  - [Livros](#livros)
  - [Canais no Youtube](#canais-no-youtube)
  - [Playlists no Youtube](#playlists-no-youtube)
  - [Podcasts](#podcasts)
  - [Playgrounds](#playgrounds)
  - [Cursos gratuitos](#cursos-gratuitos)
  - [Cursos pagos](#cursos-pagos)
  - [Roadmaps](#roadmaps)
  - [Comunidades](#comunidades)
  - [Canais no Telegram](#canais-no-telegram)
  - [Instagram](#instagram)
  - [Twitter](#twitter)

## Conteúdos

Esta seção contém links sobre conteúdos específicos relacionados à linguagem Swift e ao ecossistema de desenvolvimento da Apple.

### Tutoriais

- [Como desenvolver seu próprio gerador de senha no iOS - Victor Catão [🇧🇷]](https://medium.com/victorcatao/como-desenvolver-seu-pr%C3%B3prio-gerador-de-senha-no-ios-d538f27236dd)
- [iOS App Dev Tutorials - Apple](https://developer.apple.com/tutorials/app-dev-training)
- [SwifUI Tutorial - Apple](https://developer.apple.com/tutorials/swiftui)
- [🎬 Xcode: Como criar um aplicativo iOS do zero (para iniciantes) - Tiago Aguiar [🇧🇷]](https://www.youtube.com/watch?v=t8JI3Ur51zY)
- [🎬 Como criar um app iOS no Xcode sem Storyboard - DevPoli [🇧🇷]](https://www.youtube.com/watch?v=bXF6KMJFwSE)
- [Criação de Apps para iOS com SWIFT 2023 - Bruno Santos [🇧🇷]](https://www.youtube.com/playlist?list=PL50rZONmv8ZSJ2M6PpPMcOawgE32ke_9_)

### Linguagem

- [Variáveis e Constantes em Swift - ReisDev [🇧🇷]](https://blog.reisdev.com.br/variaveis-e-constantes-em-swift)
- [O que são Classes e Struct, as diferenças e quando usar - Giovanna Moeller [🇧🇷]](https://www.alura.com.br/artigos/ios-swift-classes-struct-diferencas-usar)
- [Uso de Struct e Class em Swift - Amanda Paiva [🇧🇷]](https://medium.com/@amandakpaiva/uso-de-struct-e-class-em-swift-10b2430ad578)
- [Protocolos em Swift: Uma abordagem didática - Caio Santos  [🇧🇷]](https://medium.com/@caio.santos/protolocos-em-swift-uma-abordagem-didática-5f032ec8bc54)
- [Propriedades em Swift - Pedro Menezes [🇧🇷]](https://pt.linkedin.com/pulse/propriedades-em-swift-pedro-menezes-/)
- [Opcionais em Swift: como utilizar? - Giovanna Moeller [🇧🇷]](https://www.alura.com.br/artigos/ios-opcionais-swift)
- [Optional em Swift - ReisDev [🇧🇷]](https://blog.reisdev.com.br/optional-em-swift)
- [Entendendo o uso de Generics: Por quê e como utilizar? - Giovanna Moeller [🇧🇷]](https://www.alura.com.br/artigos/ios-swift-entendendo-uso-generics-por-que-como-utilizar)
- [Entendendo [weak self] no Swift - Jonatan Medina [🇧🇷]](https://medium.com/jonatanm89/entendendo-weak-self-no-swift-2ba061326504)
- [Como funcionam os modificadores de acesso? - Giovanna Moeller [🇧🇷]](https://www.alura.com.br/artigos/ios-swift-como-funcionam-modificadores-de-acesso)
- [Como decodificar JSON em Swift - ReisDev [🇧🇷]](https://blog.reisdev.com.br/como-decodificar-json-em-swift)
- [Conversão de Dados com Codable (Encodable e Decodable) - Giovanna Moeller [🇧🇷]](https://www.alura.com.br/artigos/ios-swift-conversao-dados-codable-encodable-decodable)
- [Decodificando JSON com Swift 4 - Mateus Silva [🇧🇷]](https://mateusfsilvablog.wordpress.com/2018/03/02/decodificando-json-com-swift-4/)
- [Decodificando JSON com Swift 4 (parte 2) - Mateus Silva [🇧🇷]](https://mateusfsilvablog.wordpress.com/2018/03/05/decodificando-json-com-swift-4-parte-2/)
- [Gerenciamento de memória no iOS — weak, strong e unowned - Décio Montanhani [🇧🇷]](https://deciomontanhani.com.br/gerenciamento-de-memoria/)
- [Desmistificando a programação orientada a protocolos - Marcos Lacerda [🇧🇷]](https://medium.com/maclacerda/desmistificando-a-pop-2555d8335fb5)
- [Você sabe o que são Property Wrappers? Parte 1 - Marcos Lacerda [🇧🇷]](https://medium.com/maclacerda/voc%C3%AA-sabe-o-que-s%C3%A3o-property-wrappers-parte-1-60c5f159a063)
- [Você sabe o que são Property Wrappers? Parte 2 - Marcos Lacerda [🇧🇷]](https://medium.com/maclacerda/voc%C3%AA-sabe-o-que-s%C3%A3o-property-wrappers-parte-2-7c32b3a2d63b)
- [Timer — Manipulando o tempo utilizando o Timer(iOS) - Vinicius Mangueira [🇧🇷]](https://medium.com/viniciusmangueira/utilizando-o-timer-de-forma-pr%C3%A1tica-47231aafcb80)
- [Concorrência em iOS: A Teoria por Trás do Grand Central Dispatch - Laura Pinheiro [🇧🇷]](https://lauramarson.medium.com/concorrencia-em-ios-a-teoria-por-tras-do-grand-central-dispatch-38bfd3d8c0fe)
- [Race Condition e Data Race: Criando Classes Threadsafe em Swift - Laura Pinheiro [🇧🇷]](https://lauramarson.medium.com/race-condition-e-data-race-criando-classes-threadsafe-em-swift-e65edcfe8d70)
- [🎬 Automatizando a detecção de vazamento de memória - Comitando [🇧🇷]](https://www.youtube.com/watch?v=Zxo2p1MpkI4)
- [🎬 Swift na prática: Uso de protocolos (Parte 1) - Comitando [🇧🇷]](https://youtu.be/FlB-DPN6TZM)
- [🎬 Swift na prática: Uso de protocolos (Parte 2) - Comitando [🇧🇷]](https://youtu.be/WZVfZ355ez4)
- [🎬 Como trabalhar com Closures - DevPoli [🇧🇷]](https://www.youtube.com/watch?v=Lkv4bYzuH_Y)
- [🎬 Desvendando o ARC do Swift - DevPoli [🇧🇷]](https://www.youtube.com/watch?v=CZbOUMOxtU8)
- [🎬 Struct ou Class, pra que serve? - DevPoli [🇧🇷]](https://www.youtube.com/watch?v=tKSNjg9Cb_g)
- [🎬 Lazy Var e Computed Properties - Qual a diferença? - DevPoli [🇧🇷]](https://www.youtube.com/watch?v=NXNhAAWncT8)

### Arquiteturas

- [As 5 arquiteturas iOS mais utilizadas - Zup [🇧🇷]](https://www.zup.com.br/blog/5-arquiteturas-ios-mais-utilizadas)
- [Principais arquiteturas para aplicações iOS - Objective [🇧🇷]](https://www.objective.com.br/insights/principais-arquiteturas-para-aplicacoes-ios/)
- [Entendendo os padrões de modelagem MVC, MVP e MVVM - ENG [🇧🇷]](https://www.eng.com.br/artigo.cfm?id=6338&post=ios-swift-entendendo-os-padroes-de-modelagem-mvc,-mvp-e-o-mvvm)
- [Qual a melhor arquitetura para aplicações iOS? MVC? - Geraldo Bastos [🇧🇷]](https://medium.com/GeraldoBastos/qual-a-melhor-arquitetura-para-aplicações-ios-mvc-3b436cbcd36b)
- [Qual a melhor arquitetura para aplicações iOS? MVVM? - Geraldo Bastos [🇧🇷]](https://medium.com/GeraldoBastos/parte-2-qual-a-melhor-arquitetura-para-aplicações-ios-mvvm-803f09cbd989)
- [Arquitetura MVVM - Pomo Docs [🇧🇷]](https://unbarqdsw.github.io/2020.1_G6_Pomo/arquitetura-e-reutilizacao/arquitetura/mvvm/)
- [Arquitetura Limpa (CLEAN) - Rayana Prata [🇧🇷]](https://www.linkedin.com/pulse/arquitetura-limpa-rayana-prata)
- [Benefícios mais comuns entre arquiteturas iOS - Yasmin Benatti [🇧🇷]](https://medium.com/ifood-tech/benefícios-mais-comuns-entre-arquiteturas-ios-e295439c4f84)
- [Um estudo comparativo entre padrões arquiteturais para o desenvolvimento de aplicativos para a plataforma iOS - Ícaro Lima [🇧🇷]](https://repositorio.ufpb.br/jspui/bitstream/123456789/15651/1/ILM12122018.pdf)
- [Implementando arquitetura MVP - Comitando [🇧🇷]](https://www.youtube.com/watch?v=8hhxrV19Rr8)
- [iOS Architecture: MVVM-C](https://medium.com/sudo-by-icalia-labs/ios-architecture-mvvm-c-introduction-1-6-815204248518)
- [🎬 (Re)Começando com SwiftUI + MVVM - Cícero Camargo CODEMUS [🇧🇷]](https://www.youtube.com/watch?v=Vn5Wo16TAqU)
- [🎬 Aplicando o padrão de projeto MVC em aplicativos iOS - Developer Academy PUC-Rio [🇧🇷]](https://www.youtube.com/watch?v=ACDWM-49PQw)
- [🎬 Aproximando Arquiteturas do Negócio - Bruno Ramos [🇧🇷]](https://www.youtube.com/watch?v=eXvzhPJEbtM)
- [🎬 Como montar o MVVM no Swift - DevPoli [🇧🇷]](https://www.youtube.com/watch?v=wI2194K99xU)
- [🎬 Migrando tela de MVC para VIP - Comitando [🇧🇷]](https://youtube.com/watch?v=0T2gZWNAX7E)
- [🎬 Aplicando MVVM - Pedro Lagosta [🇧🇷]](https://www.youtube.com/watch?v=kdCkpLqSceI&t=1516s)

### Padrões de Projeto

- [Protocol Delegate em Swift - Cassia Barbosa [🇧🇷]](https://medium.com/mackmobile/protocol-delegate-em-swift-5f521e19ca56)
- [Padrões de Projeto em Swift - Refactoring.Guru [🇧🇷]](https://refactoring.guru/pt-br/design-patterns/swift)
- [Injeção de Dependência - Raúl Ferrer [🇧🇷]](https://ichi.pro/pt/injecao-de-dependencia-em-swift-165262232561857)
- [Um pouco sobre injeção de dependência em iOS - Victor Brito [🇧🇷]](https://victorbritodev.medium.com/um-pouco-sobre-injeção-de-dependência-em-ios-a1b0f536b05c)
- [🎬 Aplicando Delegate Pattern - Pedro Lagosta [🇧🇷]](https://www.youtube.com/watch?v=bGFAcNwN9ps)
- [🎬 Criando Coordinator - Pedro Lagosta [🇧🇷]](https://www.youtube.com/watch?v=iGMJRA0y_3E)
- [🎬 Usando pop, injeção de dependência e Factory - Pedro Lagosta [🇧🇷]](https://www.youtube.com/watch?v=DA8LBPxx9n8)
- [Design Patterns em Swift](https://github.com/ochococo/Design-Patterns-In-Swift)
- [iOS Good Practices](https://github.com/futurice/ios-good-practices)

### Interface

#### Geral

- [Diferenças na construção de layout com Storyboard, XIB e View Code - Alura [🇧🇷]](https://www.alura.com.br/artigos/ios-swift-diferencas-construcao-layouts-storyboard-xib-view-code)
- [🎬 Conhecendo UIView e Constraints no iOS - DevPoli [🇧🇷]](https://www.youtube.com/watch?v=HX38K7fz_Uw)
- [iOS do princípio com Swift: Básico de Auto Layout - Bart Jacobs [🇧🇷]](https://code.tutsplus.com/pt/ios-do-principio-com-swift-basico-de-auto-layout--cms-25520t)

#### SwiftUI

- [SwiftUI irá substituir o Swift? - Cassiane de Freitas [🇧🇷]](https://medium.com/xp-inc/swiftui-irá-substituir-o-swift-5dd45f2b8447)
- [SwiftUI: dicas para quem quer começar a desenvolver - Arthur Givigir [🇧🇷]](https://arthurgivigir.medium.com/swiftui-dicas-para-quem-quer-começar-a-desenvolver-f51f662d5825)
- [Layouts com SwiftUI - Alura [🇧🇷]](https://www.alura.com.br/conteudo/swift-ui)
- [SwiftUI Notes](https://heckj.github.io/swiftui-notes/)
- [🎬 Introdução ao SwiftUI - Construindo aplicativos iOS - Giovanna Moeller [🇧🇷]](https://www.youtube.com/watch?v=4eC49rYeugs)
- [🎬 Introdução Ao SwiftUI - Como Criar O Primeiro Aplicativo [Ponta-a-Ponta] - Irmandade Swift [🇧🇷]](https://www.youtube.com/watch?v=rJWTcNj7rg4)
- [🎬 SwiftUI: Como começar do zero no desenvolvimento iOS moderno - Tiago Aguiar [🇧🇷]](https://www.youtube.com/watch?v=I292IhjRV7k)
- [🎬 Aprenda a criar apps nativos de iPhone no Xcode - Guia Completo: SwiftUI - Irmandade Swift [🇧🇷]](https://www.youtube.com/watch?v=CIGkaLyG-Wg)
- [🎬 SwiftUI para desenvolvedores UIKit - Hugo Silva [🇧🇷]](https://www.youtube.com/playlist?list=PLMIvxX1Jrn8e79pvAHE8onakUzUqpzi16)
- [🎬 SwiftUI: Animações no iOS - Tiago Aguiar [🇧🇷]](https://www.youtube.com/watch?v=k6zgW9yIPCE)
- [🎬 Como Criar Um Aplicativo iOS no Xcode (Super Simples!) - SwiftUI Tutorial - Tiago Aguiar [🇧🇷]](https://www.youtube.com/watch?v=Gt75k60tMjc)
- [Hacking with iOS: SwiftUI Edition](https://www.youtube.com/playlist?list=PLuoeXyslFTuZRi4q4VT6lZKxYbr7so1Mr)

#### Storyboard

- [Desmistificando Storyboards - equinociOS [🇧🇷]](http://equinocios.com/storyboards/2016/03/07/desmistificando-storyboards/)
- [UIKKit, Storyboard e Padrão delegate - Ândriu Felipe [🇧🇷]](https://www.alura.com.br/conteudo/swift-uikit-storyboard)
- [Storyboard - Kodeco](https://www.kodeco.com/5055364-ios-storyboards-getting-started)
- [🎬 Como criar um app iOS usando Storyboard - Developer Academy PUC-Rio [🇧🇷]](https://www.youtube.com/watch?v=hWA1WmjkxJU)

#### ViewCode

- [View Code em Swift - Cassia Barbosa [🇧🇷]](https://medium.com/mackmobile/view-code-em-swift-6026f42bf780)
- [Implementando interfaces iOS em View Code - ioasys-voices [🇧🇷]](https://medium.com/ioasys-voices/implementando-interfaces-ios-em-view-code-325656518f93)
- [Curso iOS: Módulo sobre view code - Thiago Lioy [🇧🇷]](https://medium.com/tpLioy/curso-ios-m%C3%B3dulo-sobre-view-code-af0f6188297b)
- [Com quantas views se faz uma App? - equinociOS [🇧🇷]](http://equinocios.com/view-code/2017/03/18/com-quantas-views-se-faz-um-APP/)
- [Como começar com ViewCode no iOS - João Alexandre [🇧🇷]](https://medium.com/joaoalexandrebitar/começando-com-view-code-no-ios-f409334ff1d)
- [Como criar um app iOS em ViewCode - ReisDev [🇧🇷]](https://blog.reisdev.com.br/como-criar-um-app-ios-em-viewcode)
- [ViewCode + AutoLayout - Kodeco](https://www.kodeco.com/6004856-building-an-app-with-only-code-using-auto-layout)
- [ViewCode + SnapKit - Kodeco](https://www.kodeco.com/3225401-snapkit-for-ios-constraints-in-a-snap)
- [🎬 Como usar o ViewCode sem Storyboard - BackFront Academy [🇧🇷]](https://www.youtube.com/watch?v=_zhI9Nuuw_Y)
- [🎬 Como funciona a UIStackView - DevPoli [🇧🇷]](https://www.youtube.com/watch?v=TXhhjihouTg)
- [🎬 Como criar uma tela usando ViewCode  - Swift para todos [🇧🇷]](https://www.youtube.com/watch?v=iFzTBlRVH6s)
- [🎬 Como criar componentes em Swift usando ViewCode - Swift para todos [🇧🇷]](https://www.youtube.com/watch?v=zSzxFlIumts)

#### UIKit

- [Primeiros passos com UIKit - Tuts+ [🇧🇷]](https://code.tutsplus.com/pt/tutorials/ios-from-scratch-with-swift-first-steps-with-uikit--cms-25461)
- [UIKit: Renderizando componentes no SwiftUI - ioasys-voices [🇧🇷]](https://medium.com/ioasys-voices/uikit-renderizando-componentes-no-swiftui-9ae3619916bf)

#### Animações

- [Melhorando a experiência do seu app com animações — iOS - Leonardo Santos [🇧🇷]](https://leocoout.medium.com/melhorando-a-experi%C3%AAncia-do-seu-app-com-anima%C3%A7%C3%B5es-ios-5c09874b9eb5)
- [🎬 SwiftUI: Animações no iOS - Como começar - Tiago Aguiar [🇧🇷]](https://www.youtube.com/watch?v=k6zgW9yIPCE)

### Networking

- [Async/Await: Camada Network genérica com Swift 5.5 - Victor Catão [🇧🇷]](https://medium.com/victorcatao/async-await-camada-network-gen%C3%A9rica-com-swift-5-5-18aa8f177c9c)
- [Usando Codables em Swift 5 para consumir uma API de filmes - Lucas Fernandez [🇧🇷]](https://medium.com/mackmobile/usando-codables-em-swift-5-para-consumir-uma-api-de-filmes-356534e7e1f0)
- [Como fazer um GET em Swift 4.2 - Gois [🇧🇷]](https://medium.com/mackmobile/como-fazer-um-get-em-swift-4-2-4acc53854241)
- [Consumindo API com SwiftUI - Tamara Erlij [🇧🇷]](https://medium.com/zeroeumas/consumindo-api-com-swiftui-285dd055fb1a)
- [🎬 Buscando dados da API de forma SIMPLES - DevPoli [🇧🇷]](https://www.youtube.com/watch?v=osLMXdyC1mc)
- [🎬 Consumindo dados de uma API em Swift - Pedro Cacique [🇧🇷]](https://www.youtube.com/watch?v=nnBYugt3msA)
- [🎬 Criando camada Service - Pedro Lagosta [🇧🇷]](https://www.youtube.com/watch?v=y48vrEKeRBY)

### Gerenciamento de Dependências

- [Instalação e uso do gerenciador de dependências CocoaPods - Giovanna Moeller [🇧🇷]](https://www.alura.com.br/artigos/ios-swift-instalacao-uso-gerenciador-dependencias-cocoapods)
- [Gerenciadores de dependências iOS - tokenlab [🇧🇷]](https://blog.tokenlab.com.br/gerenciadores-de-dependencias-ios/)
- [Carthage: Um gerenciador de dependências para projetos Xcode - infoq [🇧🇷]](https://www.infoq.com/br/news/2015/07/carthage-dependency-manager/)

### Persistência

- [Aprendendo CoreData com SwiftUI - Academy IFCE + Alley Pereira [🇧🇷]](https://medium.com/academy-ifce/aprendendo-coredata-com-swiftui-90c9d2159714)
- [CoreData - Uma introdução à Persistência em iOS - Guilherme Paciulli [🇧🇷]](https://medium.com/mackmobile/coredata-940c3c61b048)
- [Persistência de dados usando CoreData - equinociOS [🇧🇷]](http://equinocios.com/banco%20de%20dados/2017/03/30/persistencia-de-dados-usando-core-data/)
- [🎬 Como utilizar o UserDefaults - Swift para Todos [🇧🇷]](https://www.youtube.com/watch?v=SvtBgqmqkpQ)

### Reatividade

- [Resumo básico de RxSwift - Hoff Silva [🇧🇷]](https://hoffsilva.medium.com/resumo-b%C3%A1sico-de-rxswift-3703f8318a7f)
- [Swift Combine - Vinicius Mangueira [🇧🇷]](https://medium.com/popcodemobile/swift-combine-6a039fde675f)
- [Comparando RxSwift e Combine - Anthony Gianeli [🇧🇷]](https://medium.com/academy-eldoradocps/comparando-rxswift-com-combine-fce79780b9bf)
- [Como inserir RxSwift + programação funcional naquele seu projeto que está 90% concluído - Bruno Bilescky [🇧🇷]](https://imasters.com.br/banco-de-dados/como-inserir-rxswift-programacao-funcional-naquele-seu-projeto-que-esta-90-concluido)
- [The Ultimate Combine Framework Tutorial in Swift](https://theswiftdev.com/the-ultimate-combine-framework-tutorial-in-swift/)

### Segurança

- [Segurança em dispositivos iOS - Daiane Santos [🇧🇷]](https://wh0isdxk.medium.com/seguran%C3%A7a-em-dispositivos-ios-a422840b71a2)
- [Criptografia para dispositivos iOS - Vinicius Mangueira [🇧🇷]](https://medium.com/viniciusmangueira/criptografia-para-dispositivos-ios-ca840639ee10)
- [Defesas anti-reversão para iOS](https://mobile-security.gitbook.io/mobile-security-testing-guide/ios-testing-guide/0x06j-testing-resiliency-against-reverse-engineering)
- [SSL Pinning - Flawless App Stories](https://medium.com/flawless-app-stories/ssl-pinning-254fa8ca2109)

### Acessibilidade

- [Tornando o seu app acessível por todos no iOS - Gustavo Severo [🇧🇷]](https://medium.com/GusSevero/tornando-o-seu-app-acess%C3%ADvel-por-todos-e93c1aa2ad9d)
- [Voice Over - Acessibilidade em iOS - Renan Germano [🇧🇷]](https://medium.com/mackmobile/voice-over-66e2a051f157)
- [Criando uma solução acessível para o One Time Code - André Salla [🇧🇷]](https://andresalla.com/tutorial-criando-uma-solucao-acessivel-para-o-one-time-code/)
- [Já parou para pensar se seu app é acessível? - iMasters [🇧🇷]](https://imasters.com.br/acessibilidade/ja-parou-para-pensar-se-seu-app-e-acessivel)
- [🎬 Como dar foco no ELEMENTO com ACESSIBILIDADE - BackFront Academy [🇧🇷]](https://www.youtube.com/watch?v=556jop6c2M0)

### Testes

- [iOS Teste Unitário e Teste de UI - Hoff Silva [🇧🇷]](https://hoffsilva.medium.com/ios-teste-unit%C3%A1rio-e-teste-de-ui-tutorial-1360bb66ff73)
- [Escrevendo testes unitários em cenários caóticos: uma abordagem prática - Renato Felício [🇧🇷]](https://engineering.idwall.co/escrevendo-testes-unitarios-em-cenarios-caoticos-uma-abordagem-pratica-e44a2d2d5d85)
- [Escrevendo Testes Unitários para uma ViewController com TableView - Leonardo Cunha [🇧🇷]](https://medium.com/usemobile/escrevendo-testes-unit%C3%A1rios-para-uma-viewcontroller-com-tableview-91ee923de478)
- [Testes unitários em Swift com MVVM - SoftDesign [🇧🇷]](https://softdesign.com.br/blog/testes-unitarios-em-swift-com-mvvm)
- [Testes automatizados com XCTest Framework para teste de app iOS - Amanda Lacerda [🇧🇷]](https://www.linkedin.com/pulse/start-testes-automatizados-com-xctest-framework-para-de-lacerda/?originalSubdomain=pt)
- [Test Doubles em Swift (Ou o isolamento de testes unitários) - Matheus de Vasconcelos [🇧🇷]](https://medium.com/digitalproductsdev/test-doubles-swift-cd43372eb45e)
- [iOS Tests 101 - Yasmin Benatti [🇧🇷]](https://medium.com/ifood-tech/ios-tests-101-c078505e2200)
- [🎬 Automação de testes NATIVA para iOS com XCUITest - qazando [🇧🇷]](https://www.youtube.com/watch?v=-JyD2EMRxVA)
- [🎬 Lidando com FileManager em testes unitários - Comitando [🇧🇷]](https://www.youtube.com/watch?v=0i1y2Kmzkj4)
- [🎬 Escrevendo testes de UI - Comitando [🇧🇷]](https://www.youtube.com/watch?v=E1P2O303aqo)
- [🎬 Criando Testes Unitários - Pedro Lagosta [🇧🇷]](https://www.youtube.com/watch?v=ZZ54oJh1uKI)
- [🎬 Criando Testes Unitários na prática - Pedro Lagosta [🇧🇷]](https://www.youtube.com/watch?v=sQzgW-dWpvU)
- [🎬 [Devpass Talks] Dominando Testes Unitários no iOS (Leonardo Santos) [🇧🇷]](https://www.youtube.com/watch?v=HYwtWibbK5o)

### Backend

- [VAPOR - A new type of web framework](https://vapor.codes/)
- [🎬 Build a RESTAPI in Swift using the Vapor Framework](https://www.youtube.com/watch?v=Xho2OetxXV8&list=PLdmqzFHyjOgS9h5OVmXExKDUHg3ekLkio)
- [🎬 Getting Started with Vapor](https://www.youtube.com/watch?v=CD283bLteP0&list=PLMRqhzcHGw1Z7xNnqS_yUNm1k9dvq-HbM)
- [🎬 Getting Started With Vapor | Server Side Swift](https://www.youtube.com/watch?v=ereSeSQkigM&list=PLyVY0g4EEX5gG5kvwdH4LtjeCzJ0ZEdld)
- [🎬 Server Side Swift Using Vapor Part 1 - Getting Started](https://www.youtube.com/watch?v=2tACpHQeHfI&t=0s)
- [🎬 Vapor New: Урок 1 - Введение, создание проекта, модель продукта, миграция. Backend на Swift | сервер](https://www.youtube.com/watch?v=4B43kB39jQQ&list=PLXnMy9fmMnYDWgvGiZ1K-E5rEffzwrAUe)

## Ferramentas e Recursos

### Utilidades

- [Swift Lint - Vinicius Mangueira [🇧🇷]](https://medium.com/viniciusmangueira/swift-lint-3b869261cf48)
- [Formatação de data - NSDateFormatter](https://nsdateformatter.com/)
- [Linting - SwiftLint](https://realm.github.io/SwiftLint/)

### Deploy e CI/CD

- [Gerando artefatos .ipa com GitHub Actions - Michel Lutz [🇧🇷]](https://micheltlutz.medium.com/gerando-artefatos-ipa-com-github-actions-51088aa5852c)
- [Bitrise](https://bitrise.io)
- [Jenkins](https://www.jenkins.io/)
- [Fastlane](https://fastlane.tools/)
- [Judo - UI orientada a servidor](https://www.judo.app/)

## Blogs e Plataformas

- [Primitive School - beta](https://www.primitive.school/beta)
- [Recreate](https://recreatecode.substack.com)
- [AppCoda](https://www.appcoda.com/ios-programming-course/)
- [Hacking With Swift](https://www.hackingwithswift.com/learn)
- [Kodeco (antigo Raywenderlich)](https://www.kodeco.com/ios/paths)
- [LearnAppMaking](https://learnappmaking.com/)
- [Daily Dose of Swift](https://dailydoseofswift.com)
- [iOS Dev Weekly](https://iosdevweekly.com)
- [Create with Swift](https://createwithswift.com)
- [Awesome iOS](https://awesome-ios.readthedocs.io/en/latest/)
- [The Swift Dev](https://theswiftdev.com/)
- [Holy Swift](https://holyswift.app/)
- [Swift with Majid](https://swiftwithmajid.com/)
- [Swift Senpai](https://swiftsenpai.com/)
- [SerialCoder.dev](https://serialcoder.dev/)
- [Swift by Sundell](https://www.swiftbysundell.com/)
- [WWDC Notes](https://wwdcnotes.com)
- [SwiftLee](https://www.avanderlee.com/)
- [Yet Another Swift Blog](https://www.vadimbulavin.com/)

## Livros

- Desenvolvendo para iPhone e iPad - Ricardo R. Lecheta
- Swift in Depth - Tjeerd in 't Veen
- Mastering Swift 5 - Jon Hoffman
- [Livros Kodeco, vários níveis e tópicos](https://www.kodeco.com/ios/books)
- [Swift Book em Português(em tradução)](https://github.com/AcademyIFCE/Swift-Book)
- [Learn Swift - Aidan Finn](https://www.aidanf.net/learn-swift)

## Canais no Youtube

- [Attekita Dev [🇧🇷]](https://www.youtube.com/channel/UCetRsdZxDQDcgVDJd6erz6g)
- [Back Front Academy [🇧🇷]](https://www.youtube.com/c/BackFrontAcademy)
- [Cícero Camargo CODEMUS [🇧🇷]](https://www.youtube.com/c/C%C3%ADceroCamargoCODEMUS/)
- [CocoaHeadsBR [🇧🇷]](https://www.youtube.com/user/cocoaheadsbr)
- [Codando Com Moa [🇧🇷]](https://www.youtube.com/c/CodandoComMoa)
- [Comitando [🇧🇷]](https://www.youtube.com/channel/UCymNbci2uMFaPz0gZmsDVXw)
- [Developer Academy PUC-Rio [🇧🇷]](https://www.youtube.com/c/DeveloperAcademyPUCRio)
- [Michel Lopes [🇧🇷]](https://www.youtube.com/channel/UC_Z0xQUwA5G06-LZFnmR8MA/)
- [Pedro Lagosta [🇧🇷]](https://www.youtube.com/@pedrolagosta8213)
- [ReisDev [🇧🇷]](https://youtube.com/@ReisDev)
- [Raphael Oliveira [🇧🇷]](https://www.youtube.com/rapholivera)
- [Tiago Aguiar [🇧🇷]](https://www.youtube.com/c/TiagoAguiar/)
- [Thais Sadami [🇧🇷]](https://www.youtube.com/ThaisSadami)
- [Swift para todos [🇧🇷]](https://www.youtube.com/@Swiftparatodos)
- [Credo Academy](https://www.youtube.com/c/CredoAcademy/)
- [Essential Developer](https://www.youtube.com/channel/UCjFr010oOpmlzZNw79f-1fA)
- [iOS Academy](https://www.youtube.com/channel/UCnksRRifsSCGUZpQukUKAyg)
- [Paul Hudson](https://www.youtube.com/c/PaulHudson/)
- [Rebeloper](https://www.youtube.com/channel/UCK88iDIf2V6w68WvC-k7jcg)
- [Sean Allen](https://www.youtube.com/c/SeanAllen)
- [Vincent Pradeilles](https://www.youtube.com/c/VincentPradeilles)
- [Kavsoft](https://www.youtube.com/c/Kavsoft/featured)
- [Stewart Lynch](https://www.youtube.com/c/StewartLynch)
- [Karin Prater](https://www.youtube.com/c/PhysicsNerdDev)

## Playlists no Youtube

- [Curso de Swift - Hugo Vasconcelos [🇧🇷]](https://www.youtube.com/playlist?list=PLxNM4ef1BpxjjMKpcYSqXI4eY4tZG2csm)
- [Aulas de Swift - Bruno Scheltzke [🇧🇷]](https://youtube.com/playlist?list=PLZwVYMtzU9Em9q0vVyneFdqn-4XVl9YBG)
- [Desenvolvimento iOS - Desgourmetizando o conhecimento / Renato Matos [🇧🇷]](https://www.youtube.com/watch?v=q0FAU6_7We0&list=PLEPErUz4EUV-Sy6ZrJjRyMRgKJPs5EGjF)
- [DESENVOLVIMENTO iOS - Tiago Aguiar [🇧🇷]](https://www.youtube.com/playlist?list=PLJ0AcghBBWSghADkQIbw-9I0m9WDOsI3s)
- [Curso de Swift - Programação - Tiago Aguiar [🇧🇷]](https://www.youtube.com/playlist?list=PLJ0AcghBBWShgIH122uw7H9T9-NIaFpP-)
- [iOS Development with Swift Tutorials](https://youtube.com/playlist?list=PL6gx4Cwl9DGDgp7nGSUnnXihbTLFZJ79B)
- [Curso grátis Swift e SwiftUI (stanford 2020)](https://youtube.com/playlist?list=PLMdYygf53DP46rneFgJ7Ab6fJPcMvr8gC)
- [Apple Swift Programming Language Tutorial Series](https://youtube.com/playlist?list=PLfOZCUzRoPfKeOS_pwpiqbdviGcCOcTYb)
- [iOS Course Lectures Spring 2021 - Cornell AppDev](https://youtube.com/playlist?list=PLjf6nsEcF5KOVWRlOPwrJm9X69YtSx_OZ)
- [TUTORIAIS iOS (LEGACY)](https://www.youtube.com/playlist?list=PLJ0AcghBBWSjpnacG8ZD_1pWpU5IJrp2d)

## Podcasts

- [Build Failed Podcast 🇧🇷](https://twitter.com/buildfailedcast)
- [Swift by Sundell](https://www.swiftbysundell.com/podcast)
- [Swift Unwrapped](https://spec.fm/podcasts/swift-unwrapped)
- [Compile Swift](https://compileswift.com/podcast)
- [Contravariance. A Swift Podcast](https://contravariance.rocks)
- [Podcasts GigaHertz](https://gigahertz.fm/podcasts)

## Playgrounds

- [Swift Online Playground](https://swiftfiddle.com)
- [Apple Swift Playgrounds](https://www.apple.com/swift/playgrounds/)

## Cursos gratuitos

- [Swift4Noobs [🇧🇷]](https://github.com/giovannamoeller/swift4noobs)
- [Aprendendo Swift do Iniciante ao Avançado - Udemy [🇧🇷]](https://www.udemy.com/course/aprendendoswift3/)
- [iOS 13 & Swift 5 - Recriando o Tinder 2020 [🇧🇷]](https://www.udemy.com/course/ios-13-swift-5-recriando-o-tinder-2020/)
- [Ensino de Programação - Apple](https://www.apple.com/br/education/k12/teaching-code/)
- [CS193p - Developing Applications for iOS using SwiftUI - Stanford](https://cs193p.sites.stanford.edu/)
- [100 Days of Swift](https://www.hackingwithswift.com/100/swiftui)
- [100 Days of SwiftUI](https://www.hackingwithswift.com/100/swiftui)

## Cursos pagos

- [Curso Carreira iOS - Comitando [🇧🇷]](https://comitando.com.br/)
- [Layouts com SwiftUI - Alura [🇧🇷]](https://www.alura.com.br/curso-online-swift-ui)
- [Curso Completo Desenvolvimento iOS 11 Swift 4 - Eric Brito [🇧🇷]](https://www.udemy.com/course/curso-completo-de-desenvolvimento-ios11swift4/)
- [Desenvolvimento de Aplicativos iOS12 em Swift4 - Rodrigo Guimarães [🇧🇷]](https://www.udemy.com/course/crie-aplicativos-para-iphone-e-ipad-com-ios11-e-swift4/)
- [Swift - TDD, Clean Architecture, Design Patterns, SOLID, MVP - Rodrigo Manguinho [🇧🇷]](https://www.udemy.com/course/swift-tdd-com-mango/)
- [Desenvolvimento IOS 12 - Aprenda a criar 18 Apps - Jamilton Damasceno [🇧🇷]](https://www.udemy.com/course/curso-desenvolvimento-ios/)
- [Desenvolvedor iOS: Prepare-se para o Mercado de Trabalho - Wellignton Bezerra [🇧🇷]](https://www.udemy.com/course/desenvolvimento-ios/)
- [The Complete iOS Development Bootcamp - Udemy](https://www.udemy.com/course/ios-13-app-development-bootcamp/)
- [Do Iniciante ao Avançado em Testes Unitários no iOS](https://www.udemy.com/course/do-iniciante-ao-avancado-em-testes-unitarios-no-ios/)

## Roadmaps

- [A Jornada do Programador iOS - BackFront Academy [🇧🇷]](https://trello.com/b/Vac1uedL/a-jornada-do-programador-ios)
- [Plano de Estudos de Desenvolvimento iOS - Zup Innovation [🇧🇷]](https://insights.zup.com.br/plano-de-estudo-ios)
- [iOS Roadmap - Escalando com Swift [🇧🇷]](https://www.figma.com/file/Z7xk155fdqvKEdjFXNndcE/Escalando-com-Swift---iOS-Roadmap?type=whiteboard&node-id=1-196&t=0aAZNCRhlXRv2zPm-0)
- [Swift Developer Roadmap - Ronan Rodrigo Nunes](https://trello.com/b/hLGyiEEE/swift-developer-roadmap)
- [Mobile Developer Roadmap - Jung Kim](https://github.com/godrm/mobile-developer-roadmap)
- [iOS Developer Skills Matrix - Bohdan Orlov](https://medium.com/ios-os-x-development/find-the-image-and-markdown-version-on-github-fee807255235)
- [iOS Roadmap to Professional Developer](https://www.youtube.com/watch?v=pbhLZMVBlp0)

## Comunidades

- [NSFlow - Telegram](https://t.me/nsflowbr)
- [iOS DevDrops - Telegram](https://t.me/iosdrops)
- [iOS Dev BR - Slack](https://iosdevbr.slack.com/)
- [iOS Brasil - Discord](https://discord.com/invite/tPT3GYAMa6)

## Canais no Telegram

- [iOS dev](https://t.me/iosdevio)

## Instagram

- [CocoaHeads Brasil](https://www.instagram.com/cocoaheadsbr/)
- [Daily Dose of Swift](https://www.instagram.com/dailydoseofswift)
- [DudaDev](https://www.instagram.com/dudadev/?hl=pt-br)
- [Lelê Developer](https://www.instagram.com/leledeveloper)
- [Luiz Mello](https://www.instagram.com/luizmello.dev)
- [Mafê](https://www.instagram.com/mafe_tech)
- [Raphael Oliveira](https://www.instagram.com/rapholivera)
- [ReisDev](https://www.instagram.com/reisdev)
- [Rychillie](https://www.instagram.com/rychillie)
- [Thais Sadami](https://www.instagram.com/thaissadami)

## Twitter

- [Enid](https://twitter.com/ios_dev_alb/)
- [Swift Language](https://twitter.com/SwiftLang)
- [Kavsoft](https://twitter.com/_Kavsoft)
- [Aviel](https://twitter.com/avielgr)
- [Paul Hudson](https://twitter.com/twostraws)
- [Xcode Releases](https://twitter.com/XcodeReleases)
- [Thomas Ricouard](https://twitter.com/Dimillian)
- [Donny Wals](https://twitter.com/DonnyWals)
