# Padrões de Projeto

- [Padrões de Projeto em Swift - Refactoring.Guru](https://refactoring.guru/pt-br/design-patterns/swift)
- [Princípios SOLID para Swift - Yago Vanzan](https://www.linkedin.com/pulse/princ%C3%ADpios-solid-para-swift-criando-c%C3%B3digo-eficiente-e-yago-vanzan/?originalSubdomain=pt)
- [Utilizando o Princípio da Responsabilidade Única em Swift - Amanda Paiva](https://medium.com/@amandakpaiva/utilizando-o-princ%C3%ADpio-da-responsabilidade-%C3%BAnica-em-swift-6b3da3110fcd)
- [Padrão Command - Rodolfo Comparsi](https://medium.com/@rodolfocomparsi96/padr%C3%A3o-command-4e9cc0f43dca)
- [Como o padrão Fixture pode te ajudar na hora de testar suas views em SwiftUI - Bruno Faganello](https://www.youtube.com/watch?v=OKf1RI2g_lQ)
- [🎬 Usando pop, injeção de dependência e Factory - Pedro Lagosta](https://www.youtube.com/watch?v=DA8LBPxx9n8)
- [Design Patterns em Swift [en]](https://github.com/ochococo/Design-Patterns-In-Swift)
- [iOS Good Practices [en]](https://github.com/futurice/ios-good-practices)
  
## Delegate

- [Protocol Delegate em Swift - Cassia Barbosa](https://medium.com/mackmobile/protocol-delegate-em-swift-5f521e19ca56)
- [🎬 Pra que serve o delegate em Swift - DevPoli](https://www.youtube.com/watch?v=IrBaLvYzRLI&pp=ygUbcHJvdG9jb2wgZGVsZWdhdGUgZW0gU1N3aWZ0)
- [🎬 Aplicando Delegate Pattern - Pedro Lagosta](https://www.youtube.com/watch?v=bGFAcNwN9ps)
- [🎬 iOS Delegate: Como funciona e o que é - Tiago Aguiar](https://www.youtube.com/watch?v=E_zpUHk0lVo)
- [🎬 Delegate e Protocol - Tiago Aguiar](https://www.youtube.com/watch?v=BVK1K509nfM&pp=ygUbcHJvdG9jb2wgZGVsZWdhdGUgZW0gU1N3aWZ0)
- [🎬 O que é Delegate, para quê serve e como usar - Swift para todos](https://youtu.be/xBb2KbMk-CA)

## Injeção de dependência

- [Injeção de Dependência - Raúl Ferrer](https://ichi.pro/pt/injecao-de-dependencia-em-swift-165262232561857)
- [Um pouco sobre injeção de dependência em iOS - Victor Brito](https://victorbritodev.medium.com/um-pouco-sobre-injeção-de-dependência-em-ios-a1b0f536b05c)

## Coordinator

- [O que é, para que serve e como usar coordinator em iOS? - Gabriel Batista](https://medium.com/@batistagc/o-que-%C3%A9-para-que-serve-e-como-usar-coordinator-em-ios-4cb310ec1e86)
- [🎬 Criando Coordinator - Pedro Lagosta](https://www.youtube.com/watch?v=iGMJRA0y_3E)




