# Linguagem

- [Como programar em Swift no Linux - ReisDev](https://dev.to/reisdev/como-programar-em-swift-no-linux-52j5)
- [Conhecendo o Swift - Raline Silva](https://medium.com/@ralinesilva1/conhecendo-o-swift-ae7385c37f18)
- [Entendendo value types e reference types em Swift - Victor Martins](https://medium.com/@Visckmart/entendendo-value-types-and-reference-types-em-swift-49e5b27fb6fb)

## Tipos básicos (Bool, Int, Float, Double, String, Array)

- [Entendendo o tipo Booleano (Bool) no Swift: Um mergulho no mundo dos verdadeiros e falsos - Cesar Giupponi](https://www.linkedin.com/pulse/entendendo-o-tipo-booleano-bool-swift-um-mergulho-mundo-giupponi-kjnjf)
- [Trabalhando com números no Swift - Cesar Giupponi](https://www.linkedin.com/pulse/trabalhando-com-n%C3%BAmeros-swift-cesar-giupponi-chaee)
- [Strings e Caracteres no Swift: Tudo o que você precisa saber - Cesar Giupponi](https://www.linkedin.com/pulse/strings-e-caracteres-swift-tudo-o-que-voc%C3%AA-precisa-saber-giupponi-zj6sf)
- [Arrays em Swift - André Porto](https://www.linkedin.com/pulse/arrays-em-swift-andr%2525C3%2525A9-porto)
- [Entendendo Arrays no Swift: Tudo o que você precisa saber - Cesar Giupponi](https://www.linkedin.com/pulse/entendendo-arrays-swift-tudo-o-que-voc%C3%AA-precisa-saber-cesar-giupponi-hj1wf)
- [Porque priorizar Collection.isEmpty em vez de Collection.count - Jonatan Medina](https://medium.com/@jonatanm89/porque-priorizar-collection-isempty-em-vez-de-collection-count-em-swift-f974874e4f54)
- [O que é Inferência de Tipo no Swift? - Cesar Giupponi](https://www.linkedin.com/pulse/o-que-%25C3%25A9-infer%25C3%25AAncia-de-tipo-swift-cesar-giupponi-vkncf)

## Enumerações, Tuplas e Dicionários

- [O que é uma Tupla no Swift? - Cesar Giupponi](https://www.linkedin.com/pulse/o-que-%C3%A9-uma-tupla-swift-cesar-giupponi-c6i2f/)
- [O que é um enumerador (enum) no Swift? - Cesar Giupponi](https://www.linkedin.com/pulse/o-que-%C3%A9-um-enumerador-enum-swift-cesar-giupponi-4mdbf/)

## Variáveis, Constantes e Propriedades

- [Variáveis e Constantes em Swift - ReisDev](https://blog.reisdev.com.br/variaveis-e-constantes-em-swift)
- [Tipos de Declaração de Variáveis no Swift - Cesar Giupponi](https://www.linkedin.com/pulse/tipos-de-declara%25C3%25A7%25C3%25A3o-vari%25C3%25A1veis-swift-cesar-giupponi-xfbcf)
- [Variáveis locais e globais no Swift: como e quando usar? - Cesar Giupponi](https://www.linkedin.com/pulse/vari%25C3%25A1veis-locais-e-globais-swift-como-quando-usar-cesar-giupponi-8cn7f)
- [Propriedades em Swift - Pedro Menezes](https://pt.linkedin.com/pulse/propriedades-em-swift-pedro-menezes-/)
- [Propriedades de tipo (static/class) no Swift - Cesar Giupponi](https://www.linkedin.com/pulse/propriedades-de-tipo-staticclass-swift-cesar-giupponi-gk8nf)
- [Getters e Setters em Swift - Cesar Giupponi](https://www.linkedin.com/pulse/getters-e-setters-em-swift-cesar-giupponi-lynrf)
- [Além dos getters e setters: Mergulhe no mundo das propriedades computadas no Swift - Cesar Giupponi](https://www.linkedin.com/pulse/al%25C3%25A9m-dos-getters-e-setters-mergulhe-mundo-das-swift-cesar-giupponi-7rm4f)
- [O que são propriedades observáveis (willSet e didSet) no Swift? - Cesar Giupponi](https://www.linkedin.com/pulse/o-que-s%C3%A3o-propriedades-observ%C3%A1veis-willset-e-didset-swift-giupponi-smntf)
- [🎬 O que são variáveis? - Swift para todos](https://www.youtube.com/watch?v=SEUlKKAQMJc)
- [🎬 Lazy Var e Computed Properties - Qual a diferença? - DevPoli](https://www.youtube.com/watch?v=NXNhAAWncT8)
- [🎬 Como as static var e extensions podem melhorar a qualidade e leitura do seu código em Swift - Bruno Faganello](https://www.youtube.com/watch?v=wv3sTmfYzCI)

## Structs e Classes

- [O que são Classes e Struct, as diferenças e quando usar - Giovanna Moeller](https://www.alura.com.br/artigos/ios-swift-classes-struct-diferencas-usar)
- [Classes vs. Structs no Swift: Qual utilizar, e quando? - André Porto](https://medium.com/@andremporto/classes-vs-structs-no-swift-qual-utilizar-e-quando-c26af7bb1da7)
- [Uso de Struct e Class em Swift - Amanda Paiva](https://medium.com/@amandakpaiva/uso-de-struct-e-class-em-swift-10b2430ad578)
- [Como funcionam os modificadores de acesso? - Giovanna Moeller](https://www.alura.com.br/artigos/ios-swift-como-funcionam-modificadores-de-acesso)
- [Níveis de Controle de Acesso no Swift - Cesar Giupponi](https://www.linkedin.com/pulse/n%25C3%25ADveis-de-controle-acesso-swift-cesar-giupponi-b0f8f)
- [Você sabe o que são Property Wrappers? Parte 1 - Marcos Lacerda](https://medium.com/maclacerda/voc%C3%AA-sabe-o-que-s%C3%A3o-property-wrappers-parte-1-60c5f159a063)
- [Você sabe o que são Property Wrappers? Parte 2 - Marcos Lacerda](https://medium.com/maclacerda/voc%C3%AA-sabe-o-que-s%C3%A3o-property-wrappers-parte-2-7c32b3a2d63b)
- [Property Wrappers em Swift - André Porto](https://www.linkedin.com/pulse/property-wrappers-em-swift-andr%2525C3%2525A9-porto-crcze)
- [Introdução à Herança em Swift - André Porto](https://medium.com/@andremporto/introdu%C3%A7%C3%A3o-%C3%A0-heran%C3%A7a-em-swift-75ece8a815ff)
- [Swift — Self vs self - Jonatan Medina](https://medium.com/@jonatanm89/swift-self-vs-self-90c9b4b35755)
- [🎬 Struct ou Class, pra que serve? - DevPoli](https://www.youtube.com/watch?v=tKSNjg9Cb_g)

## Funções e Closures

- [Parâmetros de Funções e Valores de Retorno no Swift: Entenda como eles funcionam! - Cesar Giupponi](https://www.linkedin.com/pulse/par%25C3%25A2metros-de-fun%25C3%25A7%25C3%25B5es-e-valores-retorno-swift-entenda-cesar-giupponi-umkre)
- [Como Capturar e Validar Entradas de Dados do Usuário em Swift com readLine(), if let, guard let, exit(1) e fatalError() - Thyago Raphael](https://www.linkedin.com/pulse/como-capturar-e-validar-entradas-de-dados-do-usu%C3%A1rio-em-raphael-dthff)
- [🎬 O que são funções? - Swift para todos](https://www.youtube.com/watch?v=9YxIVRmqTss)
- [🎬 Como trabalhar com Closures - DevPoli](https://www.youtube.com/watch?v=Lkv4bYzuH_Y)

## Optional

- [Optional em Swift - ReisDev](https://blog.reisdev.com.br/optional-em-swift)
- [Opcionais em Swift: como utilizar? - Giovanna Moeller](https://www.alura.com.br/artigos/ios-opcionais-swift)
- [Entendendo o uso de Generics: Por quê e como utilizar? - Giovanna Moeller](https://www.alura.com.br/artigos/ios-swift-entendendo-uso-generics-por-que-como-utilizar)
- [Entendendo [weak self] no Swift - Jonatan Medina](https://medium.com/jonatanm89/entendendo-weak-self-no-swift-2ba061326504)
- [Opcionais em Swift: Lidando com Valores Possivelmente Nulos - Sarah Silva](https://medium.com/@sarahfrontdev/opcionais-em-swift-lidando-com-valores-possivelmente-nulos-82e22efc534f)

## Protocolos

- [Entendendo a Programação Orientada a Protocolos em Swift - DIO](https://www.dio.me/articles/entendendo-a-programacao-orientada-a-protocolos-em-swift)
- [Protocolos em Swift: Quando e como utilizar - Guilherme Trevisan](https://dev.to/guilhermetrevisan/protocolos-em-swift-quando-e-como-utilizar-549)
- [Programação Orientada a Protocolos (POP) em Swift - Paula Vaz](https://medium.com/@paula_vaz/programa%C3%A7%C3%A3o-orientada-a-protocolos-pop-em-swift-b80caa290403)
- [Desmistificando a programação orientada a protocolos - Marcos Lacerda](https://medium.com/maclacerda/desmistificando-a-pop-2555d8335fb5)
- [Swift from Scratch: Herança e protocolos - Tuts+](https://code.tutsplus.com/pt/swift-from-scratch-heranca-e-protocolos--cms-23334t)
- [Programação orientada a protocolo em Swift 2 - Tuts+](https://code.tutsplus.com/pt/swift-from-scratch-heranca-e-protocolos--cms-23334t)
- [Swift: Extendendo Protocolos - RedSpark](https://www.redspark.io/swift-extendendo-protocolos/)
- [Programação Orientada a Protocolo - equinociOS](http://equinocios.com/ios/2016/03/16/protocol-oriented-programming/)
- [POP: Programação Orientada a Protocolo - Sobrinho de TI](https://www.youtube.com/watch?v=Dxo3a6b1RB4)
- [Protolocos em Swift: Uma abordagem didática - Caio Santos](https://medium.com/@caio.santos/protolocos-em-swift-uma-abordagem-did%C3%A1tica-5f032ec8bc54)
- [Entenda o que Protocolos e o Caribe têm em comum - Diego Ferreira](https://www.devpoli.com/post/entenda-o-que-protocols-e-o-caribe-t%C3%AAm-em-comum)
- [🎬 Swift na prática: Uso de protocolos (Parte 1) - Comitando](https://youtu.be/FlB-DPN6TZM)
- [🎬 Swift na prática: Uso de protocolos (Parte 2) - Comitando](https://youtu.be/WZVfZ355ez4)
- [🎬 Como implementar um protocol em Swift - DevPoli](https://www.youtube.com/watch?v=mnr_fZzgQaA)
- [🎬 Como criar um método opcional em um protocolo com Swift - BackFront Academy](https://www.youtube.com/watch?v=QJ9YTKZR1JQ)

## Codable e JSON

- [Como decodificar JSON em Swift - ReisDev](https://blog.reisdev.com.br/como-decodificar-json-em-swift)
- [Conversão de Dados com Codable (Encodable e Decodable) - Giovanna Moeller](https://www.alura.com.br/artigos/ios-swift-conversao-dados-codable-encodable-decodable)
- [Decodificando JSON com Swift 4 - Mateus Silva](https://mateusfsilvablog.wordpress.com/2018/03/02/decodificando-json-com-swift-4/)
- [Decodificando JSON com Swift 4 (parte 2) - Mateus Silva](https://mateusfsilvablog.wordpress.com/2018/03/05/decodificando-json-com-swift-4-parte-2/)
- [Gerenciamento de memória no iOS — weak, strong e unowned - Décio Montanhani](https://deciomontanhani.com.br/gerenciamento-de-memoria/)

## Concorrência

- [Concorrência em iOS: A Teoria por Trás do Grand Central Dispatch - Laura Pinheiro](https://lauramarson.medium.com/concorrencia-em-ios-a-teoria-por-tras-do-grand-central-dispatch-38bfd3d8c0fe)
- [Race Condition e Data Race: Criando Classes Threadsafe em Swift - Laura Pinheiro](https://lauramarson.medium.com/race-condition-e-data-race-criando-classes-threadsafe-em-swift-e65edcfe8d70)
- [Concorrência em Swift - Brenno](https://onnerb.medium.com/concorr%C3%AAncia-no-swift-94fea4510b55)
  
## Gerenciamento de Memória e ARC

- [weak self, escaping coluses e capture list - Fernando Luiz Goulart](https://fegoulart.medium.com/weak-self-e-otras-cositas-m%C3%A1s-1cf557f49805)
- [Analisando problemas de memory leak - Vinicius Mesquita](https://www.linkedin.com/pulse/analisando-problemas-de-memory-leak-ios-pt1-vinicius-mesquita%3FtrackingId=MGCZ9vjyS9q1QuG1nK76fQ%253D%253D/)
- [🎬 Automatizando a detecção de vazamento de memória - Comitando](https://www.youtube.com/watch?v=Zxo2p1MpkI4)
- [🎬 Desvendando o ARC do Swift - DevPoli](https://www.youtube.com/watch?v=CZbOUMOxtU8)
- [🎬 Mentoria - Gerenciamento de Memória no iOS - Parte 1 (Memória Dinâmica) - Marcelo Costa](https://www.youtube.com/watch?v=kQXW9lGyLzA)
- [🎬 Stack vs Heap - Gerenciamento de Memória no iOS - Extra 1 - Marcelo Costa](https://www.youtube.com/watch?v=GvN7zE0LGMc)

## Timer

- [Timer — Manipulando o tempo utilizando o Timer(iOS) - Vinicius Mangueira](https://medium.com/viniciusmangueira/utilizando-o-timer-de-forma-pr%C3%A1tica-47231aafcb80)
