# Arquiteturas

- [As 5 arquiteturas iOS mais utilizadas - Zup](https://www.zup.com.br/blog/5-arquiteturas-ios-mais-utilizadas)
- [Principais arquiteturas para aplicações iOS - Objective](https://www.objective.com.br/insights/principais-arquiteturas-para-aplicacoes-ios/)
- [Principais Arquiteturas de Software e sua importância para o desenvolvimento - André Porto](https://medium.com/@andremporto/principais-arquiteturas-de-software-e-sua-import%C3%A2ncia-para-o-desenvolvimento-6501acd3be5f)
- [Entendendo os padrões de modelagem MVC, MVP e MVVM - ENG](https://www.eng.com.br/artigo.cfm?id=6338&post=ios-swift-entendendo-os-padroes-de-modelagem-mvc,-mvp-e-o-mvvm)
- [Benefícios mais comuns entre arquiteturas iOS - Yasmin Benatti](https://medium.com/ifood-tech/benefícios-mais-comuns-entre-arquiteturas-ios-e295439c4f84)
- [Um estudo comparativo entre padrões arquiteturais para o desenvolvimento de aplicativos para a plataforma iOS - Ícaro Lima](https://repositorio.ufpb.br/jspui/bitstream/123456789/15651/1/ILM12122018.pdf)
- [🎬 Aproximando Arquiteturas do Negócio - Bruno Ramos](https://www.youtube.com/watch?v=eXvzhPJEbtM)

## MVC

- [Qual a melhor arquitetura para aplicações iOS? MVC? - Geraldo Bastos](https://medium.com/GeraldoBastos/qual-a-melhor-arquitetura-para-aplicações-ios-mvc-3b436cbcd36b)
- [🎬 Aplicando o padrão de projeto MVC em aplicativos iOS - Developer Academy PUC-Rio](https://www.youtube.com/watch?v=ACDWM-49PQw)

# MVVM

- [Qual a melhor arquitetura para aplicações iOS? MVVM? - Geraldo Bastos](https://medium.com/GeraldoBastos/parte-2-qual-a-melhor-arquitetura-para-aplicações-ios-mvvm-803f09cbd989)
- [MVVM-C em ViewCode - Michelli Cristina](https://medium.com/@mihcristina/mvvm-c-em-view-code-swift-83ac0623653f)
- [Arquitetura MVVM - Pomo Docs](https://unbarqdsw.github.io/2020.1_G6_Pomo/arquitetura-e-reutilizacao/arquitetura/mvvm/)
- [iOS Architecture: MVVM-C [en]](https://medium.com/sudo-by-icalia-labs/ios-architecture-mvvm-c-introduction-1-6-815204248518)
- [SwiftUI MVVM-C Template - Gustavo Alencar Silva](https://github.com/gustavoalens/SwiftUI_MVVM-C_Template)
- [🎬 (Re)Começando com SwiftUI + MVVM - Cícero Camargo CODEMUS](https://www.youtube.com/watch?v=Vn5Wo16TAqU)
- [🎬 Como montar o MVVM no Swift - DevPoli](https://www.youtube.com/watch?v=wI2194K99xU)
- [🎬 Aplicando MVVM - Pedro Lagosta](https://www.youtube.com/watch?v=kdCkpLqSceI&t=1516s)

## VIP/VIPER/CLEAN

- [Arquitetura Limpa (CLEAN) - Rayana Prata](https://www.linkedin.com/pulse/arquitetura-limpa-rayana-prata)
- [Arquitetura iOS: VIP - Fabio Miciano](https://medium.com/@fabio.miciano/arquitetura-ios-vip-4b95f9a0faaa)
- [Clean Swift (VIP): Como organizar melhor nossos códigos - Leonardo de Geus](https://leodegeus.medium.com/clean-swift-vip-como-organizar-melhor-nossos-c%C3%B3digos-f06762fc5cc2)
- [🎬 Aplicando Clean Code - Pedro Lagosta](https://www.youtube.com/watch?v=-vsbP44MCGs)
- [🎬 Migrando tela de MVC para VIP - Comitando](https://youtube.com/watch?v=0T2gZWNAX7E)
- [🎬 Refatorando MVVM para VIP - Pedro Lagosta](https://www.youtube.com/watch?v=t26H9kCjyAg)
- [🎬 Explicando a ARQUITETURA LIMPA! Como implementar o VIP? - Attekita Dev](https://www.youtube.com/watch?v=4IeEflzhl6A)

## MVP

- [iOS MVP-C Modularizado - Brenno](https://onnerb.medium.com/ios-mvp-c-modularizado-491e4ef66790)
- [🎬 Implementando arquitetura MVP - Comitando](https://www.youtube.com/watch?v=8hhxrV19Rr8)

