<?php

if (!defined('ROOT')) exit('Can\'t Access !');

class questionconfig extends table {
    public $name='question_config';
    static $me;
    public static function getInstance() {
        if (!self::$me) {
            $class=new questionconfig();
            self::$me=$class;
        }
        return self::$me;
    }

    function getcols($act) {
        return '*';
    }

    function get_form() {
        return array(
            'question_open'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'question_vip'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'reply_vip'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'question_admin_see'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'question_vip_see'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'question_reply_hf'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'question_reply_pl'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'question_edit'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(array(1=>'1小时',2=>'2小时',24=>'一天',72=>'三天',120=>'五天',9999=>'永久')),
            ),
            'question_edit_reply'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(array(1=>'1小时',2=>'2小时',24=>'一天',72=>'三天',120=>'五天',9999=>'永久')),
            ),
            'andswer_audit'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'reply_audit'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
                'default'=>0,
            ),
            'question_verifycode'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(array(0=>'关',1=>'字符',2=>'拼图')),
            ),
            'reply_verifycode'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(array(0=>'关',1=>'字符',2=>'拼图')),
            ),
             'question_index'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(array(1=>'问答首页',2=>'专题首页',3=>'热门首页')),
                'default'=>1,
            ),
            'question_audit'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
                'default'=>0,
            ),
            'urlrewrite_on'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'checkbox-inline'=>array(
                'selecttype'=>'radio',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
            ),
            'add_question_time'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(array(10=>'10分钟',30=>'30分钟',60=>'一小时',0=>'不限制')),
            ),


        );
    }

    static function get_all_config(){
        $configdata=array();
        $questionconfigdata = questionconfig::getInstance()->getrows(null,0,'id asc'); //获取配置
        if (is_array($questionconfigdata))
            foreach ($questionconfigdata as $key=>$val){
                $configdata[$val['name']]=$val['value'];
            }

        //校验安全码
        $configdata['user_crossall_state']=1;
        if ($configdata['user_crossall'] && $configdata['crossall_safetycode'] ){
            $user_get_crossall=session::get("user_get_crossall");
            if ($user_get_crossall=="" || $user_get_crossall['user_crossall']!=$configdata['user_crossall']){
                $url=$configdata['user_crossall']."/index.php?case=crossall&act=safetycode&cookie_password=".$configdata['crossall_safetycode'];
                $data= service::cmseayurl($url);
                $data=json_decode($data, true);

                $user_get_crossall['data']=$data;
                $user_get_crossall['user_crossall']=$configdata['user_crossall'];
                session::set("user_get_crossall",$user_get_crossall);
            }else{
                $data=$user_get_crossall['data'];
            }

            if ($data['state']){
                $configdata['user_crossall_state']=1;
            }else{
                $configdata['user_crossall_state']=0;
            }
        }else{
            $configdata['user_crossall_state']=0;
        }
        return $configdata;
    }
}