DROP TABLE IF EXISTS `cmseasy_announcement`;-- 
CREATE TABLE `cmseasy_announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `content` mediumtext NOT NULL,
  `adddate` datetime DEFAULT NULL,
  `state` tinyint(2) DEFAULT '1',
  `langid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_apps`;-- 
CREATE TABLE `cmseasy_apps` (
  `id` varchar(200) NOT NULL COMMENT '文件夹名称',
  `name` varchar(50) NOT NULL COMMENT '插件名称',
  `version` varchar(20) NOT NULL COMMENT '插件版本',
  `desc` varchar(200) DEFAULT NULL COMMENT '插件说明',
  `installed` int(1) NOT NULL DEFAULT '0' COMMENT '安装状态',
  `admin_url` varchar(200) DEFAULT NULL COMMENT '插件安装后跳转路径',
  `iscorp` int(1) NOT NULL DEFAULT '0' COMMENT '是否商业版',
  `icon` varchar(200) DEFAULT NULL COMMENT '插件图标',
  `static` int(1) NOT NULL DEFAULT '0' COMMENT '显示状态',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '插件单价',
  `isbuy` int(1) DEFAULT '0' COMMENT '是否支付',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 


DROP TABLE IF EXISTS `cmseasy_cash`;-- 
CREATE TABLE `cmseasy_cash` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '申请提现ID',
  `menoy` decimal(10,2) DEFAULT '0.00' COMMENT '提现金额',
  `uid` int(10) NOT NULL COMMENT '申请用户',
  `adddate` datetime NOT NULL COMMENT '申请时间',
  `number` varchar(50) NOT NULL COMMENT '收款账号',
  `type` int(1) NOT NULL DEFAULT '1' COMMENT '1/支付宝2/微信3/贝宝4/财付通',
  `contact` varchar(100) DEFAULT NULL COMMENT '联系方式',
  `tel` varchar(50) DEFAULT NULL COMMENT '手机',
  `qq` varchar(20) DEFAULT NULL COMMENT 'qq',
  `e_mail` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `message` varchar(100) DEFAULT NULL COMMENT '提现备注',
  `state` int(1) NOT NULL DEFAULT '0' COMMENT '状态 0/申请中1/审核成功2/审核失败',
  `returncon` varchar(100) DEFAULT NULL COMMENT '审核失败原因',
  `user_crossall` varchar(50) DEFAULT '' COMMENT '跨域',
  `langid` int(10) NOT NULL DEFAULT '1' COMMENT '语言',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;-- 

DROP TABLE IF EXISTS `cmseasy_consumption`;-- 
CREATE TABLE `cmseasy_consumption` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oid` varchar(100) NOT NULL COMMENT '订单号',
  `menoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `adddate` datetime DEFAULT NULL COMMENT '新增日期',
  `status` int(3) NOT NULL DEFAULT '0',
  `s_status` tinyint(1) NOT NULL DEFAULT '0',
  `trade_no` varchar(255) NOT NULL DEFAULT '' COMMENT '支付编号',
  `mid` int(11) NOT NULL COMMENT '用户id',
  `user_crossall` varchar(50) DEFAULT '' COMMENT '跨域',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_event`;-- 
CREATE TABLE `cmseasy_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `addtime` int(11) DEFAULT NULL,
  `event` varchar(30) DEFAULT NULL,
  `note` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `user` (`uid`,`username`,`ip`),
  KEY `time` (`addtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_friendlink`;-- 
CREATE TABLE `cmseasy_friendlink` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `linktype` tinyint(2) DEFAULT NULL,
  `typeid` tinyint(2) DEFAULT NULL,
  `name` varchar(60) NOT NULL,
  `listorder` int(11) DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `introduce` text,
  `uid` int(11) DEFAULT NULL,
  `username` varchar(60) DEFAULT NULL,
  `adddate` datetime DEFAULT NULL,
  `hits` int(11) DEFAULT NULL,
  `state` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_lang`;-- 
CREATE TABLE `cmseasy_lang` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `listorder` int(11) DEFAULT '0' COMMENT '排序',
  `langurlname` varchar(20) NOT NULL COMMENT '语言文件夹名称  唯一',
  `langname` varchar(50) DEFAULT NULL COMMENT '语言名称',
  `langimg` varchar(255) DEFAULT NULL COMMENT '图标',
  `static` tinyint(1) DEFAULT '1' COMMENT '语言状态',
  `isdefault` tinyint(1) DEFAULT '0' COMMENT '默认语言  第二个开其他就关',
  `domain` varchar(255) DEFAULT NULL COMMENT '域名',
  `istemplate` tinyint(1) NOT NULL DEFAULT '0',
  `isadmin` tinyint(1) NOT NULL DEFAULT '0',
  `adminlangid` int(11) DEFAULT '0' COMMENT '后台语言设置ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_notification`;-- 
CREATE TABLE `cmseasy_notification` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '通知表ID',
  `userid` varchar(50) DEFAULT NULL COMMENT '通知用户ID',
  `title` varchar(100) NOT NULL COMMENT '通知标题',
  `note` varchar(255) NOT NULL COMMENT '通知内容',
  `titleurl` varchar(255) DEFAULT NULL COMMENT '通知跳转的链接',
  `adddatatime` datetime NOT NULL COMMENT '通知时间',
  `static` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 

DROP TABLE IF EXISTS `cmseasy_p_ologin`;-- 
CREATE TABLE `cmseasy_p_ologin` (
  `ologin_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `ologin_code` varchar(20) NOT NULL DEFAULT '',
  `ologin_name` varchar(120) NOT NULL DEFAULT '',
  `ologin_desc` text NOT NULL,
  `ologin_config` text NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ologin_id`),
  UNIQUE KEY `ologin_code` (`ologin_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_p_pay`;-- 
CREATE TABLE `cmseasy_p_pay` (
  `pay_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `pay_code` varchar(20) NOT NULL DEFAULT '',
  `pay_name` varchar(120) NOT NULL DEFAULT '',
  `pay_image` varchar(255) DEFAULT NULL,
  `pay_fee` varchar(10) NOT NULL DEFAULT '0',
  `pay_desc` text NOT NULL,
  `pay_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pay_config` text NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `langid` int(11) DEFAULT NULL,
  PRIMARY KEY (`pay_id`),
  UNIQUE KEY `pay_code` (`pay_code`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_question`;-- 
CREATE TABLE `cmseasy_question` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '问答表ID',
  `title` varchar(50) NOT NULL COMMENT '标题',
  `typeid` int(1) NOT NULL COMMENT '类型表id',
  `tag` varchar(50) DEFAULT '0' COMMENT 'tag的id',
  `content` mediumtext COMMENT '问题',
  `adddate` datetime DEFAULT NULL COMMENT '新增时间',
  `updatedate` datetime DEFAULT NULL COMMENT '编辑时间',
  `rewardmenoy` decimal(10,2) DEFAULT '0.00' COMMENT '悬赏金额',
  `uid` int(10) NOT NULL COMMENT '用户id',
  `browsenum` int(10) NOT NULL DEFAULT '0' COMMENT '浏览数',
  `seemid` varchar(50) DEFAULT NULL COMMENT '关注用户',
  `isadminsee` int(1) NOT NULL DEFAULT '0' COMMENT '仅管理员可见',
  `ip` varchar(50) DEFAULT NULL COMMENT '发布问题用户IP',
  `usergroupid` int(10) NOT NULL DEFAULT '0' COMMENT '用户组权限',
  `langid` int(10) NOT NULL COMMENT '语言',
  `state` int(1) NOT NULL DEFAULT '0' COMMENT '0/草稿1/发布2/待审核3/审核失败4/关闭',
  `returncon` varchar(100) DEFAULT NULL COMMENT '审核失败原因',
  `user_crossall` varchar(50) DEFAULT '' COMMENT '跨域',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_question_config`;-- 
CREATE TABLE `cmseasy_question_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT 'config名称',
  `value` varchar(255) DEFAULT NULL COMMENT 'config值',
  `showname` varchar(59) NOT NULL COMMENT '显示名称',
  PRIMARY KEY (`id`,`name`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;-- 

DROP TABLE IF EXISTS `cmseasy_question_foot`;-- 
CREATE TABLE `cmseasy_question_foot` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '问答页底id',
  `footname` varchar(50) NOT NULL COMMENT '页底名称',
  `footurl` varchar(100) NOT NULL COMMENT '跳转地址',
  `isblank` int(1) NOT NULL DEFAULT '0' COMMENT '是否新窗口打开',
  `langid` int(10) NOT NULL DEFAULT '1' COMMENT '语言ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_question_head`;-- 
CREATE TABLE `cmseasy_question_head` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `headname` varchar(50) NOT NULL COMMENT '导航名称',
  `headurl` varchar(100) NOT NULL COMMENT '跳转链接',
  `isblank` int(1) NOT NULL DEFAULT '0' COMMENT '是否新窗口打开',
  `langid` int(10) NOT NULL DEFAULT '1' COMMENT '语言ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_question_like`;-- 
CREATE TABLE `cmseasy_question_like` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `rid` int(10) DEFAULT NULL COMMENT '评论表ID',
  `mid` int(10) NOT NULL COMMENT '点赞用户',
  `adddate` datetime DEFAULT NULL COMMENT '点赞时间',
  `aid` int(10) DEFAULT NULL COMMENT '问答表ID',
  `type` int(1) NOT NULL DEFAULT '1' COMMENT '点赞类型 1/评论2/问答',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_question_message`;-- 
CREATE TABLE `cmseasy_question_message` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '消息表ID',
  `title` varchar(50) NOT NULL COMMENT '通知标题',
  `content` varchar(255) DEFAULT NULL COMMENT '通知内容',
  `adddate` datetime DEFAULT NULL COMMENT '通知时间',
  `type` int(1) NOT NULL DEFAULT '2' COMMENT '1充值2回复记录3采纳记录4打赏5悬赏6关注问题回复7关注采纳',
  `aid` int(10) DEFAULT NULL COMMENT '问题id',
  `uid` int(10) NOT NULL COMMENT '通知用户',
  `see` int(1) NOT NULL DEFAULT '0' COMMENT '未读状态',
  `langid` int(10) NOT NULL DEFAULT '1' COMMENT '语言id',
  `user_crossall` varchar(50) DEFAULT '' COMMENT '跨域',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_question_reply`;-- 
CREATE TABLE `cmseasy_question_reply` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '问答回复表id',
  `aid` int(10) NOT NULL COMMENT '问答表ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '回复id',
  `content` text NOT NULL COMMENT '回复内容',
  `mid` int(10) NOT NULL COMMENT '回复用户',
  `floor` int(10) NOT NULL DEFAULT '0' COMMENT '楼层',
  `isadopt` int(1) NOT NULL DEFAULT '0' COMMENT '是否被采纳',
  `adddate` datetime NOT NULL COMMENT '回复时间',
  `langid` int(1) NOT NULL COMMENT '语言id',
  `state` int(1) NOT NULL DEFAULT '1' COMMENT '0/封禁1/可用2/待审3/审核失败',
  `returncon` varchar(50) DEFAULT NULL COMMENT '审核失败原因',
  `rewardmenoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '打赏金额',
  `user_crossall` varchar(50) DEFAULT '' COMMENT '跨域',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_question_reward`;-- 
CREATE TABLE `cmseasy_question_reward` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '打赏记录id',
  `uid` int(10) NOT NULL COMMENT '用户',
  `rewarduid` int(10) NOT NULL COMMENT '被打赏用户',
  `rid` int(10) NOT NULL COMMENT '打赏评论/悬赏问题',
  `menoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '打赏金额',
  `adddate` datetime DEFAULT NULL COMMENT '打赏时间',
  `type` int(1) NOT NULL DEFAULT '1' COMMENT '1/打赏 2/悬赏',
  `state` int(1) DEFAULT '1' COMMENT '0/悬赏中1/悬赏打赏成功',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_question_tag`;-- 
CREATE TABLE `cmseasy_question_tag` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `tagname` varchar(50) NOT NULL COMMENT 'tag名称',
  `content` text COMMENT '说明',
  `adddate` datetime DEFAULT NULL COMMENT '时间',
  `img` varchar(255) DEFAULT NULL COMMENT '图片',
  `langid` int(10) NOT NULL DEFAULT '1' COMMENT '语言id',
  `meta_title` varchar(255) DEFAULT '' COMMENT '网页标题',
  `keyword` varchar(255) DEFAULT NULL COMMENT '关键词',
  `description` text COMMENT '网页描述',
  `is_to_index` tinyint(1) NOT NULL COMMENT '是否推荐到首页',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_question_type`;-- 
CREATE TABLE `cmseasy_question_type` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `typename` varchar(50) NOT NULL COMMENT '类型名称',
  `content` text COMMENT '说明',
  `adddate` datetime DEFAULT NULL COMMENT '时间',
  `img` varchar(255) DEFAULT NULL COMMENT '图片',
  `langid` int(10) DEFAULT '1' COMMENT '语言id',
  `state` int(1) NOT NULL DEFAULT '1' COMMENT '1/显示0/不显示',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_settings`;-- 
CREATE TABLE `cmseasy_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(10) DEFAULT NULL,
  `tag` varchar(30) NOT NULL DEFAULT '',
  `value` mediumtext NOT NULL,
  `array` mediumtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_stats`;-- 
CREATE TABLE `cmseasy_stats` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `bot` varchar(50) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `url` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_user`;-- 
CREATE TABLE `cmseasy_user` (
  `userid` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `nickname` varchar(20) DEFAULT NULL,
  `groupid` int(2) NOT NULL DEFAULT '0',
  `checked` tinyint(2) DEFAULT NULL,
  `qqlogin` varchar(255) DEFAULT NULL,
  `alipaylogin` varchar(255) DEFAULT NULL,
  `wechatlogin` varchar(255) DEFAULT NULL,
  `avatar` varchar(100) DEFAULT NULL,
  `userip` varchar(20) DEFAULT NULL,
  `state` tinyint(4) DEFAULT '1',
  `qq` int(15) DEFAULT NULL,
  `e_mail` varchar(60) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `tel` varchar(100) DEFAULT NULL,
  `question` varchar(255) DEFAULT NULL,
  `answer` varchar(255) DEFAULT NULL,
  `intro` text,
  `point` smallint(5) unsigned DEFAULT '0',
  `introducer` int(10) unsigned DEFAULT NULL,
  `regtime` int(10) DEFAULT '0',
  `sex` varchar(10) DEFAULT '',
  `isblock` tinyint(1) DEFAULT '0',
  `isdelete` tinyint(1) DEFAULT '0',
  `headimage` varchar(255) DEFAULT NULL COMMENT '用户头像',
  `integration` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '积分',
  `couponidnum` varchar(255) DEFAULT NULL COMMENT '优惠劵',
  `collect` varchar(255) DEFAULT NULL COMMENT '收藏',
  `menoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '积分',
  `adddatetime` datetime DEFAULT NULL,
  `notifiid` varchar(255) DEFAULT '',
  `templatelang` varchar(20) NOT NULL DEFAULT 'cn' COMMENT '前台语言包',
  `adminlang` varchar(20) NOT NULL DEFAULT 'cn' COMMENT '后台语言包',
  `buyarchive` varchar(255) NOT NULL COMMENT '购买的内容或者下载',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `userid` (`userid`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `tel` (`tel`),
  UNIQUE KEY `e_mail` (`e_mail`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_user_history`;-- 
CREATE TABLE `cmseasy_user_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表自增id',
  `userid` int(11) NOT NULL COMMENT '用户id',
  `urlname` varchar(50) NOT NULL COMMENT '记录的名称',
  `url` text NOT NULL COMMENT '记录的地址',
  `static` int(1) NOT NULL DEFAULT '0' COMMENT '是否打开的状态',
  `langid` int(11) DEFAULT '1' COMMENT '语言包ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_usergroup`;-- 
CREATE TABLE `cmseasy_usergroup` (
  `groupid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `discount` float(2,1) unsigned NOT NULL DEFAULT '0.0',
  `powerlist` text,
  `fpwlist` text,
  `integrationclaim` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '积分要求',
  `isadministrator` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否管理组',
  `isint` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`groupid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8;--

DROP TABLE IF EXISTS `cmseasy_xfconsumption`;-- 
CREATE TABLE `cmseasy_xfconsumption` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oid` varchar(255) NOT NULL COMMENT '消费订单',
  `content` varchar(255) DEFAULT NULL COMMENT '消费内容',
  `menoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '消费金额',
  `adddate` datetime DEFAULT NULL COMMENT '消费日期',
  `status` int(3) NOT NULL DEFAULT '0',
  `mid` int(11) DEFAULT NULL COMMENT '用户id',
  `trade_no` varchar(255) DEFAULT '' COMMENT '支付编号',
  `xftype` int(1) DEFAULT '0' COMMENT '消费类型(1/商品消费 2/充值记录 3/插件模板消费 4/阅读下载购买)',
  `user_crossall` varchar(50) DEFAULT '' COMMENT '跨域',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;--

INSERT INTO `cmseasy_announcement` VALUES('1','关于我们','<p>关于我们内容。。。</p><p><br></p>','2010-07-07 07:07:07','1','1');-- 
INSERT INTO `cmseasy_announcement` VALUES('2','联系我们','<p>联系我们内容。。。</p><p><br></p>','2019-07-23 20:16:55','1','1');-- 
INSERT INTO `cmseasy_announcement` VALUES('3','注意事项','<p>注意事项内容。。</p>','2019-07-23 20:17:17','1','1');-- 

INSERT INTO `cmseasy_friendlink` VALUES('1','2','0','易通免费企业CMS','0','https://www.cmseasy.cn','https://www.cmseasy.cn/images/logo.png','','0','admin','2009-11-12 13:14:37','0','1');-- 
INSERT INTO `cmseasy_friendlink` VALUES('2','1','0','CmsEasy论坛','0','http://www.cmseasy.org','','','0','admin','2009-11-12 13:15:00','2','1');-- 
INSERT INTO `cmseasy_friendlink` VALUES('3','1','0','九州易通科技有限公司','0','http://www.cmseasy.net','','','0','admin','2009-11-12 13:28:53','2','1');-- 

INSERT INTO `cmseasy_lang` VALUES('1','0','cn','中文','/html/upload/images/201907/15631496836234.gif','1','1','','1','1','1');-- 



INSERT INTO `cmseasy_question_config` VALUES('1','question_open','1','是否开启问答');-- 
INSERT INTO `cmseasy_question_config` VALUES('2','question_vip','0','是否仅会员可发布');-- 
INSERT INTO `cmseasy_question_config` VALUES('3','reply_vip','1','是否仅会员可回复');-- 
INSERT INTO `cmseasy_question_config` VALUES('4','question_admin_see','0','是否设置仅管理员可查看');-- 
INSERT INTO `cmseasy_question_config` VALUES('5','question_vip_see','0','是否设置仅会员可查看');-- 
INSERT INTO `cmseasy_question_config` VALUES('6','question_reply_hf','1','允许评论回答');-- 
INSERT INTO `cmseasy_question_config` VALUES('7','question_reply_pl','1','允许评论问题');-- 
INSERT INTO `cmseasy_question_config` VALUES('8','question_edit','9999','限时编辑问题');-- 
INSERT INTO `cmseasy_question_config` VALUES('9','question_edit_reply','9999','限时编辑回答');-- 
INSERT INTO `cmseasy_question_config` VALUES('10','question_audit','0','发布问题是否需要审核');-- 
INSERT INTO `cmseasy_question_config` VALUES('11','reply_audit','0','发布回答是否需要审核');-- 
INSERT INTO `cmseasy_question_config` VALUES('12','question_pagesize','10','问题列表分页数');-- 
INSERT INTO `cmseasy_question_config` VALUES('13','reply_pagesize','10','评论列表分页数');-- 
INSERT INTO `cmseasy_question_config` VALUES('14','user_crossall','','用户跨域');-- 
INSERT INTO `cmseasy_question_config` VALUES('15','crossall_safetycode','9c156e4e42e9c6f45c77c9bf2edc3e69d41b5512','跨域安全码');-- 
INSERT INTO `cmseasy_question_config` VALUES('16','question_index','1','问答首页');-- 
INSERT INTO `cmseasy_question_config` VALUES('25','urlrewrite_on','1','伪静态');-- 
INSERT INTO `cmseasy_question_config` VALUES('26','checkbox-inline','1','伪静态404页面');-- 
INSERT INTO `cmseasy_question_config` VALUES('27','add_question_time','30','问答连续发布时间限制');-- 
INSERT INTO `cmseasy_question_config` VALUES('28','question_reply_adduser','0','回答问题获得积分');-- 
INSERT INTO `cmseasy_question_config` VALUES('29','question_reply_nice_adduser','0','最佳答案获得积分');-- 


INSERT INTO `cmseasy_question_foot` VALUES('1','关于我们','./index.php?case=announ&amp;act=show&amp;id=1','0','1');--
INSERT INTO `cmseasy_question_foot` VALUES('2','联系我们','./index.php?case=announ&amp;act=show&amp;id=2','1','1');--
INSERT INTO `cmseasy_question_foot` VALUES('3','注意事项','./index.php?case=announ&amp;act=show&amp;id=3','0','1');--

INSERT INTO `cmseasy_question_head` VALUES('1','问题','./index.php?case=question&amp;act=questionlist','0','1');-- 
INSERT INTO `cmseasy_question_head` VALUES('2','话题','./index.php?case=question&amp;act=taglist','0','1');--
INSERT INTO `cmseasy_question_head` VALUES('3','专题','./index.php?case=question&amp;act=typelist','0','1');--





INSERT INTO `cmseasy_user` VALUES('1','admin','21232f297a57a5a743894a0e4a801fc3','管理员','2','1','','','','','','0','1111','admin@admin.com','admin','admin','','','','0','0','0','','0','0','/html/upload/images/201907/15625455867367.png','0','17:0:1,25:1:0,26:1:0,27:1:1,28:1:0','2,4,3,46,14,73','55.07','0000-00-00 00:00:00','','cn','cn','');-- 


INSERT INTO `cmseasy_usergroup` VALUES('101','一般会员','0.0','','add_archive','0','0','1');-- 
INSERT INTO `cmseasy_usergroup` VALUES('3','新闻管理员','0.0','a:64:{s:6:\"config\";s:1:\"1\";s:12:\"system_image\";s:1:\"1\";s:13:\"system_upload\";s:1:\"1\";s:8:\"language\";s:1:\"1\";s:7:\"content\";s:1:\"1\";s:7:\"archive\";s:1:\"1\";s:12:\"archive_list\";s:1:\"1\";s:11:\"archive_add\";s:1:\"1\";s:12:\"archive_edit\";s:1:\"1\";s:11:\"archive_del\";s:1:\"1\";s:13:\"archive_check\";s:1:\"1\";s:15:\"archive_setting\";s:1:\"1\";s:17:\"archive_hotsearch\";s:1:\"1\";s:13:\"archive_image\";s:1:\"1\";s:11:\"archive_tag\";s:1:\"1\";s:4:\"func\";s:1:\"1\";s:12:\"func_announc\";s:1:\"1\";s:17:\"func_announc_list\";s:1:\"1\";s:16:\"func_announc_add\";s:1:\"1\";s:17:\"func_announc_edit\";s:1:\"1\";s:16:\"func_announc_del\";s:1:\"1\";s:9:\"func_book\";s:1:\"1\";s:14:\"func_book_list\";s:1:\"1\";s:15:\"func_book_reply\";s:1:\"1\";s:13:\"func_book_del\";s:1:\"1\";s:12:\"func_comment\";s:1:\"1\";s:17:\"func_comment_list\";s:1:\"1\";s:17:\"func_comment_edit\";s:1:\"1\";s:16:\"func_comment_del\";s:1:\"1\";s:11:\"func_ballot\";s:1:\"1\";s:16:\"func_ballot_list\";s:1:\"1\";s:15:\"func_ballot_add\";s:1:\"1\";s:16:\"func_ballot_edit\";s:1:\"1\";s:15:\"func_ballot_del\";s:1:\"1\";s:3:\"seo\";s:1:\"1\";s:10:\"seo_weixin\";s:1:\"1\";s:15:\"seo_weixin_list\";s:1:\"1\";s:14:\"seo_weixin_add\";s:1:\"1\";s:15:\"seo_weixin_edit\";s:1:\"1\";s:14:\"seo_weixin_del\";s:1:\"1\";s:12:\"seo_linkword\";s:1:\"1\";s:17:\"seo_linkword_list\";s:1:\"1\";s:16:\"seo_linkword_add\";s:1:\"1\";s:17:\"seo_linkword_edit\";s:1:\"1\";s:16:\"seo_linkword_del\";s:1:\"1\";s:14:\"seo_xiongzhang\";s:1:\"1\";s:5:\"cache\";s:1:\"1\";s:12:\"cache_manage\";s:1:\"1\";s:13:\"cache_content\";s:1:\"1\";s:14:\"cache_category\";s:1:\"1\";s:11:\"cache_index\";s:1:\"1\";s:10:\"cache_type\";s:1:\"1\";s:13:\"cache_special\";s:1:\"1\";s:9:\"cache_tag\";s:1:\"1\";s:11:\"cache_baidu\";s:1:\"1\";s:12:\"cache_google\";s:1:\"1\";s:16:\"cache_wap_manage\";s:1:\"1\";s:24:\"cache_manage_wap_content\";s:1:\"1\";s:25:\"cache_manage_wap_category\";s:1:\"1\";s:22:\"cache_manage_wap_index\";s:1:\"1\";s:21:\"cache_manage_wap_type\";s:1:\"1\";s:24:\"cache_manage_wap_special\";s:1:\"1\";s:20:\"cache_manage_wap_tag\";s:1:\"1\";s:12:\"cache_update\";s:1:\"1\";}','add_archive','0','0','1');-- 
INSERT INTO `cmseasy_usergroup` VALUES('4','部门管理员','0.0','a:5:{s:7:\"content\";s:1:\"1\";s:7:\"archive\";s:1:\"1\";s:12:\"archive_list\";s:1:\"1\";s:11:\"archive_add\";s:1:\"1\";s:12:\"archive_edit\";s:1:\"1\";}','add_archive','100','0','1');-- 
INSERT INTO `cmseasy_usergroup` VALUES('2','超级管理员','5.0','a:79:{s:8:\"question\";s:1:\"1\";s:13:\"question-list\";s:1:\"1\";s:14:\"question-state\";s:1:\"1\";s:14:\"question-reply\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:3:\"tag\";s:1:\"1\";s:3:\"nav\";s:1:\"1\";s:8:\"nav-head\";s:1:\"1\";s:8:\"nav-foot\";s:1:\"1\";s:13:\"system_extend\";s:1:\"1\";s:7:\"announc\";s:1:\"1\";s:12:\"announc_list\";s:1:\"1\";s:11:\"announc_add\";s:1:\"1\";s:12:\"announc_edit\";s:1:\"1\";s:11:\"announc_del\";s:1:\"1\";s:8:\"seo_mail\";s:1:\"1\";s:13:\"seo_mail_send\";s:1:\"1\";s:17:\"seo_mail_usersend\";s:1:\"1\";s:21:\"seo_mail_subscription\";s:1:\"1\";s:14:\"seo_thirdparty\";s:1:\"1\";s:9:\"order_pay\";s:1:\"1\";s:10:\"seo_status\";s:1:\"1\";s:15:\"seo_status_list\";s:1:\"1\";s:14:\"seo_status_del\";s:1:\"1\";s:16:\"seo_status_clear\";s:1:\"1\";s:14:\"seo_friendlink\";s:1:\"1\";s:19:\"seo_friendlink_list\";s:1:\"1\";s:18:\"seo_friendlink_add\";s:1:\"1\";s:19:\"seo_friendlink_edit\";s:1:\"1\";s:18:\"seo_friendlink_del\";s:1:\"1\";s:22:\"seo_friendlink_setting\";s:1:\"1\";s:4:\"user\";s:1:\"1\";s:11:\"user_manage\";s:1:\"1\";s:9:\"user_list\";s:1:\"1\";s:8:\"user_add\";s:1:\"1\";s:9:\"user_edit\";s:1:\"1\";s:8:\"user_del\";s:1:\"1\";s:11:\"user_ologin\";s:1:\"1\";s:11:\"user_invite\";s:1:\"1\";s:16:\"user_integration\";s:1:\"1\";s:10:\"user_group\";s:1:\"1\";s:14:\"usergroup_list\";s:1:\"1\";s:13:\"usergroup_add\";s:1:\"1\";s:14:\"usergroup_edit\";s:1:\"1\";s:13:\"usergroup_del\";s:1:\"1\";s:15:\"seo_consumption\";s:1:\"1\";s:11:\"seo_express\";s:1:\"1\";s:8:\"template\";s:1:\"1\";s:15:\"template_manage\";s:1:\"1\";s:15:\"system_template\";s:1:\"1\";s:13:\"template_edit\";s:1:\"1\";s:17:\"template_downlist\";s:1:\"1\";s:12:\"system_slide\";s:1:\"1\";s:8:\"security\";s:1:\"1\";s:20:\"system_filechecksite\";s:1:\"1\";s:14:\"func_filecheck\";s:1:\"1\";s:9:\"func_scan\";s:1:\"1\";s:15:\"func_returnform\";s:1:\"1\";s:9:\"func_data\";s:1:\"1\";s:15:\"func_data_baker\";s:1:\"1\";s:17:\"func_data_restore\";s:1:\"1\";s:19:\"func_data_adminlogs\";s:1:\"1\";s:13:\"system_upload\";s:1:\"1\";s:11:\"func_update\";s:1:\"1\";s:6:\"config\";s:1:\"1\";s:11:\"system_site\";s:1:\"1\";s:12:\"system_image\";s:1:\"1\";s:15:\"system_security\";s:1:\"1\";s:8:\"language\";s:1:\"1\";s:10:\"system_sms\";s:1:\"1\";s:18:\"system_information\";s:1:\"1\";s:18:\"system_websitesite\";s:1:\"1\";s:15:\"system_customer\";s:1:\"1\";s:19:\"system_verification\";s:1:\"1\";s:17:\"system_membersite\";s:1:\"1\";s:17:\"system_backupsite\";s:1:\"1\";s:17:\"system_spidersite\";s:1:\"1\";s:15:\"system_langsite\";s:1:\"1\";s:12:\"cache_update\";s:1:\"1\";}','add_archive','0','1','1');-- 
INSERT INTO `cmseasy_usergroup` VALUES('1000','游客','0.0','','','0','0','1');-- 

ALTER TABLE `cmseasy_question` ADD `topping` INT(1) DEFAULT 0 COMMENT '是否置顶';-- 

ALTER TABLE `cmseasy_question_type` ADD `meta_title` varchar(255) DEFAULT NULL COMMENT '网页标题';-- 

ALTER TABLE `cmseasy_question_type` ADD `keyword` varchar(255) DEFAULT NULL COMMENT '关键词';-- 

ALTER TABLE `cmseasy_question_type` ADD `description` text COMMENT '网页描述';-- 

INSERT INTO `cmseasy_question_config` VALUES('25','urlrewrite_on','1','伪静态');-- 

INSERT INTO `cmseasy_question_config` VALUES('26','checkbox-inline','1','伪静态404页面');-- 

ALTER TABLE `cmseasy_question_foot` ADD `listorder` INT(11) DEFAULT 0 COMMENT '排序';-- 

ALTER TABLE `cmseasy_question_head` ADD `listorder` INT(11) DEFAULT 0 COMMENT '排序';-- 

ALTER TABLE  `cmseasy_announcement` ADD `recommend` INT(1) DEFAULT 0 COMMENT '是否推荐到首页';-- 



INSERT INTO `cmseasy_question_config` (`id`, `name`, `value`, `showname`) VALUES('27','add_question_time','30','问答连续发布时间限制');
