// @flow

import React from 'react'
import { View, Text, StyleSheet } from 'react-native'
import ExamplesRegistry from '../../../App/Services/ExamplesRegistry'
import * as Animatable from 'react-native-animatable'

// Example
ExamplesRegistry.addPluginExample('Animatable', () =>
  <View>
    <Animatable.View
      animation='fadeIn'
      iterationCount='infinite'
      direction='alternate'
      style={[styles.button, styles.fadeInButton]}
    >
      <Text style={styles.fadeInButtonText}>Faaaaaddddeeeeddd</Text>
    </Animatable.View>
    <Animatable.View
      style={[styles.button, styles.jelloButton]}
      animation='jello'
      iterationCount='infinite'>
      <Text style={styles.jelloButtonText}>Jelloo00000000</Text>
    </Animatable.View>
    <Animatable.View
      animation='pulse'
      iterationCount='infinite'
      style={[styles.button, styles.pulseButton]}>
      <Text style={styles.pulseButtonText}>puLsepuLsepuLse</Text>
    </Animatable.View>
  </View>
)

const styles = StyleSheet.create({
  button: {
    margin: 10,
    height: 50,
    justifyContent: 'center',
    alignItems: 'center'
  },
  fadeInButton: {
    backgroundColor: '#ff3b3a'
  },
  fadeInButtonText: {
    color: 'white'
  },
  jelloButton: {
    backgroundColor: 'white'
  },
  pulseButton: {
    backgroundColor: '#ffc700'
  },
  pulseButtonText: {
    color: 'white'
  }
})
