/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.rsf.rpc.net.netty;
import net.hasor.core.AppContext;
import net.hasor.rsf.rpc.net.ConnectionAccepter;
import net.hasor.rsf.rpc.net.ConnectorFactory;
import net.hasor.rsf.rpc.net.ReceivedListener;

/**
 * RPC协议连接器，负责创建某个特定RPC协议的网络事件。
 * @version : 2017年01月16日
 * @author 赵永春 (zyc@hasor.net)
 */
public class NettyConnectorFactory implements ConnectorFactory {
    public NettyConnector create(String protocol, AppContext appContext, ReceivedListener receivedListener, ConnectionAccepter accepter) throws Throwable {
        return new NettyConnector(protocol, appContext, receivedListener, accepter);
    }
}