/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.rsf;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 宣布该接口是 RSF 接口,该接口会允许远端其它 RSF 客户端发起调用。
 * @version : 2014年11月12日
 * @author 赵永春 (zyc@hasor.net)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface RsfService {
    /**服务名。*/
    public String name() default "";

    /**服务分组。*/
    public String group() default "";

    /**服务版本。*/
    public String version() default "";

    /**获取客户端调用服务超时时间。*/
    public int clientTimeout() default -1;

    /**获取序列化方式*/
    public String serializeType() default "";
}