/* https://dev.mysql.com/doc/refman/5.7/en/data-types.html
 * https://dev.mysql.com/doc/refman/8.0/en/data-types.html */
create table tb_mysql_types
(
    c_serial          serial,

    c_bit             bit,
    c_bit_n           bit(3),

    c_tinyint         tinyint,
    c_tinyint_u       tinyint unsigned,
    c_tinyint_z       tinyint zerofill,
    c_tinyint_u_z     tinyint unsigned zerofill,
    c_tinyint_n       tinyint(3),
    c_tinyint_n_n     tinyint(3) unsigned,
    c_tinyint_n_z     tinyint(3) zerofill,
    c_tinyint_n_u_z   tinyint(3) unsigned zerofill,

    c_bool            bool,
    c_boolean         boolean,

    c_smallint        smallint,
    c_smallint_u      smallint unsigned,
    c_smallint_z      smallint zerofill,
    c_smallint_u_z    smallint unsigned zerofill,
    c_smallint_n      smallint(3),
    c_smallint_n_n    smallint(3) unsigned,
    c_smallint_n_z    smallint(3) zerofill,
    c_smallint_n_u_z  smallint(3) unsigned zerofill,

    c_mediumint       mediumint,
    c_mediumint_u     mediumint unsigned,
    c_mediumint_z     mediumint zerofill,
    c_mediumint_u_z   mediumint unsigned zerofill,
    c_mediumint_n     mediumint(3),
    c_mediumint_n_n   mediumint(3) unsigned,
    c_mediumint_n_z   mediumint(3) zerofill,
    c_mediumint_n_u_z mediumint(3) unsigned zerofill,

    c_int             int,
    c_int_u           int unsigned,
    c_int_z           int zerofill,
    c_int_u_z         int unsigned zerofill,
    c_int_n           int(3),
    c_int_n_n         int(3) unsigned,
    c_int_n_z         int(3) zerofill,
    c_int_n_u_z       int(3) unsigned zerofill,

    c_integer         integer,
    c_integer_u       integer unsigned,
    c_integer_z       integer zerofill,
    c_integer_u_z     integer unsigned zerofill,
    c_integer_n       integer(3),
    c_integer_n_n     integer(3) unsigned,
    c_integer_n_z     integer(3) zerofill,
    c_integer_n_u_z   integer(3) unsigned zerofill,

    c_bigint          bigint,
    c_bigint_u        bigint unsigned,
    c_bigint_z        bigint zerofill,
    c_bigint_u_z      bigint unsigned zerofill,
    c_bigint_n        bigint(3),
    c_bigint_n_n      bigint(3) unsigned,
    c_bigint_n_z      bigint(3) zerofill,
    c_bigint_n_u_z    bigint(3) unsigned zerofill,

    c_decimal         decimal,
    c_decimal_u       decimal unsigned,
    c_decimal_z       decimal zerofill,
    c_decimal_u_z     decimal unsigned zerofill,
    c_decimal_n       decimal(10),
    c_decimal_n_u     decimal(10) unsigned,
    c_decimal_n_z     decimal(10) zerofill,
    c_decimal_n_u_z   decimal(10) unsigned zerofill,
    c_decimal_n_n     decimal(10, 3),
    c_decimal_n_n_u   decimal(10, 3) unsigned,
    c_decimal_n_n_z   decimal(10, 3) zerofill,
    c_decimal_n_n_u_z decimal(10, 3) unsigned zerofill,
    c_dec             dec,
    c_dec_u           dec unsigned,
    c_dec_z           dec zerofill,
    c_dec_u_z         dec unsigned zerofill,
    c_dec_n           dec(10),
    c_dec_n_u         dec(10) unsigned,
    c_dec_n_z         dec(10) zerofill,
    c_dec_n_u_z       dec(10) unsigned zerofill,
    c_dec_n_n         dec(10, 3),
    c_dec_n_n_u       dec(10, 3) unsigned,
    c_dec_n_n_z       dec(10, 3) zerofill,
    c_dec_n_n_u_z     dec(10, 3) unsigned zerofill,
    c_numeric         numeric,
    c_numeric_u       numeric unsigned,
    c_numeric_z       numeric zerofill,
    c_numeric_u_z     numeric unsigned zerofill,
    c_numeric_n       numeric(10),
    c_numeric_n_u     numeric(10) unsigned,
    c_numeric_n_z     numeric(10) zerofill,
    c_numeric_n_u_z   numeric(10) unsigned zerofill,
    c_numeric_n_n     numeric(10, 3),
    c_numeric_n_n_u   numeric(10, 3) unsigned,
    c_numeric_n_n_z   numeric(10, 3) zerofill,
    c_numeric_n_n_u_z numeric(10, 3) unsigned zerofill,
    c_fixed           fixed,
    c_fixed_u         fixed unsigned,
    c_fixed_z         fixed zerofill,
    c_fixed_u_z       fixed unsigned zerofill,
    c_fixed_n         fixed(10),
    c_fixed_n_u       fixed(10) unsigned,
    c_fixed_n_z       fixed(10) zerofill,
    c_fixed_n_u_z     fixed(10) unsigned zerofill,
    c_fixed_n_n       fixed(10, 3),
    c_fixed_n_n_u     fixed(10, 3) unsigned,
    c_fixed_n_n_z     fixed(10, 3) zerofill,
    c_fixed_n_n_u_z   fixed(10, 3) unsigned zerofill,

    c_float           float,
    c_float_u         float unsigned,
    c_float_z         float zerofill,
    c_float_u_z       float unsigned zerofill,
    c_float_n         float(10),
    c_float_n_u       float(10) unsigned,
    c_float_n_z       float(10) zerofill,
    c_float_n_u_z     float(10) unsigned zerofill,
    c_float_n_n       float(10, 3
) ,
    c_float_n_n_u                float(10, 3) unsigned,
    c_float_n_n_z                float(10, 3) zerofill,
    c_float_n_n_u_z              float(10, 3) unsigned zerofill,

    c_double                     double,
    c_double_u                   double unsigned,
    c_double_z                   double zerofill,
    c_double_u_z                 double unsigned zerofill,
    c_double_n_n                 double(10, 3),
    c_double_n_n_u               double(10, 3) unsigned,
    c_double_n_n_z               double(10, 3) zerofill,
    c_double_n_n_u_z             double(10, 3) unsigned zerofill,

    c_double_precision           double precision,
    c_double_precision_u         double precision unsigned,
    c_double_precision_z         double precision zerofill,
    c_double_precision_u_z       double precision unsigned zerofill,
    c_double_precision_n_n       double precision(10, 3),
    c_double_precision_n_n_u     double precision(10, 3) unsigned,
    c_double_precision_n_n_z     double precision(10, 3) zerofill,
    c_double_precision_n_n_u_z   double precision(10, 3) unsigned zerofill,

    c_real                       real,
    c_real_u                     real unsigned,
    c_real_z                     real zerofill,
    c_real_u_z                   real unsigned zerofill,
    c_real_n_n                   real(10, 3),
    c_real_n_n_u                 real(10, 3) unsigned,
    c_real_n_n_z                 real(10, 3) zerofill,
    c_real_n_n_u_z               real(10, 3) unsigned zerofill,

    c_date                       date,
    c_datetime                   datetime,
    c_datetime_n                 datetime(6),
    c_timestamp                  timestamp,
    c_timestamp_n                timestamp(6),
    c_time                       time,
    c_time_n                     time(6),
    c_year                       year,
    c_year_n                     year(4),

    c_char                       char,
    c_char_n                     char(10),
    c_character                  character,
    c_character_n                character(10),
    c_nchar                      nchar,
    c_nchar_n                    nchar(10),
    c_national_char              national char,
    c_national_char_n            national char(10),

    c_varchar                    varchar(10),
    c_character_varying          character varying(10),
    c_long_varchar               long varchar,

    c_nvarchar                   nvarchar(10),
    c_national_varchar           national varchar(10),
    c_national_character_varying national character varying(10),

    c_binary                     binary,
    c_longbinary                 long binary,
    c_char_byte                  char byte,
    c_binary_n                   binary(10),

    c_varbinary                  varbinary(10),
    c_long_varbinary             long varbinary,

    c_tinyblob                   tinyblob,
    c_blob                       blob,
    c_blob_n                     blob(12),
    c_mediumblob                 mediumblob,
    c_longblob                   longblob,

    c_tinytext                   tinytext,
    c_text                       text,
    c_text_n                     text(12),
    c_mediumtext                 mediumtext,
    c_longtext                   longtext,
    c_long                       long,

    c_enum                       enum ('enum1','enum2','enum3','enum4','enum5','enum6','enum7','enum8'),
    c_set                        set ('set1','set2','set3','set4','set5','set6','set7','set8'),
    c_json                       json,

    c_geometry                   geometry,
    c_point                      point,
    c_linestring                 linestring,
    c_polygon                    polygon,
    c_multipoint                 multipoint,
    c_multilinestring            multilinestring,
    c_multipolygon               multipolygon,
    c_geometrycollection         geometrycollection
)
