/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.dataql.runtime.mem;
import net.hasor.dataql.domain.DataModel;

import java.util.Stack;

/**
 * 栈数据
 * @author 赵永春 (zyc@hasor.net)
 * @version : 2019-11-22
 */
public class DataStack extends Stack<Object> {
    private int       resultCode = 0;
    private DataModel result     = null;
    private ExitType  exitType   = null;

    public int getResultCode() {
        return resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public DataModel getResult() {
        return result;
    }

    public void setResult(DataModel result) {
        this.result = result;
    }

    public ExitType getExitType() {
        return exitType;
    }

    public void setExitType(ExitType exitType) {
        this.exitType = exitType;
    }

    @Override
    public DataStack clone() {
        DataStack dataStack = new DataStack();
        dataStack.addAll(this);
        dataStack.resultCode = this.resultCode;
        dataStack.result = this.result;
        dataStack.exitType = this.exitType;
        return dataStack;
    }
}