<a name="readme-top"></a>

<div align="center">
  <br/>

  <h1><b>my-bookstore</b></h1>

</div>

# 📗 Table of Contents

- [📗 Table of Contents](#-table-of-contents)
- [📖 my-bookstore ](#-my-bookstore-)
  - [🛠 Built With ](#-built-with-)
    - [Tech Stack ](#tech-stack-)
    - [Key Features ](#key-features-)
  - [🚀 Live Demo ](#-live-demo-)
  - [💻 Getting Started ](#-getting-started-)
    - [Project Structure](#project-structure)
    - [Setup](#setup)
    - [Install](#install)
    - [Usage](#usage)
    - [Run tests](#run-tests)
  - [👥 Authors ](#-authors-)
  - [🔭 Future Features ](#-future-features-)
  - [🤝 Contributing ](#-contributing-)
  - [⭐️ Show your support ](#️-show-your-support-)
  - [🙏 Acknowledgments ](#-acknowledgments-)
  - [📝 License ](#-license-)

# 📖 my-bookstore <a name="about-project"></a>

> This Bookstore Website is a user-friendly platform built with React.js and Redux, aimed at helping book enthusiasts store and manage their favorite books. Whether you are an avid reader or a collector, this website provides a seamless experience for organizing and accessing your beloved book collection

## 🛠 Built With <a name="built-with"></a>

### Tech Stack <a name="tech-stack"></a>

<details>
  <summary>React</summary>
    <ul>
      <li>This project use <a href="https://react.dev/">React</a></li>
    </ul>
</details>

<details>
  <summary>HTML</summary>
  <ul>
    <li>This project use <a href="https://github.com/microverseinc/curriculum-html-css/blob/main/html5.md">HTML.</a></li>
  </ul>
</details>

<details>
  <summary>CSS</summary>
  <ul>
    <li>The <a href="https://github.com/microverseinc/curriculum-html-css/blob/main/html5.md">CSS</a> is used to provide the design in the whole page.</li>
  </ul>
</details>

<details>
  <summary>Linters</summary>
  <ul>
    <li>The <a href="https://github.com/microverseinc/linters-config">Linters</a> are tools that help us to check and solve the errors in the code</li>
    This project count with three linters: 
    <ul>
      <li>CSS</li>
      <li>JavaScript</li>
    </ul>
  </ul>
</details>




### Key Features <a name="key-features"></a>

-   **React configuration**
-   **HTML Generation**
-   **Code Quality**
-   **Modular Structure**
-   **Development Server**
-   **JavaScript Functionality**
-   **Gitflow**
-   **API integration**
-   **CSS Styling**

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## 🚀 Live Demo <a name="live-demo"></a>

> You can see a Demo [here](https://bookstore-flq3.onrender.com/).

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## 💻 Getting Started <a name="getting-started"></a>

> To get a local copy up and running, follow these steps.
> This project requires Node.js and npm installed on your machine.

-Node.js
-npm

> -Clone this repository to your local machine using:

>  git clone https://github.com/ClaudiaRojasSoto/my-bookstore.git

> -Navigate to the project folder:

> cd math_magicians

> -Install the project dependencies:

> npm install

> To start the development server, run the following command:

> npm start

### Project Structure

> The project follows the following folder and file structure:

- /src: Contains the source files of the application.
- /src/index.js: Main entry point of the JavaScript application.
- /src/App.js: Top-level component of the application.
- /src/components: Directory for React component
- /public: Contains the public files and assets of the application.
- /public/index.html: Base HTML file of the application.
- /build: Contains the generated production files.

### Setup

> Clone this repository to your desired folder: https://github.com/ClaudiaRojasSoto/my-bookstore.git

### Install

> Install this project with: install Stylelint and ESLint

### Usage

> To run the project, execute the following command: just need a web Browser

### Run tests

> To run tests, run the following command: npm start
> you just need a simple web browser to run this project for a test

## 👥 Authors <a name="authors"></a>

👤 **Claudia Rojas**

-   GitHub: [@githubhandle](https://github.com/ClaudiaRojasSoto)
-   LinkedIn: [LinkedIn](https://www.linkedin.com/in/claudia-soto-260504208/)


<p align="right">(<a href="#readme-top">back to top</a>)</p>

## 🔭 Future Features <a name="future-features"></a>

-   **Testing**
-   **Deployment**

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## 🤝 Contributing <a name="contributing"></a>

> Contributions, issues, and feature requests are welcome!

> Feel free to check the [issues page](https://github.com/ClaudiaRojasSoto/my-bookstore/issues).

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## ⭐️ Show your support <a name="support"></a>

> If you like this project show support by following this account

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- ACKNOWLEDGEMENTS -->

## 🙏 Acknowledgments <a name="acknowledgements"></a>

> -   Microverse for providing the opportunity to learn Git and GitHub in a collaborative environment.

> -   GitHub Docs for providing a wealth of information on Git and GitHub.

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- LICENSE -->

## 📝 License <a name="license"></a>

> This project is [MIT](MIT.md).

<p align="right">(<a href="#readme-top">back to top</a>)</p>
