# Welcome to the Analyze Boston Open Data Challenge!
This repository is a collection of project submissions from the Analyze Boston Open Data Challenge. If you'd like, you can add your project directly to this repo by creating a new folder for your code, adding your project to the list below, and submitting a pull request. Otherwise, we'll be adding projects to this repo after the event for sharing with the community.

## List of projects
- _Boston Garbage Atlas: 2014_
  * Submitted by: C.C. Miller
  * Description: Big Belly Alerts are mapped spatially and temporally corresponding to four select Boston events.
  * [Web Application](http://garbage-milleria.rhcloud.com/)
  * [Code on Github](https://github.com/cecois/garbage)
- _Boston in Winter 2015: Beta Insights Monitor of Demand on Public Safety Incident Management_
  * Submitted by: [Cassie DeWitt](https://twitter.com/Cassie_DeWitt)
  * Description: My submission attempts to answer the question of what the fire service industry, the City of Boston, and data scientists specializing in public safety analytics can learn from Boston's heavy snow season of early 2015. In particular, I have analyzed where and when the Fire Department's services were the most utilized. Combining a look at fire district boundaries and neighborhoods, I have produced insight on what fire districts were the most utilized and what neighborhoods were the most affected. In addition, I have analyzed when the Fire Department's services were the highest in demand. The technical product is an interactive visual story of the Boston snowstorms in early 2015--through the lens of fire service delivery. I have painted a broad picture from January 1-April 7, 2015 and drilled down on two snowstorms in early 2015. In addition to the maps and visual analytics produced in Tableau, are two maps included in my Google Drive. These maps are the number of fire runs by neighborhood for each analyzed snowstorm.
  * [Tableau Workbook and PDFs on Github](https://github.com/CityOfBoston/opendatachallenge/tree/master/dewitt_boston-in-winter-2015)
  * [Tableau Public Dashboard](https://public.tableau.com/profile/cassie.dewitt#!/vizhome/BostonEarlyWinter2015/DrillDown)
- _Fire Proof Boston Housing_
  * Submitted by: [Jon Jay](https://twitter.com/jonjaytweets)
  * Description: I analyze patterns of fire risk in Boston Housing according to housing type, neighborhood, prior citizen complaints, and other parcel-level variables.
  * [Web Application](http://rpubs.com/jonjay/FPBH_JJ)
  * [Code on Github](https://github.com/JonJayHub/Fire-Proof)
- _Modeling Building Fire Risk Across the City_
  * Submitted by: Sean McKenna
  * Description: This submission is intended to be a proof-of-concept that looks to develop a machine-learned model based on recent historical data from Inspectional Services Department violations, Assessing Department building/property data, and incident reports from the Boston Fire Department to provide measures of fire risk for addresses across the City.  Results from the model's performance are encouraging, and indicate that it could significantly improve the City's efforts to avert fire incidents before they happen.
  * [Code and Results on Github](https://github.com/CityOfBoston/opendatachallenge/tree/master/mckenna_modeling-building-fire-risk)
- _Where There's Smoke..._
  * Submitted by: Wenfei Xu
  * Description: This classification project uses 311, CEP violations, and building characteristics data from tax parcels in Boston to build a predictive model for fire incidents in the city.  I try a model that uses fire incidents, along with 311 incidents and CEP violations from previous years, to predict fires in 2017 (in the 3 months for which we have data).
  * [Code and Results on Github](https://github.com/CityOfBoston/opendatachallenge/tree/master/xu_where-theres-smoke)

## Public domain licensing

Submissions to the Open Data Challenge through this repository will be released in the worldwide [public domain](LICENSE.md), consistent with other City of Boston projects such as our [311 application](https://github.com/CityOfBoston/311) and the city's website, [boston.gov](https://github.com/CityOfBoston/boston.gov). As stated in [LICENSE](LICENSE.md):

> This project is in the public domain within the United States, and copyright and related rights in the work worldwide are waived through the [CC0 1.0 Universal public domain dedication](https://creativecommons.org/publicdomain/zero/1.0/).
>
> All contributions to this project will be released under the CC0 dedication. By submitting a pull request, you are agreeing to comply with this waiver of copyright interest.

By sharing your project in the public domain, you allow the entire community to benefit from your work by using and building on it however they choose, and we make all data on Analyze Boston public domain by default for the same reason. If you'd rather not share your work this way, you can host it elsewhere, but we hope you'll contribute it here for the sake of the entire Boston data community!

_Please note:_ If your project incorporates existing code, packages, or tools not already in the public domain, please include in your pull request an update to [LICENSE](LICENSE.md) noting specific sources in the exclusion list.
