// ###########################################################################
// #
// # file:
// #	Error.cpp
// #
// ###########################################################################

#include <stdafx.h>
#include "..\app\AspForum.h"

#ifdef _DEBUG
	#define new DEBUG_NEW
	#undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#endif


//////////////////////////////////////////////////////////////////////////////
// .

std::_tstring GetLastErrorMsg( const DWORD lastError )
{
	void *msg_buf;

	if ( !FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,
		0, lastError,
		MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT ),
		reinterpret_cast<LPTSTR>( &msg_buf ), 0, 0 ) )
		return (LPCTSTR)0;

	else {
		const std::_tstring str = static_cast<LPCSTR>( msg_buf );
		LocalFree( msg_buf );
		return str;
	}
}

void __stdcall _com_issue_error(HRESULT);

void ThrowComError( HRESULT hr )
{
	_com_issue_error( hr );
}

// obtain the error message for a given HRESULT
std::_tstring LogCrackHR( HRESULT hr ) 
{
	void *msg_buf;
	::FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER |
		FORMAT_MESSAGE_FROM_SYSTEM,
		0,
		hr,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		(LPTSTR)&msg_buf,
		0,
		0 );
	
	const std::_tstring str = static_cast<LPCSTR>( msg_buf );
	
	// Free the buffer.
	::LocalFree( msg_buf );
	
	return str;
}

// obtain information from the Errors Collection.
std::_tstring LogAdoErrorImport( ADODB::_ConnectionPtr conn )
{
	ADODB::ErrorsPtr errors = 0;
	ADODB::ErrorPtr error  = 0;
	HRESULT hr = (HRESULT) 0L;
	
	std::_tstring log;

	// Don't have an un-handled exception in the handler that
	// handles exceptions!
	try {
		if ( (conn)!=0 ) {
			errors = conn->GetErrors();
			
			const long cnt = errors->GetCount();
			
			for ( long i=0; (!FAILED(hr)) && (i<cnt); i++ ) {
				log += Format( "    Dumping ADO Error %d of %d\n", i+1, cnt );
				
				hr = errors->get_Item((_variant_t)((long)i), &error );
				
				_bstr_t txt_source     ( error->GetSource() );
				_bstr_t txt_description( error->GetDescription() );
				_bstr_t txt_hlp_file   ( error->GetHelpFile() );
				_bstr_t txt_sql_state  ( error->GetSQLState() );
				
				log += Format( "         Number      = %ld\n", error->GetNumber() );
				log += Format( "         Source      = %s\n",  (LPCTSTR)txt_source );
				log += Format( "         Description = %s\n",  (LPCTSTR)txt_description );
				log += Format( "         HelpFile    = %s\n",  (LPCTSTR)txt_hlp_file );
				log += Format( "         HelpContext = %ld\n", error->GetHelpContext() );
				log += Format( "         SQLState    = %s\n",  (LPCTSTR)txt_sql_state );
				log += Format( "         HelpContext = %ld\n", error->GetHelpContext() );
				log += Format( "         NativeError = %ld\n", error->GetNativeError() );
			}
		}

	} catch(...) {
		log += Format( "*** UNABLE TO LOG EXCEPTION ***" );
	}
	
	if ( errors ) errors->Release();
	if ( error  ) error->Release();
	
	return log;
}

// for displaying in browser.
std::_tstring Pre( LPCTSTR str )
{
	std::_tstring ret;
//	ret += "<pre>";
	ret += str;
//	ret += "</pre>";

	return ret;
}
std::_tstring Pre( std::_tstring& str )
{
	return Pre( str.c_str() );
}

HRESULT CATCH_AND_LOG_XEPT( Xept& e )
{
	std::string str=Format(
		"exception thrown by Xept class\n"
		"    Text = %s\n", e.Whole().c_str() );

	LOG( str.c_str() );
	return AtlReportError( CLSID_Forum2, Pre(str).c_str(), GUID_NULL, 0 );
}

HRESULT CATCH_AND_LOG_COM_ERROR_XEPT( 
	_com_error& e, ADODB::_ConnectionPtr conn )
{
	HRESULT hr=S_OK;

	// crack _com_error.
	_bstr_t bstrSource(e.Source());
	_bstr_t bstrDescription(e.Description());

	std::_tstring log;
	log += Format( "exception thrown for classes generated by #import\n" );
	log += Format( "    Code         = %08lx\n", e.Error());
	log += Format( "    Code meaning = %s\n",    e.ErrorMessage());
	log += Format( "    Source       = %s\n",    (LPCTSTR) bstrSource);
	log += Format( "    Description  = %s\n",    (LPCTSTR) bstrDescription);

	// errors collection may not always be populated.
	if ( FAILED( hr ) ) {
		log += "*** HRESULT ***";
		log += LogCrackHR(hr);
	}

	// crack errors collection.
	log += LogAdoErrorImport( conn );
	LOG( log.c_str() );
	AtlReportError( CLSID_Forum2, Pre(log).c_str(), GUID_NULL, 0 );

	return e.Error();
}

HRESULT CATCH_AND_LOG_COM_ERROR_XEPT( _com_error& e )
{
	HRESULT hr=S_OK;

	// crack _com_error.
	_bstr_t bstrSource(e.Source());
	_bstr_t bstrDescription(e.Description());

	std::_tstring log;
	log += Format( "exception thrown for classes generated by #import\n" );
	log += Format( "    Code         = %08lx\n", e.Error());
	log += Format( "    Code meaning = %s\n",    e.ErrorMessage());
	log += Format( "    Source       = %s\n",    (LPCTSTR) bstrSource);
	log += Format( "    Description  = %s\n",    (LPCTSTR) bstrDescription);

	// errors collection may not always be populated.
	if ( FAILED( hr ) ) {
		log += "*** HRESULT ***";
		log += LogCrackHR(hr);
	}

	return e.Error();
}

HRESULT CATCH_AND_LOG_UNKNOWN_XEPT()
{
	std::_tstring str="Unknown exception thrown.\n";
	return AtlReportError( CLSID_Forum2, Pre(str).c_str(), GUID_NULL, 0 );
}


//////////////////////////////////////////////////////////////////////////////
