# Contributions

We welcome contributions to this repository! Whether you’re fixing bugs, adding new features, or improving documentation, your help is appreciated. Please follow the guidelines below to ensure a smooth contribution process.

## How to Contribute

1. **Fork the Repository**: Click the "Fork" button on the top right of the repository page to create a copy of the repository in your GitHub account.

2. **Clone Your Fork**: Clone the forked repository to your local machine.

    ```bash
    git clone https://github.com/Chongjie-Si/Subspace-Tuning.git
    cd PEFT
    ```

3. **Create a New Branch**: Create a new branch for your work.

    ```bash
    git checkout -b feature/your-feature-name
    ```

4. **Make Your Changes**: Implement your changes in the new branch. Be sure to follow the project's code style and guidelines.

5. **Commit Your Changes**: Commit your changes with a descriptive commit message.

    ```bash
    git add .
    git commit -m "Add feature: your-feature-name"
    ```

6. **Push to Your Fork**: Push your changes to your forked repository.

    ```bash
    git push origin feature/your-feature-name
    ```

7. **Submit a Pull Request**: Go to the original repository on GitHub and create a new pull request from your fork. Provide a clear description of your changes and the reasons for them.

### Reporting Issues

If you find a bug or have a feature request, please report it by creating a new issue. To make the issue reporting process effective, please follow these guidelines:

1. **Search for Duplicates**: Before creating a new issue, check if the issue has already been reported.

2. **Provide Detailed Information**: Include as much detail as possible, such as:
    - A clear and descriptive title
    - Steps to reproduce the issue
    - Expected and actual results
    - Screenshots or code snippets, if applicable
    - Environment details (e.g., OS, Python version, dependencies)

3. **Be Respectful and Considerate**: Please be kindly respectful and considerate in your communications.

### Code Style and Guidelines

To maintain a consistent codebase, please adhere to the following guidelines:

1. **Write Tests**: Ensure that your changes are covered by tests. Add new tests if you're adding new features or modifying existing ones.

2. **Update Documentation**: If your changes affect the usage or functionality of the project, update the documentation accordingly.

3. **Use Clear and Descriptive Commit Messages**: Commit messages should clearly describe the changes made in the commit.

### Reviewing and Merging Pull Requests

Pull requests will be reviewed by the maintainers. Here are some guidelines for the review process:

1. **Automated Checks**: Ensure that your pull request passes all automated checks (e.g., continuous integration tests).

2. **Address Feedback**: Be prepared to make changes based on feedback from the maintainers. Respond to comments and push updates to your branch as needed.

3. **Be Patient**: Reviewing pull requests can take time. Please be patient and courteous during the review process.

We appreciate your contributions and efforts in making this project better. Thank you for your interest and support!

If you have any questions or need further assistance, feel free to contact us at [chongjiesi@sjtu.edu.cn](mailto:chongjiesi@sjtu.edu.cn).
