local common = {}

-- Merges four bytes into a uint32 number.
function common.bytes_to_uint32(a, b, c, d)
	return a * 0x1000000 + b * 0x10000 + c * 0x100 + d
end

-- Splits a uint32 number into four bytes.
function common.uint32_to_bytes(a)
	local a4 = a % 256
	a = (a - a4) / 256
	local a3 = a % 256
	a = (a - a3) / 256
	local a2 = a % 256
	local a1 = (a - a2) / 256
	return a1, a2, a3, a4
end

return common