local chat = _G.chat or {}

local function getnick(client)
	return client:IsValid() and client:GetNick() or "server"
end

local enabled = pvars.Setup("chat_timestamps", true)

function chat.AddTimeStamp(tbl)
	if not enabled:Get() then return {} end

	tbl = tbl or {}
	local time = os.date("*t")
	list.insert(tbl, 1, " - ")
	list.insert(tbl, 1, Color(1, 1, 1))
	list.insert(tbl, 1, ("%.2d:%.2d"):format(time.hour, time.min))
	list.insert(tbl, 1, ColorBytes(118, 170, 217))
	return tbl
end

function chat.GetTimeStamp()
	local time = os.date("*t")
	return ("%.2d:%.2d - "):format(time.hour, time.min)
end

function chat.Append(var, str, skip_log)
	if not str then
		str = var
		var = NULL
	end

	local client = NULL

	if typex(var) == "client" then
		client = var
		var = getnick(var)
	elseif typex(var) == "null" then
		var = "disconnected"
	elseif not network.IsConnected() then
		var = "server"
	else
		var = tostring(var)
	end

	if not skip_log then logf("%s%s: %s\n", chat.GetTimeStamp(), var, str) end

	event.Call("Chat", var, str, client)
end

if CLIENT then
	message.AddListener("say", function(client, str, seed)
		chat.ClientSay(client, str, seed)
	end)

	function chat.Say(str)
		str = tostring(str)

		if network.IsConnected() then
			message.Send("say", str)
		else
			chat.ClientSay(clients.GetLocalClient(), str)
		end
	end
end

chat.seed = 0

function chat.ClientSay(client, str, skip_log, seed)
	local seed = seed or chat.seed

	if event.Call("ClientChat", client, str, seed) ~= false then
		chat.Append(client, str, skip_log)

		if SERVER then message.Broadcast("say", client, str, chat.seed) end

		if SERVER or not network.IsConnected() then chat.seed = chat.seed + 1 end
	end

	return false
end

if SERVER then
	message.AddListener("say", function(client, str)
		chat.ClientSay(client, str)
	end)

	function chat.Say(str)
		str = tostring(str)
		message.Broadcast("say", NULL, str)
		chat.Append(NULL, str)
	end
end

commands.Add("say=arg_line", function(text)
	chat.Say(text)
end)

return chat