import { execSync } from 'child_process';
import { getReleaseTag, getVersionByArguments } from './version.mjs';
import path from 'path';
import fs from 'fs';

// targetProject: ./packages/xxx
const workspaceRoot = process.env.NX_WORKSPACE_ROOT;
const targetProject = process.env.NX_TASK_TARGET_PROJECT
const targetProjectPath = path.resolve(workspaceRoot, `packages/${targetProject}`)

// node publish.mjs <tag> <version>
// CWD: ./dist/packages/xxx
const packageJSONPath = path.resolve(process.cwd(), 'package.json');

if (process.env.READY_FOR_PUBLISH !== 'true') {
  console.log(
    `Set env READY_FOR_PUBLISH=true before running publish commands.`
  );
  process.exit(1);
}

const tag = getReleaseTag();

// Update the version property in package.json
const version = getVersionByArguments();
const packageJSON = JSON.parse(fs.readFileSync(packageJSONPath, 'utf-8'));
packageJSON.version = version;
fs.writeFileSync(
  packageJSONPath,
  JSON.stringify(packageJSON, null, 2),
  'utf-8'
);

// Set npm credential
fs.writeFileSync(
  '.npmrc',
  '//registry.npmjs.org/:_authToken=${NPM_TOKEN}',
  'utf-8'
);

// Replace the README.md from target project
const readme = fs.readFileSync(`${targetProjectPath}/README.md`, 'utf-8');
fs.writeFileSync(
  'README.md',
  readme,
  'utf-8'
)

// Execute "npm publish" to publish
execSync(`npm publish --tag ${tag}`);
