<?php
/*
 +-------------------------------------------------------------------------+
 | Copyright (C) 2004-2024 The Cacti Group                                 |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | Cacti: The Complete RRDtool-based Graphing Solution                     |
 +-------------------------------------------------------------------------+
 | This code is designed, written, and maintained by the Cacti Group. See  |
 | about.php and/or the AUTHORS file for specific developer information.   |
 +-------------------------------------------------------------------------+
 | http://www.cacti.net/                                                   |
 +-------------------------------------------------------------------------+
*/

$guest_account = true;
include('./include/auth.php');
include_once('./lib/rrd.php');
include_once('./lib/html_graph.php');
include_once('./lib/html_tree.php');

/* set default action */
set_default_action('view');

if (!isset_request_var('view_type')) {
	set_request_var('view_type', '');
}

api_plugin_hook_function('graph');

switch (get_request_var('action')) {
	case 'view':
		html_graph_single_view($rras, $graph_title);

		break;
	case 'zoom':
		html_graph_zoom($rras, $graph_title);

		break;
	case 'properties':
		html_graph_properties();

		break;
}

