# Contributing Guildelines

### 👍🎉 First off, welcome to the project and thanks for taking the time to contribute! 🎉👍
<br>

#### When contributing to this repository, please first discuss the change you wish to make before making a change.
<br>

## Before Getting Started!
Learn how to fork a repo, create an issue, make changes, create pull request.

Learn about the File structure we use [here](/FILE_STRUCTURE.md)

For more information, refer to <a href = "https://docs.github.com/en" target = "_self">GitHub Documentation</a>

--------
## Contributing Process
1. Go through 'Issues' to ensure whether the said issue has already been raised.

2. If you do find a new issue, do not hesitate to open a new one. Make sure to describe any additions required in the message.

3. If interested, do mention in the issue that you want to work on it.

4. Kindly wait for the approval from the maintainers of this project before starting to work on any issue.

5. **Do not make changes to the main branch.** All the changes should be made to the develop branch.

6. Make sure that your code is properly formatted and does not contain any commented out code.

7. Create a pull request after making the required changes and do mention the issue number that your pull request is related to.

8. Finally, wait for it to be reviewed. Make the required changes if the reviewer asks for them. 

9. Your pull request will be merged once everything seems okay.

10. That's it! You have successfully made your contribution to the project.
<br>

-----------------
#### **Note**: Always comment and provide apt descriptions wherever necessary for efficient running of the project.
