
# ⚡ Data Structures & Algorithms - A Comprehensive Guide

<img src="Images/Banner.jpeg" alt="Banner Image">

<p align="center">
<b>A Comprehensive Guide on Data Structures & Algorithms</b>
</p>

## Table of Contents
* <a href="#Traditional Method">Traditional Method</a>
* <a href="#Unconventional Method">Unconventional Method</a>
* <a href="#Test Your Knowledge!">Test Your Knowledge!</a>

---
### <a name="Traditional Method">Traditional Method</a>
*The solid easy route to go down the data structures and algorithms hill, risk free and widely used, follow through:*
  1. [Arrays](Comprehensive_Guides/Arrays.md)
  2. [Linked List](Comprehensive_Guides/LinkedList.md)
  3. [Stacks](Comprehensive_Guides/Stack.md)
  4. [Queues](Comprehensive_Guides/Queue.md)
  5. [Hash Tables](Comprehensive_Guides/HashTable.md)
  6. [Trees](Comprehensive_Guides/Tree.md)
  7. [Heaps](Comprehensive_Guides/Heap.md)
  8. [Graphs](Comprehensive_Guides/Graph.md)

[Also Check Out some Popular Algorithms And Practice Problems](Comprehensive_Guides/Algorithm.md)
<br>
**! Make sure you go through each of these in detail, the explanation is also provided in each individual link!**
<br>
<br>
[Also Check out the Sample Codes for each Data Structures](Codes/README.md)

### <a name="Unconventional Method">Unconventional Method</a>
*If you are not interested in going down the traditional route of learning each type, There are courses that cover entirety of Data Structures:*

- [All Data Structures 8 hour course by William Fiset](https://youtu.be/RBSGKlAvoiM)
- [In Depth Algorithms Playlist by Abdul Bari](https://www.youtube.com/playlist?list=PLDN4rrl48XKpZkf03iYFl-O29szjTrs_O)
- [Data Structures And Algorithms course for GATE](https://www.youtube.com/playlist?list=PLEVDNf7p-wYyh712BgmW9UGrAc88bl3OF)
- [Stanford Algorithms Course](https://www.youtube.com/playlist?list=PLXFMmlk03Dt7Q0xr1PIAriY5623cKiH7V)
- [Algorithms MIT Course](https://www.youtube.com/playlist?list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb)

### <a name="Test Your Knowledge!">Test Your Knowledge!</a>
*After learning all this to gain an edge over others, you need to practice and keep practicing. There are some websites to learn and practice daily:*

- [Leet Code](https://leetcode.com/)
- [InterviewBit](https://www.interviewbit.com/)
- [Hackerrank](https://www.hackerrank.com/)
- [CodeWars](https://www.codewars.com/)
- [CodinGame (A fun way to code with games)](https://www.codingame.com/start)
---

**How to Contribute**
---
1. Clone repo and create a new branch: `$ git checkout https://github.com/CSI-SFIT/Data-Structures-and-Algorithms--A-Comprehensive-Guide.git -b name_for_new_branch`.
2. Make changes and test.
3. Submit Pull Request with comprehensive description of changes.

**Acknowledgements**
---

**CSI SFIT Tech Team 2020 - 2021 :**
+ Tech Executive : [@Varun-Patkar](https://github.com/Varun-Patkar)
+ Tech Executive : [@EktaMasrani](https://github.com/ekta18)

<p align="center">
  <a href="https://www.csi.sfit.ac.in/">
    <img src="https://github.com/CSI-SFIT/Getting-Started-With-Hacktoberfest/blob/main/Images/CSI_Logo.png"
         alt="csi_logo" width="300" height="300">
  </a>
</p>

<div align="center">
  <a href="https://www.instagram.com/csi_sfit/" target="_blank"><img src="https://img.icons8.com/fluent/48/000000/instagram-new.png"/></a>
  <a href="https://twitter.com/csi_sfit" target="_blank"><img src="https://img.icons8.com/fluent/48/000000/twitter.png"/></a>
  <a href="https://www.facebook.com/csi.sfit" target="_blank"><img src="https://img.icons8.com/fluent/48/000000/facebook-new.png"/></a>
  <a href="https://www.youtube.com/channel/UC7fiMWl2n3BXDQCKk3blUMA?sub_confirmation=1" target="_blank"><img src="https://img.icons8.com/color/48/000000/youtube-play.png"/></a>
  <a href="https://discord.gg/WRgX3WV" target="_blank"><img src="https://img.icons8.com/color/48/000000/discord-new-logo.png"/></a>
  <a href="mailto: csi@sfit.ac.in" target="_blank"><img src="https://img.icons8.com/fluent/48/000000/gmail.png"/></a>
</div>
