<center><h1>Heaps</h1></center><br>

## What are Heaps?

A Heap is a special case of a binary tree where the parent nodes are compared to their children with their values and are arranged accordingly.
Let us see how we can represent heaps. Heaps can be represented using trees as well as arrays. Figures 7 and 8 show how we can represent a binary heap using a binary tree and an array.

<img src="../Images/Heap 1.png" alt="Heap Image 1">
<img src="../Images/Heap 2.png" alt="Heap Image 2">  

## Types of Heaps

You should use heap when you require to allocate a large block of memory. For example, you want to create a large size array or big structure to keep that variable around a long time then you should allocate it on the heap.

- Min Heap — the key of the parent is less than or equal to those of its children. This is called the min-heap property. The root will contain the minimum value of the heap.
- Max Heap — the key of the parent is greater than or equal to those of its children. This is called the max-heap property. The root will contain the maximum value of the heap.

## Advantages of Heaps

- Heap helps you to find the greatest and minimum number
- Garbage collection runs on the heap memory to free the memory used by the object.
- Heap method also used in the Priority Queue.
- It allows you to access variables globally.
- Heap doesn't have any limit on memory size.

## Disadvantages of Heaps

- It can provide the maximum memory an OS can provide
- It takes more time to compute.
- Memory management is more complicated in heap memory as it is used globally.
- It takes too much time in execution compared to the stack.

## Resources

- [Heaps - GeeksForGeeks](https://www.geeksforgeeks.org/heap-data-structure/)
- [Heaps - TutorialsPoint](https://www.tutorialspoint.com/data_structures_algorithms/heap_data_structure.htm)
- [Heaps - HackerEarth](https://www.hackerearth.com/practice/data-structures/trees/heapspriority-queues/tutorial/)
- [Heaps - Interview Cake](https://www.interviewcake.com/concept/java/heap)
- [Heaps - Brilliant.org](https://brilliant.org/wiki/heaps/)


- [Heaps - HackerEarth](https://www.youtube.com/watch?v=t0Cq6tVNRBA)
- [Heaps and Heap Sort - Abdul Bari](https://www.youtube.com/watch?v=HqPJF2L5h9U)
- [Heaps - Jenny Lectures](https://www.youtube.com/watch?v=NEtwJASLU8Q)
- [Heaps - Education4You](https://www.youtube.com/watch?v=j6iP4lDTKyI)
- [Heaps and Heap Sort - MIT](https://www.youtube.com/watch?v=B7hVxCmfPtM)
- [Heaps - GATE Lectures](https://www.youtube.com/watch?v=40iljMQmqmY)
