<?php
// +----------------------------------------------------------------------
// | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2016~2020 https://www.crmeb.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
// +----------------------------------------------------------------------
// | Author: CRMEB Team <admin@crmeb.com>
// +----------------------------------------------------------------------

namespace app\wap\controller;

use basic\WapBasic;
use service\AlipayTradeWapService;
use service\UtilService;

/**
 * 支付宝支付
 * Class Alipay
 * @package app\wap\controller
 */
class Alipay extends WapBasic
{
    protected function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        $this->assign('overallShareWechat', json_encode([]));
        $this->assign('userInfo', ['uid' => 0]);
    }

    /**
     * 支付页微信端提示切换浏览器,其他浏览器直接支付
     * @param string $info 加密后的支付参数
     * @return mixed|void
     */
    public function index($info = '',$params = false)
    {
        if (!$info) return $this->failed('缺少支付参数');
        $info = json_decode(base64_decode($info), true);
        if (!$info) return $this->failed('缺少支付参数');
        $isWechat = UtilService::isWechatBrowser();
        if ($isWechat) {
            return $this->fetch();
        } else {
            AlipayTradeWapService::init()->AliPayWap($info['orderId'], $info['pay_price'], $info['orderName'], $params);
        }
    }

    /**
     * 支付宝同步回调
     * @return mixed
     */
    public function alipay_success_synchro()
    {
        $res = AlipayTradeWapService::init()->AliPayReturn();
        $result = $res['result'];
        if ($result) $is_pay = true;
        else $is_pay = false;
        $this->assign('is_pay', $is_pay);
        return $this->fetch();
    }

    /**
     * 支付宝异步回调
     */
    public function alipay_success_notify()
    {
        AlipayTradeWapService::handleNotify();
    }

}