/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.video;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Rect;
import org.opencv.core.RotatedRect;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.utils.Converters;
import org.opencv.video.BackgroundSubtractorKNN;
import org.opencv.video.BackgroundSubtractorMOG2;
import org.opencv.video.DualTVL1OpticalFlow;

public class Video {
    private static final int CV_LKFLOW_INITIAL_GUESSES = 4;
    private static final int CV_LKFLOW_GET_MIN_EIGENVALS = 8;
    public static final int OPTFLOW_USE_INITIAL_FLOW = 4;
    public static final int OPTFLOW_LK_GET_MIN_EIGENVALS = 8;
    public static final int OPTFLOW_FARNEBACK_GAUSSIAN = 256;
    public static final int MOTION_TRANSLATION = 0;
    public static final int MOTION_EUCLIDEAN = 1;
    public static final int MOTION_AFFINE = 2;
    public static final int MOTION_HOMOGRAPHY = 3;

    public static Mat estimateRigidTransform(Mat mat, Mat mat2, boolean bl) {
        Mat mat3 = new Mat(Video.estimateRigidTransform_0(mat.nativeObj, mat2.nativeObj, bl));
        return mat3;
    }

    public static BackgroundSubtractorKNN createBackgroundSubtractorKNN(int n, double d, boolean bl) {
        BackgroundSubtractorKNN backgroundSubtractorKNN = new BackgroundSubtractorKNN(Video.createBackgroundSubtractorKNN_0(n, d, bl));
        return backgroundSubtractorKNN;
    }

    public static BackgroundSubtractorKNN createBackgroundSubtractorKNN() {
        BackgroundSubtractorKNN backgroundSubtractorKNN = new BackgroundSubtractorKNN(Video.createBackgroundSubtractorKNN_1());
        return backgroundSubtractorKNN;
    }

    public static BackgroundSubtractorMOG2 createBackgroundSubtractorMOG2(int n, double d, boolean bl) {
        BackgroundSubtractorMOG2 backgroundSubtractorMOG2 = new BackgroundSubtractorMOG2(Video.createBackgroundSubtractorMOG2_0(n, d, bl));
        return backgroundSubtractorMOG2;
    }

    public static BackgroundSubtractorMOG2 createBackgroundSubtractorMOG2() {
        BackgroundSubtractorMOG2 backgroundSubtractorMOG2 = new BackgroundSubtractorMOG2(Video.createBackgroundSubtractorMOG2_1());
        return backgroundSubtractorMOG2;
    }

    public static DualTVL1OpticalFlow createOptFlow_DualTVL1() {
        DualTVL1OpticalFlow dualTVL1OpticalFlow = new DualTVL1OpticalFlow(Video.createOptFlow_DualTVL1_0());
        return dualTVL1OpticalFlow;
    }

    public static RotatedRect CamShift(Mat mat, Rect rect, TermCriteria termCriteria) {
        double[] dArray = new double[4];
        RotatedRect rotatedRect = new RotatedRect(Video.CamShift_0(mat.nativeObj, rect.x, rect.y, rect.width, rect.height, dArray, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon));
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        return rotatedRect;
    }

    public static double findTransformECC(Mat mat, Mat mat2, Mat mat3, int n, TermCriteria termCriteria, Mat mat4) {
        double d = Video.findTransformECC_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon, mat4.nativeObj);
        return d;
    }

    public static double findTransformECC(Mat mat, Mat mat2, Mat mat3, int n) {
        double d = Video.findTransformECC_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n);
        return d;
    }

    public static double findTransformECC(Mat mat, Mat mat2, Mat mat3) {
        double d = Video.findTransformECC_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
        return d;
    }

    public static int buildOpticalFlowPyramid(Mat mat, List<Mat> list, Size size, int n, boolean bl, int n2, int n3, boolean bl2) {
        Mat mat2 = new Mat();
        int n4 = Video.buildOpticalFlowPyramid_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, n, bl, n2, n3, bl2);
        Converters.Mat_to_vector_Mat(mat2, list);
        mat2.release();
        return n4;
    }

    public static int buildOpticalFlowPyramid(Mat mat, List<Mat> list, Size size, int n) {
        Mat mat2 = new Mat();
        int n2 = Video.buildOpticalFlowPyramid_1(mat.nativeObj, mat2.nativeObj, size.width, size.height, n);
        Converters.Mat_to_vector_Mat(mat2, list);
        mat2.release();
        return n2;
    }

    public static int meanShift(Mat mat, Rect rect, TermCriteria termCriteria) {
        double[] dArray = new double[4];
        int n = Video.meanShift_0(mat.nativeObj, rect.x, rect.y, rect.width, rect.height, dArray, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        return n;
    }

    public static void calcOpticalFlowFarneback(Mat mat, Mat mat2, Mat mat3, double d, int n, int n2, int n3, int n4, double d2, int n5) {
        Video.calcOpticalFlowFarneback_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, d, n, n2, n3, n4, d2, n5);
    }

    public static void calcOpticalFlowPyrLK(Mat mat, Mat mat2, MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, MatOfByte matOfByte, MatOfFloat matOfFloat, Size size, int n, TermCriteria termCriteria, int n2, double d) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        MatOfByte matOfByte2 = matOfByte;
        MatOfFloat matOfFloat2 = matOfFloat;
        Video.calcOpticalFlowPyrLK_0(mat.nativeObj, mat2.nativeObj, matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, matOfByte2.nativeObj, matOfFloat2.nativeObj, size.width, size.height, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon, n2, d);
    }

    public static void calcOpticalFlowPyrLK(Mat mat, Mat mat2, MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, MatOfByte matOfByte, MatOfFloat matOfFloat, Size size, int n) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        MatOfByte matOfByte2 = matOfByte;
        MatOfFloat matOfFloat2 = matOfFloat;
        Video.calcOpticalFlowPyrLK_1(mat.nativeObj, mat2.nativeObj, matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, matOfByte2.nativeObj, matOfFloat2.nativeObj, size.width, size.height, n);
    }

    public static void calcOpticalFlowPyrLK(Mat mat, Mat mat2, MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, MatOfByte matOfByte, MatOfFloat matOfFloat) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        MatOfByte matOfByte2 = matOfByte;
        MatOfFloat matOfFloat2 = matOfFloat;
        Video.calcOpticalFlowPyrLK_2(mat.nativeObj, mat2.nativeObj, matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, matOfByte2.nativeObj, matOfFloat2.nativeObj);
    }

    private static native long estimateRigidTransform_0(long var0, long var2, boolean var4);

    private static native long createBackgroundSubtractorKNN_0(int var0, double var1, boolean var3);

    private static native long createBackgroundSubtractorKNN_1();

    private static native long createBackgroundSubtractorMOG2_0(int var0, double var1, boolean var3);

    private static native long createBackgroundSubtractorMOG2_1();

    private static native long createOptFlow_DualTVL1_0();

    private static native double[] CamShift_0(long var0, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double var9);

    private static native double findTransformECC_0(long var0, long var2, long var4, int var6, int var7, int var8, double var9, long var11);

    private static native double findTransformECC_1(long var0, long var2, long var4, int var6);

    private static native double findTransformECC_2(long var0, long var2, long var4);

    private static native int buildOpticalFlowPyramid_0(long var0, long var2, double var4, double var6, int var8, boolean var9, int var10, int var11, boolean var12);

    private static native int buildOpticalFlowPyramid_1(long var0, long var2, double var4, double var6, int var8);

    private static native int meanShift_0(long var0, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double var9);

    private static native void calcOpticalFlowFarneback_0(long var0, long var2, long var4, double var6, int var8, int var9, int var10, int var11, double var12, int var14);

    private static native void calcOpticalFlowPyrLK_0(long var0, long var2, long var4, long var6, long var8, long var10, double var12, double var14, int var16, int var17, int var18, double var19, int var21, double var22);

    private static native void calcOpticalFlowPyrLK_1(long var0, long var2, long var4, long var6, long var8, long var10, double var12, double var14, int var16);

    private static native void calcOpticalFlowPyrLK_2(long var0, long var2, long var4, long var6, long var8, long var10);
}

