/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.photo;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.Point;
import org.opencv.photo.AlignMTB;
import org.opencv.photo.CalibrateDebevec;
import org.opencv.photo.CalibrateRobertson;
import org.opencv.photo.MergeDebevec;
import org.opencv.photo.MergeMertens;
import org.opencv.photo.MergeRobertson;
import org.opencv.photo.Tonemap;
import org.opencv.photo.TonemapDrago;
import org.opencv.photo.TonemapDurand;
import org.opencv.photo.TonemapMantiuk;
import org.opencv.photo.TonemapReinhard;
import org.opencv.utils.Converters;

public class Photo {
    private static final int CV_INPAINT_NS = 0;
    private static final int CV_INPAINT_TELEA = 1;
    public static final int INPAINT_NS = 0;
    public static final int INPAINT_TELEA = 1;
    public static final int NORMAL_CLONE = 1;
    public static final int MIXED_CLONE = 2;
    public static final int MONOCHROME_TRANSFER = 3;
    public static final int RECURS_FILTER = 1;
    public static final int NORMCONV_FILTER = 2;
    public static final int LDR_SIZE = 256;

    public static AlignMTB createAlignMTB(int n, int n2, boolean bl) {
        AlignMTB alignMTB = new AlignMTB(Photo.createAlignMTB_0(n, n2, bl));
        return alignMTB;
    }

    public static AlignMTB createAlignMTB() {
        AlignMTB alignMTB = new AlignMTB(Photo.createAlignMTB_1());
        return alignMTB;
    }

    public static CalibrateDebevec createCalibrateDebevec(int n, float f, boolean bl) {
        CalibrateDebevec calibrateDebevec = new CalibrateDebevec(Photo.createCalibrateDebevec_0(n, f, bl));
        return calibrateDebevec;
    }

    public static CalibrateDebevec createCalibrateDebevec() {
        CalibrateDebevec calibrateDebevec = new CalibrateDebevec(Photo.createCalibrateDebevec_1());
        return calibrateDebevec;
    }

    public static CalibrateRobertson createCalibrateRobertson(int n, float f) {
        CalibrateRobertson calibrateRobertson = new CalibrateRobertson(Photo.createCalibrateRobertson_0(n, f));
        return calibrateRobertson;
    }

    public static CalibrateRobertson createCalibrateRobertson() {
        CalibrateRobertson calibrateRobertson = new CalibrateRobertson(Photo.createCalibrateRobertson_1());
        return calibrateRobertson;
    }

    public static MergeDebevec createMergeDebevec() {
        MergeDebevec mergeDebevec = new MergeDebevec(Photo.createMergeDebevec_0());
        return mergeDebevec;
    }

    public static MergeMertens createMergeMertens(float f, float f2, float f3) {
        MergeMertens mergeMertens = new MergeMertens(Photo.createMergeMertens_0(f, f2, f3));
        return mergeMertens;
    }

    public static MergeMertens createMergeMertens() {
        MergeMertens mergeMertens = new MergeMertens(Photo.createMergeMertens_1());
        return mergeMertens;
    }

    public static MergeRobertson createMergeRobertson() {
        MergeRobertson mergeRobertson = new MergeRobertson(Photo.createMergeRobertson_0());
        return mergeRobertson;
    }

    public static Tonemap createTonemap(float f) {
        Tonemap tonemap = new Tonemap(Photo.createTonemap_0(f));
        return tonemap;
    }

    public static Tonemap createTonemap() {
        Tonemap tonemap = new Tonemap(Photo.createTonemap_1());
        return tonemap;
    }

    public static TonemapDrago createTonemapDrago(float f, float f2, float f3) {
        TonemapDrago tonemapDrago = new TonemapDrago(Photo.createTonemapDrago_0(f, f2, f3));
        return tonemapDrago;
    }

    public static TonemapDrago createTonemapDrago() {
        TonemapDrago tonemapDrago = new TonemapDrago(Photo.createTonemapDrago_1());
        return tonemapDrago;
    }

    public static TonemapDurand createTonemapDurand(float f, float f2, float f3, float f4, float f5) {
        TonemapDurand tonemapDurand = new TonemapDurand(Photo.createTonemapDurand_0(f, f2, f3, f4, f5));
        return tonemapDurand;
    }

    public static TonemapDurand createTonemapDurand() {
        TonemapDurand tonemapDurand = new TonemapDurand(Photo.createTonemapDurand_1());
        return tonemapDurand;
    }

    public static TonemapMantiuk createTonemapMantiuk(float f, float f2, float f3) {
        TonemapMantiuk tonemapMantiuk = new TonemapMantiuk(Photo.createTonemapMantiuk_0(f, f2, f3));
        return tonemapMantiuk;
    }

    public static TonemapMantiuk createTonemapMantiuk() {
        TonemapMantiuk tonemapMantiuk = new TonemapMantiuk(Photo.createTonemapMantiuk_1());
        return tonemapMantiuk;
    }

    public static TonemapReinhard createTonemapReinhard(float f, float f2, float f3, float f4) {
        TonemapReinhard tonemapReinhard = new TonemapReinhard(Photo.createTonemapReinhard_0(f, f2, f3, f4));
        return tonemapReinhard;
    }

    public static TonemapReinhard createTonemapReinhard() {
        TonemapReinhard tonemapReinhard = new TonemapReinhard(Photo.createTonemapReinhard_1());
        return tonemapReinhard;
    }

    public static void colorChange(Mat mat, Mat mat2, Mat mat3, float f, float f2, float f3) {
        Photo.colorChange_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, f, f2, f3);
    }

    public static void colorChange(Mat mat, Mat mat2, Mat mat3) {
        Photo.colorChange_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void decolor(Mat mat, Mat mat2, Mat mat3) {
        Photo.decolor_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void denoise_TVL1(List<Mat> list, Mat mat, double d, int n) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Photo.denoise_TVL1_0(mat2.nativeObj, mat.nativeObj, d, n);
    }

    public static void denoise_TVL1(List<Mat> list, Mat mat) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Photo.denoise_TVL1_1(mat2.nativeObj, mat.nativeObj);
    }

    public static void detailEnhance(Mat mat, Mat mat2, float f, float f2) {
        Photo.detailEnhance_0(mat.nativeObj, mat2.nativeObj, f, f2);
    }

    public static void detailEnhance(Mat mat, Mat mat2) {
        Photo.detailEnhance_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void edgePreservingFilter(Mat mat, Mat mat2, int n, float f, float f2) {
        Photo.edgePreservingFilter_0(mat.nativeObj, mat2.nativeObj, n, f, f2);
    }

    public static void edgePreservingFilter(Mat mat, Mat mat2) {
        Photo.edgePreservingFilter_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void fastNlMeansDenoising(Mat mat, Mat mat2, float f, int n, int n2) {
        Photo.fastNlMeansDenoising_0(mat.nativeObj, mat2.nativeObj, f, n, n2);
    }

    public static void fastNlMeansDenoising(Mat mat, Mat mat2) {
        Photo.fastNlMeansDenoising_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void fastNlMeansDenoising(Mat mat, Mat mat2, MatOfFloat matOfFloat, int n, int n2, int n3) {
        MatOfFloat matOfFloat2 = matOfFloat;
        Photo.fastNlMeansDenoising_2(mat.nativeObj, mat2.nativeObj, matOfFloat2.nativeObj, n, n2, n3);
    }

    public static void fastNlMeansDenoising(Mat mat, Mat mat2, MatOfFloat matOfFloat) {
        MatOfFloat matOfFloat2 = matOfFloat;
        Photo.fastNlMeansDenoising_3(mat.nativeObj, mat2.nativeObj, matOfFloat2.nativeObj);
    }

    public static void fastNlMeansDenoisingColored(Mat mat, Mat mat2, float f, float f2, int n, int n2) {
        Photo.fastNlMeansDenoisingColored_0(mat.nativeObj, mat2.nativeObj, f, f2, n, n2);
    }

    public static void fastNlMeansDenoisingColored(Mat mat, Mat mat2) {
        Photo.fastNlMeansDenoisingColored_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void fastNlMeansDenoisingColoredMulti(List<Mat> list, Mat mat, int n, int n2, float f, float f2, int n3, int n4) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Photo.fastNlMeansDenoisingColoredMulti_0(mat2.nativeObj, mat.nativeObj, n, n2, f, f2, n3, n4);
    }

    public static void fastNlMeansDenoisingColoredMulti(List<Mat> list, Mat mat, int n, int n2) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Photo.fastNlMeansDenoisingColoredMulti_1(mat2.nativeObj, mat.nativeObj, n, n2);
    }

    public static void fastNlMeansDenoisingMulti(List<Mat> list, Mat mat, int n, int n2, float f, int n3, int n4) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Photo.fastNlMeansDenoisingMulti_0(mat2.nativeObj, mat.nativeObj, n, n2, f, n3, n4);
    }

    public static void fastNlMeansDenoisingMulti(List<Mat> list, Mat mat, int n, int n2) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Photo.fastNlMeansDenoisingMulti_1(mat2.nativeObj, mat.nativeObj, n, n2);
    }

    public static void fastNlMeansDenoisingMulti(List<Mat> list, Mat mat, int n, int n2, MatOfFloat matOfFloat, int n3, int n4, int n5) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        MatOfFloat matOfFloat2 = matOfFloat;
        Photo.fastNlMeansDenoisingMulti_2(mat2.nativeObj, mat.nativeObj, n, n2, matOfFloat2.nativeObj, n3, n4, n5);
    }

    public static void fastNlMeansDenoisingMulti(List<Mat> list, Mat mat, int n, int n2, MatOfFloat matOfFloat) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        MatOfFloat matOfFloat2 = matOfFloat;
        Photo.fastNlMeansDenoisingMulti_3(mat2.nativeObj, mat.nativeObj, n, n2, matOfFloat2.nativeObj);
    }

    public static void illuminationChange(Mat mat, Mat mat2, Mat mat3, float f, float f2) {
        Photo.illuminationChange_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, f, f2);
    }

    public static void illuminationChange(Mat mat, Mat mat2, Mat mat3) {
        Photo.illuminationChange_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void inpaint(Mat mat, Mat mat2, Mat mat3, double d, int n) {
        Photo.inpaint_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, d, n);
    }

    public static void pencilSketch(Mat mat, Mat mat2, Mat mat3, float f, float f2, float f3) {
        Photo.pencilSketch_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, f, f2, f3);
    }

    public static void pencilSketch(Mat mat, Mat mat2, Mat mat3) {
        Photo.pencilSketch_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void seamlessClone(Mat mat, Mat mat2, Mat mat3, Point point, Mat mat4, int n) {
        Photo.seamlessClone_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, point.x, point.y, mat4.nativeObj, n);
    }

    public static void stylization(Mat mat, Mat mat2, float f, float f2) {
        Photo.stylization_0(mat.nativeObj, mat2.nativeObj, f, f2);
    }

    public static void stylization(Mat mat, Mat mat2) {
        Photo.stylization_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void textureFlattening(Mat mat, Mat mat2, Mat mat3, float f, float f2, int n) {
        Photo.textureFlattening_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, f, f2, n);
    }

    public static void textureFlattening(Mat mat, Mat mat2, Mat mat3) {
        Photo.textureFlattening_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    private static native long createAlignMTB_0(int var0, int var1, boolean var2);

    private static native long createAlignMTB_1();

    private static native long createCalibrateDebevec_0(int var0, float var1, boolean var2);

    private static native long createCalibrateDebevec_1();

    private static native long createCalibrateRobertson_0(int var0, float var1);

    private static native long createCalibrateRobertson_1();

    private static native long createMergeDebevec_0();

    private static native long createMergeMertens_0(float var0, float var1, float var2);

    private static native long createMergeMertens_1();

    private static native long createMergeRobertson_0();

    private static native long createTonemap_0(float var0);

    private static native long createTonemap_1();

    private static native long createTonemapDrago_0(float var0, float var1, float var2);

    private static native long createTonemapDrago_1();

    private static native long createTonemapDurand_0(float var0, float var1, float var2, float var3, float var4);

    private static native long createTonemapDurand_1();

    private static native long createTonemapMantiuk_0(float var0, float var1, float var2);

    private static native long createTonemapMantiuk_1();

    private static native long createTonemapReinhard_0(float var0, float var1, float var2, float var3);

    private static native long createTonemapReinhard_1();

    private static native void colorChange_0(long var0, long var2, long var4, float var6, float var7, float var8);

    private static native void colorChange_1(long var0, long var2, long var4);

    private static native void decolor_0(long var0, long var2, long var4);

    private static native void denoise_TVL1_0(long var0, long var2, double var4, int var6);

    private static native void denoise_TVL1_1(long var0, long var2);

    private static native void detailEnhance_0(long var0, long var2, float var4, float var5);

    private static native void detailEnhance_1(long var0, long var2);

    private static native void edgePreservingFilter_0(long var0, long var2, int var4, float var5, float var6);

    private static native void edgePreservingFilter_1(long var0, long var2);

    private static native void fastNlMeansDenoising_0(long var0, long var2, float var4, int var5, int var6);

    private static native void fastNlMeansDenoising_1(long var0, long var2);

    private static native void fastNlMeansDenoising_2(long var0, long var2, long var4, int var6, int var7, int var8);

    private static native void fastNlMeansDenoising_3(long var0, long var2, long var4);

    private static native void fastNlMeansDenoisingColored_0(long var0, long var2, float var4, float var5, int var6, int var7);

    private static native void fastNlMeansDenoisingColored_1(long var0, long var2);

    private static native void fastNlMeansDenoisingColoredMulti_0(long var0, long var2, int var4, int var5, float var6, float var7, int var8, int var9);

    private static native void fastNlMeansDenoisingColoredMulti_1(long var0, long var2, int var4, int var5);

    private static native void fastNlMeansDenoisingMulti_0(long var0, long var2, int var4, int var5, float var6, int var7, int var8);

    private static native void fastNlMeansDenoisingMulti_1(long var0, long var2, int var4, int var5);

    private static native void fastNlMeansDenoisingMulti_2(long var0, long var2, int var4, int var5, long var6, int var8, int var9, int var10);

    private static native void fastNlMeansDenoisingMulti_3(long var0, long var2, int var4, int var5, long var6);

    private static native void illuminationChange_0(long var0, long var2, long var4, float var6, float var7);

    private static native void illuminationChange_1(long var0, long var2, long var4);

    private static native void inpaint_0(long var0, long var2, long var4, double var6, int var8);

    private static native void pencilSketch_0(long var0, long var2, long var4, float var6, float var7, float var8);

    private static native void pencilSketch_1(long var0, long var2, long var4);

    private static native void seamlessClone_0(long var0, long var2, long var4, double var6, double var8, long var10, int var12);

    private static native void stylization_0(long var0, long var2, float var4, float var5);

    private static native void stylization_1(long var0, long var2);

    private static native void textureFlattening_0(long var0, long var2, long var4, float var6, float var7, int var8);

    private static native void textureFlattening_1(long var0, long var2, long var4);
}

