/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ml;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.TermCriteria;
import org.opencv.ml.StatModel;
import org.opencv.utils.Converters;

public class EM
extends StatModel {
    public static final int COV_MAT_SPHERICAL = 0;
    public static final int COV_MAT_DIAGONAL = 1;
    public static final int COV_MAT_GENERIC = 2;
    public static final int COV_MAT_DEFAULT = 1;
    public static final int DEFAULT_NCLUSTERS = 5;
    public static final int DEFAULT_MAX_ITERS = 100;
    public static final int START_E_STEP = 1;
    public static final int START_M_STEP = 2;
    public static final int START_AUTO_STEP = 0;

    protected EM(long l) {
        super(l);
    }

    public Mat getMeans() {
        Mat mat = new Mat(EM.getMeans_0(this.nativeObj));
        return mat;
    }

    public Mat getWeights() {
        Mat mat = new Mat(EM.getWeights_0(this.nativeObj));
        return mat;
    }

    public static EM create() {
        EM eM = new EM(EM.create_0());
        return eM;
    }

    public TermCriteria getTermCriteria() {
        TermCriteria termCriteria = new TermCriteria(EM.getTermCriteria_0(this.nativeObj));
        return termCriteria;
    }

    public double[] predict2(Mat mat, Mat mat2) {
        double[] dArray = EM.predict2_0(this.nativeObj, mat.nativeObj, mat2.nativeObj);
        return dArray;
    }

    public boolean trainE(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7) {
        boolean bl = EM.trainE_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj);
        return bl;
    }

    public boolean trainE(Mat mat, Mat mat2) {
        boolean bl = EM.trainE_1(this.nativeObj, mat.nativeObj, mat2.nativeObj);
        return bl;
    }

    public boolean trainEM(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        boolean bl = EM.trainEM_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
        return bl;
    }

    public boolean trainEM(Mat mat) {
        boolean bl = EM.trainEM_1(this.nativeObj, mat.nativeObj);
        return bl;
    }

    public boolean trainM(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        boolean bl = EM.trainM_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
        return bl;
    }

    public boolean trainM(Mat mat, Mat mat2) {
        boolean bl = EM.trainM_1(this.nativeObj, mat.nativeObj, mat2.nativeObj);
        return bl;
    }

    public int getClustersNumber() {
        int n = EM.getClustersNumber_0(this.nativeObj);
        return n;
    }

    public int getCovarianceMatrixType() {
        int n = EM.getCovarianceMatrixType_0(this.nativeObj);
        return n;
    }

    public void getCovs(List<Mat> list) {
        Mat mat = new Mat();
        EM.getCovs_0(this.nativeObj, mat.nativeObj);
        Converters.Mat_to_vector_Mat(mat, list);
        mat.release();
    }

    public void setClustersNumber(int n) {
        EM.setClustersNumber_0(this.nativeObj, n);
    }

    public void setCovarianceMatrixType(int n) {
        EM.setCovarianceMatrixType_0(this.nativeObj, n);
    }

    public void setTermCriteria(TermCriteria termCriteria) {
        EM.setTermCriteria_0(this.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    @Override
    protected void finalize() throws Throwable {
        EM.delete(this.nativeObj);
    }

    private static native long getMeans_0(long var0);

    private static native long getWeights_0(long var0);

    private static native long create_0();

    private static native double[] getTermCriteria_0(long var0);

    private static native double[] predict2_0(long var0, long var2, long var4);

    private static native boolean trainE_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native boolean trainE_1(long var0, long var2, long var4);

    private static native boolean trainEM_0(long var0, long var2, long var4, long var6, long var8);

    private static native boolean trainEM_1(long var0, long var2);

    private static native boolean trainM_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native boolean trainM_1(long var0, long var2, long var4);

    private static native int getClustersNumber_0(long var0);

    private static native int getCovarianceMatrixType_0(long var0);

    private static native void getCovs_0(long var0, long var2);

    private static native void setClustersNumber_0(long var0, int var2);

    private static native void setCovarianceMatrixType_0(long var0, int var2);

    private static native void setTermCriteria_0(long var0, int var2, int var3, double var4);

    private static native void delete(long var0);
}

