/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.imgproc;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat4;
import org.opencv.core.MatOfFloat6;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.utils.Converters;

public class Subdiv2D {
    protected final long nativeObj;
    public static final int PTLOC_ERROR = -2;
    public static final int PTLOC_OUTSIDE_RECT = -1;
    public static final int PTLOC_INSIDE = 0;
    public static final int PTLOC_VERTEX = 1;
    public static final int PTLOC_ON_EDGE = 2;
    public static final int NEXT_AROUND_ORG = 0;
    public static final int NEXT_AROUND_DST = 34;
    public static final int PREV_AROUND_ORG = 17;
    public static final int PREV_AROUND_DST = 51;
    public static final int NEXT_AROUND_LEFT = 19;
    public static final int NEXT_AROUND_RIGHT = 49;
    public static final int PREV_AROUND_LEFT = 32;
    public static final int PREV_AROUND_RIGHT = 2;

    protected Subdiv2D(long l) {
        this.nativeObj = l;
    }

    public Subdiv2D(Rect rect) {
        this.nativeObj = Subdiv2D.Subdiv2D_0(rect.x, rect.y, rect.width, rect.height);
    }

    public Subdiv2D() {
        this.nativeObj = Subdiv2D.Subdiv2D_1();
    }

    public Point getVertex(int n, int[] nArray) {
        double[] dArray = new double[1];
        Point point = new Point(Subdiv2D.getVertex_0(this.nativeObj, n, dArray));
        if (nArray != null) {
            nArray[0] = (int)dArray[0];
        }
        return point;
    }

    public Point getVertex(int n) {
        Point point = new Point(Subdiv2D.getVertex_1(this.nativeObj, n));
        return point;
    }

    public int edgeDst(int n, Point point) {
        double[] dArray = new double[2];
        int n2 = Subdiv2D.edgeDst_0(this.nativeObj, n, dArray);
        if (point != null) {
            point.x = dArray[0];
            point.y = dArray[1];
        }
        return n2;
    }

    public int edgeDst(int n) {
        int n2 = Subdiv2D.edgeDst_1(this.nativeObj, n);
        return n2;
    }

    public int edgeOrg(int n, Point point) {
        double[] dArray = new double[2];
        int n2 = Subdiv2D.edgeOrg_0(this.nativeObj, n, dArray);
        if (point != null) {
            point.x = dArray[0];
            point.y = dArray[1];
        }
        return n2;
    }

    public int edgeOrg(int n) {
        int n2 = Subdiv2D.edgeOrg_1(this.nativeObj, n);
        return n2;
    }

    public int findNearest(Point point, Point point2) {
        double[] dArray = new double[2];
        int n = Subdiv2D.findNearest_0(this.nativeObj, point.x, point.y, dArray);
        if (point2 != null) {
            point2.x = dArray[0];
            point2.y = dArray[1];
        }
        return n;
    }

    public int findNearest(Point point) {
        int n = Subdiv2D.findNearest_1(this.nativeObj, point.x, point.y);
        return n;
    }

    public int getEdge(int n, int n2) {
        int n3 = Subdiv2D.getEdge_0(this.nativeObj, n, n2);
        return n3;
    }

    public int insert(Point point) {
        int n = Subdiv2D.insert_0(this.nativeObj, point.x, point.y);
        return n;
    }

    public int locate(Point point, int[] nArray, int[] nArray2) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        int n = Subdiv2D.locate_0(this.nativeObj, point.x, point.y, dArray, dArray2);
        if (nArray != null) {
            nArray[0] = (int)dArray[0];
        }
        if (nArray2 != null) {
            nArray2[0] = (int)dArray2[0];
        }
        return n;
    }

    public int nextEdge(int n) {
        int n2 = Subdiv2D.nextEdge_0(this.nativeObj, n);
        return n2;
    }

    public int rotateEdge(int n, int n2) {
        int n3 = Subdiv2D.rotateEdge_0(this.nativeObj, n, n2);
        return n3;
    }

    public int symEdge(int n) {
        int n2 = Subdiv2D.symEdge_0(this.nativeObj, n);
        return n2;
    }

    public void getEdgeList(MatOfFloat4 matOfFloat4) {
        MatOfFloat4 matOfFloat42 = matOfFloat4;
        Subdiv2D.getEdgeList_0(this.nativeObj, matOfFloat42.nativeObj);
    }

    public void getLeadingEdgeList(MatOfInt matOfInt) {
        MatOfInt matOfInt2 = matOfInt;
        Subdiv2D.getLeadingEdgeList_0(this.nativeObj, matOfInt2.nativeObj);
    }

    public void getTriangleList(MatOfFloat6 matOfFloat6) {
        MatOfFloat6 matOfFloat62 = matOfFloat6;
        Subdiv2D.getTriangleList_0(this.nativeObj, matOfFloat62.nativeObj);
    }

    public void getVoronoiFacetList(MatOfInt matOfInt, List<MatOfPoint2f> list, MatOfPoint2f matOfPoint2f) {
        MatOfInt matOfInt2 = matOfInt;
        Mat mat = new Mat();
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Subdiv2D.getVoronoiFacetList_0(this.nativeObj, matOfInt2.nativeObj, mat.nativeObj, matOfPoint2f2.nativeObj);
        Converters.Mat_to_vector_vector_Point2f(mat, list);
        mat.release();
    }

    public void initDelaunay(Rect rect) {
        Subdiv2D.initDelaunay_0(this.nativeObj, rect.x, rect.y, rect.width, rect.height);
    }

    public void insert(MatOfPoint2f matOfPoint2f) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Subdiv2D.insert_1(this.nativeObj, matOfPoint2f2.nativeObj);
    }

    protected void finalize() throws Throwable {
        Subdiv2D.delete(this.nativeObj);
    }

    private static native long Subdiv2D_0(int var0, int var1, int var2, int var3);

    private static native long Subdiv2D_1();

    private static native double[] getVertex_0(long var0, int var2, double[] var3);

    private static native double[] getVertex_1(long var0, int var2);

    private static native int edgeDst_0(long var0, int var2, double[] var3);

    private static native int edgeDst_1(long var0, int var2);

    private static native int edgeOrg_0(long var0, int var2, double[] var3);

    private static native int edgeOrg_1(long var0, int var2);

    private static native int findNearest_0(long var0, double var2, double var4, double[] var6);

    private static native int findNearest_1(long var0, double var2, double var4);

    private static native int getEdge_0(long var0, int var2, int var3);

    private static native int insert_0(long var0, double var2, double var4);

    private static native int locate_0(long var0, double var2, double var4, double[] var6, double[] var7);

    private static native int nextEdge_0(long var0, int var2);

    private static native int rotateEdge_0(long var0, int var2, int var3);

    private static native int symEdge_0(long var0, int var2);

    private static native void getEdgeList_0(long var0, long var2);

    private static native void getLeadingEdgeList_0(long var0, long var2);

    private static native void getTriangleList_0(long var0, long var2);

    private static native void getVoronoiFacetList_0(long var0, long var2, long var4, long var6);

    private static native void initDelaunay_0(long var0, int var2, int var3, int var4, int var5);

    private static native void insert_1(long var0, long var2);

    private static native void delete(long var0);
}

