/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.imgproc;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfInt4;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.RotatedRect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.imgproc.CLAHE;
import org.opencv.imgproc.LineSegmentDetector;
import org.opencv.imgproc.Moments;
import org.opencv.utils.Converters;

public class Imgproc {
    private static final int IPL_BORDER_CONSTANT = 0;
    private static final int IPL_BORDER_REPLICATE = 1;
    private static final int IPL_BORDER_REFLECT = 2;
    private static final int IPL_BORDER_WRAP = 3;
    private static final int IPL_BORDER_REFLECT_101 = 4;
    private static final int IPL_BORDER_TRANSPARENT = 5;
    private static final int CV_INTER_NN = 0;
    private static final int CV_INTER_LINEAR = 1;
    private static final int CV_INTER_CUBIC = 2;
    private static final int CV_INTER_AREA = 3;
    private static final int CV_INTER_LANCZOS4 = 4;
    private static final int CV_MOP_ERODE = 0;
    private static final int CV_MOP_DILATE = 1;
    private static final int CV_MOP_OPEN = 2;
    private static final int CV_MOP_CLOSE = 3;
    private static final int CV_MOP_GRADIENT = 4;
    private static final int CV_MOP_TOPHAT = 5;
    private static final int CV_MOP_BLACKHAT = 6;
    private static final int CV_RETR_EXTERNAL = 0;
    private static final int CV_RETR_LIST = 1;
    private static final int CV_RETR_CCOMP = 2;
    private static final int CV_RETR_TREE = 3;
    private static final int CV_RETR_FLOODFILL = 4;
    private static final int CV_CHAIN_APPROX_NONE = 1;
    private static final int CV_CHAIN_APPROX_SIMPLE = 2;
    private static final int CV_CHAIN_APPROX_TC89_L1 = 3;
    private static final int CV_CHAIN_APPROX_TC89_KCOS = 4;
    private static final int CV_THRESH_BINARY = 0;
    private static final int CV_THRESH_BINARY_INV = 1;
    private static final int CV_THRESH_TRUNC = 2;
    private static final int CV_THRESH_TOZERO = 3;
    private static final int CV_THRESH_TOZERO_INV = 4;
    private static final int CV_THRESH_MASK = 7;
    private static final int CV_THRESH_OTSU = 8;
    private static final int CV_THRESH_TRIANGLE = 16;
    public static final int LINE_AA = 16;
    public static final int LINE_8 = 8;
    public static final int LINE_4 = 4;
    public static final int CV_BLUR_NO_SCALE = 0;
    public static final int CV_BLUR = 1;
    public static final int CV_GAUSSIAN = 2;
    public static final int CV_MEDIAN = 3;
    public static final int CV_BILATERAL = 4;
    public static final int CV_GAUSSIAN_5x5 = 7;
    public static final int CV_SCHARR = -1;
    public static final int CV_MAX_SOBEL_KSIZE = 7;
    public static final int CV_RGBA2mRGBA = 125;
    public static final int CV_mRGBA2RGBA = 126;
    public static final int CV_WARP_FILL_OUTLIERS = 8;
    public static final int CV_WARP_INVERSE_MAP = 16;
    public static final int CV_SHAPE_RECT = 0;
    public static final int CV_SHAPE_CROSS = 1;
    public static final int CV_SHAPE_ELLIPSE = 2;
    public static final int CV_SHAPE_CUSTOM = 100;
    public static final int CV_CHAIN_CODE = 0;
    public static final int CV_LINK_RUNS = 5;
    public static final int CV_POLY_APPROX_DP = 0;
    public static final int CV_CONTOURS_MATCH_I1 = 1;
    public static final int CV_CONTOURS_MATCH_I2 = 2;
    public static final int CV_CONTOURS_MATCH_I3 = 3;
    public static final int CV_CLOCKWISE = 1;
    public static final int CV_COUNTER_CLOCKWISE = 2;
    public static final int CV_COMP_CORREL = 0;
    public static final int CV_COMP_CHISQR = 1;
    public static final int CV_COMP_INTERSECT = 2;
    public static final int CV_COMP_BHATTACHARYYA = 3;
    public static final int CV_COMP_HELLINGER = 3;
    public static final int CV_COMP_CHISQR_ALT = 4;
    public static final int CV_COMP_KL_DIV = 5;
    public static final int CV_DIST_MASK_3 = 3;
    public static final int CV_DIST_MASK_5 = 5;
    public static final int CV_DIST_MASK_PRECISE = 0;
    public static final int CV_DIST_LABEL_CCOMP = 0;
    public static final int CV_DIST_LABEL_PIXEL = 1;
    public static final int CV_DIST_USER = -1;
    public static final int CV_DIST_L1 = 1;
    public static final int CV_DIST_L2 = 2;
    public static final int CV_DIST_C = 3;
    public static final int CV_DIST_L12 = 4;
    public static final int CV_DIST_FAIR = 5;
    public static final int CV_DIST_WELSCH = 6;
    public static final int CV_DIST_HUBER = 7;
    public static final int CV_CANNY_L2_GRADIENT = Integer.MIN_VALUE;
    public static final int CV_HOUGH_STANDARD = 0;
    public static final int CV_HOUGH_PROBABILISTIC = 1;
    public static final int CV_HOUGH_MULTI_SCALE = 2;
    public static final int CV_HOUGH_GRADIENT = 3;
    public static final int MORPH_ERODE = 0;
    public static final int MORPH_DILATE = 1;
    public static final int MORPH_OPEN = 2;
    public static final int MORPH_CLOSE = 3;
    public static final int MORPH_GRADIENT = 4;
    public static final int MORPH_TOPHAT = 5;
    public static final int MORPH_BLACKHAT = 6;
    public static final int MORPH_HITMISS = 7;
    public static final int MORPH_RECT = 0;
    public static final int MORPH_CROSS = 1;
    public static final int MORPH_ELLIPSE = 2;
    public static final int INTER_NEAREST = 0;
    public static final int INTER_LINEAR = 1;
    public static final int INTER_CUBIC = 2;
    public static final int INTER_AREA = 3;
    public static final int INTER_LANCZOS4 = 4;
    public static final int INTER_MAX = 7;
    public static final int WARP_FILL_OUTLIERS = 8;
    public static final int WARP_INVERSE_MAP = 16;
    public static final int INTER_BITS = 5;
    public static final int INTER_BITS2 = 10;
    public static final int INTER_TAB_SIZE = 32;
    public static final int INTER_TAB_SIZE2 = 1024;
    public static final int DIST_USER = -1;
    public static final int DIST_L1 = 1;
    public static final int DIST_L2 = 2;
    public static final int DIST_C = 3;
    public static final int DIST_L12 = 4;
    public static final int DIST_FAIR = 5;
    public static final int DIST_WELSCH = 6;
    public static final int DIST_HUBER = 7;
    public static final int DIST_MASK_3 = 3;
    public static final int DIST_MASK_5 = 5;
    public static final int DIST_MASK_PRECISE = 0;
    public static final int THRESH_BINARY = 0;
    public static final int THRESH_BINARY_INV = 1;
    public static final int THRESH_TRUNC = 2;
    public static final int THRESH_TOZERO = 3;
    public static final int THRESH_TOZERO_INV = 4;
    public static final int THRESH_MASK = 7;
    public static final int THRESH_OTSU = 8;
    public static final int THRESH_TRIANGLE = 16;
    public static final int ADAPTIVE_THRESH_MEAN_C = 0;
    public static final int ADAPTIVE_THRESH_GAUSSIAN_C = 1;
    public static final int PROJ_SPHERICAL_ORTHO = 0;
    public static final int PROJ_SPHERICAL_EQRECT = 1;
    public static final int GC_BGD = 0;
    public static final int GC_FGD = 1;
    public static final int GC_PR_BGD = 2;
    public static final int GC_PR_FGD = 3;
    public static final int GC_INIT_WITH_RECT = 0;
    public static final int GC_INIT_WITH_MASK = 1;
    public static final int GC_EVAL = 2;
    public static final int DIST_LABEL_CCOMP = 0;
    public static final int DIST_LABEL_PIXEL = 1;
    public static final int FLOODFILL_FIXED_RANGE = 65536;
    public static final int FLOODFILL_MASK_ONLY = 131072;
    public static final int CC_STAT_LEFT = 0;
    public static final int CC_STAT_TOP = 1;
    public static final int CC_STAT_WIDTH = 2;
    public static final int CC_STAT_HEIGHT = 3;
    public static final int CC_STAT_AREA = 4;
    public static final int CC_STAT_MAX = 5;
    public static final int CCL_WU = 0;
    public static final int CCL_DEFAULT = -1;
    public static final int CCL_GRANA = 1;
    public static final int RETR_EXTERNAL = 0;
    public static final int RETR_LIST = 1;
    public static final int RETR_CCOMP = 2;
    public static final int RETR_TREE = 3;
    public static final int RETR_FLOODFILL = 4;
    public static final int CHAIN_APPROX_NONE = 1;
    public static final int CHAIN_APPROX_SIMPLE = 2;
    public static final int CHAIN_APPROX_TC89_L1 = 3;
    public static final int CHAIN_APPROX_TC89_KCOS = 4;
    public static final int HOUGH_STANDARD = 0;
    public static final int HOUGH_PROBABILISTIC = 1;
    public static final int HOUGH_MULTI_SCALE = 2;
    public static final int HOUGH_GRADIENT = 3;
    public static final int LSD_REFINE_NONE = 0;
    public static final int LSD_REFINE_STD = 1;
    public static final int LSD_REFINE_ADV = 2;
    public static final int HISTCMP_CORREL = 0;
    public static final int HISTCMP_CHISQR = 1;
    public static final int HISTCMP_INTERSECT = 2;
    public static final int HISTCMP_BHATTACHARYYA = 3;
    public static final int HISTCMP_HELLINGER = 3;
    public static final int HISTCMP_CHISQR_ALT = 4;
    public static final int HISTCMP_KL_DIV = 5;
    public static final int COLOR_BGR2BGRA = 0;
    public static final int COLOR_RGB2RGBA = 0;
    public static final int COLOR_BGRA2BGR = 1;
    public static final int COLOR_RGBA2RGB = 1;
    public static final int COLOR_BGR2RGBA = 2;
    public static final int COLOR_RGB2BGRA = 2;
    public static final int COLOR_RGBA2BGR = 3;
    public static final int COLOR_BGRA2RGB = 3;
    public static final int COLOR_BGR2RGB = 4;
    public static final int COLOR_RGB2BGR = 4;
    public static final int COLOR_BGRA2RGBA = 5;
    public static final int COLOR_RGBA2BGRA = 5;
    public static final int COLOR_BGR2GRAY = 6;
    public static final int COLOR_RGB2GRAY = 7;
    public static final int COLOR_GRAY2BGR = 8;
    public static final int COLOR_GRAY2RGB = 8;
    public static final int COLOR_GRAY2BGRA = 9;
    public static final int COLOR_GRAY2RGBA = 9;
    public static final int COLOR_BGRA2GRAY = 10;
    public static final int COLOR_RGBA2GRAY = 11;
    public static final int COLOR_BGR2BGR565 = 12;
    public static final int COLOR_RGB2BGR565 = 13;
    public static final int COLOR_BGR5652BGR = 14;
    public static final int COLOR_BGR5652RGB = 15;
    public static final int COLOR_BGRA2BGR565 = 16;
    public static final int COLOR_RGBA2BGR565 = 17;
    public static final int COLOR_BGR5652BGRA = 18;
    public static final int COLOR_BGR5652RGBA = 19;
    public static final int COLOR_GRAY2BGR565 = 20;
    public static final int COLOR_BGR5652GRAY = 21;
    public static final int COLOR_BGR2BGR555 = 22;
    public static final int COLOR_RGB2BGR555 = 23;
    public static final int COLOR_BGR5552BGR = 24;
    public static final int COLOR_BGR5552RGB = 25;
    public static final int COLOR_BGRA2BGR555 = 26;
    public static final int COLOR_RGBA2BGR555 = 27;
    public static final int COLOR_BGR5552BGRA = 28;
    public static final int COLOR_BGR5552RGBA = 29;
    public static final int COLOR_GRAY2BGR555 = 30;
    public static final int COLOR_BGR5552GRAY = 31;
    public static final int COLOR_BGR2XYZ = 32;
    public static final int COLOR_RGB2XYZ = 33;
    public static final int COLOR_XYZ2BGR = 34;
    public static final int COLOR_XYZ2RGB = 35;
    public static final int COLOR_BGR2YCrCb = 36;
    public static final int COLOR_RGB2YCrCb = 37;
    public static final int COLOR_YCrCb2BGR = 38;
    public static final int COLOR_YCrCb2RGB = 39;
    public static final int COLOR_BGR2HSV = 40;
    public static final int COLOR_RGB2HSV = 41;
    public static final int COLOR_BGR2Lab = 44;
    public static final int COLOR_RGB2Lab = 45;
    public static final int COLOR_BGR2Luv = 50;
    public static final int COLOR_RGB2Luv = 51;
    public static final int COLOR_BGR2HLS = 52;
    public static final int COLOR_RGB2HLS = 53;
    public static final int COLOR_HSV2BGR = 54;
    public static final int COLOR_HSV2RGB = 55;
    public static final int COLOR_Lab2BGR = 56;
    public static final int COLOR_Lab2RGB = 57;
    public static final int COLOR_Luv2BGR = 58;
    public static final int COLOR_Luv2RGB = 59;
    public static final int COLOR_HLS2BGR = 60;
    public static final int COLOR_HLS2RGB = 61;
    public static final int COLOR_BGR2HSV_FULL = 66;
    public static final int COLOR_RGB2HSV_FULL = 67;
    public static final int COLOR_BGR2HLS_FULL = 68;
    public static final int COLOR_RGB2HLS_FULL = 69;
    public static final int COLOR_HSV2BGR_FULL = 70;
    public static final int COLOR_HSV2RGB_FULL = 71;
    public static final int COLOR_HLS2BGR_FULL = 72;
    public static final int COLOR_HLS2RGB_FULL = 73;
    public static final int COLOR_LBGR2Lab = 74;
    public static final int COLOR_LRGB2Lab = 75;
    public static final int COLOR_LBGR2Luv = 76;
    public static final int COLOR_LRGB2Luv = 77;
    public static final int COLOR_Lab2LBGR = 78;
    public static final int COLOR_Lab2LRGB = 79;
    public static final int COLOR_Luv2LBGR = 80;
    public static final int COLOR_Luv2LRGB = 81;
    public static final int COLOR_BGR2YUV = 82;
    public static final int COLOR_RGB2YUV = 83;
    public static final int COLOR_YUV2BGR = 84;
    public static final int COLOR_YUV2RGB = 85;
    public static final int COLOR_YUV2RGB_NV12 = 90;
    public static final int COLOR_YUV2BGR_NV12 = 91;
    public static final int COLOR_YUV2RGB_NV21 = 92;
    public static final int COLOR_YUV2BGR_NV21 = 93;
    public static final int COLOR_YUV420sp2RGB = 92;
    public static final int COLOR_YUV420sp2BGR = 93;
    public static final int COLOR_YUV2RGBA_NV12 = 94;
    public static final int COLOR_YUV2BGRA_NV12 = 95;
    public static final int COLOR_YUV2RGBA_NV21 = 96;
    public static final int COLOR_YUV2BGRA_NV21 = 97;
    public static final int COLOR_YUV420sp2RGBA = 96;
    public static final int COLOR_YUV420sp2BGRA = 97;
    public static final int COLOR_YUV2RGB_YV12 = 98;
    public static final int COLOR_YUV2BGR_YV12 = 99;
    public static final int COLOR_YUV2RGB_IYUV = 100;
    public static final int COLOR_YUV2BGR_IYUV = 101;
    public static final int COLOR_YUV2RGB_I420 = 100;
    public static final int COLOR_YUV2BGR_I420 = 101;
    public static final int COLOR_YUV420p2RGB = 98;
    public static final int COLOR_YUV420p2BGR = 99;
    public static final int COLOR_YUV2RGBA_YV12 = 102;
    public static final int COLOR_YUV2BGRA_YV12 = 103;
    public static final int COLOR_YUV2RGBA_IYUV = 104;
    public static final int COLOR_YUV2BGRA_IYUV = 105;
    public static final int COLOR_YUV2RGBA_I420 = 104;
    public static final int COLOR_YUV2BGRA_I420 = 105;
    public static final int COLOR_YUV420p2RGBA = 102;
    public static final int COLOR_YUV420p2BGRA = 103;
    public static final int COLOR_YUV2GRAY_420 = 106;
    public static final int COLOR_YUV2GRAY_NV21 = 106;
    public static final int COLOR_YUV2GRAY_NV12 = 106;
    public static final int COLOR_YUV2GRAY_YV12 = 106;
    public static final int COLOR_YUV2GRAY_IYUV = 106;
    public static final int COLOR_YUV2GRAY_I420 = 106;
    public static final int COLOR_YUV420sp2GRAY = 106;
    public static final int COLOR_YUV420p2GRAY = 106;
    public static final int COLOR_YUV2RGB_UYVY = 107;
    public static final int COLOR_YUV2BGR_UYVY = 108;
    public static final int COLOR_YUV2RGB_Y422 = 107;
    public static final int COLOR_YUV2BGR_Y422 = 108;
    public static final int COLOR_YUV2RGB_UYNV = 107;
    public static final int COLOR_YUV2BGR_UYNV = 108;
    public static final int COLOR_YUV2RGBA_UYVY = 111;
    public static final int COLOR_YUV2BGRA_UYVY = 112;
    public static final int COLOR_YUV2RGBA_Y422 = 111;
    public static final int COLOR_YUV2BGRA_Y422 = 112;
    public static final int COLOR_YUV2RGBA_UYNV = 111;
    public static final int COLOR_YUV2BGRA_UYNV = 112;
    public static final int COLOR_YUV2RGB_YUY2 = 115;
    public static final int COLOR_YUV2BGR_YUY2 = 116;
    public static final int COLOR_YUV2RGB_YVYU = 117;
    public static final int COLOR_YUV2BGR_YVYU = 118;
    public static final int COLOR_YUV2RGB_YUYV = 115;
    public static final int COLOR_YUV2BGR_YUYV = 116;
    public static final int COLOR_YUV2RGB_YUNV = 115;
    public static final int COLOR_YUV2BGR_YUNV = 116;
    public static final int COLOR_YUV2RGBA_YUY2 = 119;
    public static final int COLOR_YUV2BGRA_YUY2 = 120;
    public static final int COLOR_YUV2RGBA_YVYU = 121;
    public static final int COLOR_YUV2BGRA_YVYU = 122;
    public static final int COLOR_YUV2RGBA_YUYV = 119;
    public static final int COLOR_YUV2BGRA_YUYV = 120;
    public static final int COLOR_YUV2RGBA_YUNV = 119;
    public static final int COLOR_YUV2BGRA_YUNV = 120;
    public static final int COLOR_YUV2GRAY_UYVY = 123;
    public static final int COLOR_YUV2GRAY_YUY2 = 124;
    public static final int COLOR_YUV2GRAY_Y422 = 123;
    public static final int COLOR_YUV2GRAY_UYNV = 123;
    public static final int COLOR_YUV2GRAY_YVYU = 124;
    public static final int COLOR_YUV2GRAY_YUYV = 124;
    public static final int COLOR_YUV2GRAY_YUNV = 124;
    public static final int COLOR_RGBA2mRGBA = 125;
    public static final int COLOR_mRGBA2RGBA = 126;
    public static final int COLOR_RGB2YUV_I420 = 127;
    public static final int COLOR_BGR2YUV_I420 = 128;
    public static final int COLOR_RGB2YUV_IYUV = 127;
    public static final int COLOR_BGR2YUV_IYUV = 128;
    public static final int COLOR_RGBA2YUV_I420 = 129;
    public static final int COLOR_BGRA2YUV_I420 = 130;
    public static final int COLOR_RGBA2YUV_IYUV = 129;
    public static final int COLOR_BGRA2YUV_IYUV = 130;
    public static final int COLOR_RGB2YUV_YV12 = 131;
    public static final int COLOR_BGR2YUV_YV12 = 132;
    public static final int COLOR_RGBA2YUV_YV12 = 133;
    public static final int COLOR_BGRA2YUV_YV12 = 134;
    public static final int COLOR_BayerBG2BGR = 46;
    public static final int COLOR_BayerGB2BGR = 47;
    public static final int COLOR_BayerRG2BGR = 48;
    public static final int COLOR_BayerGR2BGR = 49;
    public static final int COLOR_BayerBG2RGB = 48;
    public static final int COLOR_BayerGB2RGB = 49;
    public static final int COLOR_BayerRG2RGB = 46;
    public static final int COLOR_BayerGR2RGB = 47;
    public static final int COLOR_BayerBG2GRAY = 86;
    public static final int COLOR_BayerGB2GRAY = 87;
    public static final int COLOR_BayerRG2GRAY = 88;
    public static final int COLOR_BayerGR2GRAY = 89;
    public static final int COLOR_BayerBG2BGR_VNG = 62;
    public static final int COLOR_BayerGB2BGR_VNG = 63;
    public static final int COLOR_BayerRG2BGR_VNG = 64;
    public static final int COLOR_BayerGR2BGR_VNG = 65;
    public static final int COLOR_BayerBG2RGB_VNG = 64;
    public static final int COLOR_BayerGB2RGB_VNG = 65;
    public static final int COLOR_BayerRG2RGB_VNG = 62;
    public static final int COLOR_BayerGR2RGB_VNG = 63;
    public static final int COLOR_BayerBG2BGR_EA = 135;
    public static final int COLOR_BayerGB2BGR_EA = 136;
    public static final int COLOR_BayerRG2BGR_EA = 137;
    public static final int COLOR_BayerGR2BGR_EA = 138;
    public static final int COLOR_BayerBG2RGB_EA = 137;
    public static final int COLOR_BayerGB2RGB_EA = 138;
    public static final int COLOR_BayerRG2RGB_EA = 135;
    public static final int COLOR_BayerGR2RGB_EA = 136;
    public static final int COLOR_COLORCVT_MAX = 139;
    public static final int INTERSECT_NONE = 0;
    public static final int INTERSECT_PARTIAL = 1;
    public static final int INTERSECT_FULL = 2;
    public static final int TM_SQDIFF = 0;
    public static final int TM_SQDIFF_NORMED = 1;
    public static final int TM_CCORR = 2;
    public static final int TM_CCORR_NORMED = 3;
    public static final int TM_CCOEFF = 4;
    public static final int TM_CCOEFF_NORMED = 5;
    public static final int COLORMAP_AUTUMN = 0;
    public static final int COLORMAP_BONE = 1;
    public static final int COLORMAP_JET = 2;
    public static final int COLORMAP_WINTER = 3;
    public static final int COLORMAP_RAINBOW = 4;
    public static final int COLORMAP_OCEAN = 5;
    public static final int COLORMAP_SUMMER = 6;
    public static final int COLORMAP_SPRING = 7;
    public static final int COLORMAP_COOL = 8;
    public static final int COLORMAP_HSV = 9;
    public static final int COLORMAP_PINK = 10;
    public static final int COLORMAP_HOT = 11;
    public static final int COLORMAP_PARULA = 12;
    public static final int MARKER_CROSS = 0;
    public static final int MARKER_TILTED_CROSS = 1;
    public static final int MARKER_STAR = 2;
    public static final int MARKER_DIAMOND = 3;
    public static final int MARKER_SQUARE = 4;
    public static final int MARKER_TRIANGLE_UP = 5;
    public static final int MARKER_TRIANGLE_DOWN = 6;

    public static Mat getAffineTransform(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Mat mat = new Mat(Imgproc.getAffineTransform_0(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj));
        return mat;
    }

    public static Mat getDefaultNewCameraMatrix(Mat mat, Size size, boolean bl) {
        Mat mat2 = new Mat(Imgproc.getDefaultNewCameraMatrix_0(mat.nativeObj, size.width, size.height, bl));
        return mat2;
    }

    public static Mat getDefaultNewCameraMatrix(Mat mat) {
        Mat mat2 = new Mat(Imgproc.getDefaultNewCameraMatrix_1(mat.nativeObj));
        return mat2;
    }

    public static Mat getGaborKernel(Size size, double d, double d2, double d3, double d4, double d5, int n) {
        Mat mat = new Mat(Imgproc.getGaborKernel_0(size.width, size.height, d, d2, d3, d4, d5, n));
        return mat;
    }

    public static Mat getGaborKernel(Size size, double d, double d2, double d3, double d4) {
        Mat mat = new Mat(Imgproc.getGaborKernel_1(size.width, size.height, d, d2, d3, d4));
        return mat;
    }

    public static Mat getGaussianKernel(int n, double d, int n2) {
        Mat mat = new Mat(Imgproc.getGaussianKernel_0(n, d, n2));
        return mat;
    }

    public static Mat getGaussianKernel(int n, double d) {
        Mat mat = new Mat(Imgproc.getGaussianKernel_1(n, d));
        return mat;
    }

    public static Mat getPerspectiveTransform(Mat mat, Mat mat2) {
        Mat mat3 = new Mat(Imgproc.getPerspectiveTransform_0(mat.nativeObj, mat2.nativeObj));
        return mat3;
    }

    public static Mat getRotationMatrix2D(Point point, double d, double d2) {
        Mat mat = new Mat(Imgproc.getRotationMatrix2D_0(point.x, point.y, d, d2));
        return mat;
    }

    public static Mat getStructuringElement(int n, Size size, Point point) {
        Mat mat = new Mat(Imgproc.getStructuringElement_0(n, size.width, size.height, point.x, point.y));
        return mat;
    }

    public static Mat getStructuringElement(int n, Size size) {
        Mat mat = new Mat(Imgproc.getStructuringElement_1(n, size.width, size.height));
        return mat;
    }

    public static Moments moments(Mat mat, boolean bl) {
        Moments moments = new Moments(Imgproc.moments_0(mat.nativeObj, bl));
        return moments;
    }

    public static Moments moments(Mat mat) {
        Moments moments = new Moments(Imgproc.moments_1(mat.nativeObj));
        return moments;
    }

    public static Point phaseCorrelate(Mat mat, Mat mat2, Mat mat3, double[] dArray) {
        double[] dArray2 = new double[1];
        Point point = new Point(Imgproc.phaseCorrelate_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, dArray2));
        if (dArray != null) {
            dArray[0] = dArray2[0];
        }
        return point;
    }

    public static Point phaseCorrelate(Mat mat, Mat mat2) {
        Point point = new Point(Imgproc.phaseCorrelate_1(mat.nativeObj, mat2.nativeObj));
        return point;
    }

    public static CLAHE createCLAHE(double d, Size size) {
        CLAHE cLAHE = new CLAHE(Imgproc.createCLAHE_0(d, size.width, size.height));
        return cLAHE;
    }

    public static CLAHE createCLAHE() {
        CLAHE cLAHE = new CLAHE(Imgproc.createCLAHE_1());
        return cLAHE;
    }

    public static LineSegmentDetector createLineSegmentDetector(int n, double d, double d2, double d3, double d4, double d5, double d6, int n2) {
        LineSegmentDetector lineSegmentDetector = new LineSegmentDetector(Imgproc.createLineSegmentDetector_0(n, d, d2, d3, d4, d5, d6, n2));
        return lineSegmentDetector;
    }

    public static LineSegmentDetector createLineSegmentDetector() {
        LineSegmentDetector lineSegmentDetector = new LineSegmentDetector(Imgproc.createLineSegmentDetector_1());
        return lineSegmentDetector;
    }

    public static Rect boundingRect(MatOfPoint matOfPoint) {
        MatOfPoint matOfPoint2 = matOfPoint;
        Rect rect = new Rect(Imgproc.boundingRect_0(matOfPoint2.nativeObj));
        return rect;
    }

    public static RotatedRect fitEllipse(MatOfPoint2f matOfPoint2f) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        RotatedRect rotatedRect = new RotatedRect(Imgproc.fitEllipse_0(matOfPoint2f2.nativeObj));
        return rotatedRect;
    }

    public static RotatedRect minAreaRect(MatOfPoint2f matOfPoint2f) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        RotatedRect rotatedRect = new RotatedRect(Imgproc.minAreaRect_0(matOfPoint2f2.nativeObj));
        return rotatedRect;
    }

    public static boolean clipLine(Rect rect, Point point, Point point2) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        boolean bl = Imgproc.clipLine_0(rect.x, rect.y, rect.width, rect.height, point.x, point.y, dArray, point2.x, point2.y, dArray2);
        if (point != null) {
            point.x = dArray[0];
            point.y = dArray[1];
        }
        if (point2 != null) {
            point2.x = dArray2[0];
            point2.y = dArray2[1];
        }
        return bl;
    }

    public static boolean isContourConvex(MatOfPoint matOfPoint) {
        MatOfPoint matOfPoint2 = matOfPoint;
        boolean bl = Imgproc.isContourConvex_0(matOfPoint2.nativeObj);
        return bl;
    }

    public static double arcLength(MatOfPoint2f matOfPoint2f, boolean bl) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        double d = Imgproc.arcLength_0(matOfPoint2f2.nativeObj, bl);
        return d;
    }

    public static double compareHist(Mat mat, Mat mat2, int n) {
        double d = Imgproc.compareHist_0(mat.nativeObj, mat2.nativeObj, n);
        return d;
    }

    public static double contourArea(Mat mat, boolean bl) {
        double d = Imgproc.contourArea_0(mat.nativeObj, bl);
        return d;
    }

    public static double contourArea(Mat mat) {
        double d = Imgproc.contourArea_1(mat.nativeObj);
        return d;
    }

    public static double matchShapes(Mat mat, Mat mat2, int n, double d) {
        double d2 = Imgproc.matchShapes_0(mat.nativeObj, mat2.nativeObj, n, d);
        return d2;
    }

    public static double minEnclosingTriangle(Mat mat, Mat mat2) {
        double d = Imgproc.minEnclosingTriangle_0(mat.nativeObj, mat2.nativeObj);
        return d;
    }

    public static double pointPolygonTest(MatOfPoint2f matOfPoint2f, Point point, boolean bl) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        double d = Imgproc.pointPolygonTest_0(matOfPoint2f2.nativeObj, point.x, point.y, bl);
        return d;
    }

    public static double threshold(Mat mat, Mat mat2, double d, double d2, int n) {
        double d3 = Imgproc.threshold_0(mat.nativeObj, mat2.nativeObj, d, d2, n);
        return d3;
    }

    public static float initWideAngleProjMap(Mat mat, Mat mat2, Size size, int n, int n2, Mat mat3, Mat mat4, int n3, double d) {
        float f = Imgproc.initWideAngleProjMap_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, n, n2, mat3.nativeObj, mat4.nativeObj, n3, d);
        return f;
    }

    public static float initWideAngleProjMap(Mat mat, Mat mat2, Size size, int n, int n2, Mat mat3, Mat mat4) {
        float f = Imgproc.initWideAngleProjMap_1(mat.nativeObj, mat2.nativeObj, size.width, size.height, n, n2, mat3.nativeObj, mat4.nativeObj);
        return f;
    }

    public static float intersectConvexConvex(Mat mat, Mat mat2, Mat mat3, boolean bl) {
        float f = Imgproc.intersectConvexConvex_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, bl);
        return f;
    }

    public static float intersectConvexConvex(Mat mat, Mat mat2, Mat mat3) {
        float f = Imgproc.intersectConvexConvex_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
        return f;
    }

    public static int connectedComponentsWithAlgorithm(Mat mat, Mat mat2, int n, int n2, int n3) {
        int n4 = Imgproc.connectedComponentsWithAlgorithm_0(mat.nativeObj, mat2.nativeObj, n, n2, n3);
        return n4;
    }

    public static int connectedComponents(Mat mat, Mat mat2, int n, int n2) {
        int n3 = Imgproc.connectedComponents_0(mat.nativeObj, mat2.nativeObj, n, n2);
        return n3;
    }

    public static int connectedComponents(Mat mat, Mat mat2) {
        int n = Imgproc.connectedComponents_1(mat.nativeObj, mat2.nativeObj);
        return n;
    }

    public static int connectedComponentsWithStatsWithAlgorithm(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n, int n2, int n3) {
        int n4 = Imgproc.connectedComponentsWithStatsWithAlgorithm_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n, n2, n3);
        return n4;
    }

    public static int connectedComponentsWithStats(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n, int n2) {
        int n3 = Imgproc.connectedComponentsWithStats_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n, n2);
        return n3;
    }

    public static int connectedComponentsWithStats(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        int n = Imgproc.connectedComponentsWithStats_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
        return n;
    }

    public static int floodFill(Mat mat, Mat mat2, Point point, Scalar scalar, Rect rect, Scalar scalar2, Scalar scalar3, int n) {
        double[] dArray = new double[4];
        int n2 = Imgproc.floodFill_0(mat.nativeObj, mat2.nativeObj, point.x, point.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], dArray, scalar2.val[0], scalar2.val[1], scalar2.val[2], scalar2.val[3], scalar3.val[0], scalar3.val[1], scalar3.val[2], scalar3.val[3], n);
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        return n2;
    }

    public static int floodFill(Mat mat, Mat mat2, Point point, Scalar scalar) {
        int n = Imgproc.floodFill_1(mat.nativeObj, mat2.nativeObj, point.x, point.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
        return n;
    }

    public static int rotatedRectangleIntersection(RotatedRect rotatedRect, RotatedRect rotatedRect2, Mat mat) {
        int n = Imgproc.rotatedRectangleIntersection_0(rotatedRect.center.x, rotatedRect.center.y, rotatedRect.size.width, rotatedRect.size.height, rotatedRect.angle, rotatedRect2.center.x, rotatedRect2.center.y, rotatedRect2.size.width, rotatedRect2.size.height, rotatedRect2.angle, mat.nativeObj);
        return n;
    }

    public static void Canny(Mat mat, Mat mat2, Mat mat3, double d, double d2, boolean bl) {
        Imgproc.Canny_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, d, d2, bl);
    }

    public static void Canny(Mat mat, Mat mat2, Mat mat3, double d, double d2) {
        Imgproc.Canny_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, d, d2);
    }

    public static void Canny(Mat mat, Mat mat2, double d, double d2, int n, boolean bl) {
        Imgproc.Canny_2(mat.nativeObj, mat2.nativeObj, d, d2, n, bl);
    }

    public static void Canny(Mat mat, Mat mat2, double d, double d2) {
        Imgproc.Canny_3(mat.nativeObj, mat2.nativeObj, d, d2);
    }

    public static void GaussianBlur(Mat mat, Mat mat2, Size size, double d, double d2, int n) {
        Imgproc.GaussianBlur_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, d, d2, n);
    }

    public static void GaussianBlur(Mat mat, Mat mat2, Size size, double d, double d2) {
        Imgproc.GaussianBlur_1(mat.nativeObj, mat2.nativeObj, size.width, size.height, d, d2);
    }

    public static void GaussianBlur(Mat mat, Mat mat2, Size size, double d) {
        Imgproc.GaussianBlur_2(mat.nativeObj, mat2.nativeObj, size.width, size.height, d);
    }

    public static void HoughCircles(Mat mat, Mat mat2, int n, double d, double d2, double d3, double d4, int n2, int n3) {
        Imgproc.HoughCircles_0(mat.nativeObj, mat2.nativeObj, n, d, d2, d3, d4, n2, n3);
    }

    public static void HoughCircles(Mat mat, Mat mat2, int n, double d, double d2) {
        Imgproc.HoughCircles_1(mat.nativeObj, mat2.nativeObj, n, d, d2);
    }

    public static void HoughLines(Mat mat, Mat mat2, double d, double d2, int n, double d3, double d4, double d5, double d6) {
        Imgproc.HoughLines_0(mat.nativeObj, mat2.nativeObj, d, d2, n, d3, d4, d5, d6);
    }

    public static void HoughLines(Mat mat, Mat mat2, double d, double d2, int n) {
        Imgproc.HoughLines_1(mat.nativeObj, mat2.nativeObj, d, d2, n);
    }

    public static void HoughLinesP(Mat mat, Mat mat2, double d, double d2, int n, double d3, double d4) {
        Imgproc.HoughLinesP_0(mat.nativeObj, mat2.nativeObj, d, d2, n, d3, d4);
    }

    public static void HoughLinesP(Mat mat, Mat mat2, double d, double d2, int n) {
        Imgproc.HoughLinesP_1(mat.nativeObj, mat2.nativeObj, d, d2, n);
    }

    public static void HuMoments(Moments moments, Mat mat) {
        Imgproc.HuMoments_0(moments.m00, moments.m10, moments.m01, moments.m20, moments.m11, moments.m02, moments.m30, moments.m21, moments.m12, moments.m03, mat.nativeObj);
    }

    public static void Laplacian(Mat mat, Mat mat2, int n, int n2, double d, double d2, int n3) {
        Imgproc.Laplacian_0(mat.nativeObj, mat2.nativeObj, n, n2, d, d2, n3);
    }

    public static void Laplacian(Mat mat, Mat mat2, int n, int n2, double d, double d2) {
        Imgproc.Laplacian_1(mat.nativeObj, mat2.nativeObj, n, n2, d, d2);
    }

    public static void Laplacian(Mat mat, Mat mat2, int n) {
        Imgproc.Laplacian_2(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void Scharr(Mat mat, Mat mat2, int n, int n2, int n3, double d, double d2, int n4) {
        Imgproc.Scharr_0(mat.nativeObj, mat2.nativeObj, n, n2, n3, d, d2, n4);
    }

    public static void Scharr(Mat mat, Mat mat2, int n, int n2, int n3, double d, double d2) {
        Imgproc.Scharr_1(mat.nativeObj, mat2.nativeObj, n, n2, n3, d, d2);
    }

    public static void Scharr(Mat mat, Mat mat2, int n, int n2, int n3) {
        Imgproc.Scharr_2(mat.nativeObj, mat2.nativeObj, n, n2, n3);
    }

    public static void Sobel(Mat mat, Mat mat2, int n, int n2, int n3, int n4, double d, double d2, int n5) {
        Imgproc.Sobel_0(mat.nativeObj, mat2.nativeObj, n, n2, n3, n4, d, d2, n5);
    }

    public static void Sobel(Mat mat, Mat mat2, int n, int n2, int n3, int n4, double d, double d2) {
        Imgproc.Sobel_1(mat.nativeObj, mat2.nativeObj, n, n2, n3, n4, d, d2);
    }

    public static void Sobel(Mat mat, Mat mat2, int n, int n2, int n3) {
        Imgproc.Sobel_2(mat.nativeObj, mat2.nativeObj, n, n2, n3);
    }

    public static void accumulate(Mat mat, Mat mat2, Mat mat3) {
        Imgproc.accumulate_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void accumulate(Mat mat, Mat mat2) {
        Imgproc.accumulate_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void accumulateProduct(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Imgproc.accumulateProduct_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void accumulateProduct(Mat mat, Mat mat2, Mat mat3) {
        Imgproc.accumulateProduct_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void accumulateSquare(Mat mat, Mat mat2, Mat mat3) {
        Imgproc.accumulateSquare_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void accumulateSquare(Mat mat, Mat mat2) {
        Imgproc.accumulateSquare_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void accumulateWeighted(Mat mat, Mat mat2, double d, Mat mat3) {
        Imgproc.accumulateWeighted_0(mat.nativeObj, mat2.nativeObj, d, mat3.nativeObj);
    }

    public static void accumulateWeighted(Mat mat, Mat mat2, double d) {
        Imgproc.accumulateWeighted_1(mat.nativeObj, mat2.nativeObj, d);
    }

    public static void adaptiveThreshold(Mat mat, Mat mat2, double d, int n, int n2, int n3, double d2) {
        Imgproc.adaptiveThreshold_0(mat.nativeObj, mat2.nativeObj, d, n, n2, n3, d2);
    }

    public static void applyColorMap(Mat mat, Mat mat2, int n) {
        Imgproc.applyColorMap_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void approxPolyDP(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, double d, boolean bl) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Imgproc.approxPolyDP_0(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, d, bl);
    }

    public static void arrowedLine(Mat mat, Point point, Point point2, Scalar scalar, int n, int n2, int n3, double d) {
        Imgproc.arrowedLine_0(mat.nativeObj, point.x, point.y, point2.x, point2.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n, n2, n3, d);
    }

    public static void arrowedLine(Mat mat, Point point, Point point2, Scalar scalar) {
        Imgproc.arrowedLine_1(mat.nativeObj, point.x, point.y, point2.x, point2.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void bilateralFilter(Mat mat, Mat mat2, int n, double d, double d2, int n2) {
        Imgproc.bilateralFilter_0(mat.nativeObj, mat2.nativeObj, n, d, d2, n2);
    }

    public static void bilateralFilter(Mat mat, Mat mat2, int n, double d, double d2) {
        Imgproc.bilateralFilter_1(mat.nativeObj, mat2.nativeObj, n, d, d2);
    }

    public static void blur(Mat mat, Mat mat2, Size size, Point point, int n) {
        Imgproc.blur_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, point.x, point.y, n);
    }

    public static void blur(Mat mat, Mat mat2, Size size, Point point) {
        Imgproc.blur_1(mat.nativeObj, mat2.nativeObj, size.width, size.height, point.x, point.y);
    }

    public static void blur(Mat mat, Mat mat2, Size size) {
        Imgproc.blur_2(mat.nativeObj, mat2.nativeObj, size.width, size.height);
    }

    public static void boxFilter(Mat mat, Mat mat2, int n, Size size, Point point, boolean bl, int n2) {
        Imgproc.boxFilter_0(mat.nativeObj, mat2.nativeObj, n, size.width, size.height, point.x, point.y, bl, n2);
    }

    public static void boxFilter(Mat mat, Mat mat2, int n, Size size, Point point, boolean bl) {
        Imgproc.boxFilter_1(mat.nativeObj, mat2.nativeObj, n, size.width, size.height, point.x, point.y, bl);
    }

    public static void boxFilter(Mat mat, Mat mat2, int n, Size size) {
        Imgproc.boxFilter_2(mat.nativeObj, mat2.nativeObj, n, size.width, size.height);
    }

    public static void boxPoints(RotatedRect rotatedRect, Mat mat) {
        Imgproc.boxPoints_0(rotatedRect.center.x, rotatedRect.center.y, rotatedRect.size.width, rotatedRect.size.height, rotatedRect.angle, mat.nativeObj);
    }

    public static void calcBackProject(List<Mat> list, MatOfInt matOfInt, Mat mat, Mat mat2, MatOfFloat matOfFloat, double d) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        MatOfInt matOfInt2 = matOfInt;
        MatOfFloat matOfFloat2 = matOfFloat;
        Imgproc.calcBackProject_0(mat3.nativeObj, matOfInt2.nativeObj, mat.nativeObj, mat2.nativeObj, matOfFloat2.nativeObj, d);
    }

    public static void calcHist(List<Mat> list, MatOfInt matOfInt, Mat mat, Mat mat2, MatOfInt matOfInt2, MatOfFloat matOfFloat, boolean bl) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        MatOfInt matOfInt3 = matOfInt;
        MatOfInt matOfInt4 = matOfInt2;
        MatOfFloat matOfFloat2 = matOfFloat;
        Imgproc.calcHist_0(mat3.nativeObj, matOfInt3.nativeObj, mat.nativeObj, mat2.nativeObj, matOfInt4.nativeObj, matOfFloat2.nativeObj, bl);
    }

    public static void calcHist(List<Mat> list, MatOfInt matOfInt, Mat mat, Mat mat2, MatOfInt matOfInt2, MatOfFloat matOfFloat) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        MatOfInt matOfInt3 = matOfInt;
        MatOfInt matOfInt4 = matOfInt2;
        MatOfFloat matOfFloat2 = matOfFloat;
        Imgproc.calcHist_1(mat3.nativeObj, matOfInt3.nativeObj, mat.nativeObj, mat2.nativeObj, matOfInt4.nativeObj, matOfFloat2.nativeObj);
    }

    public static void circle(Mat mat, Point point, int n, Scalar scalar, int n2, int n3, int n4) {
        Imgproc.circle_0(mat.nativeObj, point.x, point.y, n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n2, n3, n4);
    }

    public static void circle(Mat mat, Point point, int n, Scalar scalar, int n2) {
        Imgproc.circle_1(mat.nativeObj, point.x, point.y, n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n2);
    }

    public static void circle(Mat mat, Point point, int n, Scalar scalar) {
        Imgproc.circle_2(mat.nativeObj, point.x, point.y, n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void convertMaps(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n, boolean bl) {
        Imgproc.convertMaps_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n, bl);
    }

    public static void convertMaps(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n) {
        Imgproc.convertMaps_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n);
    }

    public static void convexHull(MatOfPoint matOfPoint, MatOfInt matOfInt, boolean bl) {
        MatOfPoint matOfPoint2 = matOfPoint;
        MatOfInt matOfInt2 = matOfInt;
        Imgproc.convexHull_0(matOfPoint2.nativeObj, matOfInt2.nativeObj, bl);
    }

    public static void convexHull(MatOfPoint matOfPoint, MatOfInt matOfInt) {
        MatOfPoint matOfPoint2 = matOfPoint;
        MatOfInt matOfInt2 = matOfInt;
        Imgproc.convexHull_1(matOfPoint2.nativeObj, matOfInt2.nativeObj);
    }

    public static void convexityDefects(MatOfPoint matOfPoint, MatOfInt matOfInt, MatOfInt4 matOfInt4) {
        MatOfPoint matOfPoint2 = matOfPoint;
        MatOfInt matOfInt2 = matOfInt;
        MatOfInt4 matOfInt42 = matOfInt4;
        Imgproc.convexityDefects_0(matOfPoint2.nativeObj, matOfInt2.nativeObj, matOfInt42.nativeObj);
    }

    public static void cornerEigenValsAndVecs(Mat mat, Mat mat2, int n, int n2, int n3) {
        Imgproc.cornerEigenValsAndVecs_0(mat.nativeObj, mat2.nativeObj, n, n2, n3);
    }

    public static void cornerEigenValsAndVecs(Mat mat, Mat mat2, int n, int n2) {
        Imgproc.cornerEigenValsAndVecs_1(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void cornerHarris(Mat mat, Mat mat2, int n, int n2, double d, int n3) {
        Imgproc.cornerHarris_0(mat.nativeObj, mat2.nativeObj, n, n2, d, n3);
    }

    public static void cornerHarris(Mat mat, Mat mat2, int n, int n2, double d) {
        Imgproc.cornerHarris_1(mat.nativeObj, mat2.nativeObj, n, n2, d);
    }

    public static void cornerMinEigenVal(Mat mat, Mat mat2, int n, int n2, int n3) {
        Imgproc.cornerMinEigenVal_0(mat.nativeObj, mat2.nativeObj, n, n2, n3);
    }

    public static void cornerMinEigenVal(Mat mat, Mat mat2, int n, int n2) {
        Imgproc.cornerMinEigenVal_1(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void cornerMinEigenVal(Mat mat, Mat mat2, int n) {
        Imgproc.cornerMinEigenVal_2(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void cornerSubPix(Mat mat, MatOfPoint2f matOfPoint2f, Size size, Size size2, TermCriteria termCriteria) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Imgproc.cornerSubPix_0(mat.nativeObj, matOfPoint2f2.nativeObj, size.width, size.height, size2.width, size2.height, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static void createHanningWindow(Mat mat, Size size, int n) {
        Imgproc.createHanningWindow_0(mat.nativeObj, size.width, size.height, n);
    }

    public static void cvtColor(Mat mat, Mat mat2, int n, int n2) {
        Imgproc.cvtColor_0(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void cvtColor(Mat mat, Mat mat2, int n) {
        Imgproc.cvtColor_1(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void demosaicing(Mat mat, Mat mat2, int n, int n2) {
        Imgproc.demosaicing_0(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void demosaicing(Mat mat, Mat mat2, int n) {
        Imgproc.demosaicing_1(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void dilate(Mat mat, Mat mat2, Mat mat3, Point point, int n, int n2, Scalar scalar) {
        Imgproc.dilate_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, point.x, point.y, n, n2, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void dilate(Mat mat, Mat mat2, Mat mat3, Point point, int n) {
        Imgproc.dilate_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, point.x, point.y, n);
    }

    public static void dilate(Mat mat, Mat mat2, Mat mat3) {
        Imgproc.dilate_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void distanceTransformWithLabels(Mat mat, Mat mat2, Mat mat3, int n, int n2, int n3) {
        Imgproc.distanceTransformWithLabels_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, n2, n3);
    }

    public static void distanceTransformWithLabels(Mat mat, Mat mat2, Mat mat3, int n, int n2) {
        Imgproc.distanceTransformWithLabels_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, n2);
    }

    public static void distanceTransform(Mat mat, Mat mat2, int n, int n2, int n3) {
        Imgproc.distanceTransform_0(mat.nativeObj, mat2.nativeObj, n, n2, n3);
    }

    public static void distanceTransform(Mat mat, Mat mat2, int n, int n2) {
        Imgproc.distanceTransform_1(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void drawContours(Mat mat, List<MatOfPoint> list, int n, Scalar scalar, int n2, int n3, Mat mat2, int n4, Point point) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat3 = Converters.vector_vector_Point_to_Mat(list, arrayList);
        Imgproc.drawContours_0(mat.nativeObj, mat3.nativeObj, n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n2, n3, mat2.nativeObj, n4, point.x, point.y);
    }

    public static void drawContours(Mat mat, List<MatOfPoint> list, int n, Scalar scalar, int n2) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat2 = Converters.vector_vector_Point_to_Mat(list, arrayList);
        Imgproc.drawContours_1(mat.nativeObj, mat2.nativeObj, n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n2);
    }

    public static void drawContours(Mat mat, List<MatOfPoint> list, int n, Scalar scalar) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat2 = Converters.vector_vector_Point_to_Mat(list, arrayList);
        Imgproc.drawContours_2(mat.nativeObj, mat2.nativeObj, n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void drawMarker(Mat mat, Point point, Scalar scalar, int n, int n2, int n3, int n4) {
        Imgproc.drawMarker_0(mat.nativeObj, point.x, point.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n, n2, n3, n4);
    }

    public static void drawMarker(Mat mat, Point point, Scalar scalar) {
        Imgproc.drawMarker_1(mat.nativeObj, point.x, point.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void ellipse(Mat mat, Point point, Size size, double d, double d2, double d3, Scalar scalar, int n, int n2, int n3) {
        Imgproc.ellipse_0(mat.nativeObj, point.x, point.y, size.width, size.height, d, d2, d3, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n, n2, n3);
    }

    public static void ellipse(Mat mat, Point point, Size size, double d, double d2, double d3, Scalar scalar, int n) {
        Imgproc.ellipse_1(mat.nativeObj, point.x, point.y, size.width, size.height, d, d2, d3, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n);
    }

    public static void ellipse(Mat mat, Point point, Size size, double d, double d2, double d3, Scalar scalar) {
        Imgproc.ellipse_2(mat.nativeObj, point.x, point.y, size.width, size.height, d, d2, d3, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void ellipse(Mat mat, RotatedRect rotatedRect, Scalar scalar, int n, int n2) {
        Imgproc.ellipse_3(mat.nativeObj, rotatedRect.center.x, rotatedRect.center.y, rotatedRect.size.width, rotatedRect.size.height, rotatedRect.angle, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n, n2);
    }

    public static void ellipse(Mat mat, RotatedRect rotatedRect, Scalar scalar, int n) {
        Imgproc.ellipse_4(mat.nativeObj, rotatedRect.center.x, rotatedRect.center.y, rotatedRect.size.width, rotatedRect.size.height, rotatedRect.angle, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n);
    }

    public static void ellipse(Mat mat, RotatedRect rotatedRect, Scalar scalar) {
        Imgproc.ellipse_5(mat.nativeObj, rotatedRect.center.x, rotatedRect.center.y, rotatedRect.size.width, rotatedRect.size.height, rotatedRect.angle, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void ellipse2Poly(Point point, Size size, int n, int n2, int n3, int n4, MatOfPoint matOfPoint) {
        MatOfPoint matOfPoint2 = matOfPoint;
        Imgproc.ellipse2Poly_0(point.x, point.y, size.width, size.height, n, n2, n3, n4, matOfPoint2.nativeObj);
    }

    public static void equalizeHist(Mat mat, Mat mat2) {
        Imgproc.equalizeHist_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void erode(Mat mat, Mat mat2, Mat mat3, Point point, int n, int n2, Scalar scalar) {
        Imgproc.erode_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, point.x, point.y, n, n2, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void erode(Mat mat, Mat mat2, Mat mat3, Point point, int n) {
        Imgproc.erode_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, point.x, point.y, n);
    }

    public static void erode(Mat mat, Mat mat2, Mat mat3) {
        Imgproc.erode_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void fillConvexPoly(Mat mat, MatOfPoint matOfPoint, Scalar scalar, int n, int n2) {
        MatOfPoint matOfPoint2 = matOfPoint;
        Imgproc.fillConvexPoly_0(mat.nativeObj, matOfPoint2.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n, n2);
    }

    public static void fillConvexPoly(Mat mat, MatOfPoint matOfPoint, Scalar scalar) {
        MatOfPoint matOfPoint2 = matOfPoint;
        Imgproc.fillConvexPoly_1(mat.nativeObj, matOfPoint2.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void fillPoly(Mat mat, List<MatOfPoint> list, Scalar scalar, int n, int n2, Point point) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat2 = Converters.vector_vector_Point_to_Mat(list, arrayList);
        Imgproc.fillPoly_0(mat.nativeObj, mat2.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n, n2, point.x, point.y);
    }

    public static void fillPoly(Mat mat, List<MatOfPoint> list, Scalar scalar) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat2 = Converters.vector_vector_Point_to_Mat(list, arrayList);
        Imgproc.fillPoly_1(mat.nativeObj, mat2.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void filter2D(Mat mat, Mat mat2, int n, Mat mat3, Point point, double d, int n2) {
        Imgproc.filter2D_0(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj, point.x, point.y, d, n2);
    }

    public static void filter2D(Mat mat, Mat mat2, int n, Mat mat3, Point point, double d) {
        Imgproc.filter2D_1(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj, point.x, point.y, d);
    }

    public static void filter2D(Mat mat, Mat mat2, int n, Mat mat3) {
        Imgproc.filter2D_2(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj);
    }

    public static void findContours(Mat mat, List<MatOfPoint> list, Mat mat2, int n, int n2, Point point) {
        Mat mat3 = new Mat();
        Imgproc.findContours_0(mat.nativeObj, mat3.nativeObj, mat2.nativeObj, n, n2, point.x, point.y);
        Converters.Mat_to_vector_vector_Point(mat3, list);
        mat3.release();
    }

    public static void findContours(Mat mat, List<MatOfPoint> list, Mat mat2, int n, int n2) {
        Mat mat3 = new Mat();
        Imgproc.findContours_1(mat.nativeObj, mat3.nativeObj, mat2.nativeObj, n, n2);
        Converters.Mat_to_vector_vector_Point(mat3, list);
        mat3.release();
    }

    public static void fitLine(Mat mat, Mat mat2, int n, double d, double d2, double d3) {
        Imgproc.fitLine_0(mat.nativeObj, mat2.nativeObj, n, d, d2, d3);
    }

    public static void getDerivKernels(Mat mat, Mat mat2, int n, int n2, int n3, boolean bl, int n4) {
        Imgproc.getDerivKernels_0(mat.nativeObj, mat2.nativeObj, n, n2, n3, bl, n4);
    }

    public static void getDerivKernels(Mat mat, Mat mat2, int n, int n2, int n3) {
        Imgproc.getDerivKernels_1(mat.nativeObj, mat2.nativeObj, n, n2, n3);
    }

    public static void getRectSubPix(Mat mat, Size size, Point point, Mat mat2, int n) {
        Imgproc.getRectSubPix_0(mat.nativeObj, size.width, size.height, point.x, point.y, mat2.nativeObj, n);
    }

    public static void getRectSubPix(Mat mat, Size size, Point point, Mat mat2) {
        Imgproc.getRectSubPix_1(mat.nativeObj, size.width, size.height, point.x, point.y, mat2.nativeObj);
    }

    public static void goodFeaturesToTrack(Mat mat, MatOfPoint matOfPoint, int n, double d, double d2, Mat mat2, int n2, boolean bl, double d3) {
        MatOfPoint matOfPoint2 = matOfPoint;
        Imgproc.goodFeaturesToTrack_0(mat.nativeObj, matOfPoint2.nativeObj, n, d, d2, mat2.nativeObj, n2, bl, d3);
    }

    public static void goodFeaturesToTrack(Mat mat, MatOfPoint matOfPoint, int n, double d, double d2) {
        MatOfPoint matOfPoint2 = matOfPoint;
        Imgproc.goodFeaturesToTrack_1(mat.nativeObj, matOfPoint2.nativeObj, n, d, d2);
    }

    public static void grabCut(Mat mat, Mat mat2, Rect rect, Mat mat3, Mat mat4, int n, int n2) {
        Imgproc.grabCut_0(mat.nativeObj, mat2.nativeObj, rect.x, rect.y, rect.width, rect.height, mat3.nativeObj, mat4.nativeObj, n, n2);
    }

    public static void grabCut(Mat mat, Mat mat2, Rect rect, Mat mat3, Mat mat4, int n) {
        Imgproc.grabCut_1(mat.nativeObj, mat2.nativeObj, rect.x, rect.y, rect.width, rect.height, mat3.nativeObj, mat4.nativeObj, n);
    }

    public static void initUndistortRectifyMap(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, int n, Mat mat5, Mat mat6) {
        Imgproc.initUndistortRectifyMap_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, n, mat5.nativeObj, mat6.nativeObj);
    }

    public static void integral3(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n, int n2) {
        Imgproc.integral3_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n, n2);
    }

    public static void integral3(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Imgproc.integral3_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void integral2(Mat mat, Mat mat2, Mat mat3, int n, int n2) {
        Imgproc.integral2_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, n2);
    }

    public static void integral2(Mat mat, Mat mat2, Mat mat3) {
        Imgproc.integral2_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void integral(Mat mat, Mat mat2, int n) {
        Imgproc.integral_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void integral(Mat mat, Mat mat2) {
        Imgproc.integral_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void invertAffineTransform(Mat mat, Mat mat2) {
        Imgproc.invertAffineTransform_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void line(Mat mat, Point point, Point point2, Scalar scalar, int n, int n2, int n3) {
        Imgproc.line_0(mat.nativeObj, point.x, point.y, point2.x, point2.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n, n2, n3);
    }

    public static void line(Mat mat, Point point, Point point2, Scalar scalar, int n) {
        Imgproc.line_1(mat.nativeObj, point.x, point.y, point2.x, point2.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n);
    }

    public static void line(Mat mat, Point point, Point point2, Scalar scalar) {
        Imgproc.line_2(mat.nativeObj, point.x, point.y, point2.x, point2.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void linearPolar(Mat mat, Mat mat2, Point point, double d, int n) {
        Imgproc.linearPolar_0(mat.nativeObj, mat2.nativeObj, point.x, point.y, d, n);
    }

    public static void logPolar(Mat mat, Mat mat2, Point point, double d, int n) {
        Imgproc.logPolar_0(mat.nativeObj, mat2.nativeObj, point.x, point.y, d, n);
    }

    public static void matchTemplate(Mat mat, Mat mat2, Mat mat3, int n, Mat mat4) {
        Imgproc.matchTemplate_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, mat4.nativeObj);
    }

    public static void matchTemplate(Mat mat, Mat mat2, Mat mat3, int n) {
        Imgproc.matchTemplate_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n);
    }

    public static void medianBlur(Mat mat, Mat mat2, int n) {
        Imgproc.medianBlur_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void minEnclosingCircle(MatOfPoint2f matOfPoint2f, Point point, float[] fArray) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        double[] dArray = new double[2];
        double[] dArray2 = new double[1];
        Imgproc.minEnclosingCircle_0(matOfPoint2f2.nativeObj, dArray, dArray2);
        if (point != null) {
            point.x = dArray[0];
            point.y = dArray[1];
        }
        if (fArray != null) {
            fArray[0] = (float)dArray2[0];
        }
    }

    public static void morphologyEx(Mat mat, Mat mat2, int n, Mat mat3, Point point, int n2, int n3, Scalar scalar) {
        Imgproc.morphologyEx_0(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj, point.x, point.y, n2, n3, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void morphologyEx(Mat mat, Mat mat2, int n, Mat mat3, Point point, int n2) {
        Imgproc.morphologyEx_1(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj, point.x, point.y, n2);
    }

    public static void morphologyEx(Mat mat, Mat mat2, int n, Mat mat3) {
        Imgproc.morphologyEx_2(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj);
    }

    public static void polylines(Mat mat, List<MatOfPoint> list, boolean bl, Scalar scalar, int n, int n2, int n3) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat2 = Converters.vector_vector_Point_to_Mat(list, arrayList);
        Imgproc.polylines_0(mat.nativeObj, mat2.nativeObj, bl, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n, n2, n3);
    }

    public static void polylines(Mat mat, List<MatOfPoint> list, boolean bl, Scalar scalar, int n) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat2 = Converters.vector_vector_Point_to_Mat(list, arrayList);
        Imgproc.polylines_1(mat.nativeObj, mat2.nativeObj, bl, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n);
    }

    public static void polylines(Mat mat, List<MatOfPoint> list, boolean bl, Scalar scalar) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat2 = Converters.vector_vector_Point_to_Mat(list, arrayList);
        Imgproc.polylines_2(mat.nativeObj, mat2.nativeObj, bl, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void preCornerDetect(Mat mat, Mat mat2, int n, int n2) {
        Imgproc.preCornerDetect_0(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void preCornerDetect(Mat mat, Mat mat2, int n) {
        Imgproc.preCornerDetect_1(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void putText(Mat mat, String string, Point point, int n, double d, Scalar scalar, int n2, int n3, boolean bl) {
        Imgproc.putText_0(mat.nativeObj, string, point.x, point.y, n, d, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n2, n3, bl);
    }

    public static void putText(Mat mat, String string, Point point, int n, double d, Scalar scalar, int n2) {
        Imgproc.putText_1(mat.nativeObj, string, point.x, point.y, n, d, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n2);
    }

    public static void putText(Mat mat, String string, Point point, int n, double d, Scalar scalar) {
        Imgproc.putText_2(mat.nativeObj, string, point.x, point.y, n, d, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void pyrDown(Mat mat, Mat mat2, Size size, int n) {
        Imgproc.pyrDown_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, n);
    }

    public static void pyrDown(Mat mat, Mat mat2, Size size) {
        Imgproc.pyrDown_1(mat.nativeObj, mat2.nativeObj, size.width, size.height);
    }

    public static void pyrDown(Mat mat, Mat mat2) {
        Imgproc.pyrDown_2(mat.nativeObj, mat2.nativeObj);
    }

    public static void pyrMeanShiftFiltering(Mat mat, Mat mat2, double d, double d2, int n, TermCriteria termCriteria) {
        Imgproc.pyrMeanShiftFiltering_0(mat.nativeObj, mat2.nativeObj, d, d2, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static void pyrMeanShiftFiltering(Mat mat, Mat mat2, double d, double d2) {
        Imgproc.pyrMeanShiftFiltering_1(mat.nativeObj, mat2.nativeObj, d, d2);
    }

    public static void pyrUp(Mat mat, Mat mat2, Size size, int n) {
        Imgproc.pyrUp_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, n);
    }

    public static void pyrUp(Mat mat, Mat mat2, Size size) {
        Imgproc.pyrUp_1(mat.nativeObj, mat2.nativeObj, size.width, size.height);
    }

    public static void pyrUp(Mat mat, Mat mat2) {
        Imgproc.pyrUp_2(mat.nativeObj, mat2.nativeObj);
    }

    public static void rectangle(Mat mat, Point point, Point point2, Scalar scalar, int n, int n2, int n3) {
        Imgproc.rectangle_0(mat.nativeObj, point.x, point.y, point2.x, point2.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n, n2, n3);
    }

    public static void rectangle(Mat mat, Point point, Point point2, Scalar scalar, int n) {
        Imgproc.rectangle_1(mat.nativeObj, point.x, point.y, point2.x, point2.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], n);
    }

    public static void rectangle(Mat mat, Point point, Point point2, Scalar scalar) {
        Imgproc.rectangle_2(mat.nativeObj, point.x, point.y, point2.x, point2.y, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void remap(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n, int n2, Scalar scalar) {
        Imgproc.remap_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n, n2, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void remap(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n) {
        Imgproc.remap_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n);
    }

    public static void resize(Mat mat, Mat mat2, Size size, double d, double d2, int n) {
        Imgproc.resize_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, d, d2, n);
    }

    public static void resize(Mat mat, Mat mat2, Size size) {
        Imgproc.resize_1(mat.nativeObj, mat2.nativeObj, size.width, size.height);
    }

    public static void sepFilter2D(Mat mat, Mat mat2, int n, Mat mat3, Mat mat4, Point point, double d, int n2) {
        Imgproc.sepFilter2D_0(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj, mat4.nativeObj, point.x, point.y, d, n2);
    }

    public static void sepFilter2D(Mat mat, Mat mat2, int n, Mat mat3, Mat mat4, Point point, double d) {
        Imgproc.sepFilter2D_1(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj, mat4.nativeObj, point.x, point.y, d);
    }

    public static void sepFilter2D(Mat mat, Mat mat2, int n, Mat mat3, Mat mat4) {
        Imgproc.sepFilter2D_2(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj, mat4.nativeObj);
    }

    public static void spatialGradient(Mat mat, Mat mat2, Mat mat3, int n, int n2) {
        Imgproc.spatialGradient_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, n2);
    }

    public static void spatialGradient(Mat mat, Mat mat2, Mat mat3, int n) {
        Imgproc.spatialGradient_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n);
    }

    public static void spatialGradient(Mat mat, Mat mat2, Mat mat3) {
        Imgproc.spatialGradient_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void sqrBoxFilter(Mat mat, Mat mat2, int n, Size size, Point point, boolean bl, int n2) {
        Imgproc.sqrBoxFilter_0(mat.nativeObj, mat2.nativeObj, n, size.width, size.height, point.x, point.y, bl, n2);
    }

    public static void sqrBoxFilter(Mat mat, Mat mat2, int n, Size size, Point point, boolean bl) {
        Imgproc.sqrBoxFilter_1(mat.nativeObj, mat2.nativeObj, n, size.width, size.height, point.x, point.y, bl);
    }

    public static void sqrBoxFilter(Mat mat, Mat mat2, int n, Size size) {
        Imgproc.sqrBoxFilter_2(mat.nativeObj, mat2.nativeObj, n, size.width, size.height);
    }

    public static void undistort(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Imgproc.undistort_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void undistort(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Imgproc.undistort_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void undistortPoints(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Imgproc.undistortPoints_0(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void undistortPoints(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, Mat mat, Mat mat2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Imgproc.undistortPoints_1(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public static void warpAffine(Mat mat, Mat mat2, Mat mat3, Size size, int n, int n2, Scalar scalar) {
        Imgproc.warpAffine_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height, n, n2, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void warpAffine(Mat mat, Mat mat2, Mat mat3, Size size, int n) {
        Imgproc.warpAffine_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height, n);
    }

    public static void warpAffine(Mat mat, Mat mat2, Mat mat3, Size size) {
        Imgproc.warpAffine_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height);
    }

    public static void warpPerspective(Mat mat, Mat mat2, Mat mat3, Size size, int n, int n2, Scalar scalar) {
        Imgproc.warpPerspective_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height, n, n2, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void warpPerspective(Mat mat, Mat mat2, Mat mat3, Size size, int n) {
        Imgproc.warpPerspective_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height, n);
    }

    public static void warpPerspective(Mat mat, Mat mat2, Mat mat3, Size size) {
        Imgproc.warpPerspective_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height);
    }

    public static void watershed(Mat mat, Mat mat2) {
        Imgproc.watershed_0(mat.nativeObj, mat2.nativeObj);
    }

    public static Size getTextSize(String string, int n, double d, int n2, int[] nArray) {
        if (nArray != null && nArray.length != 1) {
            throw new IllegalArgumentException("'baseLine' must be 'int[1]' or 'null'.");
        }
        Size size = new Size(Imgproc.n_getTextSize(string, n, d, n2, nArray));
        return size;
    }

    private static native long getAffineTransform_0(long var0, long var2);

    private static native long getDefaultNewCameraMatrix_0(long var0, double var2, double var4, boolean var6);

    private static native long getDefaultNewCameraMatrix_1(long var0);

    private static native long getGaborKernel_0(double var0, double var2, double var4, double var6, double var8, double var10, double var12, int var14);

    private static native long getGaborKernel_1(double var0, double var2, double var4, double var6, double var8, double var10);

    private static native long getGaussianKernel_0(int var0, double var1, int var3);

    private static native long getGaussianKernel_1(int var0, double var1);

    private static native long getPerspectiveTransform_0(long var0, long var2);

    private static native long getRotationMatrix2D_0(double var0, double var2, double var4, double var6);

    private static native long getStructuringElement_0(int var0, double var1, double var3, double var5, double var7);

    private static native long getStructuringElement_1(int var0, double var1, double var3);

    private static native double[] moments_0(long var0, boolean var2);

    private static native double[] moments_1(long var0);

    private static native double[] phaseCorrelate_0(long var0, long var2, long var4, double[] var6);

    private static native double[] phaseCorrelate_1(long var0, long var2);

    private static native long createCLAHE_0(double var0, double var2, double var4);

    private static native long createCLAHE_1();

    private static native long createLineSegmentDetector_0(int var0, double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    private static native long createLineSegmentDetector_1();

    private static native double[] boundingRect_0(long var0);

    private static native double[] fitEllipse_0(long var0);

    private static native double[] minAreaRect_0(long var0);

    private static native boolean clipLine_0(int var0, int var1, int var2, int var3, double var4, double var6, double[] var8, double var9, double var11, double[] var13);

    private static native boolean isContourConvex_0(long var0);

    private static native double arcLength_0(long var0, boolean var2);

    private static native double compareHist_0(long var0, long var2, int var4);

    private static native double contourArea_0(long var0, boolean var2);

    private static native double contourArea_1(long var0);

    private static native double matchShapes_0(long var0, long var2, int var4, double var5);

    private static native double minEnclosingTriangle_0(long var0, long var2);

    private static native double pointPolygonTest_0(long var0, double var2, double var4, boolean var6);

    private static native double threshold_0(long var0, long var2, double var4, double var6, int var8);

    private static native float initWideAngleProjMap_0(long var0, long var2, double var4, double var6, int var8, int var9, long var10, long var12, int var14, double var15);

    private static native float initWideAngleProjMap_1(long var0, long var2, double var4, double var6, int var8, int var9, long var10, long var12);

    private static native float intersectConvexConvex_0(long var0, long var2, long var4, boolean var6);

    private static native float intersectConvexConvex_1(long var0, long var2, long var4);

    private static native int connectedComponentsWithAlgorithm_0(long var0, long var2, int var4, int var5, int var6);

    private static native int connectedComponents_0(long var0, long var2, int var4, int var5);

    private static native int connectedComponents_1(long var0, long var2);

    private static native int connectedComponentsWithStatsWithAlgorithm_0(long var0, long var2, long var4, long var6, int var8, int var9, int var10);

    private static native int connectedComponentsWithStats_0(long var0, long var2, long var4, long var6, int var8, int var9);

    private static native int connectedComponentsWithStats_1(long var0, long var2, long var4, long var6);

    private static native int floodFill_0(long var0, long var2, double var4, double var6, double var8, double var10, double var12, double var14, double[] var16, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, int var33);

    private static native int floodFill_1(long var0, long var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native int rotatedRectangleIntersection_0(double var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, long var20);

    private static native void Canny_0(long var0, long var2, long var4, double var6, double var8, boolean var10);

    private static native void Canny_1(long var0, long var2, long var4, double var6, double var8);

    private static native void Canny_2(long var0, long var2, double var4, double var6, int var8, boolean var9);

    private static native void Canny_3(long var0, long var2, double var4, double var6);

    private static native void GaussianBlur_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12);

    private static native void GaussianBlur_1(long var0, long var2, double var4, double var6, double var8, double var10);

    private static native void GaussianBlur_2(long var0, long var2, double var4, double var6, double var8);

    private static native void HoughCircles_0(long var0, long var2, int var4, double var5, double var7, double var9, double var11, int var13, int var14);

    private static native void HoughCircles_1(long var0, long var2, int var4, double var5, double var7);

    private static native void HoughLines_0(long var0, long var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15);

    private static native void HoughLines_1(long var0, long var2, double var4, double var6, int var8);

    private static native void HoughLinesP_0(long var0, long var2, double var4, double var6, int var8, double var9, double var11);

    private static native void HoughLinesP_1(long var0, long var2, double var4, double var6, int var8);

    private static native void HuMoments_0(double var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, long var20);

    private static native void Laplacian_0(long var0, long var2, int var4, int var5, double var6, double var8, int var10);

    private static native void Laplacian_1(long var0, long var2, int var4, int var5, double var6, double var8);

    private static native void Laplacian_2(long var0, long var2, int var4);

    private static native void Scharr_0(long var0, long var2, int var4, int var5, int var6, double var7, double var9, int var11);

    private static native void Scharr_1(long var0, long var2, int var4, int var5, int var6, double var7, double var9);

    private static native void Scharr_2(long var0, long var2, int var4, int var5, int var6);

    private static native void Sobel_0(long var0, long var2, int var4, int var5, int var6, int var7, double var8, double var10, int var12);

    private static native void Sobel_1(long var0, long var2, int var4, int var5, int var6, int var7, double var8, double var10);

    private static native void Sobel_2(long var0, long var2, int var4, int var5, int var6);

    private static native void accumulate_0(long var0, long var2, long var4);

    private static native void accumulate_1(long var0, long var2);

    private static native void accumulateProduct_0(long var0, long var2, long var4, long var6);

    private static native void accumulateProduct_1(long var0, long var2, long var4);

    private static native void accumulateSquare_0(long var0, long var2, long var4);

    private static native void accumulateSquare_1(long var0, long var2);

    private static native void accumulateWeighted_0(long var0, long var2, double var4, long var6);

    private static native void accumulateWeighted_1(long var0, long var2, double var4);

    private static native void adaptiveThreshold_0(long var0, long var2, double var4, int var6, int var7, int var8, double var9);

    private static native void applyColorMap_0(long var0, long var2, int var4);

    private static native void approxPolyDP_0(long var0, long var2, double var4, boolean var6);

    private static native void arrowedLine_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, int var18, int var19, int var20, double var21);

    private static native void arrowedLine_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16);

    private static native void bilateralFilter_0(long var0, long var2, int var4, double var5, double var7, int var9);

    private static native void bilateralFilter_1(long var0, long var2, int var4, double var5, double var7);

    private static native void blur_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12);

    private static native void blur_1(long var0, long var2, double var4, double var6, double var8, double var10);

    private static native void blur_2(long var0, long var2, double var4, double var6);

    private static native void boxFilter_0(long var0, long var2, int var4, double var5, double var7, double var9, double var11, boolean var13, int var14);

    private static native void boxFilter_1(long var0, long var2, int var4, double var5, double var7, double var9, double var11, boolean var13);

    private static native void boxFilter_2(long var0, long var2, int var4, double var5, double var7);

    private static native void boxPoints_0(double var0, double var2, double var4, double var6, double var8, long var10);

    private static native void calcBackProject_0(long var0, long var2, long var4, long var6, long var8, double var10);

    private static native void calcHist_0(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12);

    private static native void calcHist_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void circle_0(long var0, double var2, double var4, int var6, double var7, double var9, double var11, double var13, int var15, int var16, int var17);

    private static native void circle_1(long var0, double var2, double var4, int var6, double var7, double var9, double var11, double var13, int var15);

    private static native void circle_2(long var0, double var2, double var4, int var6, double var7, double var9, double var11, double var13);

    private static native void convertMaps_0(long var0, long var2, long var4, long var6, int var8, boolean var9);

    private static native void convertMaps_1(long var0, long var2, long var4, long var6, int var8);

    private static native void convexHull_0(long var0, long var2, boolean var4);

    private static native void convexHull_1(long var0, long var2);

    private static native void convexityDefects_0(long var0, long var2, long var4);

    private static native void cornerEigenValsAndVecs_0(long var0, long var2, int var4, int var5, int var6);

    private static native void cornerEigenValsAndVecs_1(long var0, long var2, int var4, int var5);

    private static native void cornerHarris_0(long var0, long var2, int var4, int var5, double var6, int var8);

    private static native void cornerHarris_1(long var0, long var2, int var4, int var5, double var6);

    private static native void cornerMinEigenVal_0(long var0, long var2, int var4, int var5, int var6);

    private static native void cornerMinEigenVal_1(long var0, long var2, int var4, int var5);

    private static native void cornerMinEigenVal_2(long var0, long var2, int var4);

    private static native void cornerSubPix_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12, int var13, double var14);

    private static native void createHanningWindow_0(long var0, double var2, double var4, int var6);

    private static native void cvtColor_0(long var0, long var2, int var4, int var5);

    private static native void cvtColor_1(long var0, long var2, int var4);

    private static native void demosaicing_0(long var0, long var2, int var4, int var5);

    private static native void demosaicing_1(long var0, long var2, int var4);

    private static native void dilate_0(long var0, long var2, long var4, double var6, double var8, int var10, int var11, double var12, double var14, double var16, double var18);

    private static native void dilate_1(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void dilate_2(long var0, long var2, long var4);

    private static native void distanceTransformWithLabels_0(long var0, long var2, long var4, int var6, int var7, int var8);

    private static native void distanceTransformWithLabels_1(long var0, long var2, long var4, int var6, int var7);

    private static native void distanceTransform_0(long var0, long var2, int var4, int var5, int var6);

    private static native void distanceTransform_1(long var0, long var2, int var4, int var5);

    private static native void drawContours_0(long var0, long var2, int var4, double var5, double var7, double var9, double var11, int var13, int var14, long var15, int var17, double var18, double var20);

    private static native void drawContours_1(long var0, long var2, int var4, double var5, double var7, double var9, double var11, int var13);

    private static native void drawContours_2(long var0, long var2, int var4, double var5, double var7, double var9, double var11);

    private static native void drawMarker_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, int var14, int var15, int var16, int var17);

    private static native void drawMarker_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12);

    private static native void ellipse_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, int var24, int var25, int var26);

    private static native void ellipse_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, int var24);

    private static native void ellipse_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22);

    private static native void ellipse_3(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, int var20, int var21);

    private static native void ellipse_4(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, int var20);

    private static native void ellipse_5(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18);

    private static native void ellipse2Poly_0(double var0, double var2, double var4, double var6, int var8, int var9, int var10, int var11, long var12);

    private static native void equalizeHist_0(long var0, long var2);

    private static native void erode_0(long var0, long var2, long var4, double var6, double var8, int var10, int var11, double var12, double var14, double var16, double var18);

    private static native void erode_1(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void erode_2(long var0, long var2, long var4);

    private static native void fillConvexPoly_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12, int var13);

    private static native void fillConvexPoly_1(long var0, long var2, double var4, double var6, double var8, double var10);

    private static native void fillPoly_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12, int var13, double var14, double var16);

    private static native void fillPoly_1(long var0, long var2, double var4, double var6, double var8, double var10);

    private static native void filter2D_0(long var0, long var2, int var4, long var5, double var7, double var9, double var11, int var13);

    private static native void filter2D_1(long var0, long var2, int var4, long var5, double var7, double var9, double var11);

    private static native void filter2D_2(long var0, long var2, int var4, long var5);

    private static native void findContours_0(long var0, long var2, long var4, int var6, int var7, double var8, double var10);

    private static native void findContours_1(long var0, long var2, long var4, int var6, int var7);

    private static native void fitLine_0(long var0, long var2, int var4, double var5, double var7, double var9);

    private static native void getDerivKernels_0(long var0, long var2, int var4, int var5, int var6, boolean var7, int var8);

    private static native void getDerivKernels_1(long var0, long var2, int var4, int var5, int var6);

    private static native void getRectSubPix_0(long var0, double var2, double var4, double var6, double var8, long var10, int var12);

    private static native void getRectSubPix_1(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native void goodFeaturesToTrack_0(long var0, long var2, int var4, double var5, double var7, long var9, int var11, boolean var12, double var13);

    private static native void goodFeaturesToTrack_1(long var0, long var2, int var4, double var5, double var7);

    private static native void grabCut_0(long var0, long var2, int var4, int var5, int var6, int var7, long var8, long var10, int var12, int var13);

    private static native void grabCut_1(long var0, long var2, int var4, int var5, int var6, int var7, long var8, long var10, int var12);

    private static native void initUndistortRectifyMap_0(long var0, long var2, long var4, long var6, double var8, double var10, int var12, long var13, long var15);

    private static native void integral3_0(long var0, long var2, long var4, long var6, int var8, int var9);

    private static native void integral3_1(long var0, long var2, long var4, long var6);

    private static native void integral2_0(long var0, long var2, long var4, int var6, int var7);

    private static native void integral2_1(long var0, long var2, long var4);

    private static native void integral_0(long var0, long var2, int var4);

    private static native void integral_1(long var0, long var2);

    private static native void invertAffineTransform_0(long var0, long var2);

    private static native void line_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, int var18, int var19, int var20);

    private static native void line_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, int var18);

    private static native void line_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16);

    private static native void linearPolar_0(long var0, long var2, double var4, double var6, double var8, int var10);

    private static native void logPolar_0(long var0, long var2, double var4, double var6, double var8, int var10);

    private static native void matchTemplate_0(long var0, long var2, long var4, int var6, long var7);

    private static native void matchTemplate_1(long var0, long var2, long var4, int var6);

    private static native void medianBlur_0(long var0, long var2, int var4);

    private static native void minEnclosingCircle_0(long var0, double[] var2, double[] var3);

    private static native void morphologyEx_0(long var0, long var2, int var4, long var5, double var7, double var9, int var11, int var12, double var13, double var15, double var17, double var19);

    private static native void morphologyEx_1(long var0, long var2, int var4, long var5, double var7, double var9, int var11);

    private static native void morphologyEx_2(long var0, long var2, int var4, long var5);

    private static native void polylines_0(long var0, long var2, boolean var4, double var5, double var7, double var9, double var11, int var13, int var14, int var15);

    private static native void polylines_1(long var0, long var2, boolean var4, double var5, double var7, double var9, double var11, int var13);

    private static native void polylines_2(long var0, long var2, boolean var4, double var5, double var7, double var9, double var11);

    private static native void preCornerDetect_0(long var0, long var2, int var4, int var5);

    private static native void preCornerDetect_1(long var0, long var2, int var4);

    private static native void putText_0(long var0, String var2, double var3, double var5, int var7, double var8, double var10, double var12, double var14, double var16, int var18, int var19, boolean var20);

    private static native void putText_1(long var0, String var2, double var3, double var5, int var7, double var8, double var10, double var12, double var14, double var16, int var18);

    private static native void putText_2(long var0, String var2, double var3, double var5, int var7, double var8, double var10, double var12, double var14, double var16);

    private static native void pyrDown_0(long var0, long var2, double var4, double var6, int var8);

    private static native void pyrDown_1(long var0, long var2, double var4, double var6);

    private static native void pyrDown_2(long var0, long var2);

    private static native void pyrMeanShiftFiltering_0(long var0, long var2, double var4, double var6, int var8, int var9, int var10, double var11);

    private static native void pyrMeanShiftFiltering_1(long var0, long var2, double var4, double var6);

    private static native void pyrUp_0(long var0, long var2, double var4, double var6, int var8);

    private static native void pyrUp_1(long var0, long var2, double var4, double var6);

    private static native void pyrUp_2(long var0, long var2);

    private static native void rectangle_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, int var18, int var19, int var20);

    private static native void rectangle_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, int var18);

    private static native void rectangle_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16);

    private static native void remap_0(long var0, long var2, long var4, long var6, int var8, int var9, double var10, double var12, double var14, double var16);

    private static native void remap_1(long var0, long var2, long var4, long var6, int var8);

    private static native void resize_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12);

    private static native void resize_1(long var0, long var2, double var4, double var6);

    private static native void sepFilter2D_0(long var0, long var2, int var4, long var5, long var7, double var9, double var11, double var13, int var15);

    private static native void sepFilter2D_1(long var0, long var2, int var4, long var5, long var7, double var9, double var11, double var13);

    private static native void sepFilter2D_2(long var0, long var2, int var4, long var5, long var7);

    private static native void spatialGradient_0(long var0, long var2, long var4, int var6, int var7);

    private static native void spatialGradient_1(long var0, long var2, long var4, int var6);

    private static native void spatialGradient_2(long var0, long var2, long var4);

    private static native void sqrBoxFilter_0(long var0, long var2, int var4, double var5, double var7, double var9, double var11, boolean var13, int var14);

    private static native void sqrBoxFilter_1(long var0, long var2, int var4, double var5, double var7, double var9, double var11, boolean var13);

    private static native void sqrBoxFilter_2(long var0, long var2, int var4, double var5, double var7);

    private static native void undistort_0(long var0, long var2, long var4, long var6, long var8);

    private static native void undistort_1(long var0, long var2, long var4, long var6);

    private static native void undistortPoints_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void undistortPoints_1(long var0, long var2, long var4, long var6);

    private static native void warpAffine_0(long var0, long var2, long var4, double var6, double var8, int var10, int var11, double var12, double var14, double var16, double var18);

    private static native void warpAffine_1(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void warpAffine_2(long var0, long var2, long var4, double var6, double var8);

    private static native void warpPerspective_0(long var0, long var2, long var4, double var6, double var8, int var10, int var11, double var12, double var14, double var16, double var18);

    private static native void warpPerspective_1(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void warpPerspective_2(long var0, long var2, long var4, double var6, double var8);

    private static native void watershed_0(long var0, long var2);

    private static native double[] n_getTextSize(String var0, int var1, double var2, int var4, int[] var5);
}

