/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.features2d;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.utils.Converters;

public class DescriptorExtractor {
    protected final long nativeObj;
    private static final int OPPONENTEXTRACTOR = 1000;
    public static final int SIFT = 1;
    public static final int SURF = 2;
    public static final int ORB = 3;
    public static final int BRIEF = 4;
    public static final int BRISK = 5;
    public static final int FREAK = 6;
    public static final int AKAZE = 7;
    public static final int OPPONENT_SIFT = 1001;
    public static final int OPPONENT_SURF = 1002;
    public static final int OPPONENT_ORB = 1003;
    public static final int OPPONENT_BRIEF = 1004;
    public static final int OPPONENT_BRISK = 1005;
    public static final int OPPONENT_FREAK = 1006;
    public static final int OPPONENT_AKAZE = 1007;

    protected DescriptorExtractor(long l) {
        this.nativeObj = l;
    }

    public static DescriptorExtractor create(int n) {
        DescriptorExtractor descriptorExtractor = new DescriptorExtractor(DescriptorExtractor.create_0(n));
        return descriptorExtractor;
    }

    public boolean empty() {
        boolean bl = DescriptorExtractor.empty_0(this.nativeObj);
        return bl;
    }

    public int descriptorSize() {
        int n = DescriptorExtractor.descriptorSize_0(this.nativeObj);
        return n;
    }

    public int descriptorType() {
        int n = DescriptorExtractor.descriptorType_0(this.nativeObj);
        return n;
    }

    public void compute(Mat mat, MatOfKeyPoint matOfKeyPoint, Mat mat2) {
        MatOfKeyPoint matOfKeyPoint2 = matOfKeyPoint;
        DescriptorExtractor.compute_0(this.nativeObj, mat.nativeObj, matOfKeyPoint2.nativeObj, mat2.nativeObj);
    }

    public void compute(List<Mat> list, List<MatOfKeyPoint> list2, List<Mat> list3) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list2 != null ? list2.size() : 0);
        Mat mat2 = Converters.vector_vector_KeyPoint_to_Mat(list2, arrayList);
        Mat mat3 = new Mat();
        DescriptorExtractor.compute_1(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
        Converters.Mat_to_vector_vector_KeyPoint(mat2, list2);
        mat2.release();
        Converters.Mat_to_vector_Mat(mat3, list3);
        mat3.release();
    }

    public void read(String string) {
        DescriptorExtractor.read_0(this.nativeObj, string);
    }

    public void write(String string) {
        DescriptorExtractor.write_0(this.nativeObj, string);
    }

    protected void finalize() throws Throwable {
        DescriptorExtractor.delete(this.nativeObj);
    }

    private static native long create_0(int var0);

    private static native boolean empty_0(long var0);

    private static native int descriptorSize_0(long var0);

    private static native int descriptorType_0(long var0);

    private static native void compute_0(long var0, long var2, long var4, long var6);

    private static native void compute_1(long var0, long var2, long var4, long var6);

    private static native void read_0(long var0, String var2);

    private static native void write_0(long var0, String var2);

    private static native void delete(long var0);
}

