/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import org.opencv.core.Point;

public class Size {
    public double width;
    public double height;

    public Size(double d, double d2) {
        this.width = d;
        this.height = d2;
    }

    public Size() {
        this(0.0, 0.0);
    }

    public Size(Point point) {
        this.width = point.x;
        this.height = point.y;
    }

    public Size(double[] dArray) {
        this.set(dArray);
    }

    public void set(double[] dArray) {
        if (dArray != null) {
            this.width = dArray.length > 0 ? dArray[0] : 0.0;
            this.height = dArray.length > 1 ? dArray[1] : 0.0;
        } else {
            this.width = 0.0;
            this.height = 0.0;
        }
    }

    public double area() {
        return this.width * this.height;
    }

    public Size clone() {
        return new Size(this.width, this.height);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.height);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.width);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Size)) {
            return false;
        }
        Size size = (Size)object;
        return this.width == size.width && this.height == size.height;
    }

    public String toString() {
        return (int)this.width + "x" + (int)this.height;
    }
}

