/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

public class Range {
    public int start;
    public int end;

    public Range(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    public Range() {
        this(0, 0);
    }

    public Range(double[] dArray) {
        this.set(dArray);
    }

    public void set(double[] dArray) {
        if (dArray != null) {
            this.start = dArray.length > 0 ? (int)dArray[0] : 0;
            this.end = dArray.length > 1 ? (int)dArray[1] : 0;
        } else {
            this.start = 0;
            this.end = 0;
        }
    }

    public int size() {
        return this.empty() ? 0 : this.end - this.start;
    }

    public boolean empty() {
        return this.end <= this.start;
    }

    public static Range all() {
        return new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public Range intersection(Range range) {
        Range range2 = new Range(Math.max(range.start, this.start), Math.min(range.end, this.end));
        range2.end = Math.max(range2.end, range2.start);
        return range2;
    }

    public Range shift(int n) {
        return new Range(this.start + n, this.end + n);
    }

    public Range clone() {
        return new Range(this.start, this.end);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.start);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.end);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        return this.start == range.start && this.end == range.end;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + ")";
    }
}

