/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfInt;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.TermCriteria;
import org.opencv.utils.Converters;

public class Core {
    public static final String VERSION = Core.getVersion();
    public static final String NATIVE_LIBRARY_NAME = Core.getNativeLibraryName();
    public static final int VERSION_MAJOR = Core.getVersionMajor();
    public static final int VERSION_MINOR = Core.getVersionMinor();
    public static final int VERSION_REVISION = Core.getVersionRevision();
    public static final String VERSION_STATUS = Core.getVersionStatus();
    private static final int CV_8U = 0;
    private static final int CV_8S = 1;
    private static final int CV_16U = 2;
    private static final int CV_16S = 3;
    private static final int CV_32S = 4;
    private static final int CV_32F = 5;
    private static final int CV_64F = 6;
    private static final int CV_USRTYPE1 = 7;
    public static final int SVD_MODIFY_A = 1;
    public static final int SVD_NO_UV = 2;
    public static final int SVD_FULL_UV = 4;
    public static final int FILLED = -1;
    public static final int REDUCE_SUM = 0;
    public static final int REDUCE_AVG = 1;
    public static final int REDUCE_MAX = 2;
    public static final int REDUCE_MIN = 3;
    public static final int StsOk = 0;
    public static final int StsBackTrace = -1;
    public static final int StsError = -2;
    public static final int StsInternal = -3;
    public static final int StsNoMem = -4;
    public static final int StsBadArg = -5;
    public static final int StsBadFunc = -6;
    public static final int StsNoConv = -7;
    public static final int StsAutoTrace = -8;
    public static final int HeaderIsNull = -9;
    public static final int BadImageSize = -10;
    public static final int BadOffset = -11;
    public static final int BadDataPtr = -12;
    public static final int BadStep = -13;
    public static final int BadModelOrChSeq = -14;
    public static final int BadNumChannels = -15;
    public static final int BadNumChannel1U = -16;
    public static final int BadDepth = -17;
    public static final int BadAlphaChannel = -18;
    public static final int BadOrder = -19;
    public static final int BadOrigin = -20;
    public static final int BadAlign = -21;
    public static final int BadCallBack = -22;
    public static final int BadTileSize = -23;
    public static final int BadCOI = -24;
    public static final int BadROISize = -25;
    public static final int MaskIsTiled = -26;
    public static final int StsNullPtr = -27;
    public static final int StsVecLengthErr = -28;
    public static final int StsFilterStructContentErr = -29;
    public static final int StsKernelStructContentErr = -30;
    public static final int StsFilterOffsetErr = -31;
    public static final int StsBadSize = -201;
    public static final int StsDivByZero = -202;
    public static final int StsInplaceNotSupported = -203;
    public static final int StsObjectNotFound = -204;
    public static final int StsUnmatchedFormats = -205;
    public static final int StsBadFlag = -206;
    public static final int StsBadPoint = -207;
    public static final int StsBadMask = -208;
    public static final int StsUnmatchedSizes = -209;
    public static final int StsUnsupportedFormat = -210;
    public static final int StsOutOfRange = -211;
    public static final int StsParseError = -212;
    public static final int StsNotImplemented = -213;
    public static final int StsBadMemBlock = -214;
    public static final int StsAssert = -215;
    public static final int GpuNotSupported = -216;
    public static final int GpuApiCallError = -217;
    public static final int OpenGlNotSupported = -218;
    public static final int OpenGlApiCallError = -219;
    public static final int OpenCLApiCallError = -220;
    public static final int OpenCLDoubleNotSupported = -221;
    public static final int OpenCLInitError = -222;
    public static final int OpenCLNoAMDBlasFft = -223;
    public static final int DECOMP_LU = 0;
    public static final int DECOMP_SVD = 1;
    public static final int DECOMP_EIG = 2;
    public static final int DECOMP_CHOLESKY = 3;
    public static final int DECOMP_QR = 4;
    public static final int DECOMP_NORMAL = 16;
    public static final int NORM_INF = 1;
    public static final int NORM_L1 = 2;
    public static final int NORM_L2 = 4;
    public static final int NORM_L2SQR = 5;
    public static final int NORM_HAMMING = 6;
    public static final int NORM_HAMMING2 = 7;
    public static final int NORM_TYPE_MASK = 7;
    public static final int NORM_RELATIVE = 8;
    public static final int NORM_MINMAX = 32;
    public static final int CMP_EQ = 0;
    public static final int CMP_GT = 1;
    public static final int CMP_GE = 2;
    public static final int CMP_LT = 3;
    public static final int CMP_LE = 4;
    public static final int CMP_NE = 5;
    public static final int GEMM_1_T = 1;
    public static final int GEMM_2_T = 2;
    public static final int GEMM_3_T = 4;
    public static final int DFT_INVERSE = 1;
    public static final int DFT_SCALE = 2;
    public static final int DFT_ROWS = 4;
    public static final int DFT_COMPLEX_OUTPUT = 16;
    public static final int DFT_REAL_OUTPUT = 32;
    public static final int DCT_INVERSE = 1;
    public static final int DCT_ROWS = 4;
    public static final int BORDER_CONSTANT = 0;
    public static final int BORDER_REPLICATE = 1;
    public static final int BORDER_REFLECT = 2;
    public static final int BORDER_WRAP = 3;
    public static final int BORDER_REFLECT_101 = 4;
    public static final int BORDER_TRANSPARENT = 5;
    public static final int BORDER_REFLECT101 = 4;
    public static final int BORDER_DEFAULT = 4;
    public static final int BORDER_ISOLATED = 16;
    public static final int SORT_EVERY_ROW = 0;
    public static final int SORT_EVERY_COLUMN = 1;
    public static final int SORT_ASCENDING = 0;
    public static final int SORT_DESCENDING = 16;
    public static final int COVAR_SCRAMBLED = 0;
    public static final int COVAR_NORMAL = 1;
    public static final int COVAR_USE_AVG = 2;
    public static final int COVAR_SCALE = 4;
    public static final int COVAR_ROWS = 8;
    public static final int COVAR_COLS = 16;
    public static final int KMEANS_RANDOM_CENTERS = 0;
    public static final int KMEANS_PP_CENTERS = 2;
    public static final int KMEANS_USE_INITIAL_LABELS = 1;
    public static final int LINE_4 = 4;
    public static final int LINE_8 = 8;
    public static final int LINE_AA = 16;
    public static final int FONT_HERSHEY_SIMPLEX = 0;
    public static final int FONT_HERSHEY_PLAIN = 1;
    public static final int FONT_HERSHEY_DUPLEX = 2;
    public static final int FONT_HERSHEY_COMPLEX = 3;
    public static final int FONT_HERSHEY_TRIPLEX = 4;
    public static final int FONT_HERSHEY_COMPLEX_SMALL = 5;
    public static final int FONT_HERSHEY_SCRIPT_SIMPLEX = 6;
    public static final int FONT_HERSHEY_SCRIPT_COMPLEX = 7;
    public static final int FONT_ITALIC = 16;
    public static final int ROTATE_90_CLOCKWISE = 0;
    public static final int ROTATE_180 = 1;
    public static final int ROTATE_90_COUNTERCLOCKWISE = 2;
    public static final int TYPE_GENERAL = 0;
    public static final int TYPE_MARKER = 1;
    public static final int TYPE_WRAPPER = 2;
    public static final int TYPE_FUN = 3;
    public static final int IMPL_PLAIN = 0;
    public static final int IMPL_IPP = 1;
    public static final int IMPL_OPENCL = 2;
    public static final int FLAGS_NONE = 0;
    public static final int FLAGS_MAPPING = 1;
    public static final int FLAGS_EXPAND_SAME_NAMES = 2;

    private static String getVersion() {
        return "3.2.0";
    }

    private static String getNativeLibraryName() {
        return "opencv_java320";
    }

    private static int getVersionMajor() {
        return 3;
    }

    private static int getVersionMinor() {
        return 2;
    }

    private static int getVersionRevision() {
        return 0;
    }

    private static String getVersionStatus() {
        return "";
    }

    public static Scalar mean(Mat mat, Mat mat2) {
        Scalar scalar = new Scalar(Core.mean_0(mat.nativeObj, mat2.nativeObj));
        return scalar;
    }

    public static Scalar mean(Mat mat) {
        Scalar scalar = new Scalar(Core.mean_1(mat.nativeObj));
        return scalar;
    }

    public static Scalar sumElems(Mat mat) {
        Scalar scalar = new Scalar(Core.sumElems_0(mat.nativeObj));
        return scalar;
    }

    public static Scalar trace(Mat mat) {
        Scalar scalar = new Scalar(Core.trace_0(mat.nativeObj));
        return scalar;
    }

    public static String getBuildInformation() {
        String string = Core.getBuildInformation_0();
        return string;
    }

    public static boolean checkRange(Mat mat, boolean bl, double d, double d2) {
        boolean bl2 = Core.checkRange_0(mat.nativeObj, bl, d, d2);
        return bl2;
    }

    public static boolean checkRange(Mat mat) {
        boolean bl = Core.checkRange_1(mat.nativeObj);
        return bl;
    }

    public static boolean eigen(Mat mat, Mat mat2, Mat mat3) {
        boolean bl = Core.eigen_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
        return bl;
    }

    public static boolean eigen(Mat mat, Mat mat2) {
        boolean bl = Core.eigen_1(mat.nativeObj, mat2.nativeObj);
        return bl;
    }

    public static boolean solve(Mat mat, Mat mat2, Mat mat3, int n) {
        boolean bl = Core.solve_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n);
        return bl;
    }

    public static boolean solve(Mat mat, Mat mat2, Mat mat3) {
        boolean bl = Core.solve_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
        return bl;
    }

    public static double Mahalanobis(Mat mat, Mat mat2, Mat mat3) {
        double d = Core.Mahalanobis_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
        return d;
    }

    public static double PSNR(Mat mat, Mat mat2) {
        double d = Core.PSNR_0(mat.nativeObj, mat2.nativeObj);
        return d;
    }

    public static double determinant(Mat mat) {
        double d = Core.determinant_0(mat.nativeObj);
        return d;
    }

    public static double getTickFrequency() {
        double d = Core.getTickFrequency_0();
        return d;
    }

    public static double invert(Mat mat, Mat mat2, int n) {
        double d = Core.invert_0(mat.nativeObj, mat2.nativeObj, n);
        return d;
    }

    public static double invert(Mat mat, Mat mat2) {
        double d = Core.invert_1(mat.nativeObj, mat2.nativeObj);
        return d;
    }

    public static double kmeans(Mat mat, int n, Mat mat2, TermCriteria termCriteria, int n2, int n3, Mat mat3) {
        double d = Core.kmeans_0(mat.nativeObj, n, mat2.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon, n2, n3, mat3.nativeObj);
        return d;
    }

    public static double kmeans(Mat mat, int n, Mat mat2, TermCriteria termCriteria, int n2, int n3) {
        double d = Core.kmeans_1(mat.nativeObj, n, mat2.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon, n2, n3);
        return d;
    }

    public static double norm(Mat mat, Mat mat2, int n, Mat mat3) {
        double d = Core.norm_0(mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj);
        return d;
    }

    public static double norm(Mat mat, Mat mat2, int n) {
        double d = Core.norm_1(mat.nativeObj, mat2.nativeObj, n);
        return d;
    }

    public static double norm(Mat mat, Mat mat2) {
        double d = Core.norm_2(mat.nativeObj, mat2.nativeObj);
        return d;
    }

    public static double norm(Mat mat, int n, Mat mat2) {
        double d = Core.norm_3(mat.nativeObj, n, mat2.nativeObj);
        return d;
    }

    public static double norm(Mat mat, int n) {
        double d = Core.norm_4(mat.nativeObj, n);
        return d;
    }

    public static double norm(Mat mat) {
        double d = Core.norm_5(mat.nativeObj);
        return d;
    }

    public static double solvePoly(Mat mat, Mat mat2, int n) {
        double d = Core.solvePoly_0(mat.nativeObj, mat2.nativeObj, n);
        return d;
    }

    public static double solvePoly(Mat mat, Mat mat2) {
        double d = Core.solvePoly_1(mat.nativeObj, mat2.nativeObj);
        return d;
    }

    public static float cubeRoot(float f) {
        float f2 = Core.cubeRoot_0(f);
        return f2;
    }

    public static float fastAtan2(float f, float f2) {
        float f3 = Core.fastAtan2_0(f, f2);
        return f3;
    }

    public static int borderInterpolate(int n, int n2, int n3) {
        int n4 = Core.borderInterpolate_0(n, n2, n3);
        return n4;
    }

    public static int countNonZero(Mat mat) {
        int n = Core.countNonZero_0(mat.nativeObj);
        return n;
    }

    public static int getNumThreads() {
        int n = Core.getNumThreads_0();
        return n;
    }

    public static int getNumberOfCPUs() {
        int n = Core.getNumberOfCPUs_0();
        return n;
    }

    public static int getOptimalDFTSize(int n) {
        int n2 = Core.getOptimalDFTSize_0(n);
        return n2;
    }

    public static int getThreadNum() {
        int n = Core.getThreadNum_0();
        return n;
    }

    public static int solveCubic(Mat mat, Mat mat2) {
        int n = Core.solveCubic_0(mat.nativeObj, mat2.nativeObj);
        return n;
    }

    public static long getCPUTickCount() {
        long l = Core.getCPUTickCount_0();
        return l;
    }

    public static long getTickCount() {
        long l = Core.getTickCount_0();
        return l;
    }

    public static void LUT(Mat mat, Mat mat2, Mat mat3) {
        Core.LUT_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void PCABackProject(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.PCABackProject_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void PCACompute(Mat mat, Mat mat2, Mat mat3, double d) {
        Core.PCACompute_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, d);
    }

    public static void PCACompute(Mat mat, Mat mat2, Mat mat3, int n) {
        Core.PCACompute_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n);
    }

    public static void PCACompute(Mat mat, Mat mat2, Mat mat3) {
        Core.PCACompute_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void PCAProject(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.PCAProject_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void SVBackSubst(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Core.SVBackSubst_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void SVDecomp(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n) {
        Core.SVDecomp_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n);
    }

    public static void SVDecomp(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.SVDecomp_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void absdiff(Mat mat, Mat mat2, Mat mat3) {
        Core.absdiff_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void absdiff(Mat mat, Scalar scalar, Mat mat2) {
        Core.absdiff_1(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj);
    }

    public static void add(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n) {
        Core.add_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n);
    }

    public static void add(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.add_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void add(Mat mat, Mat mat2, Mat mat3) {
        Core.add_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void add(Mat mat, Scalar scalar, Mat mat2, Mat mat3, int n) {
        Core.add_3(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj, mat3.nativeObj, n);
    }

    public static void add(Mat mat, Scalar scalar, Mat mat2, Mat mat3) {
        Core.add_4(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj, mat3.nativeObj);
    }

    public static void add(Mat mat, Scalar scalar, Mat mat2) {
        Core.add_5(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj);
    }

    public static void addWeighted(Mat mat, double d, Mat mat2, double d2, double d3, Mat mat3, int n) {
        Core.addWeighted_0(mat.nativeObj, d, mat2.nativeObj, d2, d3, mat3.nativeObj, n);
    }

    public static void addWeighted(Mat mat, double d, Mat mat2, double d2, double d3, Mat mat3) {
        Core.addWeighted_1(mat.nativeObj, d, mat2.nativeObj, d2, d3, mat3.nativeObj);
    }

    public static void batchDistance(Mat mat, Mat mat2, Mat mat3, int n, Mat mat4, int n2, int n3, Mat mat5, int n4, boolean bl) {
        Core.batchDistance_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, mat4.nativeObj, n2, n3, mat5.nativeObj, n4, bl);
    }

    public static void batchDistance(Mat mat, Mat mat2, Mat mat3, int n, Mat mat4, int n2, int n3) {
        Core.batchDistance_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, mat4.nativeObj, n2, n3);
    }

    public static void batchDistance(Mat mat, Mat mat2, Mat mat3, int n, Mat mat4) {
        Core.batchDistance_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, mat4.nativeObj);
    }

    public static void bitwise_and(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.bitwise_and_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void bitwise_and(Mat mat, Mat mat2, Mat mat3) {
        Core.bitwise_and_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void bitwise_not(Mat mat, Mat mat2, Mat mat3) {
        Core.bitwise_not_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void bitwise_not(Mat mat, Mat mat2) {
        Core.bitwise_not_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void bitwise_or(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.bitwise_or_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void bitwise_or(Mat mat, Mat mat2, Mat mat3) {
        Core.bitwise_or_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void bitwise_xor(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.bitwise_xor_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void bitwise_xor(Mat mat, Mat mat2, Mat mat3) {
        Core.bitwise_xor_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void calcCovarMatrix(Mat mat, Mat mat2, Mat mat3, int n, int n2) {
        Core.calcCovarMatrix_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, n2);
    }

    public static void calcCovarMatrix(Mat mat, Mat mat2, Mat mat3, int n) {
        Core.calcCovarMatrix_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n);
    }

    public static void cartToPolar(Mat mat, Mat mat2, Mat mat3, Mat mat4, boolean bl) {
        Core.cartToPolar_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, bl);
    }

    public static void cartToPolar(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.cartToPolar_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void compare(Mat mat, Mat mat2, Mat mat3, int n) {
        Core.compare_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n);
    }

    public static void compare(Mat mat, Scalar scalar, Mat mat2, int n) {
        Core.compare_1(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj, n);
    }

    public static void completeSymm(Mat mat, boolean bl) {
        Core.completeSymm_0(mat.nativeObj, bl);
    }

    public static void completeSymm(Mat mat) {
        Core.completeSymm_1(mat.nativeObj);
    }

    public static void convertFp16(Mat mat, Mat mat2) {
        Core.convertFp16_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void convertScaleAbs(Mat mat, Mat mat2, double d, double d2) {
        Core.convertScaleAbs_0(mat.nativeObj, mat2.nativeObj, d, d2);
    }

    public static void convertScaleAbs(Mat mat, Mat mat2) {
        Core.convertScaleAbs_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void copyMakeBorder(Mat mat, Mat mat2, int n, int n2, int n3, int n4, int n5, Scalar scalar) {
        Core.copyMakeBorder_0(mat.nativeObj, mat2.nativeObj, n, n2, n3, n4, n5, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void copyMakeBorder(Mat mat, Mat mat2, int n, int n2, int n3, int n4, int n5) {
        Core.copyMakeBorder_1(mat.nativeObj, mat2.nativeObj, n, n2, n3, n4, n5);
    }

    public static void dct(Mat mat, Mat mat2, int n) {
        Core.dct_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void dct(Mat mat, Mat mat2) {
        Core.dct_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void dft(Mat mat, Mat mat2, int n, int n2) {
        Core.dft_0(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void dft(Mat mat, Mat mat2) {
        Core.dft_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void divide(Mat mat, Mat mat2, Mat mat3, double d, int n) {
        Core.divide_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, d, n);
    }

    public static void divide(Mat mat, Mat mat2, Mat mat3, double d) {
        Core.divide_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, d);
    }

    public static void divide(Mat mat, Mat mat2, Mat mat3) {
        Core.divide_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void divide(Mat mat, Scalar scalar, Mat mat2, double d, int n) {
        Core.divide_3(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj, d, n);
    }

    public static void divide(Mat mat, Scalar scalar, Mat mat2, double d) {
        Core.divide_4(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj, d);
    }

    public static void divide(Mat mat, Scalar scalar, Mat mat2) {
        Core.divide_5(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj);
    }

    public static void divide(double d, Mat mat, Mat mat2, int n) {
        Core.divide_6(d, mat.nativeObj, mat2.nativeObj, n);
    }

    public static void divide(double d, Mat mat, Mat mat2) {
        Core.divide_7(d, mat.nativeObj, mat2.nativeObj);
    }

    public static void exp(Mat mat, Mat mat2) {
        Core.exp_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void extractChannel(Mat mat, Mat mat2, int n) {
        Core.extractChannel_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void findNonZero(Mat mat, Mat mat2) {
        Core.findNonZero_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void flip(Mat mat, Mat mat2, int n) {
        Core.flip_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void gemm(Mat mat, Mat mat2, double d, Mat mat3, double d2, Mat mat4, int n) {
        Core.gemm_0(mat.nativeObj, mat2.nativeObj, d, mat3.nativeObj, d2, mat4.nativeObj, n);
    }

    public static void gemm(Mat mat, Mat mat2, double d, Mat mat3, double d2, Mat mat4) {
        Core.gemm_1(mat.nativeObj, mat2.nativeObj, d, mat3.nativeObj, d2, mat4.nativeObj);
    }

    public static void hconcat(List<Mat> list, Mat mat) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Core.hconcat_0(mat2.nativeObj, mat.nativeObj);
    }

    public static void idct(Mat mat, Mat mat2, int n) {
        Core.idct_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void idct(Mat mat, Mat mat2) {
        Core.idct_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void idft(Mat mat, Mat mat2, int n, int n2) {
        Core.idft_0(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void idft(Mat mat, Mat mat2) {
        Core.idft_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void inRange(Mat mat, Scalar scalar, Scalar scalar2, Mat mat2) {
        Core.inRange_0(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], scalar2.val[0], scalar2.val[1], scalar2.val[2], scalar2.val[3], mat2.nativeObj);
    }

    public static void insertChannel(Mat mat, Mat mat2, int n) {
        Core.insertChannel_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void log(Mat mat, Mat mat2) {
        Core.log_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void magnitude(Mat mat, Mat mat2, Mat mat3) {
        Core.magnitude_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void max(Mat mat, Mat mat2, Mat mat3) {
        Core.max_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void max(Mat mat, Scalar scalar, Mat mat2) {
        Core.max_1(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj);
    }

    public static void meanStdDev(Mat mat, MatOfDouble matOfDouble, MatOfDouble matOfDouble2, Mat mat2) {
        MatOfDouble matOfDouble3 = matOfDouble;
        MatOfDouble matOfDouble4 = matOfDouble2;
        Core.meanStdDev_0(mat.nativeObj, matOfDouble3.nativeObj, matOfDouble4.nativeObj, mat2.nativeObj);
    }

    public static void meanStdDev(Mat mat, MatOfDouble matOfDouble, MatOfDouble matOfDouble2) {
        MatOfDouble matOfDouble3 = matOfDouble;
        MatOfDouble matOfDouble4 = matOfDouble2;
        Core.meanStdDev_1(mat.nativeObj, matOfDouble3.nativeObj, matOfDouble4.nativeObj);
    }

    public static void merge(List<Mat> list, Mat mat) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Core.merge_0(mat2.nativeObj, mat.nativeObj);
    }

    public static void min(Mat mat, Mat mat2, Mat mat3) {
        Core.min_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void min(Mat mat, Scalar scalar, Mat mat2) {
        Core.min_1(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj);
    }

    public static void mixChannels(List<Mat> list, List<Mat> list2, MatOfInt matOfInt) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        Mat mat2 = Converters.vector_Mat_to_Mat(list2);
        MatOfInt matOfInt2 = matOfInt;
        Core.mixChannels_0(mat.nativeObj, mat2.nativeObj, matOfInt2.nativeObj);
    }

    public static void mulSpectrums(Mat mat, Mat mat2, Mat mat3, int n, boolean bl) {
        Core.mulSpectrums_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, bl);
    }

    public static void mulSpectrums(Mat mat, Mat mat2, Mat mat3, int n) {
        Core.mulSpectrums_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n);
    }

    public static void mulTransposed(Mat mat, Mat mat2, boolean bl, Mat mat3, double d, int n) {
        Core.mulTransposed_0(mat.nativeObj, mat2.nativeObj, bl, mat3.nativeObj, d, n);
    }

    public static void mulTransposed(Mat mat, Mat mat2, boolean bl, Mat mat3, double d) {
        Core.mulTransposed_1(mat.nativeObj, mat2.nativeObj, bl, mat3.nativeObj, d);
    }

    public static void mulTransposed(Mat mat, Mat mat2, boolean bl) {
        Core.mulTransposed_2(mat.nativeObj, mat2.nativeObj, bl);
    }

    public static void multiply(Mat mat, Mat mat2, Mat mat3, double d, int n) {
        Core.multiply_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, d, n);
    }

    public static void multiply(Mat mat, Mat mat2, Mat mat3, double d) {
        Core.multiply_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, d);
    }

    public static void multiply(Mat mat, Mat mat2, Mat mat3) {
        Core.multiply_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void multiply(Mat mat, Scalar scalar, Mat mat2, double d, int n) {
        Core.multiply_3(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj, d, n);
    }

    public static void multiply(Mat mat, Scalar scalar, Mat mat2, double d) {
        Core.multiply_4(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj, d);
    }

    public static void multiply(Mat mat, Scalar scalar, Mat mat2) {
        Core.multiply_5(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj);
    }

    public static void normalize(Mat mat, Mat mat2, double d, double d2, int n, int n2, Mat mat3) {
        Core.normalize_0(mat.nativeObj, mat2.nativeObj, d, d2, n, n2, mat3.nativeObj);
    }

    public static void normalize(Mat mat, Mat mat2, double d, double d2, int n, int n2) {
        Core.normalize_1(mat.nativeObj, mat2.nativeObj, d, d2, n, n2);
    }

    public static void normalize(Mat mat, Mat mat2, double d, double d2, int n) {
        Core.normalize_2(mat.nativeObj, mat2.nativeObj, d, d2, n);
    }

    public static void normalize(Mat mat, Mat mat2) {
        Core.normalize_3(mat.nativeObj, mat2.nativeObj);
    }

    public static void patchNaNs(Mat mat, double d) {
        Core.patchNaNs_0(mat.nativeObj, d);
    }

    public static void patchNaNs(Mat mat) {
        Core.patchNaNs_1(mat.nativeObj);
    }

    public static void perspectiveTransform(Mat mat, Mat mat2, Mat mat3) {
        Core.perspectiveTransform_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void phase(Mat mat, Mat mat2, Mat mat3, boolean bl) {
        Core.phase_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, bl);
    }

    public static void phase(Mat mat, Mat mat2, Mat mat3) {
        Core.phase_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void polarToCart(Mat mat, Mat mat2, Mat mat3, Mat mat4, boolean bl) {
        Core.polarToCart_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, bl);
    }

    public static void polarToCart(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.polarToCart_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void pow(Mat mat, double d, Mat mat2) {
        Core.pow_0(mat.nativeObj, d, mat2.nativeObj);
    }

    public static void randShuffle(Mat mat, double d) {
        Core.randShuffle_0(mat.nativeObj, d);
    }

    public static void randShuffle(Mat mat) {
        Core.randShuffle_1(mat.nativeObj);
    }

    public static void randn(Mat mat, double d, double d2) {
        Core.randn_0(mat.nativeObj, d, d2);
    }

    public static void randu(Mat mat, double d, double d2) {
        Core.randu_0(mat.nativeObj, d, d2);
    }

    public static void reduce(Mat mat, Mat mat2, int n, int n2, int n3) {
        Core.reduce_0(mat.nativeObj, mat2.nativeObj, n, n2, n3);
    }

    public static void reduce(Mat mat, Mat mat2, int n, int n2) {
        Core.reduce_1(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void repeat(Mat mat, int n, int n2, Mat mat2) {
        Core.repeat_0(mat.nativeObj, n, n2, mat2.nativeObj);
    }

    public static void rotate(Mat mat, Mat mat2, int n) {
        Core.rotate_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void scaleAdd(Mat mat, double d, Mat mat2, Mat mat3) {
        Core.scaleAdd_0(mat.nativeObj, d, mat2.nativeObj, mat3.nativeObj);
    }

    public static void setErrorVerbosity(boolean bl) {
        Core.setErrorVerbosity_0(bl);
    }

    public static void setIdentity(Mat mat, Scalar scalar) {
        Core.setIdentity_0(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void setIdentity(Mat mat) {
        Core.setIdentity_1(mat.nativeObj);
    }

    public static void setNumThreads(int n) {
        Core.setNumThreads_0(n);
    }

    public static void setRNGSeed(int n) {
        Core.setRNGSeed_0(n);
    }

    public static void sort(Mat mat, Mat mat2, int n) {
        Core.sort_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void sortIdx(Mat mat, Mat mat2, int n) {
        Core.sortIdx_0(mat.nativeObj, mat2.nativeObj, n);
    }

    public static void split(Mat mat, List<Mat> list) {
        Mat mat2 = new Mat();
        Core.split_0(mat.nativeObj, mat2.nativeObj);
        Converters.Mat_to_vector_Mat(mat2, list);
        mat2.release();
    }

    public static void sqrt(Mat mat, Mat mat2) {
        Core.sqrt_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void subtract(Mat mat, Mat mat2, Mat mat3, Mat mat4, int n) {
        Core.subtract_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n);
    }

    public static void subtract(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Core.subtract_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void subtract(Mat mat, Mat mat2, Mat mat3) {
        Core.subtract_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void subtract(Mat mat, Scalar scalar, Mat mat2, Mat mat3, int n) {
        Core.subtract_3(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj, mat3.nativeObj, n);
    }

    public static void subtract(Mat mat, Scalar scalar, Mat mat2, Mat mat3) {
        Core.subtract_4(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj, mat3.nativeObj);
    }

    public static void subtract(Mat mat, Scalar scalar, Mat mat2) {
        Core.subtract_5(mat.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat2.nativeObj);
    }

    public static void transform(Mat mat, Mat mat2, Mat mat3) {
        Core.transform_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void transpose(Mat mat, Mat mat2) {
        Core.transpose_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void vconcat(List<Mat> list, Mat mat) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Core.vconcat_0(mat2.nativeObj, mat.nativeObj);
    }

    public static MinMaxLocResult minMaxLoc(Mat mat, Mat mat2) {
        MinMaxLocResult minMaxLocResult = new MinMaxLocResult();
        long l = 0L;
        if (mat2 != null) {
            l = mat2.nativeObj;
        }
        double[] dArray = Core.n_minMaxLocManual(mat.nativeObj, l);
        minMaxLocResult.minVal = dArray[0];
        minMaxLocResult.maxVal = dArray[1];
        minMaxLocResult.minLoc.x = dArray[2];
        minMaxLocResult.minLoc.y = dArray[3];
        minMaxLocResult.maxLoc.x = dArray[4];
        minMaxLocResult.maxLoc.y = dArray[5];
        return minMaxLocResult;
    }

    public static MinMaxLocResult minMaxLoc(Mat mat) {
        return Core.minMaxLoc(mat, null);
    }

    private static native double[] mean_0(long var0, long var2);

    private static native double[] mean_1(long var0);

    private static native double[] sumElems_0(long var0);

    private static native double[] trace_0(long var0);

    private static native String getBuildInformation_0();

    private static native boolean checkRange_0(long var0, boolean var2, double var3, double var5);

    private static native boolean checkRange_1(long var0);

    private static native boolean eigen_0(long var0, long var2, long var4);

    private static native boolean eigen_1(long var0, long var2);

    private static native boolean solve_0(long var0, long var2, long var4, int var6);

    private static native boolean solve_1(long var0, long var2, long var4);

    private static native double Mahalanobis_0(long var0, long var2, long var4);

    private static native double PSNR_0(long var0, long var2);

    private static native double determinant_0(long var0);

    private static native double getTickFrequency_0();

    private static native double invert_0(long var0, long var2, int var4);

    private static native double invert_1(long var0, long var2);

    private static native double kmeans_0(long var0, int var2, long var3, int var5, int var6, double var7, int var9, int var10, long var11);

    private static native double kmeans_1(long var0, int var2, long var3, int var5, int var6, double var7, int var9, int var10);

    private static native double norm_0(long var0, long var2, int var4, long var5);

    private static native double norm_1(long var0, long var2, int var4);

    private static native double norm_2(long var0, long var2);

    private static native double norm_3(long var0, int var2, long var3);

    private static native double norm_4(long var0, int var2);

    private static native double norm_5(long var0);

    private static native double solvePoly_0(long var0, long var2, int var4);

    private static native double solvePoly_1(long var0, long var2);

    private static native float cubeRoot_0(float var0);

    private static native float fastAtan2_0(float var0, float var1);

    private static native int borderInterpolate_0(int var0, int var1, int var2);

    private static native int countNonZero_0(long var0);

    private static native int getNumThreads_0();

    private static native int getNumberOfCPUs_0();

    private static native int getOptimalDFTSize_0(int var0);

    private static native int getThreadNum_0();

    private static native int solveCubic_0(long var0, long var2);

    private static native long getCPUTickCount_0();

    private static native long getTickCount_0();

    private static native void LUT_0(long var0, long var2, long var4);

    private static native void PCABackProject_0(long var0, long var2, long var4, long var6);

    private static native void PCACompute_0(long var0, long var2, long var4, double var6);

    private static native void PCACompute_1(long var0, long var2, long var4, int var6);

    private static native void PCACompute_2(long var0, long var2, long var4);

    private static native void PCAProject_0(long var0, long var2, long var4, long var6);

    private static native void SVBackSubst_0(long var0, long var2, long var4, long var6, long var8);

    private static native void SVDecomp_0(long var0, long var2, long var4, long var6, int var8);

    private static native void SVDecomp_1(long var0, long var2, long var4, long var6);

    private static native void absdiff_0(long var0, long var2, long var4);

    private static native void absdiff_1(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native void add_0(long var0, long var2, long var4, long var6, int var8);

    private static native void add_1(long var0, long var2, long var4, long var6);

    private static native void add_2(long var0, long var2, long var4);

    private static native void add_3(long var0, double var2, double var4, double var6, double var8, long var10, long var12, int var14);

    private static native void add_4(long var0, double var2, double var4, double var6, double var8, long var10, long var12);

    private static native void add_5(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native void addWeighted_0(long var0, double var2, long var4, double var6, double var8, long var10, int var12);

    private static native void addWeighted_1(long var0, double var2, long var4, double var6, double var8, long var10);

    private static native void batchDistance_0(long var0, long var2, long var4, int var6, long var7, int var9, int var10, long var11, int var13, boolean var14);

    private static native void batchDistance_1(long var0, long var2, long var4, int var6, long var7, int var9, int var10);

    private static native void batchDistance_2(long var0, long var2, long var4, int var6, long var7);

    private static native void bitwise_and_0(long var0, long var2, long var4, long var6);

    private static native void bitwise_and_1(long var0, long var2, long var4);

    private static native void bitwise_not_0(long var0, long var2, long var4);

    private static native void bitwise_not_1(long var0, long var2);

    private static native void bitwise_or_0(long var0, long var2, long var4, long var6);

    private static native void bitwise_or_1(long var0, long var2, long var4);

    private static native void bitwise_xor_0(long var0, long var2, long var4, long var6);

    private static native void bitwise_xor_1(long var0, long var2, long var4);

    private static native void calcCovarMatrix_0(long var0, long var2, long var4, int var6, int var7);

    private static native void calcCovarMatrix_1(long var0, long var2, long var4, int var6);

    private static native void cartToPolar_0(long var0, long var2, long var4, long var6, boolean var8);

    private static native void cartToPolar_1(long var0, long var2, long var4, long var6);

    private static native void compare_0(long var0, long var2, long var4, int var6);

    private static native void compare_1(long var0, double var2, double var4, double var6, double var8, long var10, int var12);

    private static native void completeSymm_0(long var0, boolean var2);

    private static native void completeSymm_1(long var0);

    private static native void convertFp16_0(long var0, long var2);

    private static native void convertScaleAbs_0(long var0, long var2, double var4, double var6);

    private static native void convertScaleAbs_1(long var0, long var2);

    private static native void copyMakeBorder_0(long var0, long var2, int var4, int var5, int var6, int var7, int var8, double var9, double var11, double var13, double var15);

    private static native void copyMakeBorder_1(long var0, long var2, int var4, int var5, int var6, int var7, int var8);

    private static native void dct_0(long var0, long var2, int var4);

    private static native void dct_1(long var0, long var2);

    private static native void dft_0(long var0, long var2, int var4, int var5);

    private static native void dft_1(long var0, long var2);

    private static native void divide_0(long var0, long var2, long var4, double var6, int var8);

    private static native void divide_1(long var0, long var2, long var4, double var6);

    private static native void divide_2(long var0, long var2, long var4);

    private static native void divide_3(long var0, double var2, double var4, double var6, double var8, long var10, double var12, int var14);

    private static native void divide_4(long var0, double var2, double var4, double var6, double var8, long var10, double var12);

    private static native void divide_5(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native void divide_6(double var0, long var2, long var4, int var6);

    private static native void divide_7(double var0, long var2, long var4);

    private static native void exp_0(long var0, long var2);

    private static native void extractChannel_0(long var0, long var2, int var4);

    private static native void findNonZero_0(long var0, long var2);

    private static native void flip_0(long var0, long var2, int var4);

    private static native void gemm_0(long var0, long var2, double var4, long var6, double var8, long var10, int var12);

    private static native void gemm_1(long var0, long var2, double var4, long var6, double var8, long var10);

    private static native void hconcat_0(long var0, long var2);

    private static native void idct_0(long var0, long var2, int var4);

    private static native void idct_1(long var0, long var2);

    private static native void idft_0(long var0, long var2, int var4, int var5);

    private static native void idft_1(long var0, long var2);

    private static native void inRange_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, long var18);

    private static native void insertChannel_0(long var0, long var2, int var4);

    private static native void log_0(long var0, long var2);

    private static native void magnitude_0(long var0, long var2, long var4);

    private static native void max_0(long var0, long var2, long var4);

    private static native void max_1(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native void meanStdDev_0(long var0, long var2, long var4, long var6);

    private static native void meanStdDev_1(long var0, long var2, long var4);

    private static native void merge_0(long var0, long var2);

    private static native void min_0(long var0, long var2, long var4);

    private static native void min_1(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native void mixChannels_0(long var0, long var2, long var4);

    private static native void mulSpectrums_0(long var0, long var2, long var4, int var6, boolean var7);

    private static native void mulSpectrums_1(long var0, long var2, long var4, int var6);

    private static native void mulTransposed_0(long var0, long var2, boolean var4, long var5, double var7, int var9);

    private static native void mulTransposed_1(long var0, long var2, boolean var4, long var5, double var7);

    private static native void mulTransposed_2(long var0, long var2, boolean var4);

    private static native void multiply_0(long var0, long var2, long var4, double var6, int var8);

    private static native void multiply_1(long var0, long var2, long var4, double var6);

    private static native void multiply_2(long var0, long var2, long var4);

    private static native void multiply_3(long var0, double var2, double var4, double var6, double var8, long var10, double var12, int var14);

    private static native void multiply_4(long var0, double var2, double var4, double var6, double var8, long var10, double var12);

    private static native void multiply_5(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native void normalize_0(long var0, long var2, double var4, double var6, int var8, int var9, long var10);

    private static native void normalize_1(long var0, long var2, double var4, double var6, int var8, int var9);

    private static native void normalize_2(long var0, long var2, double var4, double var6, int var8);

    private static native void normalize_3(long var0, long var2);

    private static native void patchNaNs_0(long var0, double var2);

    private static native void patchNaNs_1(long var0);

    private static native void perspectiveTransform_0(long var0, long var2, long var4);

    private static native void phase_0(long var0, long var2, long var4, boolean var6);

    private static native void phase_1(long var0, long var2, long var4);

    private static native void polarToCart_0(long var0, long var2, long var4, long var6, boolean var8);

    private static native void polarToCart_1(long var0, long var2, long var4, long var6);

    private static native void pow_0(long var0, double var2, long var4);

    private static native void randShuffle_0(long var0, double var2);

    private static native void randShuffle_1(long var0);

    private static native void randn_0(long var0, double var2, double var4);

    private static native void randu_0(long var0, double var2, double var4);

    private static native void reduce_0(long var0, long var2, int var4, int var5, int var6);

    private static native void reduce_1(long var0, long var2, int var4, int var5);

    private static native void repeat_0(long var0, int var2, int var3, long var4);

    private static native void rotate_0(long var0, long var2, int var4);

    private static native void scaleAdd_0(long var0, double var2, long var4, long var6);

    private static native void setErrorVerbosity_0(boolean var0);

    private static native void setIdentity_0(long var0, double var2, double var4, double var6, double var8);

    private static native void setIdentity_1(long var0);

    private static native void setNumThreads_0(int var0);

    private static native void setRNGSeed_0(int var0);

    private static native void sort_0(long var0, long var2, int var4);

    private static native void sortIdx_0(long var0, long var2, int var4);

    private static native void split_0(long var0, long var2);

    private static native void sqrt_0(long var0, long var2);

    private static native void subtract_0(long var0, long var2, long var4, long var6, int var8);

    private static native void subtract_1(long var0, long var2, long var4, long var6);

    private static native void subtract_2(long var0, long var2, long var4);

    private static native void subtract_3(long var0, double var2, double var4, double var6, double var8, long var10, long var12, int var14);

    private static native void subtract_4(long var0, double var2, double var4, double var6, double var8, long var10, long var12);

    private static native void subtract_5(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native void transform_0(long var0, long var2, long var4);

    private static native void transpose_0(long var0, long var2);

    private static native void vconcat_0(long var0, long var2);

    private static native double[] n_minMaxLocManual(long var0, long var2);

    public static class MinMaxLocResult {
        public double minVal = 0.0;
        public double maxVal = 0.0;
        public Point minLoc = new Point();
        public Point maxLoc = new Point();
    }
}

