/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.vision;

import edu.wpi.cscore.CvSink;
import edu.wpi.cscore.VideoSource;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.RobotBase;
import edu.wpi.first.wpilibj.vision.VisionPipeline;
import org.opencv.core.Mat;

public class VisionRunner<P extends VisionPipeline> {
    private final CvSink m_cvSink = new CvSink("VisionRunner CvSink");
    private final P m_pipeline;
    private final Mat m_image = new Mat();
    private final Listener<? super P> m_listener;
    private volatile boolean m_enabled = true;

    public VisionRunner(VideoSource videoSource, P pipeline, Listener<? super P> listener) {
        this.m_pipeline = pipeline;
        this.m_listener = listener;
        this.m_cvSink.setSource(videoSource);
    }

    public void runOnce() {
        if (Thread.currentThread().getId() == RobotBase.MAIN_THREAD_ID) {
            throw new IllegalStateException("VisionRunner.runOnce() cannot be called from the main robot thread");
        }
        long frameTime = this.m_cvSink.grabFrame(this.m_image);
        if (frameTime == 0L) {
            String error = this.m_cvSink.getError();
            DriverStation.reportError(error, true);
        } else {
            this.m_pipeline.process(this.m_image);
            this.m_listener.copyPipelineOutputs(this.m_pipeline);
        }
    }

    public void runForever() {
        if (Thread.currentThread().getId() == RobotBase.MAIN_THREAD_ID) {
            throw new IllegalStateException("VisionRunner.runForever() cannot be called from the main robot thread");
        }
        while (this.m_enabled && !Thread.interrupted()) {
            this.runOnce();
        }
    }

    public void stop() {
        this.m_enabled = false;
    }

    @FunctionalInterface
    public static interface Listener<P extends VisionPipeline> {
        public void copyPipelineOutputs(P var1);
    }
}

