/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.smartdashboard;

import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;
import java.util.LinkedHashMap;
import java.util.Objects;

public class SendableChooser<V>
extends SendableBase
implements Sendable {
    private static final String DEFAULT = "default";
    private static final String SELECTED = "selected";
    private static final String OPTIONS = "options";
    private final LinkedHashMap<String, V> m_map = new LinkedHashMap();
    private String m_defaultChoice = "";
    private NetworkTableEntry m_tableSelected;

    public void addObject(String name, V object) {
        this.m_map.put(name, object);
    }

    public void addDefault(String name, V object) {
        Objects.requireNonNull(name, "Provided name was null");
        this.m_defaultChoice = name;
        this.addObject(name, object);
    }

    public V getSelected() {
        String selected = this.m_defaultChoice;
        if (this.m_tableSelected != null) {
            selected = this.m_tableSelected.getString(this.m_defaultChoice);
        }
        return this.m_map.get(selected);
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("String Chooser");
        builder.addStringProperty(DEFAULT, () -> this.m_defaultChoice, null);
        builder.addStringArrayProperty(OPTIONS, () -> this.m_map.keySet().toArray(new String[0]), null);
        this.m_tableSelected = builder.getEntry(SELECTED);
    }
}

