/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.smartdashboard;

import edu.wpi.first.networktables.NetworkTable;
import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.networktables.NetworkTableValue;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;

public class SendableBuilderImpl
implements SendableBuilder {
    private final List<Property> m_properties = new ArrayList<Property>();
    private Runnable m_safeState;
    private Runnable m_updateTable;
    private NetworkTable m_table;

    public void setTable(NetworkTable table) {
        this.m_table = table;
    }

    public NetworkTable getTable() {
        return this.m_table;
    }

    public void updateTable() {
        for (Property property : this.m_properties) {
            if (property.m_update == null) continue;
            property.m_update.accept(property.m_entry);
        }
        if (this.m_updateTable != null) {
            this.m_updateTable.run();
        }
    }

    public void startListeners() {
        for (Property property : this.m_properties) {
            property.startListener();
        }
    }

    public void stopListeners() {
        for (Property property : this.m_properties) {
            property.stopListener();
        }
    }

    public void startLiveWindowMode() {
        if (this.m_safeState != null) {
            this.m_safeState.run();
        }
        this.startListeners();
    }

    public void stopLiveWindowMode() {
        this.stopListeners();
        if (this.m_safeState != null) {
            this.m_safeState.run();
        }
    }

    @Override
    public void setSmartDashboardType(String type) {
        this.m_table.getEntry(".type").setString(type);
    }

    @Override
    public void setSafeState(Runnable func) {
        this.m_safeState = func;
    }

    @Override
    public void setUpdateTable(Runnable func) {
        this.m_updateTable = func;
    }

    @Override
    public NetworkTableEntry getEntry(String key) {
        return this.m_table.getEntry(key);
    }

    @Override
    public void addBooleanProperty(String key, BooleanSupplier getter, SendableBuilder.BooleanConsumer setter) {
        Property property = new Property(this.m_table, key);
        if (getter != null) {
            property.m_update = entry -> entry.setBoolean(getter.getAsBoolean());
        }
        if (setter != null) {
            property.m_createListener = entry -> entry.addListener(event -> {
                if (event.value.isBoolean()) {
                    setter.accept(event.value.getBoolean());
                }
            }, 21);
        }
        this.m_properties.add(property);
    }

    @Override
    public void addDoubleProperty(String key, DoubleSupplier getter, DoubleConsumer setter) {
        Property property = new Property(this.m_table, key);
        if (getter != null) {
            property.m_update = entry -> entry.setDouble(getter.getAsDouble());
        }
        if (setter != null) {
            property.m_createListener = entry -> entry.addListener(event -> {
                if (event.value.isDouble()) {
                    setter.accept(event.value.getDouble());
                }
            }, 21);
        }
        this.m_properties.add(property);
    }

    @Override
    public void addStringProperty(String key, Supplier<String> getter, Consumer<String> setter) {
        Property property = new Property(this.m_table, key);
        if (getter != null) {
            property.m_update = entry -> entry.setString((String)getter.get());
        }
        if (setter != null) {
            property.m_createListener = entry -> entry.addListener(event -> {
                if (event.value.isString()) {
                    setter.accept(event.value.getString());
                }
            }, 21);
        }
        this.m_properties.add(property);
    }

    @Override
    public void addBooleanArrayProperty(String key, Supplier<boolean[]> getter, Consumer<boolean[]> setter) {
        Property property = new Property(this.m_table, key);
        if (getter != null) {
            property.m_update = entry -> entry.setBooleanArray((boolean[])getter.get());
        }
        if (setter != null) {
            property.m_createListener = entry -> entry.addListener(event -> {
                if (event.value.isBooleanArray()) {
                    setter.accept(event.value.getBooleanArray());
                }
            }, 21);
        }
        this.m_properties.add(property);
    }

    @Override
    public void addDoubleArrayProperty(String key, Supplier<double[]> getter, Consumer<double[]> setter) {
        Property property = new Property(this.m_table, key);
        if (getter != null) {
            property.m_update = entry -> entry.setDoubleArray((double[])getter.get());
        }
        if (setter != null) {
            property.m_createListener = entry -> entry.addListener(event -> {
                if (event.value.isDoubleArray()) {
                    setter.accept(event.value.getDoubleArray());
                }
            }, 21);
        }
        this.m_properties.add(property);
    }

    @Override
    public void addStringArrayProperty(String key, Supplier<String[]> getter, Consumer<String[]> setter) {
        Property property = new Property(this.m_table, key);
        if (getter != null) {
            property.m_update = entry -> entry.setStringArray((String[])getter.get());
        }
        if (setter != null) {
            property.m_createListener = entry -> entry.addListener(event -> {
                if (event.value.isStringArray()) {
                    setter.accept(event.value.getStringArray());
                }
            }, 21);
        }
        this.m_properties.add(property);
    }

    @Override
    public void addRawProperty(String key, Supplier<byte[]> getter, Consumer<byte[]> setter) {
        Property property = new Property(this.m_table, key);
        if (getter != null) {
            property.m_update = entry -> entry.setRaw((byte[])getter.get());
        }
        if (setter != null) {
            property.m_createListener = entry -> entry.addListener(event -> {
                if (event.value.isRaw()) {
                    setter.accept(event.value.getRaw());
                }
            }, 21);
        }
        this.m_properties.add(property);
    }

    @Override
    public void addValueProperty(String key, Supplier<NetworkTableValue> getter, Consumer<NetworkTableValue> setter) {
        Property property = new Property(this.m_table, key);
        if (getter != null) {
            property.m_update = entry -> entry.setValue(getter.get());
        }
        if (setter != null) {
            property.m_createListener = entry -> entry.addListener(event -> setter.accept(event.value), 21);
        }
        this.m_properties.add(property);
    }

    private static class Property {
        final NetworkTableEntry m_entry;
        int m_listener = 0;
        Consumer<NetworkTableEntry> m_update;
        Function<NetworkTableEntry, Integer> m_createListener;

        Property(NetworkTable table, String key) {
            this.m_entry = table.getEntry(key);
        }

        public synchronized void finalize() {
            this.stopListener();
        }

        void startListener() {
            if (this.m_entry.isValid() && this.m_listener == 0 && this.m_createListener != null) {
                this.m_listener = this.m_createListener.apply(this.m_entry);
            }
        }

        void stopListener() {
            if (this.m_entry.isValid() && this.m_listener != 0) {
                this.m_entry.removeListener(this.m_listener);
                this.m_listener = 0;
            }
        }
    }
}

