/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.livewindow;

import edu.wpi.first.networktables.NetworkTable;
import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilderImpl;
import java.util.HashMap;
import java.util.Map;

public class LiveWindow {
    private static final Map<Object, Component> components = new HashMap<Object, Component>();
    private static final NetworkTable liveWindowTable = NetworkTableInstance.getDefault().getTable("LiveWindow");
    private static final NetworkTable statusTable = liveWindowTable.getSubTable(".status");
    private static final NetworkTableEntry enabledEntry = statusTable.getEntry("LW Enabled");
    private static boolean startLiveWindow = false;
    private static boolean liveWindowEnabled = false;
    private static boolean telemetryEnabled = true;

    public static synchronized boolean isEnabled() {
        return liveWindowEnabled;
    }

    public static synchronized void setEnabled(boolean enabled) {
        if (liveWindowEnabled != enabled) {
            Scheduler scheduler = Scheduler.getInstance();
            if (enabled) {
                System.out.println("Starting live window mode.");
                scheduler.disable();
                scheduler.removeAll();
            } else {
                System.out.println("stopping live window mode.");
                for (Component component : components.values()) {
                    component.m_builder.stopLiveWindowMode();
                }
                scheduler.enable();
            }
            startLiveWindow = enabled;
            liveWindowEnabled = enabled;
            enabledEntry.setBoolean(enabled);
        }
    }

    @Deprecated
    public static void run() {
        LiveWindow.updateValues();
    }

    @Deprecated
    public static synchronized void addSensor(String subsystem, String name, Sendable component) {
        LiveWindow.add(component);
        component.setName(subsystem, name);
    }

    @Deprecated
    public static void addSensor(String moduleType, int channel, Sendable component) {
        LiveWindow.add(component);
        component.setName("Ungrouped", moduleType + "[" + channel + "]");
    }

    @Deprecated
    public static synchronized void addActuator(String subsystem, String name, Sendable component) {
        LiveWindow.add(component);
        component.setName(subsystem, name);
    }

    @Deprecated
    public static void addActuator(String moduleType, int channel, Sendable component) {
        LiveWindow.add(component);
        component.setName("Ungrouped", moduleType + "[" + channel + "]");
    }

    @Deprecated
    public static void addActuator(String moduleType, int moduleNumber, int channel, Sendable component) {
        LiveWindow.add(component);
        component.setName("Ungrouped", moduleType + "[" + moduleNumber + "," + channel + "]");
    }

    public static synchronized void add(Sendable sendable) {
        components.putIfAbsent(sendable, new Component(sendable, null));
    }

    public static synchronized void addChild(Sendable parent, Object child) {
        Component component = components.get(child);
        if (component == null) {
            component = new Component(null, parent);
            components.put(child, component);
        } else {
            component.m_parent = parent;
        }
        component.m_telemetryEnabled = false;
    }

    public static synchronized void remove(Sendable sendable) {
        Component component = components.remove(sendable);
        if (component != null && LiveWindow.isEnabled()) {
            component.m_builder.stopLiveWindowMode();
        }
    }

    public static synchronized void enableTelemetry(Sendable sendable) {
        telemetryEnabled = true;
        Component component = components.get(sendable);
        if (component != null) {
            component.m_telemetryEnabled = true;
        }
    }

    public static synchronized void disableTelemetry(Sendable sendable) {
        Component component = components.get(sendable);
        if (component != null) {
            component.m_telemetryEnabled = false;
        }
    }

    public static synchronized void disableAllTelemetry() {
        telemetryEnabled = false;
        for (Component component : components.values()) {
            component.m_telemetryEnabled = false;
        }
    }

    public static synchronized void updateValues() {
        if (!liveWindowEnabled && !telemetryEnabled) {
            return;
        }
        for (Component component : components.values()) {
            if (component.m_sendable == null || component.m_parent != null || !liveWindowEnabled && !component.m_telemetryEnabled) continue;
            if (component.m_firstTime) {
                String name = component.m_sendable.getName();
                if (name.isEmpty()) continue;
                String subsystem = component.m_sendable.getSubsystem();
                NetworkTable ssTable = liveWindowTable.getSubTable(subsystem);
                NetworkTable table = name.equals(subsystem) ? ssTable : ssTable.getSubTable(name);
                table.getEntry(".name").setString(name);
                component.m_builder.setTable(table);
                component.m_sendable.initSendable(component.m_builder);
                ssTable.getEntry(".type").setString("LW Subsystem");
                component.m_firstTime = false;
            }
            if (startLiveWindow) {
                component.m_builder.startLiveWindowMode();
            }
            component.m_builder.updateTable();
        }
        startLiveWindow = false;
    }

    private static class Component {
        final Sendable m_sendable;
        Sendable m_parent;
        final SendableBuilderImpl m_builder = new SendableBuilderImpl();
        boolean m_firstTime = true;
        boolean m_telemetryEnabled = true;

        Component(Sendable sendable, Sendable parent) {
            this.m_sendable = sendable;
            this.m_parent = parent;
        }
    }
}

