/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.internal;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.RobotController;
import edu.wpi.first.wpilibj.Timer;

public class HardwareTimer
implements Timer.StaticInterface {
    @Override
    public void delay(double seconds) {
        try {
            Thread.sleep((long)(seconds * 1000.0));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public double getFPGATimestamp() {
        return (double)RobotController.getFPGATime() / 1000000.0;
    }

    @Override
    public double getMatchTime() {
        return DriverStation.getInstance().getMatchTime();
    }

    @Override
    public Timer.Interface newTimer() {
        return new TimerImpl();
    }

    class TimerImpl
    implements Timer.Interface {
        private double m_startTime;
        private double m_accumulatedTime;
        private boolean m_running;

        TimerImpl() {
            this.reset();
        }

        private double getMsClock() {
            return (double)RobotController.getFPGATime() / 1000.0;
        }

        @Override
        public synchronized double get() {
            if (this.m_running) {
                return (this.getMsClock() - this.m_startTime + this.m_accumulatedTime) / 1000.0;
            }
            return this.m_accumulatedTime;
        }

        @Override
        public synchronized void reset() {
            this.m_accumulatedTime = 0.0;
            this.m_startTime = this.getMsClock();
        }

        @Override
        public synchronized void start() {
            this.m_startTime = this.getMsClock();
            this.m_running = true;
        }

        @Override
        public synchronized void stop() {
            double temp;
            this.m_accumulatedTime = temp = this.get();
            this.m_running = false;
        }

        @Override
        public synchronized boolean hasPeriodPassed(double period) {
            if (this.get() > period) {
                this.m_startTime += period * 1000.0;
                return true;
            }
            return false;
        }
    }
}

