/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.drive;

import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.SendableBase;

public abstract class RobotDriveBase
extends SendableBase
implements MotorSafety {
    public static final double kDefaultDeadband = 0.02;
    public static final double kDefaultMaxOutput = 1.0;
    protected double m_deadband = 0.02;
    protected double m_maxOutput = 1.0;
    protected MotorSafetyHelper m_safetyHelper = new MotorSafetyHelper(this);

    public RobotDriveBase() {
        this.m_safetyHelper.setSafetyEnabled(true);
        this.setName("RobotDriveBase");
    }

    public void setDeadband(double deadband) {
        this.m_deadband = deadband;
    }

    public void setMaxOutput(double maxOutput) {
        this.m_maxOutput = maxOutput;
    }

    @Override
    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    @Override
    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    @Override
    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    @Override
    public abstract void stopMotor();

    @Override
    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    @Override
    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    @Override
    public abstract String getDescription();

    protected double limit(double value) {
        if (value > 1.0) {
            return 1.0;
        }
        if (value < -1.0) {
            return -1.0;
        }
        return value;
    }

    protected double applyDeadband(double value, double deadband) {
        if (Math.abs(value) > deadband) {
            if (value > 0.0) {
                return (value - deadband) / (1.0 - deadband);
            }
            return (value + deadband) / (1.0 - deadband);
        }
        return 0.0;
    }

    protected void normalize(double[] wheelSpeeds) {
        int i;
        double maxMagnitude = Math.abs(wheelSpeeds[0]);
        for (i = 1; i < wheelSpeeds.length; ++i) {
            double temp = Math.abs(wheelSpeeds[i]);
            if (!(maxMagnitude < temp)) continue;
            maxMagnitude = temp;
        }
        if (maxMagnitude > 1.0) {
            for (i = 0; i < wheelSpeeds.length; ++i) {
                wheelSpeeds[i] = wheelSpeeds[i] / maxMagnitude;
            }
        }
    }

    public static enum MotorType {
        kFrontLeft(0),
        kFrontRight(1),
        kRearLeft(2),
        kRearRight(3),
        kLeft(0),
        kRight(1),
        kBack(2);

        public final int value;

        private MotorType(int value) {
            this.value = value;
        }
    }
}

