/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.drive;

import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.drive.RobotDriveBase;
import edu.wpi.first.wpilibj.drive.Vector2d;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class MecanumDrive
extends RobotDriveBase {
    private static int instances = 0;
    private SpeedController m_frontLeftMotor;
    private SpeedController m_rearLeftMotor;
    private SpeedController m_frontRightMotor;
    private SpeedController m_rearRightMotor;
    private boolean m_reported = false;

    public MecanumDrive(SpeedController frontLeftMotor, SpeedController rearLeftMotor, SpeedController frontRightMotor, SpeedController rearRightMotor) {
        this.m_frontLeftMotor = frontLeftMotor;
        this.m_rearLeftMotor = rearLeftMotor;
        this.m_frontRightMotor = frontRightMotor;
        this.m_rearRightMotor = rearRightMotor;
        this.addChild(this.m_frontLeftMotor);
        this.addChild(this.m_rearLeftMotor);
        this.addChild(this.m_frontRightMotor);
        this.addChild(this.m_rearRightMotor);
        this.setName("MecanumDrive", ++instances);
    }

    public void driveCartesian(double ySpeed, double xSpeed, double zRotation) {
        this.driveCartesian(ySpeed, xSpeed, zRotation, 0.0);
    }

    public void driveCartesian(double ySpeed, double xSpeed, double zRotation, double gyroAngle) {
        if (!this.m_reported) {
            HAL.report(31, 4, 6);
            this.m_reported = true;
        }
        ySpeed = this.limit(ySpeed);
        ySpeed = this.applyDeadband(ySpeed, this.m_deadband);
        xSpeed = this.limit(xSpeed);
        xSpeed = this.applyDeadband(xSpeed, this.m_deadband);
        Vector2d input = new Vector2d(ySpeed, xSpeed);
        input.rotate(-gyroAngle);
        double[] wheelSpeeds = new double[4];
        wheelSpeeds[RobotDriveBase.MotorType.kFrontLeft.value] = input.x + input.y + zRotation;
        wheelSpeeds[RobotDriveBase.MotorType.kFrontRight.value] = input.x - input.y + zRotation;
        wheelSpeeds[RobotDriveBase.MotorType.kRearLeft.value] = -input.x + input.y + zRotation;
        wheelSpeeds[RobotDriveBase.MotorType.kRearRight.value] = -input.x - input.y + zRotation;
        this.normalize(wheelSpeeds);
        this.m_frontLeftMotor.set(wheelSpeeds[RobotDriveBase.MotorType.kFrontLeft.value] * this.m_maxOutput);
        this.m_frontRightMotor.set(wheelSpeeds[RobotDriveBase.MotorType.kFrontRight.value] * this.m_maxOutput);
        this.m_rearLeftMotor.set(wheelSpeeds[RobotDriveBase.MotorType.kRearLeft.value] * this.m_maxOutput);
        this.m_rearRightMotor.set(wheelSpeeds[RobotDriveBase.MotorType.kRearRight.value] * this.m_maxOutput);
        this.m_safetyHelper.feed();
    }

    public void drivePolar(double magnitude, double angle, double zRotation) {
        if (!this.m_reported) {
            HAL.report(31, 4, 5);
            this.m_reported = true;
        }
        this.driveCartesian(magnitude * Math.sin(angle * (Math.PI / 180)), magnitude * Math.cos(angle * (Math.PI / 180)), zRotation, 0.0);
    }

    @Override
    public void stopMotor() {
        this.m_frontLeftMotor.stopMotor();
        this.m_frontRightMotor.stopMotor();
        this.m_rearLeftMotor.stopMotor();
        this.m_rearRightMotor.stopMotor();
        this.m_safetyHelper.feed();
    }

    @Override
    public String getDescription() {
        return "MecanumDrive";
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("MecanumDrive");
        builder.addDoubleProperty("Front Left Motor Speed", this.m_frontLeftMotor::get, this.m_frontLeftMotor::set);
        builder.addDoubleProperty("Front Right Motor Speed", this.m_frontRightMotor::get, this.m_frontRightMotor::set);
        builder.addDoubleProperty("Rear Left Motor Speed", this.m_rearLeftMotor::get, this.m_rearLeftMotor::set);
        builder.addDoubleProperty("Rear Right Motor Speed", this.m_rearRightMotor::get, this.m_rearRightMotor::set);
    }
}

